/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatmini.order.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelTokenService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUser;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.wechatmini.WeChatPayMiniConstants;
import com.yqbsoft.laser.service.ext.channel.wechatmini.domain.CmChannelClearReDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "wechatmini.DisOrderServiceImpl";
    ChannelTokenService channelTokenService;
    private static String url = "https://api.weixin.qq.com/wxa/sec/order/upload_shipping_info?access_token=";
    private static String receiveUrl = "https://api.weixin.qq.com/wxa/sec/order/notify_confirm_receive?access_token=";

    protected String getChannelCode() {
        return WeChatPayMiniConstants.channelCode;
    }

    public void setChannelTokenService(ChannelTokenService channelTokenService) {
        this.channelTokenService = channelTokenService;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComOrderParam", (Object)("====" + channelApiCode + "===" + sendParam.toString() + "====" + configMap.toString() + "====" + param.toString()));
            return null;
        }
        String tenantCode = disChannel.getTenantCode();
        String accessToken = this.accessToken(param, false);
        sendParam.put("serverUrl", configMap.get("ophost"));
        sendParam.put("accessToken", accessToken);
        sendParam.put("appKey", configMap.get("key"));
        sendParam.put("appSecret", configMap.get("secret"));
        if ("cmc.disOrder.saveOcContract".equals(channelApiCode)) {
            HashMap<String, Object> shipMap;
            OcContractReDomain ocContractReDomain = (OcContractReDomain)param.get("ocContractReDomain");
            if (null == ocContractReDomain || StringUtils.isBlank((String)ocContractReDomain.getContractBillcode())) {
                this.logger.error(this.SYS_CODE + ".buildComOrderParam.e", (Object)(channelApiCode + "===sgSendgoodsReDomain.null"));
                return null;
            }
            String contractBillcode = ocContractReDomain.getContractBbillcode();
            String memberBcode = ocContractReDomain.getMemberBcode();
            List goodsList = ocContractReDomain.getGoodsList();
            Map queryMapParam = this.getQueryMapParam("businessOrderno,dataState,tenantCode,order", new Object[]{contractBillcode, 2, tenantCode, true});
            Map sendMap = this.getQueryMapParam("map", new Object[]{queryMapParam});
            QueryResult cmChannelClearReDomainQueryResult = this.getQueryResutl("cm.channelClear.querychannelClearPage", sendMap, CmChannelClearReDomain.class);
            if (null == cmChannelClearReDomainQueryResult || ListUtil.isEmpty((Collection)cmChannelClearReDomainQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".buildComOrderParam.e" + contractBillcode, (Object)(channelApiCode + "===cmChannelClearReDomainQueryResult.null"));
                return null;
            }
            CmChannelClearReDomain cmChannelClearReDomain = (CmChannelClearReDomain)cmChannelClearReDomainQueryResult.getList().get(0);
            String orderBankseq = cmChannelClearReDomain.getOrderBankseq();
            Map exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(cmChannelClearReDomain.getExtension(), String.class, String.class);
            String userOpenid = "";
            if (MapUtil.isNotEmpty((Map)exmap) && null != exmap.get("openId")) {
                userOpenid = (String)exmap.get("openId");
            } else {
                queryMapParam = this.getQueryMapParam("userPcode,tenantCode", new Object[]{memberBcode, tenantCode});
                sendMap = this.getQueryMapParam("map", new Object[]{queryMapParam});
                QueryResult umUserQueryResult = this.getQueryResutl("um.user.queryUserPage", sendMap, UmUser.class);
                if (null == umUserQueryResult || ListUtil.isEmpty((Collection)umUserQueryResult.getList())) {
                    this.logger.error(this.SYS_CODE + ".buildComOrderParam.e", (Object)(channelApiCode + "===umUserQueryResult.null"));
                    return null;
                }
                userOpenid = ((UmUser)umUserQueryResult.getList().get(0)).getUserOpenid();
            }
            if (ocContractReDomain.getDataState() > 3) {
                shipMap = new HashMap<String, Object>();
                shipMap.put("access_token", sendParam.get("accessToken"));
                shipMap.put("transaction_id", orderBankseq);
                shipMap.put("received_time", ocContractReDomain.getGmtModified().getTime());
                sendParam.put("receiveMap", shipMap);
            } else {
                shipMap = new HashMap();
                shipMap.put("access_token", sendParam.get("accessToken"));
                HashMap<String, Object> orderMap = new HashMap<String, Object>();
                orderMap.put("order_number_type", 2);
                orderMap.put("transaction_id", orderBankseq);
                shipMap.put("order_key", orderMap);
                shipMap.put("logistics_type", 4);
                shipMap.put("delivery_mode", 1);
                ZonedDateTime zonedDateTime = ZonedDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                String formattedDateTime = zonedDateTime.format(formatter);
                shipMap.put("upload_time", formattedDateTime);
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("openid", userOpenid);
                shipMap.put("payer", userMap);
                ArrayList mapList = new ArrayList();
                String goodsDetail = goodsList.stream().map(ocg -> ocg.getGoodsName()).collect(Collectors.joining(","));
                HashMap<String, String> shipDetailMap = new HashMap<String, String>();
                shipDetailMap.put("item_desc", DisOrderServiceImpl.truncateString(goodsDetail));
                mapList.add(shipDetailMap);
                shipMap.put("shipping_list", mapList);
                sendParam.put("sendParamStr", shipMap);
            }
            this.logger.info(this.SYS_CODE + ".buildComOrderParam.buildParamComplete", (Object)(channelApiCode + "===" + JsonUtil.buildNormalBinder().toJson(sendParam)));
        }
        return sendParam;
    }

    public static String truncateString(String input) {
        if (input != null && input.length() > 120) {
            return input.substring(0, 120);
        }
        return input;
    }

    private String accessToken(Map<String, Object> params, boolean ifUpdate) {
        params.put("ifUpdate", ifUpdate);
        this.logger.info(this.SYS_CODE + "accessToken.params", (Object)JsonUtil.buildNormalBinder().toJson(params));
        Object token = this.channelTokenService.channelToken(params);
        this.logger.info(this.SYS_CODE + "accessToken", token);
        return (String)token;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode) || null == disChannel || MapUtil.isEmpty(sendhttpParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.params", (Object)"params is null");
            return "ERROR";
        }
        String accessToken = this.accessToken(param, false);
        if (StringUtils.isBlank((String)accessToken)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.sendhttpParam.accessToken", (Object)"accessToken\u4e3anull");
            return "ERROR";
        }
        String result = "";
        Map<String, Object> sendParamStr = new HashMap();
        if (null != sendhttpParam.get("sendParamStr")) {
            sendParamStr = (Map)sendhttpParam.get("sendParamStr");
            sendParamStr.remove("access_token");
            result = this.sendPostCom(channelApiCode, sendParamStr, url + accessToken);
        } else {
            sendParamStr = (Map)sendhttpParam.get("receiveMap");
            sendParamStr.remove("access_token");
            result = this.sendPostCom(channelApiCode, sendParamStr, receiveUrl + accessToken);
        }
        Map<String, Object> resultMap = this.getResultMap(result);
        if (MapUtils.isNotEmpty(resultMap) && null != resultMap.get("errcode") && "41001".equals(resultMap.get("errcode").toString())) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.sendhttpParam.sendPost.resultMap.errcode=40001", (Object)JsonUtil.buildNormalBinder().toJson(resultMap));
            accessToken = this.getAccessToken(configMap.get("appid"), configMap.get("secret"), true);
            if (StringUtils.isBlank((String)accessToken)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.sendhttpParam.accessToken2", (Object)"accessToken\u4e3anull");
                return "ERROR";
            }
            result = this.sendPostCom(channelApiCode, sendParamStr, url + accessToken);
            resultMap = this.getResultMap(result);
        }
        if (MapUtils.isEmpty(resultMap) || !"0".equals(resultMap.get("errcode").toString())) {
            return "ERROR";
        }
        return "SUCCESS";
    }

    private Map<String, Object> getResultMap(String result) {
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
    }

    public String getAccessToken(String appid, String secret, boolean ifUpdate) {
        String key = appid + "-" + secret;
        String accessToken = SupDisUtil.getRemot((String)key);
        if (StringUtils.isBlank((String)accessToken) || ifUpdate) {
            String result = this.updateAccessToken(appid, secret);
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
            if (MapUtils.isEmpty((Map)jsonToMap) || null == jsonToMap.get("access_token")) {
                this.logger.error(this.SYS_CODE + ".getAccessToken:result", (Object)result);
                return null;
            }
            accessToken = (String)jsonToMap.get("access_token");
            SupDisUtil.set((String)key, (String)accessToken, (int)7200);
        }
        return accessToken;
    }

    private String updateAccessToken(String appid, String secret) {
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        invoiceMap.put("appid", appid);
        invoiceMap.put("secret", secret);
        invoiceMap.put("grant_type", "client_credential");
        String result = "";
        try {
            result = WebUtils.doGet((String)"https://api.weixin.qq.com/cgi-bin/token", invoiceMap, null);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error(this.SYS_CODE + ".updateAccessToken:result", (Object)(result + "+(result\u4e3a\u7a7a)"));
                return null;
            }
        }
        catch (IOException e) {
            this.logger.error(this.SYS_CODE + ".updateAccessToken:result", (Object)result, (Throwable)e);
            return null;
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String result = "";
        try {
            param.put("transaction_id", "4200002602202502018537671511");
            param.put("received_time", 1738398988000L);
            result = WebUtils.doPostJson((String)(receiveUrl + "88_l4YBIioupZ0mCPTOOWnxvhceeJvDlDa2QO-IDSVWseNp-99gmdtkJVAv5_cYvqHCmIMuHD61swwAy3gdQYGKJ-UIq4gY8qB0fQ1RDiIiFbOyT2W-68r-Xjbn-WEGVXcACAUJL"), param, (int)10000, (int)400000);
            System.out.println(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String sendPostCom(String channelApiCode, Map<String, Object> param, String url) {
        if (MapUtil.isEmpty(param) || StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendPostCom.params", (Object)("params is null-" + url));
            return null;
        }
        String result = "";
        try {
            this.logger.info(this.SYS_CODE + ".sendPostCom.params", (Object)(url + "==" + JsonUtil.buildNormalBinder().toJson(param)));
            result = WebUtils.doPostJson((String)url, param, (int)10000, (int)400000);
            this.logger.info(this.SYS_CODE + ".sendPostCom.response", (Object)result);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendPostCom.e", (Throwable)e);
        }
        return result;
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return null;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }
}

