/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.sign.service.impl;

import cn.hutool.core.util.StrUtil;
import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.common.OpenId;
import com.fasc.open.api.config.HttpConfig;
import com.fasc.open.api.enums.common.IdTypeEnum;
import com.fasc.open.api.stratey.DefaultJsonStrategy;
import com.fasc.open.api.stratey.JsonStrategy;
import com.fasc.open.api.utils.ResultUtil;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.client.ServiceClient;
import com.fasc.open.api.v5_1.res.service.AccessTokenRes;
import com.yqbsoft.laser.bus.ext.data.sign.context.OpenApiExecutionContext;
import com.yqbsoft.laser.bus.ext.data.sign.service.OpenApiContextService;
import com.yqbsoft.laser.bus.ext.data.sign.supbase.BusBaseService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenApiContextServiceImpl
extends BusBaseService
implements OpenApiContextService {
    private static final String SYS_CODE = "datasign.OpenApiContextServiceImpl";
    private final Map<String, OpenApiClient> OPEN_API_CLIENT_CACHE = new ConcurrentHashMap<String, OpenApiClient>();
    public static final String ACCESS_TOKEN_KEY = "FascAccessToken-";

    @Override
    public OpenApiExecutionContext getExecutionContext(String tenantCode) throws ApiException {
        String METHOD_NAME = ".getExecutionContext";
        this.logger.info("datasign.OpenApiContextServiceImpl.getExecutionContext", (Object)(":params:" + tenantCode));
        OpenApiExecutionContext.App app = this.getApp(tenantCode);
        OpenApiClient openApiClient = this.getOpenApiClient(tenantCode, app);
        OpenApiExecutionContext context = new OpenApiExecutionContext(tenantCode, app, openApiClient);
        context.initBusClient();
        String accessToken = this.getAccessToken(context);
        context.setAccessToken(accessToken);
        OpenId openId = OpenId.getInstance((String)IdTypeEnum.CORP.getCode(), (String)context.getApp().getOpenCorpId());
        context.setOpenId(openId);
        return context;
    }

    private OpenApiExecutionContext.App getApp(String tenantCode) {
        String METHOD_NAME = ".getApp";
        this.logger.info("datasign.OpenApiContextServiceImpl.getApp", (Object)(":params:" + tenantCode));
        String appId = this.getDdFlag(tenantCode, "FASC", "FASC_APP_ID");
        String appSecret = this.getDdFlag(tenantCode, "FASC", "FASC_APP_SECRET");
        String serverUrl = this.getDdFlag(tenantCode, "FASC", "FASC_SERVER_URL");
        String openCorpId = this.getDdFlag(tenantCode, "FASC", "FASC_OPEN_ID");
        String callbackUrl = this.getDdFlag(tenantCode, "FASC", "FASC_CALLBACK_URL");
        return OpenApiExecutionContext.App.builder().appId(appId).appSecret(appSecret).serverUrl(serverUrl).openCorpId(openCorpId).callbackUrl(callbackUrl).build();
    }

    private OpenApiClient getOpenApiClient(String tenantCode, OpenApiExecutionContext.App app) {
        String METHOD_NAME = ".getOpenApiClient";
        this.logger.info("datasign.OpenApiContextServiceImpl.getOpenApiClient", (Object)(":params:" + tenantCode));
        OpenApiClient openApiClient = this.OPEN_API_CLIENT_CACHE.get(tenantCode);
        if (openApiClient != null) {
            return openApiClient;
        }
        openApiClient = this.createOpenApiClient(app);
        this.OPEN_API_CLIENT_CACHE.put(tenantCode, openApiClient);
        return openApiClient;
    }

    private OpenApiClient createOpenApiClient(OpenApiExecutionContext.App app) {
        String METHOD_NAME = ".createOpenApiClient";
        this.logger.info("datasign.OpenApiContextServiceImpl.createOpenApiClient", (Object)(":params:" + JsonUtil.buildNormalBinder().toJson((Object)app)));
        OpenApiClient openApiClient = new OpenApiClient(app.getAppId(), app.getAppSecret(), app.getServerUrl());
        HttpConfig httpConfig = new HttpConfig();
        httpConfig.setConnectTimeout(Integer.valueOf(1000000));
        httpConfig.setReadTimeout(Integer.valueOf(1000000));
        openApiClient.setHttpConfig(httpConfig);
        openApiClient.setJsonStrategy((JsonStrategy)new DefaultJsonStrategy());
        return openApiClient;
    }

    public String getAccessToken(OpenApiExecutionContext context) throws ApiException {
        String METHOD_NAME = ".getAccessToken";
        this.logger.info("datasign.OpenApiContextServiceImpl.getAccessToken", (Object)(":params:" + JsonUtil.buildNormalBinder().toJson((Object)context)));
        try {
            String accessToken = SupDisUtil.get((String)(ACCESS_TOKEN_KEY + context.getTenantCode()));
            if (StrUtil.isNotBlank((CharSequence)accessToken)) {
                return accessToken;
            }
            OpenApiClient openApiClient = context.getOpenApiClient();
            ServiceClient serviceClient = new ServiceClient(openApiClient);
            BaseRes res = serviceClient.getAccessToken();
            ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
            accessToken = ((AccessTokenRes)res.getData()).getAccessToken();
            this.cacheAccessToken(context.getTenantCode(), accessToken);
            return accessToken;
        }
        catch (Exception e) {
            this.logger.error("datasign.OpenApiContextServiceImpl.getAccessToken", (Object)("\u83b7\u53d6accessToken\u5931\u8d25\uff01" + e.getMessage()), (Throwable)e);
            throw new ApiException("accessToken", "\u83b7\u53d6accessToken\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private void cacheAccessToken(String tenantCode, String accessToken) {
        SupDisUtil.set((String)(ACCESS_TOKEN_KEY + tenantCode), (String)accessToken, (int)3600);
    }
}

