/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.sign.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.common.Actor;
import com.fasc.open.api.bean.common.AudioVideoInfo;
import com.fasc.open.api.enums.common.IdTypeEnum;
import com.fasc.open.api.enums.doc.FileTypeEnum;
import com.fasc.open.api.enums.template.SignTemplateStatusEnum;
import com.fasc.open.api.v5_1.req.doc.FddFileUrl;
import com.fasc.open.api.v5_1.req.doc.FileProcessReq;
import com.fasc.open.api.v5_1.req.doc.GetUploadUrlReq;
import com.fasc.open.api.v5_1.req.signtask.ActorAttachInfo;
import com.fasc.open.api.v5_1.req.signtask.AddActorsTempInfo;
import com.fasc.open.api.v5_1.req.signtask.AddAttachInfo;
import com.fasc.open.api.v5_1.req.signtask.AddAttachReq;
import com.fasc.open.api.v5_1.req.signtask.AddFillFieldInfo;
import com.fasc.open.api.v5_1.req.signtask.AddSignFieldInfo;
import com.fasc.open.api.v5_1.req.signtask.CreateWithTemplateReq;
import com.fasc.open.api.v5_1.req.signtask.FillFieldValuesReq;
import com.fasc.open.api.v5_1.req.signtask.GetOwnerDownloadUrlReq;
import com.fasc.open.api.v5_1.req.signtask.SignTaskActorGetUrlReq;
import com.fasc.open.api.v5_1.req.signtask.SignTaskBaseReq;
import com.fasc.open.api.v5_1.req.signtask.TemplateSignConfigInfoReq;
import com.fasc.open.api.v5_1.req.signtask.Watermark;
import com.fasc.open.api.v5_1.res.doc.FileProcessRes;
import com.fasc.open.api.v5_1.res.doc.GetUploadUrlRes;
import com.fasc.open.api.v5_1.res.signtask.CreateSignTaskRes;
import com.fasc.open.api.v5_1.res.signtask.OwnerDownloadUrlRes;
import com.fasc.open.api.v5_1.res.signtask.SignTaskActorGetUrlRes;
import com.fasc.open.api.v5_1.res.template.FillActorFieldInfo;
import com.fasc.open.api.v5_1.res.template.SignActorFieldInfo;
import com.fasc.open.api.v5_1.res.template.SignTaskActorInfo;
import com.fasc.open.api.v5_1.res.template.SignTemplateDetailRes;
import com.yqbsoft.laser.bus.ext.data.sign.context.OpenApiExecutionContext;
import com.yqbsoft.laser.bus.ext.data.sign.request.CreateSignTaskWithTemplateRequest;
import com.yqbsoft.laser.bus.ext.data.sign.request.GetOwnerDownloadUrlRequest;
import com.yqbsoft.laser.bus.ext.data.sign.request.SignTaskActorGetUrlRequest;
import com.yqbsoft.laser.bus.ext.data.sign.service.OpenApiContextService;
import com.yqbsoft.laser.bus.ext.data.sign.service.SignTaskService;
import com.yqbsoft.laser.bus.ext.data.sign.service.SignTemplateService;
import com.yqbsoft.laser.bus.ext.data.sign.supbase.BusBaseService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SignTaskServiceImpl
extends BusBaseService
implements SignTaskService {
    private static final String SYS_CODE = "datasign.SignTaskServiceImpl";
    @Autowired
    private OpenApiContextService openApiContextService;
    @Autowired
    private SignTemplateService signTemplateService;

    @Override
    public String createSignTaskWithTemplate(CreateSignTaskWithTemplateRequest request) throws ApiException {
        String METHOD_NAME = ".createSignTaskWithTemplate";
        this.logger.info("datasign.SignTaskServiceImpl.createSignTaskWithTemplate", (Object)(":params:" + JsonUtil.buildNormalBinder().toJson((Object)request)));
        OpenApiExecutionContext context = this.openApiContextService.getExecutionContext(request.getTenantCode());
        SignTemplateDetailRes signTemplate = this.getSignTemplateDetail(request.getTenantCode(), request.getSignTemplateId());
        String signTaskId = this.createWithTemplate(context, request, signTemplate);
        this.fillFieldValues(context, signTaskId, request);
        if (CollectionUtil.isNotEmpty(request.getAttaches())) {
            request.getAttaches().forEach(attach -> {
                GetUploadUrlRes uploadUrlRes = this.getUploadFileUrl(context);
                attach.setFddFileUrl(uploadUrlRes.getFddFileUrl());
                attach.setUploadUrl(uploadUrlRes.getUploadUrl());
                this.uploadFile(request.getTenantCode(), (CreateSignTaskWithTemplateRequest.Attach)attach);
            });
            this.process(context, request.getAttaches());
            this.addAttach(context, signTaskId, request.getAttaches());
        }
        this.start(context, signTaskId);
        return signTaskId;
    }

    @Override
    public SignTaskActorGetUrlRes signTaskActorGetUrl(SignTaskActorGetUrlRequest request) throws ApiException {
        String METHOD_NAME = ".signTaskActorGetUrl";
        this.logger.info("datasign.SignTaskServiceImpl.signTaskActorGetUrl", (Object)(":params:" + JsonUtil.buildNormalBinder().toJson((Object)request)));
        OpenApiExecutionContext context = this.openApiContextService.getExecutionContext(request.getTenantCode());
        SignTaskActorGetUrlReq req = context.initReq(SignTaskActorGetUrlReq.class);
        req.setSignTaskId(request.getSignTaskId());
        req.setActorId(request.getActorId());
        try {
            BaseRes res = context.getSignTaskClient().signTaskActorGetUrl(req);
            this.printLog(SYS_CODE, ".signTaskActorGetUrl", res, context.getOpenApiClient().getJsonStrategy());
            return (SignTaskActorGetUrlRes)res.getData();
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.signTaskActorGetUrl", (Object)"\u83b7\u53d6\u53c2\u4e0e\u65b9\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".signTaskActorGetUrl", "\u83b7\u53d6\u53c2\u4e0e\u65b9\u7b7e\u7f72\u94fe\u63a5\u5931\u8d25\uff01");
        }
    }

    @Override
    public OwnerDownloadUrlRes getOwnerDownloadUrl(GetOwnerDownloadUrlRequest request) throws ApiException {
        String METHOD_NAME = ".getOwnerDownloadUrl";
        this.logger.info("datasign.SignTaskServiceImpl.getOwnerDownloadUrl", (Object)(":params:" + JsonUtil.buildNormalBinder().toJson((Object)request)));
        OpenApiExecutionContext context = this.openApiContextService.getExecutionContext(request.getTenantCode());
        GetOwnerDownloadUrlReq req = context.initReq(GetOwnerDownloadUrlReq.class);
        req.setSignTaskId(request.getSignTaskId());
        try {
            BaseRes res = context.getSignTaskClient().getOwnerDownloadUrl(req);
            this.printLog(SYS_CODE, ".getOwnerDownloadUrl", res, context.getOpenApiClient().getJsonStrategy());
            return (OwnerDownloadUrlRes)res.getData();
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.getOwnerDownloadUrl", (Object)"\u83b7\u53d6\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".getOwnerDownloadUrl", "\u83b7\u53d6\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff01");
        }
    }

    private String createWithTemplate(OpenApiExecutionContext context, CreateSignTaskWithTemplateRequest request, SignTemplateDetailRes signTemplate) {
        String METHOD_NAME = ".createWithTemplate";
        CreateWithTemplateReq req = this.buildCreateWithTemplateReq(context, request);
        req.setActors(this.buildAddActorsTempInfos(context, request, signTemplate));
        try {
            BaseRes res = context.getSignTaskClient().createWithTemplate(req);
            this.printLog(SYS_CODE, ".createWithTemplate", res, context.getOpenApiClient().getJsonStrategy());
            return ((CreateSignTaskRes)res.getData()).getSignTaskId();
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.createWithTemplate", (Object)"\u521b\u5efa\u7b7e\u7f72\u4efb\u52a1(\u57fa\u4e8e\u7b7e\u7f72\u4efb\u52a1\u6a21\u677f)\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".createWithTemplate", "\u521b\u5efa\u7b7e\u7f72\u4efb\u52a1(\u57fa\u4e8e\u7b7e\u7f72\u4efb\u52a1\u6a21\u677f)\u5931\u8d25\uff01");
        }
    }

    private SignTemplateDetailRes getSignTemplateDetail(String tenantCode, String signTemplateId) {
        SignTemplateDetailRes signTemplate = this.signTemplateService.getSignTemplateDetail(tenantCode, signTemplateId);
        if (ObjectUtil.isNull((Object)signTemplate)) {
            throw new ApiException("SignTemplate", "\u7b7e\u7f72\u6a21\u677fID\u4e0d\u5b58\u5728\uff01");
        }
        if (!StrUtil.equals((CharSequence)signTemplate.getSignTemplateStatus(), (CharSequence)SignTemplateStatusEnum.VALID.getCode())) {
            throw new ApiException("SignTemplate", "\u7b7e\u7f72\u6a21\u677f\u672a\u542f\u7528\uff01");
        }
        return signTemplate;
    }

    private CreateWithTemplateReq buildCreateWithTemplateReq(OpenApiExecutionContext context, CreateSignTaskWithTemplateRequest request) {
        CreateWithTemplateReq req = context.initCreateWithTemplateReq();
        req.setInitiatorMemberId(request.getInitiatorMemberId());
        req.setSignTaskSubject(request.getSignTaskSubject());
        req.setSignTemplateId(request.getSignTemplateId());
        req.setExpiresTime(request.getExpiresTime());
        req.setDueDate(request.getDueDate());
        req.setAutoStart(Boolean.valueOf(false));
        req.setAutoFinish(Boolean.valueOf(true));
        req.setAutoFillFinalize(Boolean.valueOf(true));
        req.setTransReferenceId(request.getTransReferenceId());
        req.setCallbackUrl(context.getApp().getCallbackUrl());
        return req;
    }

    private List<AddActorsTempInfo> buildAddActorsTempInfos(OpenApiExecutionContext context, CreateSignTaskWithTemplateRequest request, SignTemplateDetailRes signTemplate) {
        ArrayList<AddActorsTempInfo> addActorsTempInfos = new ArrayList<AddActorsTempInfo>();
        List<CreateSignTaskWithTemplateRequest.Actor> taskActors = request.getActors();
        List templateActors = signTemplate.getActors();
        if (ObjectUtil.notEqual((Object)taskActors.size(), (Object)templateActors.size())) {
            throw new ApiException("Actor", "\u53c2\u4e0e\u65b9\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        taskActors.forEach(taskActor -> {
            String actorId = taskActor.getActorId();
            SignTaskActorInfo templateActor = templateActors.stream().filter(t -> ObjectUtil.equal((Object)t.getActorInfo().getActorId(), (Object)actorId)).findFirst().orElse(null);
            if (ObjectUtil.isNull((Object)templateActor)) {
                throw new ApiException("Actor", "\u53c2\u4e0e\u65b9" + actorId + "\u4e0d\u5b58\u5728\uff01");
            }
            AddActorsTempInfo addActorsTempInfo = new AddActorsTempInfo();
            Actor actor = this.buildActor(context, (CreateSignTaskWithTemplateRequest.Actor)taskActor, templateActor);
            addActorsTempInfo.setActor(actor);
            if (CollectionUtil.isNotEmpty((Collection)templateActor.getSignFields())) {
                addActorsTempInfo.setSignFields(this.buildAddSignFieldInfo(templateActor.getSignFields()));
            }
            if (CollectionUtil.isNotEmpty((Collection)templateActor.getFillFields())) {
                addActorsTempInfo.setFillFields(this.buildAddFillFieldInfo(templateActor.getFillFields()));
            }
            addActorsTempInfos.add(addActorsTempInfo);
        });
        return addActorsTempInfos;
    }

    private Actor buildActor(OpenApiExecutionContext context, CreateSignTaskWithTemplateRequest.Actor taskActor, SignTaskActorInfo templateActor) {
        Actor actor = new Actor();
        actor.setActorId(taskActor.getActorId());
        actor.setActorType(templateActor.getActorInfo().getActorType());
        actor.setActorName(taskActor.getActorName());
        actor.setPermissions(templateActor.getActorInfo().getPermissions());
        if (StrUtil.equals((CharSequence)actor.getActorType(), (CharSequence)IdTypeEnum.CORP.getCode())) {
            actor.setActorOpenId(context.getApp().getOpenCorpId());
        }
        if (StrUtil.equals((CharSequence)actor.getActorType(), (CharSequence)IdTypeEnum.PERSON.getCode())) {
            actor.setAccountName(taskActor.getAccountName());
        }
        return actor;
    }

    private List<AddSignFieldInfo> buildAddSignFieldInfo(List<SignActorFieldInfo> signFields) {
        return signFields.stream().map(field -> {
            AddSignFieldInfo addSignFieldInfo = new AddSignFieldInfo();
            addSignFieldInfo.setFieldDocId(String.valueOf(field.getFieldDocId()));
            addSignFieldInfo.setFieldId(field.getFieldId());
            return addSignFieldInfo;
        }).collect(Collectors.toList());
    }

    private List<AddFillFieldInfo> buildAddFillFieldInfo(List<FillActorFieldInfo> fillFields) {
        return fillFields.stream().map(field -> {
            AddFillFieldInfo addFillFieldInfo = new AddFillFieldInfo();
            addFillFieldInfo.setFieldDocId(String.valueOf(field.getFieldDocId()));
            addFillFieldInfo.setFieldId(field.getFieldId());
            return addFillFieldInfo;
        }).collect(Collectors.toList());
    }

    private void fillFieldValues(OpenApiExecutionContext context, String signTaskId, CreateSignTaskWithTemplateRequest request) throws ApiException {
        String METHOD_NAME = ".fillFieldValues";
        FillFieldValuesReq req = context.initReq(FillFieldValuesReq.class);
        req.setSignTaskId(signTaskId);
        req.setDocFieldValues(request.getDocFieldValues());
        try {
            BaseRes res = context.getSignTaskClient().fillFieldValues(req);
            this.printLog(SYS_CODE, ".fillFieldValues", res, context.getOpenApiClient().getJsonStrategy());
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.fillFieldValues", (Object)"\u586b\u5145\u7b7e\u7f72\u4efb\u52a1\u5b57\u6bb5\u503c\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".fillFieldValues", "\u586b\u5145\u7b7e\u7f72\u4efb\u52a1\u5b57\u6bb5\u503c\u5931\u8d25\uff01");
        }
    }

    private GetUploadUrlRes getUploadFileUrl(OpenApiExecutionContext context) {
        String METHOD_NAME = ".getUploadFileUrl";
        GetUploadUrlReq req = context.initReq(GetUploadUrlReq.class);
        req.setFileType(FileTypeEnum.ATTACH.getCode());
        try {
            BaseRes res = context.getDocClient().getUploadFileUrl(req);
            this.printLog(SYS_CODE, ".getUploadFileUrl", res, context.getOpenApiClient().getJsonStrategy());
            return (GetUploadUrlRes)res.getData();
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.getUploadFileUrl", (Object)"\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".getUploadFileUrl", "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5931\u8d25\uff01");
        }
    }

    private void uploadFile(String tenantCode, CreateSignTaskWithTemplateRequest.Attach attach) {
        String METHOD_NAME = ".uploadFile";
        try {
            int readByte;
            String fullFilePath = this.buildFilePath(attach.getAttachPath());
            int lastSlash = fullFilePath.lastIndexOf("/");
            String fileName = fullFilePath.substring(lastSlash + 1);
            String lastFilePath = "/data/file/" + tenantCode + "/" + fileName;
            URL uploadUrl = new URL(attach.getUploadUrl());
            HttpURLConnection connection = (HttpURLConnection)uploadUrl.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            connection.setDoOutput(true);
            BufferedOutputStream bos = new BufferedOutputStream(connection.getOutputStream());
            BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(lastFilePath, new String[0]), new OpenOption[0]));
            while ((readByte = bis.read()) != -1) {
                bos.write(readByte);
            }
            bis.close();
            bos.close();
            int responseCode = connection.getResponseCode();
            this.logger.info("datasign.SignTaskServiceImpl.uploadFile", (Object)("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c\uff1a" + responseCode + ":" + connection.getResponseMessage()));
            if (responseCode == 200) {
                throw new ApiException(".uploadFile", "\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("datasign.SignTaskServiceImpl.uploadFile", (Object)"\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".uploadFile", "\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
        }
    }

    private String buildFilePath(String filePath) {
        if (StringUtils.isBlank((String)filePath)) {
            return "";
        }
        String[] split = filePath.split("/");
        return "/" + Arrays.stream(split).filter(s -> !s.isEmpty()).collect(Collectors.joining("/"));
    }

    private void process(OpenApiExecutionContext context, List<CreateSignTaskWithTemplateRequest.Attach> attaches) {
        String METHOD_NAME = ".process";
        FileProcessReq req = context.initReq(FileProcessReq.class);
        if (CollectionUtil.isEmpty((Collection)req.getFddFileUrlList())) {
            req.setFddFileUrlList(new ArrayList());
        }
        attaches.forEach(attach -> {
            FddFileUrl fu = new FddFileUrl();
            fu.setFileType(FileTypeEnum.ATTACH.getCode());
            fu.setFddFileUrl(attach.getFddFileUrl());
            fu.setFileName(attach.getAttachName());
            req.getFddFileUrlList().add(fu);
        });
        try {
            BaseRes res = context.getDocClient().process(req);
            this.printLog(SYS_CODE, ".process", res, context.getOpenApiClient().getJsonStrategy());
            ((FileProcessRes)res.getData()).getFileIdList().forEach(f -> attaches.stream().filter(a -> StrUtil.equals((CharSequence)a.getFddFileUrl(), (CharSequence)f.getFddFileUrl()) && StrUtil.equals((CharSequence)a.getAttachName(), (CharSequence)f.getFileName())).findFirst().ifPresent(a -> a.setAttachFileId(f.getFileId())));
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.process", (Object)"\u5904\u7406\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".process", "\u5904\u7406\u6587\u4ef6\u5931\u8d25\uff01");
        }
    }

    private void addAttach(OpenApiExecutionContext context, String signTaskId, List<CreateSignTaskWithTemplateRequest.Attach> attaches) throws ApiException {
        String METHOD_NAME = ".addAttach";
        AddAttachReq req = context.initReq(AddAttachReq.class);
        req.setSignTaskId(signTaskId);
        List aa = attaches.stream().map(a -> {
            AddAttachInfo info = new AddAttachInfo();
            info.setAttachId(UUID.randomUUID().toString().replace("-", ""));
            info.setAttachFileId(a.getAttachFileId());
            info.setAttachName(a.getAttachName());
            return info;
        }).collect(Collectors.toList());
        req.setAttachs(aa);
        try {
            BaseRes res = context.getSignTaskClient().addAttach(req);
            this.printLog(SYS_CODE, ".addAttach", res, context.getOpenApiClient().getJsonStrategy());
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.addAttach", (Object)"\u6dfb\u52a0\u7b7e\u7f72\u4efb\u52a1\u9644\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".addAttach", "\u6dfb\u52a0\u7b7e\u7f72\u4efb\u52a1\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }

    private void start(OpenApiExecutionContext context, String signTaskId) throws ApiException {
        String METHOD_NAME = ".start";
        SignTaskBaseReq req = context.initReq(SignTaskBaseReq.class);
        req.setSignTaskId(signTaskId);
        try {
            BaseRes res = context.getSignTaskClient().start(req);
            this.printLog(SYS_CODE, ".start", res, context.getOpenApiClient().getJsonStrategy());
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                throw new ApiException((Throwable)e);
            }
            this.logger.error("datasign.SignTaskServiceImpl.start", (Object)"\u63d0\u4ea4\u7b7e\u7f72\u4efb\u52a1\u5931\u8d25\uff01", (Throwable)e);
            throw new ApiException(".start", "\u63d0\u4ea4\u7b7e\u7f72\u4efb\u52a1\u5931\u8d25\uff01");
        }
    }

    private TemplateSignConfigInfoReq buildSignConfigInfo() {
        TemplateSignConfigInfoReq templateSignConfigInfoReq = new TemplateSignConfigInfoReq();
        templateSignConfigInfoReq.setOrderNo(null);
        templateSignConfigInfoReq.setFreeDragSealId(null);
        templateSignConfigInfoReq.setSignAllDoc(Boolean.valueOf(false));
        templateSignConfigInfoReq.setBlockHere(Boolean.valueOf(false));
        templateSignConfigInfoReq.setRequestVerifyFree(Boolean.valueOf(false));
        templateSignConfigInfoReq.setAuthorizeFreeSign(Boolean.valueOf(false));
        templateSignConfigInfoReq.setRequestMemberSign(Boolean.valueOf(false));
        templateSignConfigInfoReq.setSignerSignMethod(null);
        templateSignConfigInfoReq.setVerifyMethods(null);
        templateSignConfigInfoReq.setAudioVideoInfos(null);
        templateSignConfigInfoReq.setJoinByLink(Boolean.valueOf(true));
        templateSignConfigInfoReq.setReadingToEnd(Boolean.valueOf(false));
        templateSignConfigInfoReq.setReadingTime(null);
        templateSignConfigInfoReq.setFreeLogin(Boolean.valueOf(false));
        templateSignConfigInfoReq.setIdentifiedView(Boolean.valueOf(true));
        templateSignConfigInfoReq.setResizeSeal(Boolean.valueOf(false));
        templateSignConfigInfoReq.setMultiFactor(null);
        templateSignConfigInfoReq.setActorAttachInfos(null);
        return templateSignConfigInfoReq;
    }

    private AudioVideoInfo buildAudioVideoInfo() {
        AudioVideoInfo audioVideoInfo = new AudioVideoInfo();
        audioVideoInfo.setAudioText(null);
        audioVideoInfo.setAnswerText(null);
        audioVideoInfo.setSkipVerification(Boolean.valueOf(false));
        return audioVideoInfo;
    }

    private ActorAttachInfo buildActorAttachInfo() {
        ActorAttachInfo actorAttachInfo = new ActorAttachInfo();
        actorAttachInfo.setActorAttachName("");
        actorAttachInfo.setRequired(Boolean.valueOf(false));
        return actorAttachInfo;
    }

    private Watermark buildWatermark() {
        Watermark watermark = new Watermark();
        watermark.setType(null);
        watermark.setContent(null);
        watermark.setFontSize(Integer.valueOf(14));
        watermark.setFontColor("#000000");
        watermark.setPicBase64(null);
        watermark.setPicWidth(null);
        watermark.setPicHeight(null);
        watermark.setRotation(Integer.valueOf(0));
        watermark.setTransparency(Integer.valueOf(50));
        watermark.setPosition(null);
        watermark.setDensity(null);
        return watermark;
    }
}

