/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    public static String httpGet(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (MapUtil.isNotEmpty(httpParam)) {
            String pstr = "";
            for (String key : httpParam.keySet()) {
                if (StringUtils.isNotBlank((String)pstr)) {
                    pstr = pstr + "&";
                }
                pstr = pstr + key + "=" + httpParam.get(key);
            }
            url = url + "?" + pstr;
        }
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(url).get().addHeader("Content-Type", ctype).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String httpPost(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (MapUtil.isNotEmpty(httpParam)) {
            Set<String> keySet = httpParam.keySet();
            for (String key : keySet) {
                String value = httpParam.get(key);
                formBodyBuilder.add(key, value);
            }
        }
        FormBody formBody = formBodyBuilder.build();
        Request request = new Request.Builder().post((RequestBody)formBody).addHeader("Content-Type", ctype).url(url).build();
        try {
            OkHttpClient mOkHttpClient = new OkHttpClient();
            Response response = mOkHttpClient.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

