/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.f4b6a3.ulid.UlidCreator;
import com.yqbsoft.laser.service.adapter.oss.ImageCMYKUtil;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(OssClientUtil.class);
    private static String aliOSS = "0";
    private static String jdOSS = "1";

    public static String uploadOSS(Map<String, Object> paramMap, FileBean fileBean) {
        logger.info("OssClientUtil.uploadOSS.paramMap={}", paramMap);
        String accessKeyId = EmptyUtil.isEmpty((Object)paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty((Object)paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty((Object)paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String ossUrl = EmptyUtil.isEmpty((Object)paramMap.get("ossUrl")) ? "" : String.valueOf(paramMap.get("ossUrl"));
        String bucketName = EmptyUtil.isEmpty((Object)paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String objectNamePath = EmptyUtil.isEmpty((Object)paramMap.get("objectNamePath")) ? "" : String.valueOf(paramMap.get("objectNamePath"));
        String fileName = EmptyUtil.isEmpty((Object)paramMap.get("fileName")) ? "" : String.valueOf(paramMap.get("fileName"));
        String ossToype = EmptyUtil.isEmpty((Object)paramMap.get("ossType")) ? "" : String.valueOf(paramMap.get("ossType"));
        String tag = "-1";
        if (StringUtils.isBlank((String)accessKeyId) || StringUtils.isBlank((String)accessKeySecret) || StringUtils.isBlank((String)endPoint) || StringUtils.isBlank((String)bucketName) || EmptyUtil.isEmpty((Object)fileBean)) {
            logger.error("OssClientUtil.uploadOSS.null,{}", paramMap);
            return tag;
        }
        try {
            if (StringUtils.isBlank((String)fileName)) {
                fileName = fileBean.getName();
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && objectNamePath.startsWith("/")) {
                objectNamePath = objectNamePath.substring(1);
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && objectNamePath.endsWith("//")) {
                objectNamePath = objectNamePath.substring(0, objectNamePath.length() - 1);
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && !objectNamePath.endsWith("/")) {
                objectNamePath = objectNamePath.concat("/");
            }
            fileName = OssClientUtil.encodeFileName(fileName);
            logger.info("OssClientUtil.uploadOSS.info,{}", (Object)(endPoint + "=" + objectNamePath + fileName));
            if (aliOSS.equals(ossToype)) {
                OSSClient aliClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
                boolean found = aliClient.doesObjectExist(bucketName, objectNamePath + fileName);
                if (found) {
                    logger.info("OssClientUtil.uploadOSS.\u5b58\u5728\u56fe\u7247\u5220\u9664,{}", (Object)(objectNamePath + fileName));
                    aliClient.deleteObject(bucketName, objectNamePath + fileName);
                }
                return OssClientUtil.aliUpload(aliClient, bucketName, ossUrl, objectNamePath, fileName, fileBean);
            }
            if (jdOSS.equals(ossToype)) {
                AmazonS3 JdClient = OssClientUtil.loadJdOSS(endPoint, accessKeyId, accessKeySecret);
                return String.valueOf(OssClientUtil.jdUpload(JdClient, bucketName, objectNamePath, fileName, fileBean));
            }
            logger.error("OssClientUtil.uploadOSS.ossToype,{}", (Object)ossToype);
            return tag;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.uploadOSS.e,{}", paramMap, (Object)e);
            return tag;
        }
    }

    private static AmazonS3 loadJdOSS(String endPoint, String AKid, String AKSecret) {
        System.setProperty("com.amazonaws.services.s3.enableV4", "true");
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(endPoint, "cn-north-1");
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(AKid, AKSecret);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        return s3;
    }

    private static OSSClient loadAliOSS(String endPoint, String accessKeyId, String accessKeySecret) {
        return new OSSClient(endPoint, accessKeyId, accessKeySecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String aliUpload(OSSClient ossClient, String bucketname, String OSSUrl, String objectNamePath, String fileName, FileBean fileBean) throws IOException {
        logger.info("-======> aliUpload \u5f00\u59cb,{}", (Object)(fileName + "," + fileBean.getFilelistOcode()));
        String tag = "-1";
        InputStream inputStream = null;
        try {
            inputStream = StringUtils.isNotBlank((String)fileBean.getFilelistOcode()) && fileBean.getFilelistOcode().indexOf("unzip") > -1 ? new ByteArrayInputStream(fileBean.getBytes()) : OssClientUtil.imageZip(fileBean.getBytes(), fileName);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)inputStream.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentType(OssClientUtil.getContentType(fileName));
            metadata.setContentDisposition("inline;filename=" + fileName);
            PutObjectResult putResult = ossClient.putObject(bucketname, objectNamePath + fileName, inputStream, metadata);
            if (OSSUrl.indexOf("{") >= 0) {
                OSSUrl = OSSUrl.replace("{objectNamePath}", objectNamePath);
                OSSUrl = OSSUrl.replace("{fileName}", fileName);
            } else {
                OSSUrl = OSSUrl + objectNamePath + fileName;
            }
            if (!"".equals(putResult.getETag())) {
                logger.info("\u4e0a\u4f20\u540e\u7684\u56fe\u7247MD5\u6570\u5b57\u552f\u4e00\u7b7e\u540d:" + putResult.getETag());
                logger.info("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u6210\u529f:" + OSSUrl);
                String string = OSSUrl;
                return string;
            }
            logger.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38");
        }
        catch (Exception e) {
            logger.error("OssClientUtil.AliUpload.e", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            ossClient.shutdown();
        }
        return tag;
    }

    public static String encodeFileName(String fileName) throws Exception {
        String encodeName = fileName.substring(0, fileName.lastIndexOf("."));
        String postfix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        encodeName = encodeName + "-" + UlidCreator.getMonotonicUlid();
        logger.debug("\u9644\u4ef6[" + fileName + "]\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u540d:" + encodeName + postfix);
        return encodeName + postfix;
    }

    public static void main(String[] args) throws Exception {
        OssClientUtil.imageZip(new byte[]{1, 2, 3}, "\uffe6\uffb5\uff8b\uffe8\uffaf\uff95.pdf");
    }

    public static byte[] getImageStream(String url) {
        byte[] buffer = null;
        File file = new File(url);
        try {
            int n;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String jdUpload(AmazonS3 s3, String bucketname, String objectNamePath, String filename, FileBean fileBean) {
        String tag = "-1";
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBean.getBytes());
            com.amazonaws.services.s3.model.ObjectMetadata objectMetadata = new com.amazonaws.services.s3.model.ObjectMetadata();
            objectMetadata.setContentLength(fileBean.getSize().longValue());
            s3.putObject(bucketname, objectNamePath + filename, (InputStream)inputStream, objectMetadata);
            URL url = s3.getUrl(bucketname, objectNamePath + filename);
            String string = String.valueOf(url);
            return string;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.JdUpload.e", (Throwable)e);
            String string = tag;
            return string;
        }
        finally {
            s3.shutdown();
        }
    }

    public static String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf("."));
        if (".bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if (".gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if (".jpeg".equalsIgnoreCase(fileExtension) || ".jpg".equalsIgnoreCase(fileExtension) || ".png".equalsIgnoreCase(fileExtension)) {
            return "image/jpg";
        }
        if (".html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if (".txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if (".vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if (".pptx".equalsIgnoreCase(fileExtension) || ".ppt".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if (".docx".equalsIgnoreCase(fileExtension) || ".doc".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if (".xla".equalsIgnoreCase(fileExtension) || ".xlc".equalsIgnoreCase(fileExtension) || ".xlm".equalsIgnoreCase(fileExtension) || ".xls".equalsIgnoreCase(fileExtension) || ".xlt".equalsIgnoreCase(fileExtension) || ".xlw".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-excel";
        }
        if (".xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        if (".pdf".equalsIgnoreCase(fileExtension)) {
            return "application/pdf";
        }
        if (".zip".equalsIgnoreCase(fileExtension)) {
            return "application/zip";
        }
        if (".tar".equalsIgnoreCase(fileExtension)) {
            return "application/x-tar";
        }
        if (".avi".equalsIgnoreCase(fileExtension)) {
            return "video/avi";
        }
        if (".mp4".equalsIgnoreCase(fileExtension)) {
            return "video/mpeg4";
        }
        if (".mp3".equalsIgnoreCase(fileExtension)) {
            return "audio/mp3";
        }
        if (".mp2".equalsIgnoreCase(fileExtension)) {
            return "audio/mp2";
        }
        return "application/octet-stream";
    }

    public static ByteArrayInputStream imageZip(byte[] bytes, String fileName) throws Exception {
        String formatName = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String contentType = OssClientUtil.getContentType(fileName);
        if (contentType.indexOf("image") == -1) {
            return inputStream;
        }
        int length = bytes.length;
        logger.info(" -- \u56fe\u7247\u538b\u7f29\u51c6\u5907 -- {}", (Object)("\u6587\u4ef6\u540d\uff1a" + fileName + ",size={" + length / 1000 + "}KB"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = ImageCMYKUtil.readImage(new ByteArrayInputStream(bytes));
        int newWidth = bufferedImage.getWidth() * 1;
        int newHeight = bufferedImage.getHeight() * 1;
        BufferedImage compressedImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = compressedImage.createGraphics();
        g2d.drawImage(bufferedImage, 0, 0, newWidth, newHeight, Color.WHITE, null);
        g2d.dispose();
        byte[] bytes1 = OssClientUtil.toByteArray(compressedImage, formatName);
        int length1 = bytes1.length;
        logger.info("  |-- \u56fe\u7247\u538b\u7f29\u5b8c\u6210 -- {}", (Object)("\u6587\u4ef6\u540d\uff1a" + fileName + ",size={" + length1 / 1000 + "}KB"));
        if (length1 > length) {
            return inputStream;
        }
        return new ByteArrayInputStream(bytes1);
    }

    public static byte[] toByteArray(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        return imageInByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listFileName(Map paramMap) {
        logger.info("OssClientUtil.listFileName.paramaMap=", (Object)paramMap);
        String accessKeyId = EmptyUtil.isEmpty(paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty(paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty(paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty(paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String prefix = EmptyUtil.isEmpty(paramMap.get("prefix")) ? "" : String.valueOf(paramMap.get("prefix"));
        String marker = EmptyUtil.isEmpty(paramMap.get("marker")) ? "" : String.valueOf(paramMap.get("marker"));
        Integer maxKeys = EmptyUtil.isEmpty(paramMap.get("maxKeys")) ? 100 : (Integer)paramMap.get("maxKeys");
        boolean hasNext = true;
        ArrayList<String> res = new ArrayList<String>();
        OSSClient ossClient = null;
        FileWriter fw = null;
        try {
            fw = new FileWriter("d:/1.txt");
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setPrefix(prefix);
            listObjectsRequest.setMarker(marker);
            listObjectsRequest.setMaxKeys(maxKeys);
            ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
            String nextMarker = "";
            ObjectListing objectListing = null;
            do {
                objectListing = ossClient.listObjects(new ListObjectsRequest(bucketName).withPrefix(prefix).withMarker(nextMarker).withMaxKeys(maxKeys));
                List sums = objectListing.getObjectSummaries();
                for (OSSObjectSummary s : sums) {
                    System.out.println("\t" + s.getKey());
                    fw.write(s.getKey() + "\r");
                }
                nextMarker = objectListing.getNextMarker();
            } while (objectListing.isTruncated());
        }
        catch (Exception e) {
            logger.error("OssClientUtil.listFileName.e", (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return res;
    }

    public static String deleteFiles(Map paramMap) {
        logger.info("OssClientUtil.deleteFiles.paramaMap=", (Object)paramMap);
        String accessKeyId = EmptyUtil.isEmpty(paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty(paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty(paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty(paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        List fileNameList = EmptyUtil.isEmpty(paramMap.get("fileNameList")) ? null : (List)paramMap.get("fileNameList");
        OSSClient ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
        DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(bucketName).withKeys(fileNameList));
        List deletedObjects = deleteObjectsResult.getDeletedObjects();
        ossClient.shutdown();
        return deletedObjects.size() + "";
    }

    public static String createFolder(Map paramMap) {
        logger.info("OssClientUtil.createFolder.paramaMap=", (Object)paramMap);
        String accessKeyId = EmptyUtil.isEmpty(paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty(paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty(paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty(paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String keySuffixWithSlash = EmptyUtil.isEmpty(paramMap.get("folder")) ? "" : String.valueOf(paramMap.get("folder"));
        OSSClient ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
        if (!ossClient.doesObjectExist(bucketName, keySuffixWithSlash)) {
            ossClient.putObject(bucketName, keySuffixWithSlash, (InputStream)new ByteArrayInputStream(new byte[0]));
            OSSObject object = ossClient.getObject(bucketName, keySuffixWithSlash);
            String fileDir = object.getKey();
            ossClient.shutdown();
            return fileDir;
        }
        return "-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String aliCopyFile(Map<String, Object> paramMap) {
        logger.info("OssClientUtil.createFolder.aliCopyFile=", paramMap);
        String accessKeyId = EmptyUtil.isEmpty((Object)paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty((Object)paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty((Object)paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String bucketName = EmptyUtil.isEmpty((Object)paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String sourceUrl = EmptyUtil.isEmpty((Object)paramMap.get("sourceUrl")) ? "" : String.valueOf(paramMap.get("sourceUrl"));
        String targetUrl = EmptyUtil.isEmpty((Object)paramMap.get("targetUrl")) ? "" : String.valueOf(paramMap.get("targetUrl"));
        OSSClient ossClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
        try {
            if (StringUtils.isNotBlank((String)sourceUrl) && StringUtils.isNotBlank((String)targetUrl)) {
                String fileDir;
                CopyObjectResult result = ossClient.copyObject(bucketName, sourceUrl, bucketName, targetUrl);
                logger.info("OssClientUtil.createFolder.aliCopyFile=", (Object)("ETag: " + result.getETag() + " LastModified: " + result.getLastModified()));
                String string = fileDir = result.getETag();
                return string;
            }
        }
        catch (Exception e) {
            logger.error("OssClientUtil.createFolder.aliCopyFile=", (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return "-1";
    }
}

