/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class OssClientUtil {
    protected static final SupperLogUtil logger = new SupperLogUtil(OssClientUtil.class);
    private static String aliOSS = "0";
    private static String jdOSS = "1";

    public static String uploadOSS(Map<String, Object> paramMap, FileBean fileBean) {
        String accessKeyId = EmptyUtil.isEmpty((Object)paramMap.get("accessKeyId")) ? "" : String.valueOf(paramMap.get("accessKeyId"));
        String accessKeySecret = EmptyUtil.isEmpty((Object)paramMap.get("accessKeySecret")) ? "" : String.valueOf(paramMap.get("accessKeySecret"));
        String endPoint = EmptyUtil.isEmpty((Object)paramMap.get("endPoint")) ? "" : String.valueOf(paramMap.get("endPoint"));
        String ossUrl = EmptyUtil.isEmpty((Object)paramMap.get("ossUrl")) ? "" : String.valueOf(paramMap.get("ossUrl"));
        String bucketName = EmptyUtil.isEmpty((Object)paramMap.get("bucketName")) ? "" : String.valueOf(paramMap.get("bucketName"));
        String objectNamePath = EmptyUtil.isEmpty((Object)paramMap.get("objectNamePath")) ? "" : String.valueOf(paramMap.get("objectNamePath"));
        String fileName = EmptyUtil.isEmpty((Object)paramMap.get("fileName")) ? "" : String.valueOf(paramMap.get("fileName"));
        String ossToype = EmptyUtil.isEmpty((Object)paramMap.get("ossType")) ? "" : String.valueOf(paramMap.get("ossType"));
        String tag = "-1";
        if (StringUtils.isBlank((String)accessKeyId) || StringUtils.isBlank((String)accessKeySecret) || StringUtils.isBlank((String)endPoint) || StringUtils.isBlank((String)bucketName) || EmptyUtil.isEmpty((Object)fileBean)) {
            logger.error("OssClientUtil.uploadOSS.null", paramMap);
            return tag;
        }
        try {
            if (StringUtils.isBlank((String)fileName)) {
                fileName = fileBean.getName();
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && objectNamePath.startsWith("/")) {
                objectNamePath = objectNamePath.substring(1);
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && objectNamePath.endsWith("//")) {
                objectNamePath = objectNamePath.substring(0, objectNamePath.length() - 1);
            }
            if (StringUtils.isNotBlank((String)objectNamePath) && !objectNamePath.endsWith("/")) {
                objectNamePath = objectNamePath.concat("/");
            }
            logger.info("OssClientUtil.uploadOSS.info", (Object)(endPoint + "=" + objectNamePath + fileName));
            if (aliOSS.equals(ossToype)) {
                OSSClient aliClient = OssClientUtil.loadAliOSS(endPoint, accessKeyId, accessKeySecret);
                boolean found = aliClient.doesObjectExist(bucketName, objectNamePath + fileName);
                if (found) {
                    aliClient.deleteObject(bucketName, objectNamePath + fileName);
                }
                return OssClientUtil.aliUpload(aliClient, bucketName, ossUrl, objectNamePath, fileName, fileBean);
            }
            if (jdOSS.equals(ossToype)) {
                AmazonS3 JdClient = OssClientUtil.loadJdOSS(endPoint, accessKeyId, accessKeySecret);
                return String.valueOf(OssClientUtil.jdUpload(JdClient, bucketName, objectNamePath, fileName, fileBean));
            }
            logger.error("OssClientUtil.uploadOSS.ossToype", (Object)ossToype);
            return tag;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.uploadOSS.e", paramMap, (Throwable)e);
            return tag;
        }
    }

    private static AmazonS3 loadJdOSS(String endPoint, String AKid, String AKSecret) {
        System.setProperty("com.amazonaws.services.s3.enableV4", "true");
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(endPoint, "cn-north-1");
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(AKid, AKSecret);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        return s3;
    }

    private static OSSClient loadAliOSS(String endPoint, String accessKeyId, String accessKeySecret) {
        return new OSSClient(endPoint, accessKeyId, accessKeySecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String aliUpload(OSSClient ossClient, String bucketname, String OSSUrl, String objectNamePath, String filename, FileBean fileBean) {
        String tag = "-1";
        try {
            ByteArrayInputStream content = new ByteArrayInputStream(fileBean.getBytes());
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(fileBean.getSize().longValue());
            ossClient.putObject(bucketname, objectNamePath + filename, (InputStream)content, meta);
            String string = OSSUrl + objectNamePath + filename;
            return string;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.AliUpload.e", (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String jdUpload(AmazonS3 s3, String bucketname, String objectNamePath, String filename, FileBean fileBean) {
        String tag = "-1";
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBean.getBytes());
            com.amazonaws.services.s3.model.ObjectMetadata objectMetadata = new com.amazonaws.services.s3.model.ObjectMetadata();
            objectMetadata.setContentLength(fileBean.getSize().longValue());
            s3.putObject(bucketname, objectNamePath + filename, (InputStream)inputStream, objectMetadata);
            URL url = s3.getUrl(bucketname, objectNamePath + filename);
            String string = String.valueOf(url);
            return string;
        }
        catch (Exception e) {
            logger.error("OssClientUtil.JdUpload.e", (Throwable)e);
            String string = tag;
            return string;
        }
        finally {
            s3.shutdown();
        }
    }
}

