/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.basicsetting.service.impl;

import com.yqbsoft.laser.service.basicsetting.dao.BsAreaMapper;
import com.yqbsoft.laser.service.basicsetting.domain.BsAreaDomain;
import com.yqbsoft.laser.service.basicsetting.model.BsArea;
import com.yqbsoft.laser.service.basicsetting.service.BsAreaService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BsAreaServiceImpl
extends BaseServiceImpl
implements BsAreaService {
    public static final String SYS_CODE = "bs.BASIC_SETTING.BsAreaServiceImpl";
    private BsAreaMapper bsAreaMapper;
    private String areaCache_key = "areaCache_key";

    public void setBsAreaMapper(BsAreaMapper bsAreaMapper) {
        this.bsAreaMapper = bsAreaMapper;
    }

    private Date getSysDate() {
        try {
            return this.bsAreaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkArea(BsAreaDomain bsAreaDomain) {
        if (null == bsAreaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAreaDefault(BsArea bsArea) {
        if (null == bsArea) {
            return;
        }
        if (null == bsArea.getDataState()) {
            bsArea.setDataState(0);
        }
        if (null == bsArea.getGmtCreate()) {
            bsArea.setGmtCreate(this.getSysDate());
        }
        bsArea.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsArea.getAreaCode())) {
            bsArea.setAreaCode(this.createUUIDString());
        }
    }

    private int getAreaMaxCode() {
        int code = 0;
        try {
            return this.bsAreaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.getAreaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAreaUpdataDefault(BsArea bsArea) {
        if (null == bsArea) {
            return;
        }
        bsArea.setGmtModified(this.getSysDate());
    }

    private void saveAreaModel(BsArea bsArea) throws ApiException {
        if (null == bsArea) {
            return;
        }
        try {
            this.bsAreaMapper.insert(bsArea);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.saveAreaModel.ex", (Throwable)e);
        }
    }

    private void saveAreaListModel(List<BsArea> bsAreas) throws ApiException {
        if (null == bsAreas) {
            return;
        }
        try {
            this.bsAreaMapper.insertBatch(bsAreas);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.saveAreaListModel.ex", (Throwable)e);
        }
    }

    private BsArea getAreaModelById(Integer areaId) {
        if (null == areaId) {
            return null;
        }
        try {
            return this.bsAreaMapper.selectByPrimaryKey(areaId);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.getAreaModelById", (Throwable)e);
            return null;
        }
    }

    public BsArea getAreaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.bsAreaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.getAreaModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAreaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.bsAreaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.delAreaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.delAreaModelByCode.num");
        }
    }

    private void deleteAreaModel(Integer areaId) throws ApiException {
        if (null == areaId) {
            return;
        }
        int i = 0;
        try {
            i = this.bsAreaMapper.deleteByPrimaryKey(areaId);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.deleteAreaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.deleteAreaModel.num");
        }
    }

    private void updateAreaModel(BsArea bsArea) throws ApiException {
        if (null == bsArea) {
            return;
        }
        try {
            this.bsAreaMapper.updateByPrimaryKeySelective(bsArea);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.updateAreaModel.ex", (Throwable)e);
        }
    }

    private void updateStateAreaModel(Integer areaId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == areaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("areaId", areaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.bsAreaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.updateStateAreaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.updateStateAreaModel.null");
        }
    }

    private BsArea makeArea(BsAreaDomain bsAreaDomain, BsArea bsArea) {
        if (null == bsAreaDomain) {
            return null;
        }
        if (null == bsArea) {
            bsArea = new BsArea();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsArea, (Object)bsAreaDomain);
            return bsArea;
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.makeArea", (Throwable)e);
            return null;
        }
    }

    private List<BsArea> queryAreaModelPage(Map<String, Object> parammap) {
        try {
            String p = JsonUtil.buildNormalBinder().toJson(parammap);
            this.logger.error("pmap=============================================================>>>>>>>>>>", (Object)p);
            return this.bsAreaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.queryAreaModel", (Throwable)e);
            return null;
        }
    }

    private int countArea(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.bsAreaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.countArea", (Throwable)e);
        }
        return i;
    }

    private void sendMsg(String dir, BsArea bsArea) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("channelsendType", "bsArea");
        p.put("channelsendDir", dir);
        p.put("channelsendTxt", JsonUtil.buildNormalBinder().toJson((Object)bsArea));
        p.put("channelsendOpcode", bsArea.getProvinceCode());
        p.put("tenantCode", bsArea.getTenantCode());
        paramsMap.put("emChannelSendDomain", JsonUtil.buildNormalBinder().toJson(p));
        this.internalInvoke("evm.emEngineService.send", paramsMap);
    }

    @Override
    public void saveArea(BsAreaDomain bsAreaDomain) throws ApiException {
        String msg = this.checkArea(bsAreaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.saveArea.checkArea", msg);
        }
        BsArea bsArea = this.makeArea(bsAreaDomain, null);
        this.setAreaDefault(bsArea);
        this.saveAreaModel(bsArea);
        this.sendMsg("add", bsArea);
    }

    @Override
    public void saveAreaList(List<BsAreaDomain> bsAreaDomains) throws ApiException {
        if (ListUtil.isEmpty(bsAreaDomains)) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.saveAreaListModel", "param null");
        }
        ArrayList<BsArea> bsAreas = new ArrayList<BsArea>();
        for (BsAreaDomain bsAreaDomain : bsAreaDomains) {
            BsArea bsArea = this.makeArea(bsAreaDomain, null);
            this.setAreaDefault(bsArea);
            bsAreas.add(bsArea);
        }
        this.saveAreaListModel(bsAreas);
    }

    @Override
    public void updateAreaState(Integer areaId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAreaModel(areaId, dataState, oldDataState);
    }

    @Override
    public void updateArea(BsAreaDomain bsAreaDomain) throws ApiException {
        String msg = this.checkArea(bsAreaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.updateArea.checkArea", msg);
        }
        BsArea oldBsArea = this.getAreaModelById(bsAreaDomain.getAreaId());
        if (null == oldBsArea) {
            throw new ApiException("bs.BASIC_SETTING.BsAreaServiceImpl.updateArea.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BsArea bsArea = this.makeArea(bsAreaDomain, oldBsArea);
        this.setAreaUpdataDefault(bsArea);
        this.updateAreaModel(bsArea);
        this.sendMsg("edit", bsArea);
    }

    @Override
    public void updateByAreaRemark(Map<String, Object> map) throws ApiException {
        this.bsAreaMapper.updateByAreaRemark(map);
    }

    @Override
    public BsArea getArea(Integer areaId) {
        return this.getAreaModelById(areaId);
    }

    @Override
    public void deleteArea(Integer areaId) throws ApiException {
        this.sendMsg("del", this.getAreaModelById(areaId));
        this.deleteAreaModel(areaId);
    }

    @Override
    public QueryResult<BsArea> queryAreaPage(Map<String, Object> map) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)((String)map.get("areaParentCode")))) {
            this.logger.error("bs.BASIC_SETTING.BsAreaServiceImpl.queryAreaPage.null", (Object)"\u5e02\u533acode\u4e3a\u7a7a");
            return new QueryResult();
        }
        List<BsArea> bsAreaList = this.queryAreaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countArea(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsAreaList);
        this.logger.info("bs.BASIC_SETTING.BsAreaServiceImpl.queryAreaPage.Total", (Object)queryResult.getTotal());
        return queryResult;
    }

    @Override
    public BsArea getAreaByCode(Map<String, Object> map) {
        return this.getAreaModelByCode(map);
    }

    @Override
    public void delAreaByCode(Map<String, Object> map) throws ApiException {
        this.delAreaModelByCode(map);
    }

    private List<BsArea> setChildAreaList(List<BsArea> listS, String parentCode) {
        ArrayList<BsArea> newList = new ArrayList<BsArea>();
        for (BsArea bsArea : listS) {
            if (!parentCode.equals(bsArea.getAreaParentCode())) continue;
            newList.add(bsArea);
        }
        if (newList != null && !newList.isEmpty()) {
            for (BsArea bsArea : newList) {
                bsArea.setChildren(this.setChildAreaList(listS, bsArea.getAreaCode()));
            }
        }
        return newList;
    }

    @Override
    public void queryProvinceAreaCache() {
        List<BsArea> list = this.queryAreaModelPage(new HashMap<String, Object>());
        Map<String, String> map = this.make(list);
        DisUtil.setMap((String)this.areaCache_key, map);
    }

    private Map<String, String> make(List<BsArea> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BsArea bsArea : list) {
            List<BsArea> p_list;
            if (!StringUtils.isNotBlank((String)bsArea.getProvinceCode())) continue;
            bsArea.setChildren(this.setChildAreaList(list, bsArea.getAreaCode()));
            String p_area = (String)map.get(bsArea.getProvinceCode());
            if (StringUtils.isBlank((String)p_area)) {
                p_list = new ArrayList<BsArea>();
                p_list.add(bsArea);
                map.put(bsArea.getProvinceCode(), JsonUtil.buildNormalBinder().toJson(p_list));
                continue;
            }
            p_list = (List)JsonUtil.buildNormalBinder().getJsonToList(p_area, BsArea.class);
            p_list.add(bsArea);
            map.put(bsArea.getProvinceCode(), JsonUtil.buildNormalBinder().toJson(p_list));
        }
        return map;
    }

    @Override
    public List<BsArea> queryAreaList(Map<String, Object> map) {
        List<BsArea> bsAreaList = this.queryAreaModelPage(map);
        return bsAreaList;
    }

    @Override
    public Map<String, List<BsArea>> queryAreaTree() {
        List<BsArea> bsAreaList = this.queryAreaModelPage(null);
        HashMap<String, List<BsArea>> map = new HashMap<String, List<BsArea>>();
        for (BsArea bsArea : bsAreaList) {
            if (!StringUtils.isNotBlank((String)bsArea.getProvinceCode())) continue;
            bsArea.setChildren(this.setChildAreaList(bsAreaList, bsArea.getAreaCode()));
            ArrayList<BsArea> p_list = (ArrayList<BsArea>)map.get(bsArea.getProvinceCode());
            if (null == p_list) {
                p_list = new ArrayList<BsArea>();
                p_list.add(bsArea);
                map.put(bsArea.getProvinceCode(), p_list);
                continue;
            }
            p_list.add(bsArea);
            map.put(bsArea.getProvinceCode(), p_list);
        }
        return map;
    }
}

