/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.dao.CdCardvirMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardvirDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirListDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirReDomain;
import com.yqbsoft.laser.service.cd.model.CdCardvir;
import com.yqbsoft.laser.service.cd.service.CdCardvirListService;
import com.yqbsoft.laser.service.cd.service.CdCardvirService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CdCardvirImpl
extends BaseServiceImpl
implements CdCardvirService {
    private static final String SYS_CODE = "cd.CARDP.CdCardvirImpl";
    private CdCardvirMapper cdCardvirMapper;
    private CdCardvirListService cdCardvirListService;
    public static final String RANDOM_MIXFX = "3459ACDEFHJKLPRSXYacdefhjklprsxy";

    public void setCdCardvirMapper(CdCardvirMapper cdCardvirMapper) {
        this.cdCardvirMapper = cdCardvirMapper;
    }

    public void setCdCardvirListService(CdCardvirListService cdCardvirListService) {
        this.cdCardvirListService = cdCardvirListService;
    }

    private Date getSysDate() {
        try {
            return this.cdCardvirMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardvir(CdCardvirDomain cdCardvirDomain) {
        if (null == cdCardvirDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardvirDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardvirDefault(CdCardvir cdCardvir) {
        if (null == cdCardvir) {
            return;
        }
        if (null == cdCardvir.getDataState()) {
            cdCardvir.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cdCardvir.getGmtCreate()) {
            cdCardvir.setGmtCreate(date);
        }
        cdCardvir.setGmtModified(date);
        if (StringUtils.isBlank((String)cdCardvir.getCardvirCode())) {
            cdCardvir.setCardvirCode(this.getNo(null, "CdCardvir", "cdCardvir", cdCardvir.getTenantCode()));
        }
        if (StringUtils.isBlank((String)cdCardvir.getCardpBatch())) {
            String cardpBatchNo = this.getNo("0", "CdCardvir", "cardpBatchNo", cdCardvir.getTenantCode());
            cdCardvir.setCardpBatch(cardpBatchNo);
        }
    }

    private int getCardvirMaxCode() {
        int code = 0;
        try {
            return this.cdCardvirMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.getCardvirMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardvirUpdataDefault(CdCardvir cdCardvir) {
        if (null == cdCardvir) {
            return;
        }
        cdCardvir.setGmtModified(this.getSysDate());
    }

    private void saveCardvirModel(CdCardvir cdCardvir) throws ApiException {
        if (null == cdCardvir) {
            return;
        }
        try {
            this.cdCardvirMapper.insert(cdCardvir);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.saveCardvirModel.ex", (Throwable)e);
        }
    }

    private void saveCardvirBatchModel(List<CdCardvir> cdCardvirList) throws ApiException {
        if (null == cdCardvirList || cdCardvirList.isEmpty()) {
            return;
        }
        try {
            this.cdCardvirMapper.insertBatch(cdCardvirList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.saveCardvirBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardvir getCardvirModelById(Integer cardvirId) {
        if (null == cardvirId) {
            return null;
        }
        try {
            return this.cdCardvirMapper.selectByPrimaryKey(cardvirId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.getCardvirModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardvir getCardvirModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardvirMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.getCardvirModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardvirModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.delCardvirModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.delCardvirModelByCode.num");
        }
    }

    private void deleteCardvirModel(Integer cardvirId) throws ApiException {
        if (null == cardvirId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirMapper.deleteByPrimaryKey(cardvirId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.deleteCardvirModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.deleteCardvirModel.num");
        }
    }

    private void updateCardvirModel(CdCardvir cdCardvir) throws ApiException {
        if (null == cdCardvir) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirMapper.updateByPrimaryKey(cdCardvir);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateCardvirModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateCardvirModel.num");
        }
    }

    private void updateStateCardvirModel(Integer cardvirId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cardvirId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardvirId", cardvirId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardvirMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateStateCardvirModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateStateCardvirModel.null");
        }
    }

    private void updateStateCardvirModelByCode(String tenantCode, String cardvirCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cardvirCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardvirCode", cardvirCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardvirMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateStateCardvirModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateStateCardvirModelByCode.null");
        }
    }

    private CdCardvir makeCardvir(CdCardvirDomain cdCardvirDomain, CdCardvir cdCardvir) {
        if (null == cdCardvirDomain) {
            return null;
        }
        if (null == cdCardvir) {
            cdCardvir = new CdCardvir();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardvir, (Object)cdCardvirDomain);
            return cdCardvir;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.makeCardvir", (Throwable)e);
            return null;
        }
    }

    private CdCardvirReDomain makeCdCardvirReDomain(CdCardvir cdCardvir) {
        if (null == cdCardvir) {
            return null;
        }
        CdCardvirReDomain cdCardvirReDomain = new CdCardvirReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardvirReDomain, (Object)cdCardvir);
            return cdCardvirReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.makeCdCardvirReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardvir> queryCardvirModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardvirMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.queryCardvirModel", (Throwable)e);
            return null;
        }
    }

    private int countCardvir(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardvirMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirImpl.countCardvir", (Throwable)e);
        }
        return i;
    }

    private CdCardvir createCdCardvir(CdCardvirDomain cdCardvirDomain) {
        String msg = this.checkCardvir(cdCardvirDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.saveCardvir.checkCardvir", msg);
        }
        CdCardvir cdCardvir = this.makeCardvir(cdCardvirDomain, null);
        this.setCardvirDefault(cdCardvir);
        return cdCardvir;
    }

    @Override
    public String saveCardvir(CdCardvirDomain cdCardvirDomain) throws ApiException {
        CdCardvir cdCardvir = this.createCdCardvir(cdCardvirDomain);
        this.saveCardvirModel(cdCardvir);
        this.createCardListBatch(cdCardvir);
        return cdCardvir.getCardvirCode();
    }

    private void createCardListBatch(CdCardvir cdCardvir) {
        if (cdCardvir.getCardpCnum() == null || cdCardvir.getCardpCnum().intValue() <= 0) {
            return;
        }
        ArrayList<CdCardvirListDomain> cdCardvirlistDomainList = new ArrayList<CdCardvirListDomain>();
        String cardvirCode = cdCardvir.getCardvirCode();
        int cardnum = cdCardvir.getCardpCnum().intValue();
        HashSet<String> set = new HashSet<String>();
        while (set.size() < cardnum) {
            String cardpNumber = new Date().getTime() + RandomUtils.generateVerifyCode((int)5, (String)RANDOM_MIXFX).toUpperCase();
            set.add(cardpNumber);
        }
        for (String cardpNumber : set) {
            CdCardvirListDomain cdCardvirListDomain = new CdCardvirListDomain();
            set.add(cardpNumber);
            String cardpPass = RandomUtils.generateRandom((int)6, (Integer)0);
            cdCardvirListDomain.setCardpvirCode(cardvirCode);
            cdCardvirListDomain.setCardpRak(cardpPass);
            cdCardvirListDomain.setCardpPass(cardpPass);
            cdCardvirListDomain.setCardpNumber(cardpNumber);
            cdCardvirListDomain.setAppmanageIcode(cdCardvir.getAppmanageIcode());
            cdCardvirListDomain.setCardpBatch(cdCardvir.getCardpBatch());
            cdCardvirListDomain.setCardpChange(cdCardvir.getCardpChange());
            cdCardvirListDomain.setCardpEnd(cdCardvirListDomain.getCardpEnd() == null ? cdCardvir.getCardpEnd() : cdCardvirListDomain.getCardpEnd());
            cdCardvirListDomain.setCardpName(cdCardvir.getCardvirName());
            cdCardvirListDomain.setCardpOpcode(cdCardvir.getCardpOpcode());
            cdCardvirListDomain.setCardpOptype(cdCardvir.getCardpOptype());
            cdCardvirListDomain.setCardpStart(cdCardvirListDomain.getCardpStart() == null ? cdCardvir.getCardpStart() : cdCardvirListDomain.getCardpStart());
            cdCardvirListDomain.setTenantCode(cdCardvir.getTenantCode());
            cdCardvirListDomain.setMemberCode(cdCardvir.getMemberCode());
            cdCardvirListDomain.setMemberName(cdCardvir.getMemberName());
            cdCardvirListDomain.setCardpChange("0");
            cdCardvirListDomain.setCardpRak(cardpPass);
            cdCardvirlistDomainList.add(cdCardvirListDomain);
        }
        this.logger.info("cd.CARDP.CdCardvirImpl.saveCardp.cdCardplistDomainList", (Object)cdCardvirlistDomainList.size());
        if (cdCardvirlistDomainList.size() > 0) {
            this.cdCardvirListService.saveCardvirListBatch(cdCardvirlistDomainList);
        }
    }

    @Override
    public String saveCardvirBatch(List<CdCardvirDomain> cdCardvirDomainList) throws ApiException {
        if (null == cdCardvirDomainList || cdCardvirDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardvir> cdCardvirList = new ArrayList<CdCardvir>();
        String code = "";
        for (CdCardvirDomain cdCardvirDomain : cdCardvirDomainList) {
            CdCardvir cdCardvir = this.createCdCardvir(cdCardvirDomain);
            code = cdCardvir.getCardvirCode();
            cdCardvirList.add(cdCardvir);
        }
        this.saveCardvirBatchModel(cdCardvirList);
        return code;
    }

    @Override
    public void updateCardvirState(Integer cardvirId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cardvirId) {
            return;
        }
        this.updateStateCardvirModel(cardvirId, dataState, oldDataState, map);
    }

    @Override
    public void updateCardvirStateByCode(String tenantCode, String cardvirCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cardvirCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCardvirModelByCode(tenantCode, cardvirCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCardvir(CdCardvirDomain cdCardvirDomain) throws ApiException {
        String msg = this.checkCardvir(cdCardvirDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateCardvir.checkCardvir", msg);
        }
        CdCardvir oldCdCardvir = this.getCardvirModelById(cdCardvirDomain.getCardvirId());
        if (null == oldCdCardvir) {
            throw new ApiException("cd.CARDP.CdCardvirImpl.updateCardvir.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardvir cdCardvir = this.makeCardvir(cdCardvirDomain, oldCdCardvir);
        this.setCardvirUpdataDefault(cdCardvir);
        this.updateCardvirModel(cdCardvir);
    }

    @Override
    public CdCardvir getCardvir(Integer cardvirId) {
        if (null == cardvirId) {
            return null;
        }
        return this.getCardvirModelById(cardvirId);
    }

    @Override
    public void deleteCardvir(Integer cardvirId) throws ApiException {
        if (null == cardvirId) {
            return;
        }
        this.deleteCardvirModel(cardvirId);
    }

    @Override
    public QueryResult<CdCardvir> queryCardvirPage(Map<String, Object> map) {
        List<CdCardvir> cdCardvirList = this.queryCardvirModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardvir(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardvirList);
        return queryResult;
    }

    @Override
    public CdCardvir getCardvirByCode(String tenantCode, String cardvirCode) throws ApiException {
        if (StringUtils.isBlank((String)cardvirCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardvirCode", cardvirCode);
        return this.getCardvirModelByCode(map);
    }

    @Override
    public void deleteCardvirByCode(String tenantCode, String cardvirCode) throws ApiException {
        if (StringUtils.isBlank((String)cardvirCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardvirCode", cardvirCode);
        this.delCardvirModelByCode(map);
    }
}

