/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.CdCardpConstants;
import com.yqbsoft.laser.service.cd.dao.CdCardvirListMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardvirListDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirListReDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardvirProcessDomain;
import com.yqbsoft.laser.service.cd.domain.EditSkuDomain;
import com.yqbsoft.laser.service.cd.model.CdCardvirList;
import com.yqbsoft.laser.service.cd.service.CdCardvirListService;
import com.yqbsoft.laser.service.cd.service.CdCardvirProcessService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdCardvirListImpl
extends BaseServiceImpl
implements CdCardvirListService {
    private static final String SYS_CODE = "cd.CARDP.CdCardvirListImpl";
    private CdCardvirListMapper cdCardvirListMapper;
    private CdCardvirProcessService cdCardvirProcessService;

    public void setCdCardvirListMapper(CdCardvirListMapper cdCardvirListMapper) {
        this.cdCardvirListMapper = cdCardvirListMapper;
    }

    public void setCdCardvirProcessService(CdCardvirProcessService cdCardvirProcessService) {
        this.cdCardvirProcessService = cdCardvirProcessService;
    }

    private Date getSysDate() {
        try {
            return this.cdCardvirListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardvirList(CdCardvirListDomain cdCardvirListDomain) {
        if (null == cdCardvirListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardvirListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardvirListDefault(CdCardvirList cdCardvirList) {
        if (null == cdCardvirList) {
            return;
        }
        if (null == cdCardvirList.getDataState()) {
            cdCardvirList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cdCardvirList.getGmtCreate()) {
            cdCardvirList.setGmtCreate(date);
        }
        cdCardvirList.setGmtModified(date);
        if (StringUtils.isBlank((String)cdCardvirList.getCardpvirListCode())) {
            cdCardvirList.setCardpvirListCode(this.getNo(null, "CdCardvirList", "cdCardvirList", cdCardvirList.getTenantCode()));
        }
    }

    private int getCardvirListMaxCode() {
        int code = 0;
        try {
            return this.cdCardvirListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getCardvirListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardvirListUpdataDefault(CdCardvirList cdCardvirList) {
        if (null == cdCardvirList) {
            return;
        }
        cdCardvirList.setGmtModified(this.getSysDate());
    }

    private void saveCardvirListModel(CdCardvirList cdCardvirList) throws ApiException {
        if (null == cdCardvirList) {
            return;
        }
        try {
            this.cdCardvirListMapper.insert(cdCardvirList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.saveCardvirListModel.ex", (Throwable)e);
        }
    }

    private void saveCardvirListBatchModel(List<CdCardvirList> cdCardvirListList) throws ApiException {
        if (null == cdCardvirListList || cdCardvirListList.isEmpty()) {
            return;
        }
        try {
            this.cdCardvirListMapper.insertBatch(cdCardvirListList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.saveCardvirListBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardvirList getCardvirListModelById(Integer cardpvirListId) {
        if (null == cardpvirListId) {
            return null;
        }
        try {
            return this.cdCardvirListMapper.selectByPrimaryKey(cardpvirListId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getCardvirListModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardvirList getCardvirListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardvirListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.getCardvirListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardvirListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.delCardvirListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.delCardvirListModelByCode.num");
        }
    }

    private void deleteCardvirListModel(Integer cardpvirListId) throws ApiException {
        if (null == cardpvirListId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.deleteByPrimaryKey(cardpvirListId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.deleteCardvirListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.deleteCardvirListModel.num");
        }
    }

    private void updateCardvirListModel(CdCardvirList cdCardvirList) throws ApiException {
        if (null == cdCardvirList) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateByPrimaryKey(cdCardvirList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirListModel.num");
        }
    }

    private void updateStateCardvirListModel(Integer cardpvirListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cardpvirListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpvirListId", cardpvirListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModel.null");
        }
    }

    private void updateStateCardvirListModelByCode(String tenantCode, String cardpvirListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpvirListCode", cardpvirListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateStateCardvirListModelByCode.null");
        }
    }

    private CdCardvirList makeCardvirList(CdCardvirListDomain cdCardvirListDomain, CdCardvirList cdCardvirList) {
        if (null == cdCardvirListDomain) {
            return null;
        }
        if (null == cdCardvirList) {
            cdCardvirList = new CdCardvirList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardvirList, (Object)cdCardvirListDomain);
            return cdCardvirList;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.makeCardvirList", (Throwable)e);
            return null;
        }
    }

    private CdCardvirListReDomain makeCdCardvirListReDomain(CdCardvirList cdCardvirList) {
        if (null == cdCardvirList) {
            return null;
        }
        CdCardvirListReDomain cdCardvirListReDomain = new CdCardvirListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardvirListReDomain, (Object)cdCardvirList);
            return cdCardvirListReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.makeCdCardvirListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardvirList> queryCardvirListModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardvirListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.queryCardvirListModel", (Throwable)e);
            return null;
        }
    }

    private int countCardvirList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardvirListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.countCardvirList", (Throwable)e);
        }
        return i;
    }

    private CdCardvirList createCdCardvirList(CdCardvirListDomain cdCardvirListDomain) {
        String msg = this.checkCardvirList(cdCardvirListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.saveCardvirList.checkCardvirList", msg);
        }
        CdCardvirList cdCardvirList = this.makeCardvirList(cdCardvirListDomain, null);
        this.setCardvirListDefault(cdCardvirList);
        return cdCardvirList;
    }

    @Override
    public String saveCardvirList(CdCardvirListDomain cdCardvirListDomain) throws ApiException {
        CdCardvirList cdCardvirList = this.createCdCardvirList(cdCardvirListDomain);
        this.saveCardvirListModel(cdCardvirList);
        return cdCardvirList.getCardpvirListCode();
    }

    @Override
    public String saveCardvirListBatch(List<CdCardvirListDomain> cdCardvirListDomainList) throws ApiException {
        if (null == cdCardvirListDomainList || cdCardvirListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardvirList> cdCardvirListList = new ArrayList<CdCardvirList>();
        String code = "";
        for (CdCardvirListDomain cdCardvirListDomain : cdCardvirListDomainList) {
            CdCardvirList cdCardvirList = this.createCdCardvirList(cdCardvirListDomain);
            code = cdCardvirList.getCardpvirListCode();
            cdCardvirListList.add(cdCardvirList);
        }
        this.saveCardvirListBatchModel(cdCardvirListList);
        return code;
    }

    @Override
    public void updateCardvirListState(Integer cardpvirListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cardpvirListId) {
            return;
        }
        this.updateStateCardvirListModel(cardpvirListId, dataState, oldDataState, map);
    }

    @Override
    public void updateCardvirListStateByCode(String tenantCode, String cardpvirListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCardvirListModelByCode(tenantCode, cardpvirListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCardvirList(CdCardvirListDomain cdCardvirListDomain) throws ApiException {
        String msg = this.checkCardvirList(cdCardvirListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirList.checkCardvirList", msg);
        }
        CdCardvirList oldCdCardvirList = this.getCardvirListModelById(cdCardvirListDomain.getCardpvirListId());
        if (null == oldCdCardvirList) {
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardvirList cdCardvirList = this.makeCardvirList(cdCardvirListDomain, oldCdCardvirList);
        this.setCardvirListUpdataDefault(cdCardvirList);
        this.updateCardvirListModel(cdCardvirList);
    }

    @Override
    public CdCardvirList getCardvirList(Integer cardpvirListId) {
        if (null == cardpvirListId) {
            return null;
        }
        return this.getCardvirListModelById(cardpvirListId);
    }

    @Override
    public void deleteCardvirList(Integer cardpvirListId) throws ApiException {
        if (null == cardpvirListId) {
            return;
        }
        this.deleteCardvirListModel(cardpvirListId);
    }

    @Override
    public QueryResult<CdCardvirList> queryCardvirListPage(Map<String, Object> map) {
        List<CdCardvirList> cdCardvirListList = this.queryCardvirListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardvirList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardvirListList);
        return queryResult;
    }

    @Override
    public CdCardvirList getCardvirListByCode(String tenantCode, String cardpvirListCode) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpvirListCode", cardpvirListCode);
        return this.getCardvirListModelByCode(map);
    }

    @Override
    public void deleteCardvirListByCode(String tenantCode, String cardpvirListCode) throws ApiException {
        if (StringUtils.isBlank((String)cardpvirListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpvirListCode", cardpvirListCode);
        this.delCardvirListModelByCode(map);
    }

    @Override
    public void deleteCardvirListByMap(Map<String, Object> map) throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.deleteCardvirListByMap {map}", map);
        this.delCardvirListModelByMap(map);
    }

    private void delCardvirListModelByMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.delByMap(map);
            map.put("handelSize", i);
            this.logger.error("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap {map}", map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap", (Throwable)e);
            throw new ApiException("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.delCardvirListModelByMap handel is null", map);
        }
    }

    @Override
    public void updateCardvirListByMap(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty() || map.get("tenantCode") == null) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap map is null", map);
        }
        if (map.get("cardvirListCode") == null && map.get("cardvirListCodeStr") == null && map.get("cardpBatch") == null && map.get("cardpBatchStr") == null) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap need params is null", map);
            return;
        }
        this.updateCardvirListModelByMap(map);
    }

    private void createCardProcess(Map<String, Object> map) {
        try {
            CdCardvirProcessDomain cdCardvirProcessDomain = new CdCardvirProcessDomain();
            Integer businessType = CdCardpConstants.BUSINESS_TYPE_0;
            String memo = null;
            Integer dataState = CdCardpConstants.CARD_PROCESS_STATE_f1;
            if (map.get("tenantCode") != null) {
                cdCardvirProcessDomain.setTenantCode(map.get("tenantCode").toString());
            } else {
                cdCardvirProcessDomain.setTenantCode("00000000");
            }
            if (map.get("cardvirListCode") != null) {
                cdCardvirProcessDomain.setCardpvirListCode(map.get("cardvirListCode").toString());
            }
            if (map.get("cardpBatch") != null) {
                cdCardvirProcessDomain.setCardpBatch(map.get("cardpBatch").toString());
            }
            if (map.get("userName") != null) {
                cdCardvirProcessDomain.setUserName(map.get("userName").toString());
            }
            if (map.get("userCode") != null) {
                cdCardvirProcessDomain.setUserCode(map.get("userCode").toString());
            }
            if (map.get("memo") != null) {
                cdCardvirProcessDomain.setMemo(map.get("memo").toString());
            }
            cdCardvirProcessDomain.setBusniessContent(JsonUtil.buildNormalBinder().toJson(map));
            if (map.get("handelSize") != null && Integer.valueOf(map.get("handelSize").toString()) > 0) {
                dataState = CdCardpConstants.CARD_PROCESS_STATE_0;
            }
            if (map.get("businessType") != null) {
                businessType = Integer.valueOf(map.get("businessType").toString());
            }
            if (map.get("contractBillcode") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_7;
            }
            if (map.get("cardSendState") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_8;
            }
            if (map.get("cardStartState") != null) {
                businessType = CdCardpConstants.START_STATE_1 == Integer.valueOf(map.get("cardStartState").toString()) ? CdCardpConstants.BUSINESS_TYPE_3 : CdCardpConstants.BUSINESS_TYPE_1;
            }
            if (map.get("cardStartStateBatch") != null) {
                businessType = CdCardpConstants.START_STATE_BATCH_1 == Integer.valueOf(map.get("cardStartStateBatch").toString()) ? CdCardpConstants.BUSINESS_TYPE_4 : CdCardpConstants.BUSINESS_TYPE_2;
            }
            if (map.get("cardpEnd") != null) {
                businessType = CdCardpConstants.BUSINESS_TYPE_5;
                if (map.get("cardpBatch") != null) {
                    businessType = CdCardpConstants.BUSINESS_TYPE_6;
                }
            }
            cdCardvirProcessDomain.setBusniessType(businessType);
            if (StringUtils.isBlank((String)cdCardvirProcessDomain.getMemo())) {
                for (CdCardpConstants.CardProcessType cardProcessType : CdCardpConstants.CardProcessType.values()) {
                    if (cardProcessType.getBusinessType() != businessType) continue;
                    memo = cardProcessType.getBusinessDesc();
                }
                cdCardvirProcessDomain.setMemo(memo);
            }
            cdCardvirProcessDomain.setDataState(dataState);
            this.cdCardvirProcessService.saveCardvirProcess(cdCardvirProcessDomain);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.createCardProcess ex", (Throwable)e);
        }
    }

    private void updateCardvirListModelByMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateByMap(map);
            map.put("handelSize", i);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap", (Throwable)e);
            throw new ApiException("cd.CARDP.CdCardvirListImpl.updateCardvirListModelByMap.ex", (Throwable)e);
        }
        finally {
            this.createCardProcess(map);
        }
        if (i <= 0) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateCardvirListByMap handel is null", map);
        }
    }

    @Override
    public void updateValidExpire() throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum ===== \u66f4\u65b0\u5df2\u8fc7\u671f\u865a\u62df\u5546\u54c1\u5361\u5377.start =====");
        int i = 0;
        try {
            i = this.cdCardvirListMapper.updateValidExpire();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidExpire ex", (Throwable)e);
        }
        finally {
            if (i > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("businessType", CdCardpConstants.CardProcessType.CARD_VALID_UN.getBusinessType());
                map.put("handelSize", i);
                this.createCardProcess(map);
                this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidExpire ===== \u66f4\u65b0\u8fc7\u671f\u5361\u5377 job =====", (Object)("size:" + i));
            }
        }
    }

    @Override
    public void updateValidGoodsNum() throws ApiException {
        this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum ===== \u66f4\u65b0\u865a\u62df\u5361\u5377\u5546\u54c1\u5e93\u5b58.start =====");
        long start = System.currentTimeMillis();
        List<Map<String, Object>> varList = this.queryCardListValid(null);
        if (varList == null || ListUtil.isEmpty(varList)) {
            return;
        }
        for (Map<String, Object> map : varList) {
            if (map.get("skuCode") == null || map.get("skuNo") == null || map.get("goodsCode") == null || map.get("tenantCode") == null || map.get("num") == null) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum params is null", (Object)JsonUtil.buildNormalBinder().toJson(map));
                continue;
            }
            EditSkuDomain editSkuDomain = new EditSkuDomain();
            editSkuDomain.setSkuCode(map.get("skuCode").toString());
            editSkuDomain.setSkuNo(map.get("skuNo").toString());
            editSkuDomain.setGoodsCode(map.get("goodsCode").toString());
            editSkuDomain.setTenantCode(map.get("tenantCode").toString());
            editSkuDomain.setGoodsSupplynum(new BigDecimal(map.get("num").toString()));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
            try {
                this.internalInvoke("rs.resource.sendUpdateSkuEdit", paramMap);
            }
            catch (Exception e) {
                this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum ex", (Throwable)e);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessType", CdCardpConstants.CardProcessType.CARD_SKU_NUM.getBusinessType());
        map.put("handelSize", varList.size());
        map.put("varList", JsonUtil.buildNormalBinder().toJson(varList));
        this.createCardProcess(map);
        this.logger.error("cd.CARDP.CdCardvirListImpl.updateValidGoodsNum end", (Object)("time:" + (System.currentTimeMillis() - start)));
    }

    @Override
    public List<Map<String, Object>> queryCardListValid(Map<String, Object> map) {
        this.logger.error("cd.CARDP.CdCardvirListImpl.queryCardListValid ===== \u6709\u6548\u5361\u5377\u6570\u91cf\u548c\u5546\u54c1\u5e93\u5b58 ===== {map}", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<Map<String, Object>> varList = this.cdCardvirListMapper.queryCardListValid(map);
        if (ListUtil.isNotEmpty(varList)) {
            this.logger.error("cd.CARDP.CdCardvirListImpl.queryCardListValid {varList}", (Object)JsonUtil.buildNormalBinder().toJson(varList));
        }
        return varList;
    }
}

