/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.dao.CdCardpMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardpDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardpReDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardplistDomain;
import com.yqbsoft.laser.service.cd.model.CdCardp;
import com.yqbsoft.laser.service.cd.service.CdCardpCardService;
import com.yqbsoft.laser.service.cd.service.CdCardplistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CdCardpServiceImpl
extends BaseServiceImpl
implements CdCardpCardService {
    private static final String SYS_CODE = "cd.CARDP.CdCardpServiceImpl";
    private CdCardpMapper cdCardpMapper;
    private CdCardplistService cdCardplistService;
    public static final String RANDOM_MIXFX = "3459ACDEFHJKLPRSXYacdefhjklprsxy";

    public void setCdCardpMapper(CdCardpMapper cdCardpMapper) {
        this.cdCardpMapper = cdCardpMapper;
    }

    public void setCdCardplistService(CdCardplistService cdCardplistService) {
        this.cdCardplistService = cdCardplistService;
    }

    private Date getSysDate() {
        try {
            return this.cdCardpMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardp(CdCardpDomain cdCardpDomain) {
        if (null == cdCardpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardpDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardpDefault(CdCardp cdCardp) {
        if (null == cdCardp) {
            return;
        }
        if (null == cdCardp.getDataState()) {
            cdCardp.setDataState(0);
        }
        if (null == cdCardp.getGmtCreate()) {
            cdCardp.setGmtCreate(this.getSysDate());
        }
        cdCardp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cdCardp.getCardpCode())) {
            cdCardp.setCardpCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)cdCardp.getCardpBatch())) {
            String cardpBatchNo = this.getNo("0", "CdCardp", "cardpBatchNo", cdCardp.getTenantCode());
            cdCardp.setCardpBatch(cardpBatchNo);
        }
    }

    private int getCardpMaxCode() {
        int code = 0;
        try {
            return this.cdCardpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.getCardpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardpUpdataDefault(CdCardp cdCardp) {
        if (null == cdCardp) {
            return;
        }
        cdCardp.setGmtModified(this.getSysDate());
    }

    private void saveCardpModel(CdCardp cdCardp) throws ApiException {
        if (null == cdCardp) {
            return;
        }
        try {
            this.cdCardpMapper.insert(cdCardp);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.saveCardpModel.ex", (Throwable)e);
        }
    }

    private void saveCardpBatchModel(List<CdCardp> cdCardpList) throws ApiException {
        if (null == cdCardpList || cdCardpList.isEmpty()) {
            return;
        }
        try {
            this.cdCardpMapper.insertBatch(cdCardpList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.saveCardpBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardp getCardpModelById(Integer cardpId) {
        if (null == cardpId) {
            return null;
        }
        try {
            return this.cdCardpMapper.selectByPrimaryKey(cardpId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.getCardpModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardp getCardpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.getCardpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.delCardpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.delCardpModelByCode.num");
        }
    }

    private void deleteCardpModel(Integer cardpId) throws ApiException {
        if (null == cardpId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpMapper.deleteByPrimaryKey(cardpId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.deleteCardpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.deleteCardpModel.num");
        }
    }

    private void updateCardpModel(CdCardp cdCardp) throws ApiException {
        if (null == cdCardp) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpMapper.updateByPrimaryKeySelective(cdCardp);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateCardpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateCardpModel.num");
        }
    }

    private void updateStateCardpModel(Integer cardpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cardpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpId", cardpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateStateCardpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateStateCardpModel.null");
        }
    }

    private void updateStateCardpModelByCode(String tenantCode, String cardpCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)cardpCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpCode", cardpCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateStateCardpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateStateCardpModelByCode.null");
        }
    }

    private CdCardp makeCardp(CdCardpDomain cdCardpDomain, CdCardp cdCardp) {
        if (null == cdCardpDomain) {
            return null;
        }
        if (null == cdCardp) {
            cdCardp = new CdCardp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardp, (Object)cdCardpDomain);
            return cdCardp;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.makeCardp", (Throwable)e);
            return null;
        }
    }

    private CdCardpReDomain makeCdCardpReDomain(CdCardp cdCardp) {
        if (null == cdCardp) {
            return null;
        }
        CdCardpReDomain cdCardpReDomain = new CdCardpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpReDomain, (Object)cdCardp);
            return cdCardpReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.makeCdCardpReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardp> queryCardpModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.queryCardpModel", (Throwable)e);
            return null;
        }
    }

    private int countCardp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpServiceImpl.countCardp", (Throwable)e);
        }
        return i;
    }

    private CdCardp createCdCardp(CdCardpDomain cdCardpDomain) {
        String msg = this.checkCardp(cdCardpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.saveCardp.checkCardp", msg);
        }
        CdCardp cdCardp = this.makeCardp(cdCardpDomain, null);
        this.setCardpDefault(cdCardp);
        List<CdCardplistDomain> cdCardplistDomainList = cdCardpDomain.getCdCardplistDomainList();
        if (ListUtil.isNotEmpty(cdCardplistDomainList)) {
            cdCardp.setCardpCnum(new BigDecimal(cdCardplistDomainList.size()));
        }
        return cdCardp;
    }

    @Override
    public String saveCardp(CdCardpDomain cdCardpDomain) throws ApiException {
        CdCardp cdCardp = this.createCdCardp(cdCardpDomain);
        this.saveCardpModel(cdCardp);
        String cardpCode = cdCardp.getCardpCode();
        int cardnum = cdCardp.getCardpCnum().intValue();
        List<CdCardplistDomain> cdCardplistDomainList = cdCardpDomain.getCdCardplistDomainList();
        if (ListUtil.isNotEmpty(cdCardplistDomainList)) {
            for (CdCardplistDomain cdCardplistDomain : cdCardplistDomainList) {
                cdCardplistDomain.setCardpCode(cdCardp.getCardpCode());
                cdCardplistDomain.setAppmanageIcode(cdCardp.getAppmanageIcode());
                cdCardplistDomain.setCardpBatch(cdCardp.getCardpBatch());
                cdCardplistDomain.setCardpChange(cdCardp.getCardpChange());
                cdCardplistDomain.setCardpEnd(cdCardplistDomain.getCardpEnd() == null ? cdCardpDomain.getCardpEnd() : cdCardplistDomain.getCardpEnd());
                cdCardplistDomain.setCardpName(cdCardp.getCardpName());
                cdCardplistDomain.setCardpOptype(cdCardp.getCardpOptype());
                cdCardplistDomain.setCardpStart(cdCardplistDomain.getCardpStart() == null ? cdCardpDomain.getCardpStart() : cdCardplistDomain.getCardpStart());
                cdCardplistDomain.setTenantCode(cdCardp.getTenantCode());
                cdCardplistDomain.setMemberCode(cdCardp.getMemberCode());
                cdCardplistDomain.setMemberName(cdCardp.getMemberName());
                cdCardplistDomain.setGiftNo(cdCardp.getGiftNo());
                cdCardplistDomain.setCardpChange("0");
            }
        } else {
            cdCardplistDomainList = new ArrayList<CdCardplistDomain>();
            HashSet<String> set = new HashSet<String>();
            while (set.size() < cardnum) {
                String cardpNumber = new Date().getTime() + RandomUtils.generateVerifyCode((int)5, (String)RANDOM_MIXFX).toUpperCase();
                set.add(cardpNumber);
            }
            for (String cardpNumber : set) {
                CdCardplistDomain cdCardplistDomain = new CdCardplistDomain();
                set.add(cardpNumber);
                String cardpPass = RandomUtils.generateRandom((int)6, (Integer)0);
                cdCardplistDomain.setCardpCode(cardpCode);
                cdCardplistDomain.setCardpRak(cardpPass);
                cdCardplistDomain.setCardpPass(cardpPass);
                cdCardplistDomain.setCardpNumber(cardpNumber);
                cdCardplistDomain.setAppmanageIcode(cdCardp.getAppmanageIcode());
                cdCardplistDomain.setCardpBatch(cdCardp.getCardpBatch());
                cdCardplistDomain.setCardpChange(cdCardp.getCardpChange());
                cdCardplistDomain.setCardpEnd(cdCardplistDomain.getCardpEnd() == null ? cdCardpDomain.getCardpEnd() : cdCardplistDomain.getCardpEnd());
                cdCardplistDomain.setCardpName(cdCardp.getCardpName());
                cdCardplistDomain.setCardpOpcode(cdCardp.getCardpOpcode());
                cdCardplistDomain.setCardpOptype(cdCardp.getCardpOptype());
                cdCardplistDomain.setCardpStart(cdCardplistDomain.getCardpStart() == null ? cdCardpDomain.getCardpStart() : cdCardplistDomain.getCardpStart());
                cdCardplistDomain.setTenantCode(cdCardp.getTenantCode());
                cdCardplistDomain.setMemberCode(cdCardp.getMemberCode());
                cdCardplistDomain.setMemberName(cdCardp.getMemberName());
                cdCardplistDomain.setGiftNo(cdCardp.getGiftNo());
                cdCardplistDomain.setCardpChange("0");
                cdCardplistDomain.setCardpRak(cardpPass);
                cdCardplistDomainList.add(cdCardplistDomain);
            }
        }
        this.logger.info("cd.CARDP.CdCardpServiceImpl.saveCardp.cdCardplistDomainList", (Object)cdCardplistDomainList.size());
        if (cdCardplistDomainList.size() > 0) {
            this.cdCardplistService.saveCardplistBatch(cdCardplistDomainList);
        }
        return cardpCode;
    }

    @Override
    public String saveCardpBatch(List<CdCardpDomain> cdCardpDomainList) throws ApiException {
        if (null == cdCardpDomainList || cdCardpDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardp> cdCardpList = new ArrayList<CdCardp>();
        String code = "";
        String cardpBatchNo = this.getNo("0", "CdCardp", "cardpBatchNo", ((CdCardp)cdCardpList.get(0)).getTenantCode());
        for (CdCardpDomain cdCardpDomain : cdCardpDomainList) {
            CdCardp cdCardp = this.createCdCardp(cdCardpDomain);
            cdCardp.setCardpBatch(cardpBatchNo);
            code = cdCardp.getCardpCode();
            cdCardpList.add(cdCardp);
        }
        this.saveCardpBatchModel(cdCardpList);
        return code;
    }

    @Override
    public void updateCardpState(Integer cardpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpModel(cardpId, dataState, oldDataState);
    }

    @Override
    public void updateCardpStateByCode(String tenantCode, String cardpCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpModelByCode(tenantCode, cardpCode, dataState, oldDataState);
    }

    @Override
    public void updateCardp(CdCardpDomain cdCardpDomain) throws ApiException {
        String msg = this.checkCardp(cdCardpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateCardp.checkCardp", msg);
        }
        CdCardp oldCdCardp = this.getCardpModelById(cdCardpDomain.getCardpId());
        if (null == oldCdCardp) {
            throw new ApiException("cd.CARDP.CdCardpServiceImpl.updateCardp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardp cdCardp = this.makeCardp(cdCardpDomain, oldCdCardp);
        this.setCardpUpdataDefault(cdCardp);
        this.updateCardpModel(cdCardp);
        cdCardpDomain.getCdCardplistDomainList();
        List<CdCardplistDomain> cdCardplistDomainList = cdCardpDomain.getCdCardplistDomainList();
        if (ListUtil.isNotEmpty(cdCardplistDomainList)) {
            this.cdCardplistService.deleteCardplistByCardpCode(cdCardp.getTenantCode(), cdCardp.getCardpCode());
            for (CdCardplistDomain cdCardplistDomain : cdCardplistDomainList) {
                cdCardplistDomain.setAppmanageIcode(cdCardp.getAppmanageIcode());
                cdCardplistDomain.setCardpCode(cdCardp.getCardpCode());
                cdCardplistDomain.setCardpBatch(cdCardp.getCardpBatch());
                cdCardplistDomain.setCardpChange(cdCardp.getCardpChange());
                cdCardplistDomain.setCardpEnd(cdCardp.getCardpEnd());
                cdCardplistDomain.setCardpName(cdCardp.getCardpName());
                cdCardplistDomain.setCardpOpcode(cdCardp.getCardpOpcode());
                cdCardplistDomain.setCardpOptype(cdCardp.getCardpOptype());
                cdCardplistDomain.setCardpStart(cdCardp.getCardpStart());
                cdCardplistDomain.setTenantCode(cdCardp.getTenantCode());
                cdCardplistDomain.setMemberCode(cdCardp.getMemberCode());
                cdCardplistDomain.setMemberName(cdCardp.getMemberName());
                cdCardplistDomain.setGiftNo(cdCardp.getGiftNo());
                cdCardplistDomain.setCardpChange("0");
            }
            this.cdCardplistService.saveCardplistBatch(cdCardplistDomainList);
        }
    }

    @Override
    public CdCardp getCardp(Integer cardpId) {
        return this.getCardpModelById(cardpId);
    }

    @Override
    public void deleteCardp(Integer cardpId) throws ApiException {
        this.deleteCardpModel(cardpId);
    }

    @Override
    public QueryResult<CdCardp> queryCardpPage(Map<String, Object> map) {
        List<CdCardp> cdCardpList = this.queryCardpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardpList);
        return queryResult;
    }

    @Override
    public CdCardp getCardpByCode(String tenantCode, String cardpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpCode", cardpCode);
        return this.getCardpModelByCode(map);
    }

    @Override
    public void deleteCardpByCode(String tenantCode, String cardpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpCode", cardpCode);
        this.delCardpModelByCode(map);
    }

    @Override
    public void updateCardpStateJob() throws ApiException {
        String notUpdateCancelState = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-cd-notUpdateCancelState");
        if (StringUtils.isNotBlank((String)notUpdateCancelState)) {
            return;
        }
        this.logger.error("cd.CARDP.CdCardpServiceImplupdateCardpStateJob", (Object)"cd.cdcardp.updateCardpStateJob");
        this.cdCardpMapper.updateCardpState();
        this.cdCardpMapper.updateCardpListState();
    }

    @Override
    public void updateCardpStateJobNotUpdateCancelState() throws ApiException {
        this.logger.error("cd.CARDP.CdCardpServiceImplupdateCardpStateJobNotUpdateCancelState", (Object)"cd.cdcardp.updateCardpStateJobNotUpdateCancelState");
        this.cdCardpMapper.updateCardpStateNotUpdateCancelState();
        this.cdCardpMapper.updateCardpListStateNotUpdateCancelState();
    }

    @Override
    public String saveCardpByPhone(CdCardpDomain cdCardpDomain) throws ApiException {
        CdCardp cdCardp = this.createCdCardp(cdCardpDomain);
        this.saveCardpModel(cdCardp);
        String cardpCode = cdCardp.getCardpCode();
        List<CdCardplistDomain> cdCardplistDomainList = cdCardpDomain.getCdCardplistDomainList();
        ArrayList<CdCardplistDomain> cdCardplistDomainListNew = new ArrayList<CdCardplistDomain>();
        if (ListUtil.isNotEmpty(cdCardplistDomainList)) {
            for (CdCardplistDomain cdCardplistDomainNew : cdCardplistDomainList) {
                int cardnum = cdCardplistDomainNew.getCardpCnum().intValue();
                HashSet<String> set = new HashSet<String>();
                while (set.size() < cardnum) {
                    String cardpNumber = new Date().getTime() + RandomUtils.generateVerifyCode((int)5, (String)RANDOM_MIXFX).toUpperCase();
                    set.add(cardpNumber);
                }
                for (String cardpNumber : set) {
                    CdCardplistDomain cdCardplistDomain = new CdCardplistDomain();
                    set.add(cardpNumber);
                    String cardpPass = RandomUtils.generateRandom((int)6, (Integer)0);
                    cdCardplistDomain.setCardpCode(cardpCode);
                    cdCardplistDomain.setCardpRak(cardpPass);
                    cdCardplistDomain.setCardpPass(cardpPass);
                    cdCardplistDomain.setCardpNumber(cardpNumber);
                    cdCardplistDomain.setCardpPhone(cdCardplistDomainNew.getCardpPhone());
                    cdCardplistDomain.setEmployeeName(cdCardplistDomainNew.getEmployeeName());
                    cdCardplistDomain.setCardpCnum(cdCardplistDomainNew.getCardpCnum());
                    cdCardplistDomain.setAppmanageIcode(cdCardp.getAppmanageIcode());
                    cdCardplistDomain.setCardpBatch(cdCardp.getCardpBatch());
                    cdCardplistDomain.setCardpChange(cdCardp.getCardpChange());
                    cdCardplistDomain.setCardpEnd(cdCardplistDomain.getCardpEnd() == null ? cdCardpDomain.getCardpEnd() : cdCardplistDomain.getCardpEnd());
                    cdCardplistDomain.setCardpName(cdCardp.getCardpName());
                    cdCardplistDomain.setCardpOpcode(cdCardp.getCardpOpcode());
                    cdCardplistDomain.setCardpOptype(cdCardp.getCardpOptype());
                    cdCardplistDomain.setCardpStart(cdCardplistDomain.getCardpStart() == null ? cdCardpDomain.getCardpStart() : cdCardplistDomain.getCardpStart());
                    cdCardplistDomain.setTenantCode(cdCardp.getTenantCode());
                    cdCardplistDomain.setMemberCode(cdCardp.getMemberCode());
                    cdCardplistDomain.setMemberName(cdCardp.getMemberName());
                    cdCardplistDomain.setGiftNo(cdCardp.getGiftNo());
                    cdCardplistDomain.setCardpChange("0");
                    cdCardplistDomain.setCardpRak(cardpPass);
                    cdCardplistDomainListNew.add(cdCardplistDomain);
                }
            }
        }
        this.logger.info("cd.CARDP.CdCardpServiceImpl.saveCardp.saveCardpByPhone", (Object)cdCardplistDomainListNew.size());
        if (cdCardplistDomainListNew.size() > 0) {
            this.cdCardplistService.saveCardplistBatch(cdCardplistDomainListNew);
        }
        return cardpCode;
    }
}

