/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.channelmanage.service.impl;

import com.yqbsoft.laser.service.channelmanage.dao.CmFchannelBankMapper;
import com.yqbsoft.laser.service.channelmanage.domain.CmFchannelBankDomain;
import com.yqbsoft.laser.service.channelmanage.domain.CmFchannelBankconfigDomain;
import com.yqbsoft.laser.service.channelmanage.domain.CmFchannelConfigDomain;
import com.yqbsoft.laser.service.channelmanage.model.CmFchannelBank;
import com.yqbsoft.laser.service.channelmanage.model.CmFchannelBankconfig;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelBankService;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelBankconfigService;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelConfigService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CmFchannelBankServiceImpl
extends BaseServiceImpl
implements CmFchannelBankService {
    public static final String SYS_CODE = "cm.CmFchannelBankServiceImpl";
    private CmFchannelBankMapper cmFchannelBankMapper;
    private CmFchannelBankconfigService cmFchannelBankconfigService;
    private CmFchannelConfigService cmFchannelConfigService;

    public void setCmFchannelBankMapper(CmFchannelBankMapper cmFchannelBankMapper) {
        this.cmFchannelBankMapper = cmFchannelBankMapper;
    }

    public CmFchannelBankconfigService getCmFchannelBankconfigService() {
        return this.cmFchannelBankconfigService;
    }

    public void setCmFchannelBankconfigService(CmFchannelBankconfigService cmFchannelBankconfigService) {
        this.cmFchannelBankconfigService = cmFchannelBankconfigService;
    }

    public CmFchannelConfigService getCmFchannelConfigService() {
        return this.cmFchannelConfigService;
    }

    public void setCmFchannelConfigService(CmFchannelConfigService cmFchannelConfigService) {
        this.cmFchannelConfigService = cmFchannelConfigService;
    }

    private Date getSysDate() {
        try {
            return this.cmFchannelBankMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFchannelBank(CmFchannelBankDomain cmFchannelBankDomain) {
        if (null == cmFchannelBankDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFchannelBankDefault(CmFchannelBank cmFchannelBank) {
        if (null == cmFchannelBank) {
            return;
        }
        if (null == cmFchannelBank.getDataState()) {
            cmFchannelBank.setDataState(0);
        }
        if (null == cmFchannelBank.getGmtCreate()) {
            cmFchannelBank.setGmtCreate(this.getSysDate());
        }
        cmFchannelBank.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmFchannelBank.getFchannelBankCode())) {
            cmFchannelBank.setFchannelBankCode(this.createUUIDString());
        }
    }

    private int getFchannelBankMaxCode() {
        int code = 0;
        try {
            return this.cmFchannelBankMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.getFchannelBankMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFchannelBankUpdataDefault(CmFchannelBank cmFchannelBank) {
        if (null == cmFchannelBank) {
            return;
        }
        cmFchannelBank.setGmtModified(this.getSysDate());
    }

    private void saveFchannelBankModel(CmFchannelBank cmFchannelBank) throws ApiException {
        if (null == cmFchannelBank) {
            return;
        }
        try {
            this.cmFchannelBankMapper.insert(cmFchannelBank);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.saveFchannelBankModel.ex", (Throwable)e);
        }
    }

    private CmFchannelBank getFchannelBankModelById(Integer fchannelBankId) {
        if (null == fchannelBankId) {
            return null;
        }
        try {
            return this.cmFchannelBankMapper.selectByPrimaryKey(fchannelBankId);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.getFchannelBankModelById", (Throwable)e);
            return null;
        }
    }

    public CmFchannelBank getFchannelBankModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmFchannelBankMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.getFchannelBankModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFchannelBankModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmFchannelBankMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.delFchannelBankModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.delFchannelBankModelByCode.num");
        }
    }

    private void deleteFchannelBankModel(Integer fchannelBankId) throws ApiException {
        if (null == fchannelBankId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmFchannelBankMapper.deleteByPrimaryKey(fchannelBankId);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.deleteFchannelBankModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.deleteFchannelBankModel.num");
        }
    }

    private void updateFchannelBankModel(CmFchannelBank cmFchannelBank) throws ApiException {
        if (null == cmFchannelBank) {
            return;
        }
        try {
            this.cmFchannelBankMapper.updateByPrimaryKeySelective(cmFchannelBank);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.updateFchannelBankModel.ex", (Throwable)e);
        }
    }

    private void updateStateFchannelBankModel(Integer fchannelBankId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == fchannelBankId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fchannelBankId", fchannelBankId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmFchannelBankMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.updateStateFchannelBankModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.updateStateFchannelBankModel.null");
        }
    }

    private CmFchannelBank makeFchannelBank(CmFchannelBankDomain cmFchannelBankDomain, CmFchannelBank cmFchannelBank) {
        if (null == cmFchannelBankDomain) {
            return null;
        }
        if (null == cmFchannelBank) {
            cmFchannelBank = new CmFchannelBank();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmFchannelBank, (Object)cmFchannelBankDomain);
            return cmFchannelBank;
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.makeFchannelBank", (Throwable)e);
            return null;
        }
    }

    private List<CmFchannelBank> queryFchannelBankModelPage(Map<String, Object> parammap) {
        try {
            return this.cmFchannelBankMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.queryFchannelBankModel", (Throwable)e);
            return null;
        }
    }

    private int countFchannelBank(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmFchannelBankMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelBankServiceImpl.countFchannelBank", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFchannelBank(CmFchannelBankDomain cmFchannelBankDomain) throws ApiException {
        String msg = this.checkFchannelBank(cmFchannelBankDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.saveFchannelBank.checkFchannelBank", msg);
        }
        CmFchannelBank cmFchannelBank = this.makeFchannelBank(cmFchannelBankDomain, null);
        this.setFchannelBankDefault(cmFchannelBank);
        this.saveFchannelBankModel(cmFchannelBank);
        if (ListUtil.isNotEmpty(cmFchannelBankDomain.getCmFchannelBankconfigList())) {
            for (CmFchannelBankconfigDomain cmFchannelBankconfigDomain : cmFchannelBankDomain.getCmFchannelBankconfigList()) {
                cmFchannelBankconfigDomain.setTenantCode(cmFchannelBank.getTenantCode());
                cmFchannelBankconfigDomain.setFchannelBankCode(cmFchannelBank.getFchannelBankCode());
            }
            this.cmFchannelBankconfigService.saveCmFchannelBankconfigBatch(cmFchannelBankDomain.getCmFchannelBankconfigList());
        }
        if (ListUtil.isNotEmpty(cmFchannelBankDomain.getCmFchannelConfigDomainList())) {
            for (CmFchannelConfigDomain cmFchannelConfigDomain : cmFchannelBankDomain.getCmFchannelConfigDomainList()) {
                cmFchannelConfigDomain.setTenantCode(cmFchannelBank.getTenantCode());
                cmFchannelConfigDomain.setFchannelConfigScope(cmFchannelBank.getFchannelBankCode());
            }
            this.cmFchannelConfigService.saveFchannelConfigBatch(cmFchannelBankDomain.getCmFchannelConfigDomainList());
        }
        if (null != cmFchannelBankDomain.getDataState() && cmFchannelBankDomain.getDataState() == 1) {
            this.queryFchannelBankCache();
        }
    }

    @Override
    public void updateFchannelBankState(Integer fchannelBankId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFchannelBankModel(fchannelBankId, dataState, oldDataState);
        if (dataState == 1) {
            this.queryFchannelBankCache();
            this.cmFchannelConfigService.queryFchannelConfigCache();
        }
    }

    @Override
    public void updateFchannelBank(CmFchannelBankDomain cmFchannelBankDomain) throws ApiException {
        String msg = this.checkFchannelBank(cmFchannelBankDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.updateFchannelBank.checkFchannelBank", msg);
        }
        CmFchannelBank oldCmFchannelBank = this.getFchannelBankModelById(cmFchannelBankDomain.getFchannelBankId());
        if (null == oldCmFchannelBank) {
            throw new ApiException("cm.CmFchannelBankServiceImpl.updateFchannelBank.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmFchannelBank cmFchannelBank = this.makeFchannelBank(cmFchannelBankDomain, oldCmFchannelBank);
        this.setFchannelBankUpdataDefault(cmFchannelBank);
        if (null != cmFchannelBankDomain.getDataState()) {
            cmFchannelBank.setDataState(cmFchannelBankDomain.getDataState());
        }
        this.logger.error("cm.CmFchannelBankServiceImpl.updateFchannelBank" + JsonUtil.buildNonDefaultBinder().toJson(cmFchannelBankDomain.getCmFchannelBankconfigList()));
        this.updateFchannelBankModel(cmFchannelBank);
        if (ListUtil.isNotEmpty(cmFchannelBankDomain.getCmFchannelBankconfigList())) {
            this.cmFchannelBankconfigService.delCmFchannelBankconfigModelByBankCode(cmFchannelBank.getTenantCode(), cmFchannelBank.getFchannelBankCode());
            this.cmFchannelBankconfigService.saveCmFchannelBankconfigBatch(cmFchannelBankDomain.getCmFchannelBankconfigList());
        }
        if (ListUtil.isNotEmpty(cmFchannelBankDomain.getCmFchannelConfigDomainList())) {
            for (CmFchannelConfigDomain cmFchannelConfigDomain : cmFchannelBankDomain.getCmFchannelConfigDomainList()) {
                if (null != cmFchannelConfigDomain.getFchannelConfigId()) {
                    this.cmFchannelConfigService.updateFchannelConfig(cmFchannelConfigDomain);
                    continue;
                }
                this.cmFchannelConfigService.saveFchannelConfig(cmFchannelConfigDomain);
            }
        }
        if (null != cmFchannelBankDomain.getDataState() && cmFchannelBankDomain.getDataState() == 1) {
            this.queryFchannelBankCache();
        }
    }

    @Override
    public CmFchannelBank getFchannelBank(Integer fchannelBankId) {
        return this.getFchannelBankModelById(fchannelBankId);
    }

    @Override
    public void deleteFchannelBank(Integer fchannelBankId) throws ApiException {
        CmFchannelBank cmFchannelBank = this.getFchannelBank(fchannelBankId);
        if (null != cmFchannelBank) {
            this.cmFchannelBankconfigService.delCmFchannelBankconfigModelByBankCode(cmFchannelBank.getTenantCode(), cmFchannelBank.getFchannelBankCode());
        }
        this.deleteFchannelBankModel(fchannelBankId);
    }

    @Override
    public QueryResult<CmFchannelBank> queryFchannelBankPage(Map<String, Object> map) {
        List<CmFchannelBank> cmFchannelBankList = this.queryFchannelBankModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFchannelBank(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmFchannelBankList);
        return queryResult;
    }

    @Override
    public CmFchannelBank getFchannelBankByCode(Map<String, Object> map) {
        return this.getFchannelBankModelByCode(map);
    }

    @Override
    public void delFchannelBankByCode(Map<String, Object> map) throws ApiException {
        this.delFchannelBankModelByCode(map);
    }

    @Override
    public void queryFchannelBankCache() {
        this.logger.info("cm.CmFchannelBankServiceImpl.queryFchannelBackCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1L);
        List<CmFchannelBank> cmFchannelBankList = this.queryFchannelBankModelPage(parammap);
        if (ListUtil.isEmpty(cmFchannelBankList)) {
            DisUtil.delVer((String)"Fchannel_bank");
            DisUtil.delVer((String)"Fchannel_small_bank");
            DisUtil.delVer((String)"Fchannel_small_proapp_bank");
            this.info("cm.CmFchannelBankServiceImpl.queryFchannelBackCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> smallddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> smallddProAppMap = new ConcurrentHashMap<String, String>();
        QueryResult<CmFchannelBankconfig> cmFchannelBankconfigQueryResult = null;
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<CmFchannelBank>> ddListMap = new ConcurrentHashMap<String, ArrayList<CmFchannelBank>>();
        ConcurrentHashMap<String, ArrayList<CmFchannelBank>> smallddListMap = new ConcurrentHashMap<String, ArrayList<CmFchannelBank>>();
        ConcurrentHashMap<String, ArrayList<CmFchannelBank>> smallddProAppListMap = new ConcurrentHashMap<String, ArrayList<CmFchannelBank>>();
        for (CmFchannelBank cmFchannelBank : cmFchannelBankList) {
            confparammap.put("fchannelBankCode", cmFchannelBank.getFchannelBankCode());
            confparammap.put("tenantCode", cmFchannelBank.getTenantCode());
            cmFchannelBankconfigQueryResult = this.cmFchannelBankconfigService.queryCmFchannelBankconfigPage(confparammap);
            cmFchannelBank.setCmFchannelBankconfigList(cmFchannelBankconfigQueryResult.getList());
            String key = cmFchannelBank.getFchannelCode() + "-" + cmFchannelBank.getTenantCode();
            ArrayList<CmFchannelBank> mlist = (ArrayList<CmFchannelBank>)ddListMap.get(key);
            if (null == mlist) {
                mlist = new ArrayList<CmFchannelBank>();
                ddListMap.put(key, mlist);
            }
            mlist.add(cmFchannelBank);
            String smallKey = cmFchannelBank.getFchannelCode() + "-" + cmFchannelBank.getTenantCode() + "-" + cmFchannelBank.getChannelCode();
            ArrayList<CmFchannelBank> smallList = (ArrayList<CmFchannelBank>)smallddListMap.get(smallKey);
            if (null == smallList) {
                smallList = new ArrayList<CmFchannelBank>();
                smallddListMap.put(smallKey, smallList);
            }
            smallList.add(cmFchannelBank);
            String smallProAppKey = cmFchannelBank.getFchannelCode() + "-" + cmFchannelBank.getTenantCode() + "-" + cmFchannelBank.getChannelCode() + "-" + cmFchannelBank.getProappCode();
            ArrayList<CmFchannelBank> smallddProAppList = (ArrayList<CmFchannelBank>)smallddProAppListMap.get(smallProAppKey);
            if (null == smallddProAppList) {
                smallddProAppList = new ArrayList<CmFchannelBank>();
                smallddProAppListMap.put(smallProAppKey, smallList);
            }
            smallddProAppList.add(cmFchannelBank);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.CmFchannelBanksort((List)ddListMap.get(key))));
        }
        for (String key : smallddListMap.keySet()) {
            smallddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.CmFchannelBanksort((List)smallddListMap.get(key))));
        }
        for (String key : smallddProAppListMap.keySet()) {
            smallddProAppMap.put(key, JsonUtil.buildNormalBinder().toJson(this.CmFchannelBanksort((List)smallddProAppListMap.get(key))));
        }
        DisUtil.setMapVer((String)"Fchannel_bank", ddMap);
        DisUtil.setMapVer((String)"Fchannel_small_bank", smallddMap);
        DisUtil.setMapVer((String)"Fchannel_small_proapp_bank", smallddProAppMap);
        this.logger.info("cm.CmFchannelBankServiceImpl.queryFchannelBackCache", (Object)("===========add-end==========" + JsonUtil.buildNormalBinder().toJson(ddMap)));
    }

    private List<CmFchannelBank> CmFchannelBanksort(List<CmFchannelBank> mlist) {
        if (ListUtil.isEmpty(mlist)) {
            return null;
        }
        Collections.sort(mlist, new Comparator<CmFchannelBank>(){

            @Override
            public int compare(CmFchannelBank arg0, CmFchannelBank arg1) {
                if (arg0.getBankWeight() > arg1.getBankWeight()) {
                    return 1;
                }
                if (arg0.getBankWeight() < arg1.getBankWeight()) {
                    return -1;
                }
                return arg0.getBankWeight().compareTo(arg0.getBankWeight());
            }
        });
        return mlist;
    }
}

