/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.channelmanage.service.impl;

import com.yqbsoft.laser.service.channelmanage.dao.CmFchannelBankMapper;
import com.yqbsoft.laser.service.channelmanage.dao.CmFchannelConfigMapper;
import com.yqbsoft.laser.service.channelmanage.domain.CmFchannelBankDomain;
import com.yqbsoft.laser.service.channelmanage.domain.CmFchannelConfigDomain;
import com.yqbsoft.laser.service.channelmanage.domain.TmProappEnvDomain;
import com.yqbsoft.laser.service.channelmanage.model.CmFchannelBank;
import com.yqbsoft.laser.service.channelmanage.model.CmFchannelConfig;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelBankService;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelConfigService;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelService;
import com.yqbsoft.laser.service.channelmanage.statistics.ThreadPoolUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.helper.StringUtil;

public class CmFchannelConfigServiceImpl
extends BaseServiceImpl
implements CmFchannelConfigService {
    public static final String SYS_CODE = "cm.CmFchannelConfigServiceImpl";
    private CmFchannelService cmFchannelService;
    private CmFchannelConfigMapper cmFchannelConfigMapper;
    private String cacheenvChannelcode = "TmProappEnv-tenant-ProappCode-ChannelCode";
    private CmFchannelBankMapper cmFchannelBankMapper;
    private CmFchannelBankService cmFchannelBankService;

    public CmFchannelService getCmFchannelService() {
        return this.cmFchannelService;
    }

    public void setCmFchannelService(CmFchannelService cmFchannelService) {
        this.cmFchannelService = cmFchannelService;
    }

    public void setCmFchannelConfigMapper(CmFchannelConfigMapper cmFchannelConfigMapper) {
        this.cmFchannelConfigMapper = cmFchannelConfigMapper;
    }

    public void setCmFchannelBankMapper(CmFchannelBankMapper cmFchannelBankMapper) {
        this.cmFchannelBankMapper = cmFchannelBankMapper;
    }

    public CmFchannelBankMapper getCmFchannelBankMapper() {
        return this.cmFchannelBankMapper;
    }

    public CmFchannelBankService getCmFchannelBankService() {
        return this.cmFchannelBankService;
    }

    public void setCmFchannelBankService(CmFchannelBankService cmFchannelBankService) {
        this.cmFchannelBankService = cmFchannelBankService;
    }

    private Date getSysDate() {
        try {
            return this.cmFchannelConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFchannelConfig(CmFchannelConfigDomain cmFchannelConfigDomain) {
        if (null == cmFchannelConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmFchannelConfigDomain.getFchannelCode())) {
            msg = msg + "FchannelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmFchannelConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFchannelConfigDefault(CmFchannelConfig cmFchannelConfig) {
        if (null == cmFchannelConfig) {
            return;
        }
        if (null == cmFchannelConfig.getDataState()) {
            cmFchannelConfig.setDataState(0);
        }
        if (null == cmFchannelConfig.getGmtCreate()) {
            cmFchannelConfig.setGmtCreate(this.getSysDate());
        }
        cmFchannelConfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmFchannelConfig.getFchannelConfigCode())) {
            cmFchannelConfig.setFchannelConfigCode(this.createUUIDString());
        }
    }

    private int getFchannelConfigMaxCode() {
        int code = 0;
        try {
            return this.cmFchannelConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getFchannelConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFchannelConfigUpdataDefault(CmFchannelConfig cmFchannelConfig) {
        if (null == cmFchannelConfig) {
            return;
        }
        cmFchannelConfig.setGmtModified(this.getSysDate());
    }

    private void saveFchannelConfigModel(CmFchannelConfig cmFchannelConfig) throws ApiException {
        if (null == cmFchannelConfig) {
            return;
        }
        try {
            this.cmFchannelConfigMapper.insert(cmFchannelConfig);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.saveFchannelConfigModel.ex", (Throwable)e);
        }
    }

    private CmFchannelConfig getFchannelConfigModelById(Integer fchannelConfigId) {
        if (null == fchannelConfigId) {
            return null;
        }
        try {
            return this.cmFchannelConfigMapper.selectByPrimaryKey(fchannelConfigId);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getFchannelConfigModelById", (Throwable)e);
            return null;
        }
    }

    public CmFchannelConfig getFchannelConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmFchannelConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getFchannelConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFchannelConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmFchannelConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.delFchannelConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.delFchannelConfigModelByCode.num");
        }
    }

    private void deleteFchannelConfigModel(Integer fchannelConfigId) throws ApiException {
        if (null == fchannelConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmFchannelConfigMapper.deleteByPrimaryKey(fchannelConfigId);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.deleteFchannelConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.deleteFchannelConfigModel.num");
        }
    }

    private void updateFchannelConfigModel(CmFchannelConfig cmFchannelConfig) throws ApiException {
        if (null == cmFchannelConfig) {
            return;
        }
        try {
            this.cmFchannelConfigMapper.updateByPrimaryKeySelective(cmFchannelConfig);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.updateFchannelConfigModel.ex", (Throwable)e);
        }
    }

    private void updateStateFchannelConfigModel(Integer fchannelConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == fchannelConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fchannelConfigId", fchannelConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmFchannelConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.updateStateFchannelConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.updateStateFchannelConfigModel.null");
        }
    }

    private CmFchannelConfig makeFchannelConfig(CmFchannelConfigDomain cmFchannelConfigDomain, CmFchannelConfig cmFchannelConfig) {
        if (null == cmFchannelConfigDomain) {
            return null;
        }
        if (null == cmFchannelConfig) {
            cmFchannelConfig = new CmFchannelConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmFchannelConfig, (Object)cmFchannelConfigDomain);
            return cmFchannelConfig;
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.makeFchannelConfig", (Throwable)e);
            return null;
        }
    }

    private CmFchannelConfigDomain makeFchannelConfigDomain(CmFchannelConfig cmFchannelConfig) {
        if (null == cmFchannelConfig) {
            return null;
        }
        CmFchannelConfigDomain cmFchannelConfigDomain = new CmFchannelConfigDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmFchannelConfigDomain, (Object)cmFchannelConfig);
            return cmFchannelConfigDomain;
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.makeFchannelConfigDomain", (Throwable)e);
            return null;
        }
    }

    private CmFchannelBankDomain makeFchannelBankDomain(CmFchannelBank cmFchannelBank) {
        if (null == cmFchannelBank) {
            return null;
        }
        CmFchannelBankDomain cmFchannelBankDomain = new CmFchannelBankDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmFchannelBankDomain, (Object)cmFchannelBank);
            return cmFchannelBankDomain;
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.makeFchannelBankDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmFchannelConfig> queryFchannelConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.cmFchannelConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.queryFchannelConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countFchannelConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmFchannelConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.countFchannelConfig", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFchannelConfig(CmFchannelConfigDomain cmFchannelConfigDomain) throws ApiException {
        String msg = this.checkFchannelConfig(cmFchannelConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.saveFchannelConfig.checkFchannelConfig", msg);
        }
        CmFchannelConfig cmFchannelConfig = this.makeFchannelConfig(cmFchannelConfigDomain, null);
        this.setFchannelConfigDefault(cmFchannelConfig);
        this.saveFchannelConfigModel(cmFchannelConfig);
        this.updateCache(cmFchannelConfig);
    }

    @Override
    public void saveFchannelConfigs(List<CmFchannelConfigDomain> list) throws ApiException {
        for (CmFchannelConfigDomain cmFchannelConfigDomain : list) {
            String msg = this.checkFchannelConfig(cmFchannelConfigDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("cm.CmFchannelConfigServiceImpl.saveFchannelConfig.checkFchannelConfig", msg);
            }
            CmFchannelConfig cmFchannelConfig = this.makeFchannelConfig(cmFchannelConfigDomain, null);
            this.setFchannelConfigDefault(cmFchannelConfig);
            this.saveFchannelConfigModel(cmFchannelConfig);
            this.updateCache(cmFchannelConfig);
        }
    }

    @Override
    public void updateFchannelConfigState(Integer fchannelConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFchannelConfigModel(fchannelConfigId, dataState, oldDataState);
        if (1 == dataState) {
            CmFchannelConfig cmFchannelConfig = this.getFchannelConfig(fchannelConfigId);
            this.updateCache(cmFchannelConfig);
        } else if (-1 == dataState) {
            CmFchannelConfig cmFchannelConfig = this.getFchannelConfig(fchannelConfigId);
            this.delCache(cmFchannelConfig);
        }
    }

    @Override
    public void updateFchannelConfig(CmFchannelConfigDomain cmFchannelConfigDomain) throws ApiException {
        String msg = this.checkFchannelConfig(cmFchannelConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.updateFchannelConfig.checkFchannelConfig", msg);
        }
        CmFchannelConfig oldCmFchannelConfig = this.getFchannelConfigModelById(cmFchannelConfigDomain.getFchannelConfigId());
        if (null == oldCmFchannelConfig) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.updateFchannelConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmFchannelConfig cmFchannelConfig = this.makeFchannelConfig(cmFchannelConfigDomain, oldCmFchannelConfig);
        this.setFchannelConfigUpdataDefault(cmFchannelConfig);
        cmFchannelConfig.setDataState(1);
        this.updateFchannelConfigModel(cmFchannelConfig);
        this.updateCache(cmFchannelConfig);
    }

    @Override
    public CmFchannelConfig getFchannelConfig(Integer fchannelConfigId) {
        return this.getFchannelConfigModelById(fchannelConfigId);
    }

    @Override
    public void deleteFchannelConfig(Integer fchannelConfigId) throws ApiException {
        this.deleteFchannelConfigModel(fchannelConfigId);
        CmFchannelConfig cmFchannelConfig = this.getFchannelConfig(fchannelConfigId);
        this.delCache(cmFchannelConfig);
    }

    @Override
    public QueryResult<CmFchannelConfig> queryFchannelConfigPage(Map<String, Object> map) {
        List<CmFchannelConfig> cmFchannelConfigList = this.queryFchannelConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFchannelConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmFchannelConfigList);
        return queryResult;
    }

    @Override
    public CmFchannelConfig getFchannelConfigByCode(Map<String, Object> map) {
        return this.getFchannelConfigModelByCode(map);
    }

    @Override
    public void delFchannelConfigByCode(Map<String, Object> map) throws ApiException {
        this.delFchannelConfigModelByCode(map);
        CmFchannelConfig cmFchannelConfig = this.getFchannelConfigByCode(map);
        this.delCache(cmFchannelConfig);
    }

    private void delCache(CmFchannelConfig cmFchannelConfig) {
        if (null == cmFchannelConfig) {
            return;
        }
        String key = "";
        key = cmFchannelConfig.getFchannelCode() + "-" + cmFchannelConfig.getFchannelConfigScope() + "-" + cmFchannelConfig.getTenantCode();
        String json = DisUtil.getRemotMap((String)"Fchannel_config", (String)key);
        Map cmap = null;
        if (StringUtils.isNotBlank((String)json)) {
            cmap = JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, String.class);
        }
        if (MapUtil.isEmpty(cmap)) {
            return;
        }
        cmap.remove(cmFchannelConfig.getFchannelConfigKey());
        DisUtil.setMap((String)"Fchannel_config", (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)cmap));
    }

    private void updateCache(CmFchannelConfig cmFchannelConfig) {
        if (null == cmFchannelConfig) {
            return;
        }
        String key = "";
        key = cmFchannelConfig.getFchannelCode() + "-" + cmFchannelConfig.getFchannelConfigScope() + "-" + cmFchannelConfig.getTenantCode();
        String json = DisUtil.getRemotMap((String)"Fchannel_config", (String)key);
        HashMap<String, String> cmap = null;
        if (StringUtils.isNotBlank((String)json)) {
            cmap = JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, String.class);
        }
        if (null == cmap) {
            cmap = new HashMap<String, String>();
        }
        cmap.put(cmFchannelConfig.getFchannelConfigKey(), this.getValue(cmFchannelConfig.getFchannelConfigValue(), cmFchannelConfig.getFchannelConfigScope(), cmFchannelConfig.getTenantCode()));
        DisUtil.setMap((String)"Fchannel_config", (String)key, (String)JsonUtil.buildNormalBinder().toJson(cmap));
    }

    public static void main(String[] args) {
        String fchannelConfigScope = "wechatmini-338296217517314110";
        String[] v = fchannelConfigScope.split("-");
        String fchannelConfigValue = "https://{{tenantCode}-032-{channelCode}}/laserBank/http/post/bank/wechatmini/{fchannelConfigScope}/{tenantCode}";
        if (v.length > 1) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{channelCode\\}", v[1]);
        }
        System.out.println(fchannelConfigValue);
    }

    private String getValue(String fchannelConfigValue, String fchannelConfigScope, String tenantCode) {
        String[] v;
        if (StringUtils.isBlank((String)fchannelConfigValue)) {
            return "";
        }
        if (fchannelConfigValue.indexOf("{") < 0) {
            return fchannelConfigValue;
        }
        if (fchannelConfigValue.indexOf("{fchannelConfigScope}") >= 0) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{fchannelConfigScope\\}", fchannelConfigScope);
        }
        if (fchannelConfigValue.indexOf("{tenantCode}") >= 0) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{tenantCode\\}", tenantCode);
        }
        if (fchannelConfigValue.indexOf("{channelCode}") >= 0 && fchannelConfigScope.indexOf("-") >= 0 && (v = fchannelConfigScope.split("-")).length > 1) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{channelCode\\}", v[1]);
        }
        if (fchannelConfigValue.indexOf("{") < 0 || fchannelConfigValue.indexOf("}") < 0) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getValue.start", (Object)(fchannelConfigValue + "==" + tenantCode));
            return fchannelConfigValue;
        }
        String code = fchannelConfigValue.substring(fchannelConfigValue.indexOf("{"));
        if (code.indexOf("}") < 0) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getValue.start1", (Object)(fchannelConfigValue + "==" + tenantCode));
            return fchannelConfigValue;
        }
        String json = DisUtil.getMap((String)"TmProappEnv-tenant-ProappCode", (String)(code = code.substring(1, code.indexOf("}"))));
        if (StringUtils.isBlank((String)json)) {
            json = DisUtil.getRemotMap((String)"TmProappEnv-tenant-ProappCode", (String)code);
        }
        if (StringUtils.isBlank((String)json)) {
            json = DisUtil.getRemotMap((String)this.cacheenvChannelcode, (String)code);
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getValue.start2", (Object)(fchannelConfigValue + "==" + tenantCode + "==" + code));
            return fchannelConfigValue;
        }
        TmProappEnvDomain tmProappEnvDomain = (TmProappEnvDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, TmProappEnvDomain.class);
        if (null == tmProappEnvDomain) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getValue.start3", (Object)(fchannelConfigValue + "==" + tenantCode + "==" + code));
            return fchannelConfigValue;
        }
        String domain = tmProappEnvDomain.getProappEnvDomain();
        if (StringUtils.isBlank((String)domain)) {
            domain = tmProappEnvDomain.getProappEnvDomain1();
        }
        if (StringUtils.isBlank((String)domain)) {
            domain = tmProappEnvDomain.getProappEnvDomain2();
        }
        if (StringUtils.isBlank((String)domain)) {
            this.logger.error("cm.CmFchannelConfigServiceImpl.getValue.start4", (Object)(fchannelConfigValue + "==" + tenantCode + "==" + code));
            domain = "";
        }
        fchannelConfigValue = fchannelConfigValue.replaceAll("\\{" + code + "\\}", domain);
        return fchannelConfigValue;
    }

    @Override
    public void queryFchannelConfigCache() {
        this.info("cm.CmFchannelConfigServiceImpl.queryFchannelConfigCache.start", "=======\u8c03\u5ea6start=======");
        this.cmFchannelBankService.queryFchannelBankCache();
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<CmFchannelConfig> list = this.queryFchannelConfigModelPage(params);
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)"Fchannel_config");
            this.info("cm.CmFchannelConfigServiceImpl.queryFchannelConfigCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        String key = "";
        HashMap<String, String> kmap = null;
        for (CmFchannelConfig cmFchannelConfig : list) {
            key = cmFchannelConfig.getFchannelCode() + "-" + cmFchannelConfig.getFchannelConfigScope() + "-" + cmFchannelConfig.getTenantCode();
            kmap = (HashMap<String, String>)map.get(key);
            if (null == kmap) {
                kmap = new HashMap<String, String>();
                map.put(key, kmap);
            }
            kmap.put(cmFchannelConfig.getFchannelConfigKey(), this.getValue(cmFchannelConfig.getFchannelConfigValue(), cmFchannelConfig.getFchannelConfigScope(), cmFchannelConfig.getTenantCode()));
        }
        HashMap<String, String> cmap = new HashMap<String, String>();
        for (String mkey : map.keySet()) {
            String value = JsonUtil.buildNormalBinder().toJson(map.get(mkey));
            if (StringUtil.isBlank((String)value)) continue;
            cmap.put(mkey, JsonUtil.buildNormalBinder().toJson(map.get(mkey)));
        }
        DisUtil.setMap((String)"Fchannel_config", cmap);
        this.info("cm.CmFchannelConfigServiceImpl.queryFchannelConfigCache.end", "=======\u8c03\u5ea6end=======");
    }

    @Override
    public void saveFchannelConfigBatch(List<CmFchannelConfigDomain> list) throws ApiException {
        if (list == null || list.size() == 0) {
            throw new ApiException("cm.CmFchannelConfigServiceImpl.saveFchannelConfig.saveFchannelConfigBatch", "\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)list.get(0).getFchannelConfigCode())) {
            for (CmFchannelConfigDomain cmFchannelConfigDomain : list) {
                this.saveFchannelConfig(cmFchannelConfigDomain);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", list.get(0).getTenantCode());
            map.put("fchannelCode", list.get(0).getFchannelCode());
            this.internalInvoke("pte.ptfchannel.savePtfchannelInit", map);
        } else {
            for (CmFchannelConfigDomain cmFchannelConfigDomain : list) {
                this.updateFchannelConfig(cmFchannelConfigDomain);
            }
        }
    }

    @Override
    public void saveFchannelConfigInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", "00000000");
        List<CmFchannelConfig> list = this.queryFchannelConfigModelPage(params);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        for (CmFchannelConfig cmFchannelConfig : list) {
            List<CmFchannelConfig> oldList = this.queryFchannelConfigModelPage(this.getQueryMapParam("tenantCode,fchannelCode,fchannelConfigKey,fchannelConfigScope", new Object[]{tenantCode, cmFchannelConfig.getFchannelCode(), cmFchannelConfig.getFchannelConfigKey(), cmFchannelConfig.getFchannelConfigScope()}));
            if (ListUtil.isNotEmpty(oldList)) continue;
            CmFchannelConfigDomain cmFchannelConfigDomain = this.makeFchannelConfigDomain(cmFchannelConfig);
            cmFchannelConfigDomain.setFchannelConfigId(null);
            cmFchannelConfigDomain.setFchannelConfigCode(null);
            cmFchannelConfigDomain.setTenantCode(tenantCode);
            this.saveFchannelConfig(cmFchannelConfigDomain);
        }
    }

    @Override
    public List<CmFchannelConfig> queryCmFchannelConfigByEnvCode(String tenantCode, String fchannelCode, String fchannelConfigScope) throws ApiException {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("fchannelCode", fchannelCode);
        parammap.put("fchannelConfigScope", fchannelConfigScope);
        List<CmFchannelConfig> osList = this.queryFchannelConfigModelPage(parammap);
        if (ListUtil.isEmpty(osList)) {
            parammap.put("fchannelConfigScope", "PRO");
            osList = this.queryFchannelConfigModelPage(parammap);
            if (ListUtil.isEmpty(osList)) {
                this.logger.error("cm.CmFchannelConfigServiceImpl.queryOAuthEnvconfigByEnvCode.osList1", (Object)((Object)parammap).toString());
            }
        } else {
            this.logger.error("cm.CmFchannelConfigServiceImpl.queryOAuthEnvconfigByEnvCode.parameter", (Object)((Object)parammap).toString());
        }
        return osList;
    }

    @Override
    public void saveFchannelConfigAndBankByChannelInit(Map<String, Object> param) throws ApiException {
        ThreadPoolUtil.execute(() -> {
            try {
                this.saveFchannelConfigAndBankByChannelTreadInit(param);
            }
            catch (Exception e) {
                this.logger.error("cm.CmFchannelConfigServiceImpl.saveFchannelConfigAndBankByChannelInit param.error\uff1a", (Throwable)e);
            }
        });
    }

    private void saveFchannelConfigAndBankByChannelTreadInit(Map<String, Object> param) {
        this.logger.info("cm.CmFchannelConfigServiceImpl.saveFchannelConfigAndBankByChannelInit param\uff1a", param);
        String tenantCode = String.valueOf(param.get("tenantCode"));
        String channelCode = String.valueOf(param.get("channelCode"));
        String channelName = String.valueOf(param.get("channelName"));
        String memberCode = String.valueOf(param.get("memberCode"));
        String memberName = String.valueOf(param.get("memberName"));
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fchannelConfigScope", "PRO");
        params.put("tenantCode", "00000000");
        params.put("dataState", "1");
        List<CmFchannelConfig> list = this.queryFchannelConfigModelPage(params);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        Map<String, List<CmFchannelConfig>> map = list.stream().collect(Collectors.groupingBy(cmFchannelConfig -> cmFchannelConfig.getFchannelCode()));
        Iterator<Map.Entry<String, List<CmFchannelConfig>>> entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            long startTime2 = System.currentTimeMillis();
            Map.Entry<String, List<CmFchannelConfig>> entry = entries.next();
            String fchannelCode = entry.getKey();
            List<CmFchannelConfig> fchannelConfigs = entry.getValue();
            String fchannelBankCode = fchannelCode + "-" + channelCode;
            CmFchannelBankDomain cmFchannelBankDomain = new CmFchannelBankDomain();
            cmFchannelBankDomain.setFchannelBankId(null);
            cmFchannelBankDomain.setTenantCode(tenantCode);
            cmFchannelBankDomain.setChannelCode(channelCode);
            cmFchannelBankDomain.setChannelName(channelName);
            cmFchannelBankDomain.setMemberCode(memberCode);
            cmFchannelBankDomain.setMemberName(memberName);
            cmFchannelBankDomain.setFchannelBankCode(fchannelBankCode);
            cmFchannelBankDomain.setFchannelBankArea("all");
            cmFchannelBankDomain.setFchannelCode(fchannelCode);
            cmFchannelBankDomain.setDataState(1);
            HashMap<String, Object> bankMap = new HashMap<String, Object>();
            bankMap.put("fchannelBankCode", fchannelBankCode);
            bankMap.put("tenantCode", tenantCode);
            long startTime3 = System.currentTimeMillis();
            QueryResult<CmFchannelBank> cmFchannelBankQueryResult = this.cmFchannelBankService.queryFchannelBankPage(bankMap);
            this.logger.info("cm.CmFchannelConfigServiceImpl.saveFchannelConfigAndBankByChannelInit.queryFchannelBankPage.time\uff1a", (Object)(System.currentTimeMillis() - startTime3));
            if (cmFchannelBankQueryResult != null && CollectionUtils.isNotEmpty((Collection)cmFchannelBankQueryResult.getList())) {
                this.logger.info("cm.CmFchannelConfigServiceImpl.saveFchannelConfigAndBankByChannelInit.getFchannelBankByCode\u5df2\u5b58\u5728", bankMap);
                continue;
            }
            this.cmFchannelBankService.saveFchannelBank(cmFchannelBankDomain);
            for (CmFchannelConfig cmFchannelConfig2 : fchannelConfigs) {
                List<CmFchannelConfig> oldList = this.queryFchannelConfigModelPage(this.getQueryMapParam("tenantCode,fchannelCode,fchannelConfigScope,fchannelConfigKey", new Object[]{tenantCode, fchannelCode, fchannelBankCode, cmFchannelConfig2.getFchannelConfigKey()}));
                if (ListUtil.isNotEmpty(oldList)) continue;
                CmFchannelConfigDomain cmFchannelConfigDomain = this.makeFchannelConfigDomain(cmFchannelConfig2);
                cmFchannelConfigDomain.setFchannelConfigId(null);
                cmFchannelConfigDomain.setFchannelConfigCode(null);
                cmFchannelConfigDomain.setFchannelConfigScope(fchannelBankCode);
                cmFchannelConfigDomain.setTenantCode(tenantCode);
                this.saveFchannelConfig(cmFchannelConfigDomain);
            }
            this.logger.info("cm.CmFchannelConfigServiceImpl.saveFchannelConfigAndBankByChannelInit.one.time\uff1a", (Object)(System.currentTimeMillis() - startTime2));
        }
        this.cmFchannelBankService.queryFchannelBankCache();
    }

    @Override
    public void queryFchannelConfigCacheNew(Map<String, Object> nmap) {
        List<CmFchannelConfig> list;
        this.info("cm.CmFchannelConfigServiceImpl.queryFchannelConfigCacheNew.start", nmap);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (MapUtil.isEmpty(nmap)) {
            params.putAll(nmap);
        }
        if (CollectionUtils.isEmpty(list = this.queryFchannelConfigModelPage(params))) {
            DisUtil.delVer((String)"Fchannel_config");
            this.info("cm.CmFchannelConfigServiceImpl.queryFchannelConfigCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        String key = "";
        HashMap<String, String> kmap = null;
        for (CmFchannelConfig cmFchannelConfig : list) {
            key = cmFchannelConfig.getFchannelCode() + "-" + cmFchannelConfig.getFchannelConfigScope() + "-" + cmFchannelConfig.getTenantCode();
            kmap = (HashMap<String, String>)map.get(key);
            if (null == kmap) {
                kmap = new HashMap<String, String>();
                map.put(key, kmap);
            }
            kmap.put(cmFchannelConfig.getFchannelConfigKey(), this.getValue(cmFchannelConfig.getFchannelConfigValue(), cmFchannelConfig.getFchannelConfigScope(), cmFchannelConfig.getTenantCode()));
        }
        HashMap<String, String> cmap = new HashMap<String, String>();
        for (String mkey : map.keySet()) {
            String value = JsonUtil.buildNormalBinder().toJson(map.get(mkey));
            if (StringUtil.isBlank((String)value)) continue;
            cmap.put(mkey, JsonUtil.buildNormalBinder().toJson(map.get(mkey)));
        }
        DisUtil.setMap((String)"Fchannel_config", cmap);
        this.info("cm.CmFchannelConfigServiceImpl.queryFchannelConfigCache.end", "=======\u8c03\u5ea6end=======");
    }
}

