/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.groovy;

import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.groovy.GroovyBaseServiceImpl;
import com.yqbsoft.laser.service.contract.model.RsResourceGoods;
import com.yqbsoft.laser.service.contract.model.RsSku;
import com.yqbsoft.laser.service.contract.service.OcContractGroovy;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractGroovyImpl
extends GroovyBaseServiceImpl
implements OcContractGroovy {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractgoodsGroovyImpl";

    @Override
    public List<OcContractReDomain> makeOcContract(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.map", map);
            return null;
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)map.get("ocContractReDomain");
        if (null == ocContractReDomain || ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImplmakeOcContract.ocContractReDomain", map);
            return null;
        }
        List<OcContractGoodsDomain> ocContractGoodsDomainList = new ArrayList();
        HashMap<String, List<OcContractGoodsDomain>> goodsMap = new HashMap<String, List<OcContractGoodsDomain>>();
        for (OcContractGoodsDomain goodsDomain : ocContractReDomain.getGoodsList()) {
            if (StringUtils.isBlank((String)goodsDomain.getSkuCode())) {
                this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.skuCode", (Object)"skuCode is null");
                return null;
            }
            HashMap<String, Object> sendMap = new HashMap<String, Object>();
            sendMap.put("tenantCode", goodsDomain.getTenantCode());
            sendMap.put("skuCode", goodsDomain.getSkuCode());
            HashMap<String, Object> invokeMap = new HashMap<String, Object>();
            invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
            String s = this.internalInvoke("rs.sku.getSkuByCode", invokeMap);
            if (StringUtils.isBlank((String)s)) {
                this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImplmakeOcContract.paramMap", (Object)(((Object)invokeMap).toString() + s));
                return null;
            }
            RsSku rsSku = (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(s, RsSku.class);
            if (null == rsSku) {
                this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.rsSku", (Object)"rsSku is null");
                return null;
            }
            sendMap.remove("skuCode");
            sendMap.put("goodsCode", goodsDomain.getGoodsCode());
            String goods = this.internalInvoke("rs.resourceGoods.getResourceGoodsByCodeStr", sendMap);
            if (StringUtils.isBlank((String)s)) {
                this.logger.error(SYS_CODE, (Object)("paramMap" + ((Object)invokeMap).toString() + s));
                return null;
            }
            RsResourceGoods rsResourceGoods = (RsResourceGoods)JsonUtil.buildNormalBinder().getJsonToObject(goods, RsResourceGoods.class);
            if (null == rsResourceGoods) {
                this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.rsResourceGoods", (Object)"rsResourceGoods is null");
                return null;
            }
            if (rsSku.getGoodsSupplynum().compareTo(goodsDomain.getGoodsCamount()) < 0) {
                this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.rsSku", (Object)(rsSku.getGoodsSupplynum() + "," + goodsDomain.getGoodsCamount()));
                return null;
            }
            if ("A".equals(rsResourceGoods.getGoodsProperty()) || "B".equals(rsResourceGoods.getGoodsProperty()) || "F".equals(rsResourceGoods.getGoodsProperty()) || "N".equals(rsResourceGoods.getGoodsProperty())) {
                ocContractGoodsDomainList = (List)goodsMap.get("7");
                if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
                    ocContractGoodsDomainList = new ArrayList();
                    goodsMap.put("7", ocContractGoodsDomainList);
                }
                ocContractGoodsDomainList.add(goodsDomain);
                continue;
            }
            if ("C".equals(rsResourceGoods.getGoodsProperty()) || "D".equals(rsResourceGoods.getGoodsProperty()) || "E".equals(rsResourceGoods.getGoodsProperty())) {
                ocContractGoodsDomainList = (List)goodsMap.get("8");
                if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
                    ocContractGoodsDomainList = new ArrayList();
                    goodsMap.put("8", ocContractGoodsDomainList);
                }
                ocContractGoodsDomainList.add(goodsDomain);
                continue;
            }
            ocContractGoodsDomainList = (List)goodsMap.get("9");
            if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
                ocContractGoodsDomainList = new ArrayList();
                goodsMap.put("9", ocContractGoodsDomainList);
            }
            ocContractGoodsDomainList.add(goodsDomain);
        }
        if (MapUtil.isEmpty(goodsMap)) {
            this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.goodsList", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocContractReDomain.getGoodsList()));
            return null;
        }
        ArrayList<OcContractReDomain> ocContractReDomainList = new ArrayList<OcContractReDomain>();
        String obj = this.makeContracts(goodsMap, ocContractReDomain, ocContractReDomainList);
        if ("error".equals(obj)) {
            this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeOcContract.obj", goodsMap);
            return null;
        }
        return ocContractReDomainList;
    }

    public String makeContracts(Map<String, List<OcContractGoodsDomain>> goodsMap, OcContractReDomain ocContractDomain, List<OcContractReDomain> ocContractDomainList) {
        int i = 0;
        BigDecimal dataMoney = ocContractDomain.getDataBmoney();
        for (String key : goodsMap.keySet()) {
            ++i;
            List<OcContractGoodsDomain> goodsDomainList = goodsMap.get(key);
            OcContractReDomain domain = new OcContractReDomain();
            if (null == goodsDomainList) {
                this.logger.error("oc.CONTRACT.OcContractgoodsGroovyImpl.makeContract", (Object)key);
                return "error";
            }
            try {
                BeanUtils.copyAllPropertys((Object)domain, (Object)ocContractDomain);
                domain.setContractId(null);
                domain.setContractBillcode(null);
                domain.setContractBbillcode(null);
                domain.setContractType("89");
                domain.setPackageList(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("7".equals(key)) {
                domain.setContractProperty("7");
            } else if ("8".equals(key)) {
                domain.setContractProperty("8");
            } else if ("9".equals(key)) {
                domain.setContractProperty("9");
            }
            BigDecimal contratMoney = BigDecimal.ZERO;
            BigDecimal contratInMoney = BigDecimal.ZERO;
            BigDecimal bNum = BigDecimal.ZERO;
            OcPackageDomain packageDomain = new OcPackageDomain();
            ArrayList<OcPackageDomain> packageDomains = new ArrayList<OcPackageDomain>();
            for (OcContractGoodsDomain goods : goodsDomainList) {
                goods.setContractGoodsId(null);
                goods.setContractGoodsCode(null);
                goods.setContractBillcode(null);
                goods.setPackageCode(null);
                bNum = bNum.add(goods.getGoodsCamount());
                contratMoney = contratMoney.add(goods.getContractGoodsMoney());
                contratInMoney = contratInMoney.add(goods.getContractGoodsInmoney());
            }
            domain.setContractMoney(contratMoney);
            domain.setGoodsMoney(contratMoney);
            domain.setContractInmoney(contratInMoney);
            domain.setDataBnum(bNum);
            domain.setGoodsNum(bNum);
            if (goodsMap.size() != i) {
                dataMoney = dataMoney.subtract(contratInMoney);
                domain.setDataBmoney(contratInMoney);
            } else {
                domain.setDataBmoney(dataMoney);
            }
            packageDomain.setContractGoodsList(goodsDomainList);
            packageDomains.add(packageDomain);
            domain.setPackageList(packageDomains);
            domain.setGoodsList(goodsDomainList);
            ocContractDomainList.add(domain);
        }
        return "success";
    }
}

