/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler;

import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.handler.AbstractContractApprovalHandler;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="priceHandler")
public class PriceApprovalHandler
extends AbstractContractApprovalHandler {
    private static final Logger log = LoggerFactory.getLogger(PriceApprovalHandler.class);

    public PriceApprovalHandler(OcContractService contractService, OcContractEngineService contractEngineService) {
        super(contractService, contractEngineService);
    }

    @Override
    public String getBizType() {
        return "ORDER";
    }

    @Override
    public void onApproved(String bizId) {
        log.info("==============PriceApprovalHandler =========onApproved {}", (Object)bizId);
        OcContractReDomain contract = this.getContractByCode(bizId);
        this.handleContractStatus(contract, "3");
        this.contractEngineService.sendContractNext(bizId, contract.getTenantCode(), null);
    }

    @Override
    public void onRejected(String bizId) {
        OcContractReDomain contract = this.getContractByCode(bizId);
        this.handleContractStatus(contract, "4");
        this.contractEngineService.sendContractBack(bizId, contract.getTenantCode(), null);
    }
}

