/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.dao;

import com.yqbsoft.laser.service.contract.domain.BizPaymentFlow;
import java.util.List;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface BizPaymentFlowMapper {
    @Insert(value={"INSERT INTO biz_payment_flow (customer_code, merchant_code, order_no, payment_order_no, channel, pay_type, flow_type, amount, currency, status, qr_code_url, pay_url, trace_id, remark, created_at, updated_at) VALUES (#{customerCode}, #{merchantCode}, #{orderNo}, #{paymentOrderNo}, #{channel}, #{payType}, #{flowType}, #{amount}, #{currency}, #{status}, #{qrCodeUrl}, #{payUrl}, #{traceId}, #{remark}, NOW(), NOW())"})
    @Options(useGeneratedKeys=true, keyProperty="id")
    public void insert(BizPaymentFlow var1);

    @Select(value={"SELECT * FROM biz_payment_flow WHERE order_no = #{orderNo} AND flow_type = 'PAYMENT' AND status = 'PROCESSING' LIMIT 1"})
    public BizPaymentFlow selectProcessingPayByOrderNo(@Param(value="orderNo") String var1);

    @Select(value={"SELECT COALESCE(SUM(amount), 0) FROM biz_payment_flow WHERE order_no = #{orderNo} AND flow_type = 'PAYMENT' AND status = 'SUCCESS'"})
    public Long selectTotalPaidAmountByOrderNo(@Param(value="orderNo") String var1);

    @Select(value={"SELECT COALESCE(SUM(amount), 0) FROM biz_payment_flow WHERE order_no = #{orderNo} AND flow_type = 'REFUND' AND status IN ('PROCESSING', 'SUCCESS')"})
    public Long selectTotalRefundedAmountByOrderNo(@Param(value="orderNo") String var1);

    @Update(value={"UPDATE biz_payment_flow SET status = #{status}, updated_at = NOW() WHERE id = #{flowId}"})
    public void updateStatus(@Param(value="flowId") Long var1, @Param(value="status") String var2);

    @Update(value={"UPDATE biz_payment_flow SET payment_order_no = #{paymentOrderNo}, qr_code_url = #{qrCodeUrl}, pay_url = #{payUrl}, status = #{status}, updated_at = NOW() WHERE id = #{id}"})
    public void update(BizPaymentFlow var1);

    @Select(value={"SELECT * FROM biz_payment_flow WHERE order_no = #{orderNo} ORDER BY created_at ASC"})
    public List<BizPaymentFlow> selectByOrderNo(@Param(value="orderNo") String var1);

    @Select(value={"SELECT * FROM biz_payment_flow WHERE flow_no = #{flowNo} LIMIT 1"})
    public BizPaymentFlow selectByFlowNo(@Param(value="flowNo") String var1);
}

