/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.factory;

import com.yqbsoft.laser.service.contract.enums.PayChannelsEnum;
import com.yqbsoft.laser.service.contract.handler.payment.PaymentHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PaymentHandlerFactory {
    private final List<PaymentHandler> handlers;
    private Map<String, PaymentHandler> map;

    private void initIfNeeded() {
        if (this.map == null) {
            this.map = this.handlers.stream().collect(Collectors.toMap(h -> {
                String cn = h.getClass().getSimpleName().toUpperCase();
                if (cn.contains("CMB")) {
                    return PayChannelsEnum.CMB.getCode();
                }
                if (cn.contains("CBS_OFFLINE")) {
                    return PayChannelsEnum.CBS_OFFLINE.getCode();
                }
                if (cn.contains("ALIPAY")) {
                    return PayChannelsEnum.ALIPAY.getCode();
                }
                if (cn.contains("WECHAT")) {
                    return PayChannelsEnum.WECHAT.getCode();
                }
                return "UNKNOWN" + cn;
            }, h -> h));
        }
    }

    public PaymentHandler getHandler(String channel) {
        this.initIfNeeded();
        return this.map.get(channel);
    }

    public PaymentHandlerFactory(List<PaymentHandler> handlers) {
        this.handlers = handlers;
    }
}

