/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.service.OcContractGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcContractGoodsServiceImpl
extends BaseServiceImpl
implements OcContractGoodsService {
    private static final Logger log = LoggerFactory.getLogger(OcContractGoodsServiceImpl.class);
    private static final String SYS_CODE = "oc.CONTRACT.OcContractGoodsServiceImpl";
    private OcContractGoodsMapper ocContractGoodsMapper;

    public void setOcContractGoodsMapper(OcContractGoodsMapper ocContractGoodsMapper) {
        this.ocContractGoodsMapper = ocContractGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkcontractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setcontractGoodsDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        if (null == ocContractGoods.getDataState()) {
            ocContractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractGoods.getGmtCreate()) {
            ocContractGoods.setGmtCreate(date);
        }
        ocContractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsCode())) {
            ocContractGoods.setContractGoodsCode(this.getNo(null, "OcContractGoods", "ocContractGoods", ocContractGoods.getTenantCode()));
        }
    }

    private int getcontractGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocContractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.getcontractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setcontractGoodsUpdataDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        ocContractGoods.setGmtModified(this.getSysDate());
    }

    private void savecontractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insert(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.savecontractGoodsModel.ex", (Throwable)e);
        }
    }

    private void savecontractGoodsBatchModel(List<OcContractGoods> ocContractGoodsList) throws ApiException {
        if (null == ocContractGoodsList || ocContractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insertBatch(ocContractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.savecontractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractGoods getcontractGoodsModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.getcontractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractGoods getcontractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.getcontractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delcontractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.delcontractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.delcontractGoodsModelByCode.num");
        }
    }

    private void deletecontractGoodsModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.deletecontractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.deletecontractGoodsModel.num");
        }
    }

    private void updatecontractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateByPrimaryKey(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updatecontractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updatecontractGoodsModel.num");
        }
    }

    private void updateocContractGoodsSpecByCodeModel(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateSpecByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updateocContractGoodsSpecByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updateocContractGoodsSpecByCodeModel.null" + map);
        }
    }

    private void updateStatecontractGoodsModel(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updateStatecontractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updateStatecontractGoodsModel.null");
        }
    }

    private void updateStatecontractGoodsModelByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updateStatecontractGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updateStatecontractGoodsModelByCode.null");
        }
    }

    private OcContractGoods makecontractGoods(OcContractGoodsDomain ocContractGoodsDomain, OcContractGoods ocContractGoods) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        if (null == ocContractGoods) {
            ocContractGoods = new OcContractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)ocContractGoodsDomain);
            return ocContractGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.makecontractGoods", (Throwable)e);
            return null;
        }
    }

    private OcContractGoodsReDomain makeOcContractGoodsReDomain(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return null;
        }
        OcContractGoodsReDomain ocContractGoodsReDomain = new OcContractGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoodsReDomain, (Object)ocContractGoods);
            return ocContractGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.makeOcContractGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoods> querycontractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.querycontractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countcontractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            if (MapUtil.isNotEmpty(map) && map.containsKey("rows") && map.containsKey("startRow")) {
                i = this.ocContractGoodsMapper.count(map);
            }
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.countcontractGoods", (Throwable)e);
        }
        return i;
    }

    private OcContractGoods createOcContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        String msg = this.checkcontractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.savecontractGoods.checkcontractGoods", msg);
        }
        OcContractGoods ocContractGoods = this.makecontractGoods(ocContractGoodsDomain, null);
        this.setcontractGoodsDefault(ocContractGoods);
        return ocContractGoods;
    }

    @Override
    public String savecontractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        OcContractGoods ocContractGoods = this.createOcContractGoods(ocContractGoodsDomain);
        this.savecontractGoodsModel(ocContractGoods);
        return ocContractGoods.getContractGoodsCode();
    }

    @Override
    public String savecontractGoodsBatch(List<OcContractGoodsDomain> ocContractGoodsDomainList) throws ApiException {
        if (null == ocContractGoodsDomainList || ocContractGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractGoods> ocContractGoodsList = new ArrayList<OcContractGoods>();
        String code = "";
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            OcContractGoods ocContractGoods = this.createOcContractGoods(ocContractGoodsDomain);
            code = ocContractGoods.getContractGoodsCode();
            ocContractGoodsList.add(ocContractGoods);
        }
        this.savecontractGoodsBatchModel(ocContractGoodsList);
        return code;
    }

    @Override
    public void updatecontractGoodsState(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        this.updateStatecontractGoodsModel(contractGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updatecontractGoodsStateByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatecontractGoodsModelByCode(tenantCode, contractGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatecontractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        String msg = this.checkcontractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updatecontractGoods.checkcontractGoods", msg);
        }
        OcContractGoods oldOcContractGoods = ocContractGoodsDomain.getContractGoodsId() != null ? this.getcontractGoodsModelById(ocContractGoodsDomain.getContractGoodsId()) : this.getcontractGoodsByCode(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain.getTenantCode());
        if (null == oldOcContractGoods) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsServiceImpl.updatecontractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractGoods ocContractGoods = this.makecontractGoods(ocContractGoodsDomain, oldOcContractGoods);
        this.setcontractGoodsUpdataDefault(ocContractGoods);
        this.updatecontractGoodsModel(ocContractGoods);
    }

    @Override
    public OcContractGoods getcontractGoods(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        return this.getcontractGoodsModelById(contractGoodsId);
    }

    @Override
    public void deletecontractGoods(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        this.deletecontractGoodsModel(contractGoodsId);
    }

    @Override
    public SupQueryResult<OcContractGoods> querycontractGoodsPage(Map<String, Object> map) {
        log.info("================querycontractGoodsPage={}", (Object)JSONObject.toJSONString(map));
        List<OcContractGoods> ocContractGoodsList = this.querycontractGoodsModelPage(map);
        log.info("===========ocContractGoodsList========={}", (Object)JSONObject.toJSONString(ocContractGoodsList));
        SupQueryResult queryResult = new SupQueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(ocContractGoodsList)) {
            count = this.countcontractGoods(map);
        }
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsList);
        return queryResult;
    }

    @Override
    public OcContractGoods getcontractGoodsByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        return this.getcontractGoodsModelByCode(map);
    }

    @Override
    public void deletecontractGoodsByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        this.delcontractGoodsModelByCode(map);
    }

    @Override
    public void updatecontractGoodsBatch(List<Map<String, Object>> mapList) {
        if (ListUtil.isEmpty(mapList)) {
            return;
        }
        this.logger.error("oc.CONTRACT.OcContractGoodsServiceImpl.updatecontractGoodsBatch", (Object)JsonUtil.buildNormalBinder().toJson(mapList));
        for (Map<String, Object> map : mapList) {
            this.updateocContractGoodsSpecByCodeModel(map);
        }
    }
}

