/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.task;

import com.yqbsoft.laser.service.contract.dao.BizPaymentFlowMapper;
import com.yqbsoft.laser.service.contract.domain.BizPaymentFlow;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PaymentFlowTimeoutTask {
    private static final Logger log = LoggerFactory.getLogger(PaymentFlowTimeoutTask.class);
    private final BizPaymentFlowMapper bizPaymentFlowMapper;

    @Scheduled(cron="0 * * * * ?")
    public void markTimeoutProcessingAsFail() {
        log.info("[PaymentFlowTimeoutTask]==================markTimeoutProcessingAsFail======================");
        LocalDateTime cutoff = LocalDateTime.now().minusMinutes(21L);
        List<BizPaymentFlow> timeoutList = this.bizPaymentFlowMapper.selectTimeoutProcessing(cutoff);
        log.info("[PaymentFlowTimeoutTask]=======================================timeoutList={}", timeoutList);
        if (timeoutList.isEmpty()) {
            return;
        }
        for (BizPaymentFlow flow : timeoutList) {
            try {
                this.bizPaymentFlowMapper.updateStatus(flow.getId(), BizPaymentFlow.FlowStatus.FAIL.name());
                log.warn("[PaymentTimeout] flow {} marked as FAIL (last update: {})", (Object)flow.getFlowNo(), (Object)flow.getUpdatedAt());
            }
            catch (Exception e) {
                log.error("[PaymentTimeout] update failed for flow {}", (Object)flow.getFlowNo(), (Object)e);
            }
        }
    }

    public PaymentFlowTimeoutTask(BizPaymentFlowMapper bizPaymentFlowMapper) {
        this.bizPaymentFlowMapper = bizPaymentFlowMapper;
    }
}

