/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.ContractConstants;
import com.yqbsoft.laser.service.contract.domain.ApAdaptationReDomainBean;
import com.yqbsoft.laser.service.contract.domain.GoodsSendNumBean;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcRecflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundFileDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsAuBean;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsCallBean;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.domain.SgSendgoods;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsGoods;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsGoodsReDomain;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsRuleReDomain;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsRuleconfDomain;
import com.yqbsoft.laser.service.contract.model.CmChannelClear;
import com.yqbsoft.laser.service.contract.model.OcContractSettl;
import com.yqbsoft.laser.service.contract.model.OcRecflowPprocess;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcRefundFile;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.contract.model.OcSendcontractData;
import com.yqbsoft.laser.service.contract.refundes.PprocessModelPutThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessPollThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessPutThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessService;
import com.yqbsoft.laser.service.contract.refundes.RefundDomainPutThread;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcRecflowPprocessService;
import com.yqbsoft.laser.service.contract.service.OcRefundEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundFileService;
import com.yqbsoft.laser.service.contract.service.OcRefundFlowEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundGroovy;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundCtrlServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcSendcontractDataServiceImpl;
import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundEngineServiceImpl
extends BaseServiceImpl
implements OcRefundEngineService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRefundEngineServiceImpl";
    private static PprocessService pprocessService;
    private static Object lock;
    private OcRefundFlowEngineService ocRefundFlowEngineService;
    private OcRecflowPprocessService ocRecflowPprocessService;
    OcRefundService ocRefundService;
    private OcContractService ocContractService;
    private OcRefundFileService ocRefundFileService;
    private static Integer oc_errDataState;
    private static Integer oc_newDataState;

    public OcRefundFileService getOcRefundFileService() {
        return this.ocRefundFileService;
    }

    public void setOcRefundFileService(OcRefundFileService ocRefundFileService) {
        this.ocRefundFileService = ocRefundFileService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public void setOcRefundService(OcRefundService ocRefundService) {
        this.ocRefundService = ocRefundService;
    }

    public OcRecflowPprocessService getOcRecflowPprocessService() {
        return this.ocRecflowPprocessService;
    }

    public void setOcRecflowPprocessService(OcRecflowPprocessService ocRecflowPprocessService) {
        this.ocRecflowPprocessService = ocRecflowPprocessService;
    }

    public OcRefundFlowEngineService getOcRefundFlowEngineService() {
        return this.ocRefundFlowEngineService;
    }

    public void setOcRefundFlowEngineService(OcRefundFlowEngineService ocRefundFlowEngineService) {
        this.ocRefundFlowEngineService = ocRefundFlowEngineService;
    }

    @Override
    public void sendRefundEngineStart(OcRefundDomain ocRefundDomain) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundEngineStart(ocRefundDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        } else {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendRefundEngineStart.pprocessList", (Object)(ocRefundDomain.getRefundCode() + "=" + ocRefundDomain.getTenantCode()));
        }
    }

    @Override
    public void sendRefundGoodsAndNext(OcRefundDomain ocRefundDomain, Map<String, Object> map) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundGoodsAndNext(ocRefundDomain, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public void sendRefundNext(String refundCode, String tenantCode, Map<String, Object> map) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundNext(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public String sendContracPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        this.sendRefundNext(refundCode, tenantCode, null);
        return "success";
    }

    @Override
    public String sendContracSubPay(String businessOrder, String businessOrderno, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSubCode", businessOrderno);
        this.sendRefundNext(businessOrder, tenantCode, map);
        return "success";
    }

    @Override
    public String sendContracBatchPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        if (null == dataState || dataState != 3) {
            return "success";
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBatchNext(refundCode, tenantCode, null);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
        return "success";
    }

    @Override
    public String sendSaveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        Boolean cmClear = this.getCmClear(refundCode, tenantCode);
        if (!cmClear.booleanValue()) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payDataState", dataState);
        map.put("ptradeSeqno", ptradeSeqno);
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBatchNext(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
        return "success";
    }

    private Boolean getCmClear(String refundCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessOrderno", refundCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String object = this.internalInvoke("cm.channelClear.querychannelClearPage", paramMap);
        if (object == null) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplgetCmClear.is null");
            return true;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(object, SupQueryResult.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplgetCmClear.supQueryResult.is null" + refundCode, (Object)object);
            return false;
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), CmChannelClear.class);
        for (CmChannelClear cmChannelClear : list) {
            if (2 != cmChannelClear.getDataState()) continue;
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplgetCmClear.cmChannelClear =2", (Object)refundCode);
            return true;
        }
        this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplgetCmClear.supQueryResult.is false" + refundCode, (Object)object);
        return false;
    }

    @Override
    public void sendRefundBack(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBack(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public void sendFlowNode(OcRecflowPprocessDomain ocRecflowPprocessDomain) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveFlowNode(ocRecflowPprocessDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PprocessService getPprocessService() {
        Object object = lock;
        synchronized (object) {
            if (null == pprocessService) {
                pprocessService = new PprocessService((OcRefundEngineService)SpringApplicationContextUtil.getBean((String)"ocRefundEngineService"));
                for (int i = 0; i < 20; ++i) {
                    pprocessService.addPollPool(new PprocessPollThread(pprocessService));
                }
            }
            return pprocessService;
        }
    }

    @Override
    public void queryPprocessLoadDb() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRecflowPprocess> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getPprocessService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPprocessService().getPage());
                result = this.ocRecflowPprocessService.queryRecflowPprocessPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPprocessService().addPutPool(new PprocessModelPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), result.getRows()));
                    if (result.getRows().size() == this.getPprocessService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPprocessService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundEngineServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public String sendBatchSaveRefund(List<OcRefundDomain> ocRefundDomainList) throws ApiException {
        String code = this.ocRefundService.saveBatchRefund(ocRefundDomainList);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        return code;
    }

    @Override
    public Map<String, String> sendSaveRefundOk(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.ocRefundService.saveRefundre(ocRefundDomain);
        if (null == ocRefund) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsendSaveRefundOk", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return null;
        }
        ArrayList<OcRefundDomain> ocRefundDomainList = new ArrayList<OcRefundDomain>();
        ocRefundDomainList.add(ocRefundDomain);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        return this.getRefund(ocRefund, oc_errDataState, oc_newDataState);
    }

    public Map<String, String> getRefund(OcRefund ocRefund, Integer errDataState, Integer newDataState) {
        HashMap<String, String> remap = new HashMap<String, String>();
        remap.put("state", "success");
        if (null == ocRefund) {
            remap.put("state", "ERROR");
            remap.put("errCode", "oc.getRefund.null");
            remap.put("errMsg", "\u6570\u636e\u5f02\u5e38");
            return remap;
        }
        remap.put("code", ocRefund.getRefundCode());
        String tenantCode = ocRefund.getTenantCode();
        String refundCode = ocRefund.getRefundCode();
        long currentTime = System.currentTimeMillis();
        long expireMillis = 30000L;
        Integer dataState = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", tenantCode);
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (System.currentTimeMillis() - currentTime > 30000L) {
                dataState = this.getCachStrByThread(refundCode, tenantCode, errDataState, newDataState);
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    return remap;
                }
                if (!this.checkErrorDataState(dataState, errDataState, newDataState)) break;
                remap.put("state", "ERROR");
                return remap;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.getRefund.sleep.ex", (Throwable)e);
            }
            try {
                dataState = this.getCachStrByThread(refundCode, tenantCode, errDataState, newDataState);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.getRefund.getCachStrByThread.ex", (Throwable)e);
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                return remap;
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            remap.put("state", "ERROR");
            return remap;
        }
        if (this.checkOkDataState(dataState, errDataState, newDataState)) {
            return remap;
        }
        return remap;
    }

    private Integer getCachStrByThread(String contractBillcode, String tenantCode, Integer errDataState, Integer newDataState) {
        String correlationId = "OCRETURNDATASTATE-" + contractBillcode + tenantCode;
        String okobj = DisUtil.getRemot((String)(correlationId + "-" + newDataState));
        if (StringUtils.isNotBlank((String)okobj)) {
            return newDataState;
        }
        String errorobj = DisUtil.getRemot((String)(correlationId + "-" + errDataState));
        if (StringUtils.isNotBlank((String)errorobj)) {
            return errDataState;
        }
        String obj = DisUtil.getRemot((String)correlationId);
        if (StringUtils.isBlank((String)obj)) {
            return null;
        }
        Integer returnDate = Integer.valueOf(obj);
        return returnDate;
    }

    public boolean checkErrorDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        return dataState != null && dataState <= errDataState;
    }

    public boolean checkOkDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        return dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1);
    }

    @Override
    public String sendSaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveRefund start", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundRe(ocRefundDomain);
        if (null == ocSendcontractData) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsendSaveRefund=====Str", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    public Map<String, String> sendsaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.ocRefundService.saveRefundre(ocRefundDomain);
        if (null == ocRefund) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplocRefundDomainStr", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return null;
        }
        ArrayList<OcRefundDomain> ocRefundDomainList = new ArrayList<OcRefundDomain>();
        ocRefundDomainList.add(ocRefundDomain);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "success");
        map.put("code", ocRefund.getRefundCode());
        return map;
    }

    @Override
    public String sendSaveRefundCli(OcRefundDomain ocRefundDomain) throws ApiException {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundRe(ocRefundDomain);
        if (null == ocSendcontractData) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsendSaveRefund=====Str", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendSaveSgGoodsRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        Map<String, String> map = this.sendSaveRefundOk(ocRefundDomain);
        if (MapUtil.isEmpty(map)) {
            this.logger.error("sendSaveSgGoodsRefund", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return "error";
        }
        return "success";
    }

    @Override
    public String sendUpdateRefundStateByNcode(String refundNcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcRefund ocRefund = this.ocRefundService.getRefundByNcode(refundNcode, channelCode, tenantCode);
        if (null == ocRefund) {
            return null;
        }
        this.sendRefundNext(ocRefund.getRefundCode(), tenantCode, map);
        return "";
    }

    @Override
    public String sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendsaveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundPay(refundCode, tenantCode, ptradeSeqno, dataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.updateRefundPass(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPay(OcRefund ocRefund) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundPay(ocRefund);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPayByCrp(OcRefundDomain ocRefundDomain) {
        return this.ocRefundService.updateSendRefundPayByCrp(ocRefundDomain);
    }

    @Override
    public String sendupdateRefundPayByVd(OcRefundDomain ocRefundDomain) {
        return this.ocRefundService.updateSendRefundPayByVd(ocRefundDomain);
    }

    @Override
    public String sendupdateRefundRefuse(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRes(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateByCode(String refundCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundStateByCode(refundCode, dataState, oldDataState, tenantCode);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateById(Integer refundId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundState(refundId, dataState, oldDataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendSaveOrderRefund(OcContractDomain ocContractDomain) throws ApiException {
        OcRefundDomain ocRefundDomain = this.getOcRefundDomain(ocContractDomain, "B03", false);
        if (ocRefundDomain == null) {
            return "error";
        }
        this.sendsaveRefund(ocRefundDomain);
        return "success";
    }

    @Override
    public String sendSaveOrderRefundDG(OcContractDomain ocContractDomain) throws ApiException {
        OcRefundDomain ocRefundDomain = this.getOcRefundDomain(ocContractDomain, "B04", false);
        if (ocRefundDomain == null) {
            return "error";
        }
        this.sendsaveRefund(ocRefundDomain);
        return "success";
    }

    @Override
    public String orderToRefund(OcContractDomain ocContractDomain) {
        this.logger.info("oc.CONTRACT.OcRefundEngineServiceImpl.orderToRefund.getOcRefundDomain.start", (Object)JSONObject.toJSONString((Object)ocContractDomain));
        OcRefundDomain ocRefundDomain = this.getOcRefundDomain(ocContractDomain, "BO4", false);
        this.logger.info("oc.CONTRACT.OcRefundEngineServiceImpl.orderToRefund.getOcRefundDomain.\u5c01\u88c5\u6570\u636e:", (Object)JSONObject.toJSONString((Object)ocRefundDomain));
        Map<String, String> map = this.sendSaveRefundOk(ocRefundDomain);
        this.logger.info("oc.CONTRACT.OcRefundEngineServiceImpl.orderToRefund.sendSaveRefundOk.\u6267\u884c\u7ed3\u679c", (Object)JSONObject.toJSONString(map));
        return map.get("state");
    }

    @Override
    public String sendSaveOrderRefundByTop(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return "param";
        }
        QueryResult<OcContractSettl> qlist = this.ocContractService.queryContractSettlPage(this.getQueryMapParam("contractBillcode,tenantCode,contractSettlBlance", new Object[]{contractBillcode, tenantCode, "RMY"}));
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return "success";
        }
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        OcRefundDomain ocRefundDomain = this.getOcRefundDomain(ocContractReDomain, "BR0", true);
        if (ocRefundDomain == null) {
            return "error";
        }
        if (((OcContractSettl)qlist.getList().get(0)).getContractSettlPmoney().compareTo(ocRefundDomain.getRefundMoney()) != 0) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveOrderRefundByTop.num", (Object)(((OcContractSettl)qlist.getList().get(0)).getContractSettlPmoney() + "=" + ocRefundDomain.getRefundMoney()));
            return "error";
        }
        this.sendSaveRefund(ocRefundDomain);
        return "success";
    }

    @Override
    public void updateAuditCall(Map<String, Object> map) throws ApiException {
        if (map.get("auditStatus") == null) {
            throw new ApiException("oc.CONTRACT.OcRefundEngineServiceImpl.updateAuditCall.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(map.get("ocRefundReDomain")), OcRefundReDomain.class);
        if ("YES".equals(auditStatus)) {
            this.ocRefundService.updateRefundState(ocRefundReDomain.getRefundId(), 2, 0);
            String sendgoods = this.internalInvoke("sg.sendgoods.getSendgoods", this.getQueryParamMap("sendgoodsId", new Object[]{ocRefundReDomain.getPackageMode()}));
            if (StringUtils.isBlank((String)sendgoods)) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsendgoods" + JsonUtil.buildNonDefaultBinder().toJson((Object)sendgoods));
            }
            SgSendgoods sg = (SgSendgoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendgoods, SgSendgoods.class);
            HashMap<String, Integer> sgMap = new HashMap<String, Integer>();
            sgMap.put("sendgoodsId", sg.getSendgoodsId());
            sgMap.put("dataState", 5);
            sgMap.put("oldDataState", sg.getDataState());
            this.internalInvoke("sg.sendgoods.updateSendgoodsState", sgMap);
        } else if ("NO".equals(auditStatus)) {
            HashMap<String, String> sgmap = new HashMap<String, String>();
            HashMap<String, String> pmmap = new HashMap<String, String>();
            HashMap<String, SgSendgoodsGoodsReDomain> sggoodsmap = new HashMap<String, SgSendgoodsGoodsReDomain>();
            HashMap<String, String> sgsendgoodmap = new HashMap<String, String>();
            String sendgoods = this.internalInvoke("sg.sendgoods.getSendgoods", this.getQueryParamMap("sendgoodsId", new Object[]{ocRefundReDomain.getPackageMode()}));
            if (StringUtils.isBlank((String)sendgoods)) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsendgoods" + JsonUtil.buildNonDefaultBinder().toJson((Object)sendgoods));
            }
            SgSendgoods sg = (SgSendgoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendgoods, SgSendgoods.class);
            sgmap.put("sendgoodsCode", sg.getSendgoodsCode());
            sgmap.put("tenantCode", sg.getTenantCode());
            pmmap.put("map", JsonUtil.buildNormalBinder().toJson(sgmap));
            String object = this.internalInvoke("sg.sendgoods.querySendgoodsGoodsPage", pmmap);
            if (object == null) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsgmap" + JsonUtil.buildNonDefaultBinder().toJson(sgmap) + object);
            }
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(object, SupQueryResult.class);
            List sgSendgoodsGoodsReDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), SgSendgoodsGoodsReDomain.class);
            if (ListUtil.isEmpty((Collection)sgSendgoodsGoodsReDomains)) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsgSendgoodsGoodsReDomains" + JsonUtil.buildNonDefaultBinder().toJson((Object)sgSendgoodsGoodsReDomains));
            }
            for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsGoodsReDomains) {
                sggoodsmap.put(sgSendgoodsGoodsReDomain.getSendgoodsGoodsCode(), sgSendgoodsGoodsReDomain);
            }
            for (OcRefundGoods ocRefundGoods : ocRefundReDomain.getOcRefundGoodsList()) {
                SgSendgoodsGoodsDomain sgSendgoodsGoods = (SgSendgoodsGoodsDomain)sggoodsmap.get(ocRefundGoods.getContractGoodsCode());
                sgSendgoodsGoods.setContractGoodsMoney(sgSendgoodsGoods.getContractGoodsMoney().add(ocRefundGoods.getRefundGoodsNum().multiply(ocRefundGoods.getRefundGoodsAmt())));
                sgSendgoodsGoods.setContractGoodsRefnum(sgSendgoodsGoods.getContractGoodsRefnum().subtract(ocRefundGoods.getRefundGoodsNum()));
                sgsendgoodmap.put("sgSendgoodsGoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)sgSendgoodsGoods));
                this.internalInvoke("sg.sendgoods.updateSendgoodsGoods", sgsendgoodmap);
            }
            this.ocRefundService.updateRefundState(ocRefundReDomain.getRefundId(), -1, 0);
        }
    }

    private List<GoodsSendNumBean> makeGoodsSendNum(List<OcRefundGoods> ocRefundGoodsList, int dir) {
        if (ListUtil.isEmpty(ocRefundGoodsList)) {
            return null;
        }
        ArrayList<GoodsSendNumBean> sendNumList = new ArrayList<GoodsSendNumBean>();
        BigDecimal Refundnum = new BigDecimal("0");
        for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
            GoodsSendNumBean goodsSendNumBean = new GoodsSendNumBean();
            goodsSendNumBean.setContractBillcode(ocRefundGoods.getContractBillcode());
            goodsSendNumBean.setContractGoodsCode(ocRefundGoods.getContractGoodsCode());
            goodsSendNumBean.setTenantCode(ocRefundGoods.getTenantCode());
            if (null == ocRefundGoods.getRefundGoodsNum()) {
                ocRefundGoods.setRefundGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocRefundGoods.getRefundGoodsWeight()) {
                ocRefundGoods.setRefundGoodsWeight(BigDecimal.ZERO);
            }
            Refundnum = Refundnum.add(ocRefundGoods.getRefundGoodsNum());
            goodsSendNumBean.setContractGoodsSendnum(new BigDecimal(dir).multiply(ocRefundGoods.getRefundGoodsNum()));
            goodsSendNumBean.setContractGoodsSendweight(new BigDecimal(dir).multiply(ocRefundGoods.getRefundGoodsWeight()));
            sendNumList.add(goodsSendNumBean);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", ocRefundGoodsList.get(0).getContractBillcode());
        paramMap.put("tenantCode", ocRefundGoodsList.get(0).getTenantCode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        String s = this.internalInvoke("sg.sendgoods.querySendgoodsGoodsPage", invokeMap);
        if (StringUtils.isBlank((String)s)) {
            this.logger.error(SYS_CODE, (Object)("paramMap" + ((Object)invokeMap).toString() + s));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, SupQueryResult.class);
        List sgSendgoodsGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), SgSendgoodsGoods.class);
        BigDecimal sgsendgoodsnum = new BigDecimal("0");
        for (SgSendgoodsGoods sgSendgoodsGoods : sgSendgoodsGoodsList) {
            sgsendgoodsnum = sgsendgoodsnum.add(sgSendgoodsGoods.getGoodsNum());
        }
        if (sgsendgoodsnum.compareTo(Refundnum) == 0) {
            String sendgoods = this.internalInvoke("sg.sendgoods.querySendgoodsPage", invokeMap);
            if (StringUtils.isBlank((String)sendgoods)) {
                this.logger.error(SYS_CODE, (Object)("paramMap" + ((Object)invokeMap).toString() + sendgoods));
                return null;
            }
            SgSendgoods sg = (SgSendgoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendgoods, SgSendgoods.class);
            HashMap<String, Integer> sgMap = new HashMap<String, Integer>();
            sgMap.put("sendgoodsId", sg.getSendgoodsId());
            sgMap.put("dataState", 11);
            sgMap.put("oldDataState", sg.getDataState());
            this.internalInvoke("sg.sendgoods.updateSendgoodsState", sgMap);
        }
        return sendNumList;
    }

    private OcRefundDomain getOcRefundDomain(OcContractDomain ocContractDomain, String refundType, boolean top) {
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.getOcRefundDomain.ex" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain), (Throwable)e);
            return null;
        }
        if (null == ocContractDomain.getContractOremoney()) {
            ocContractDomain.setContractOremoney(BigDecimal.ZERO);
        }
        boolean oreflag = false;
        if ("BR0".equals(refundType)) {
            oreflag = true;
        }
        ocRefundDomain.setRefundMoney(BigDecimal.ZERO);
        ocRefundDomain.setRefundType(refundType);
        ocRefundDomain.setRefundUsertype("3");
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                if (null == ocContractGoodsDomain.getGoodsCweight()) {
                    ocContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                if (null == ocContractGoodsDomain.getGoodsTopweight()) {
                    ocContractGoodsDomain.setGoodsTopweight(BigDecimal.ZERO);
                }
                if (top && ocContractGoodsDomain.getGoodsCweight().compareTo(ocContractGoodsDomain.getGoodsTopweight()) == 0) continue;
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.getOcRefundDomain.ex1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain), (Throwable)e);
                }
                ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsCamount());
                ocRefundGoodsDomain.setRefundGoodsWeight(ocContractGoodsDomain.getGoodsWeight());
                if (null == ocContractGoodsDomain.getContractGoodsOremoney() || "".equals(ocContractGoodsDomain.getContractGoodsOremoney())) {
                    ocContractGoodsDomain.setContractGoodsOremoney(BigDecimal.ZERO);
                }
                ocRefundGoodsDomain.setRefundGoodsAmt(ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsOremoney()));
                if (oreflag) {
                    ocRefundGoodsDomain.setRefundGoodsAmt(ocContractGoodsDomain.getContractGoodsOremoney());
                }
                ocRefundDomain.setRefundMoney(ocRefundDomain.getRefundMoney().add(ocRefundGoodsDomain.getRefundGoodsAmt()));
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        return ocRefundDomain;
    }

    @Override
    public String sendBatchRefundPay(String tenantCode, String dataState) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)dataState)) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendBatchRefundPay", (Object)("tenantCode=" + tenantCode + "dataState=" + dataState));
            return "error";
        }
        HashMap<String, Object> queryRefundMap = new HashMap<String, Object>();
        queryRefundMap.put("tenantCode", tenantCode);
        queryRefundMap.put("dataState", dataState);
        List queryResult = this.ocRefundService.queryRefundPage(queryRefundMap).getList();
        if (ListUtil.isNotEmpty((Collection)queryResult)) {
            for (OcRefund domain : queryResult) {
                this.sendRefundNext(domain.getRefundCode(), domain.getTenantCode(), null);
            }
        }
        return "success";
    }

    @Override
    public String sendSaveSplitRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveSplitRefund.ocContractDomain", (Object)"ocContractDomain is null");
            return "error";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveSplitRefund.ocContractDomain", (Object)"refundCode is null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        map.put("refundCode", ocRefundDomain.getRefundCode());
        OcRefundReDomain ocRefundReDomain = this.ocRefundService.getRefundByCode(map);
        if (null == ocRefundReDomain) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveSplitRefund.ocRefundReDomain", (Object)((Object)map).toString());
            return "error";
        }
        map = new HashMap();
        map.put("sendgoodsRuleType", "Refund");
        map.put("detailRulelFlag", true);
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        map.put("dataState", ContractConstants.CONTRACT_RULE_DATE);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult supQueryResult = this.sendReSupObject("sg.sgSendgoodsRule.querySendgoodsRuleReDomainPage", invokeMap, SgSendgoodsRuleReDomain.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImplsendSaveSplitRefund.paramMap", (Object)((Object)invokeMap).toString());
            return "error";
        }
        List ruleReDomainList = supQueryResult.getList();
        if (ListUtil.isEmpty((Collection)ruleReDomainList)) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveSplitRefund.ruleReDomainList", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
            return "error";
        }
        SgSendgoodsRuleReDomain sgSendgoodsRule = this.structureRule(ruleReDomainList, ocRefundReDomain);
        if (null == sgSendgoodsRule) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveSplitRefund.sgSendgoodsRule", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
            return "error";
        }
        ApAdaptationReDomainBean apAdaptationReDomainBean = this.queryAdaptationByCode(sgSendgoodsRule.getAdaptationCode(), sgSendgoodsRule.getTenantCode());
        if (null == apAdaptationReDomainBean || StringUtils.isBlank((String)apAdaptationReDomainBean.getAdaptationClob())) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveSplitRefund.apAdaptationReDomainBean", (Object)(sgSendgoodsRule.getAdaptationCode() + "," + sgSendgoodsRule.getTenantCode()));
            return "error";
        }
        HashMap<String, Object> ocMap = new HashMap<String, Object>();
        ocMap.put("ocRefundReDomain", ocRefundReDomain);
        ocMap.put("sgSendgoodsRule", sgSendgoodsRule);
        List<OcRefundDomain> ocRefundDomainList = this.createOcRefundByRule(ocMap, apAdaptationReDomainBean.getAdaptationClob());
        if (ListUtil.isNotEmpty(ocRefundDomainList)) {
            return this.sendsaveRefund(ocRefundDomainList);
        }
        return "success";
    }

    public String sendsaveRefund(List<OcRefundDomain> ocRefundDomainList) throws ApiException {
        List<OcRefund> ocRefundList = this.ocRefundService.saveBatchRefundRe(ocRefundDomainList);
        if (ListUtil.isEmpty(ocRefundList)) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendsaveRefund");
            return "error";
        }
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        return "success";
    }

    private SgSendgoodsRuleReDomain structureRule(List<SgSendgoodsRuleReDomain> sendgoodsRuleList, OcRefundReDomain ocRefundReDomain) {
        if (ListUtil.isEmpty(sendgoodsRuleList) || null == ocRefundReDomain) {
            return null;
        }
        SgSendgoodsRuleReDomain sendgoodsRule = null;
        for (SgSendgoodsRuleReDomain sgSendgoodsRuleReDomain : sendgoodsRuleList) {
            if (null == sendgoodsRule) {
                sendgoodsRule = sgSendgoodsRuleReDomain;
            }
            if (null != sendgoodsRule && sendgoodsRule.getSendgoodsRuleOr() > sgSendgoodsRuleReDomain.getSendgoodsRuleOr()) continue;
            sendgoodsRule = sgSendgoodsRuleReDomain;
            List<SgSendgoodsRuleconfDomain> sgSendgoodsRuleconfDomainList = sgSendgoodsRuleReDomain.getSgSendgoodsRuleconfDomainList();
            if (ListUtil.isEmpty(sgSendgoodsRuleconfDomainList)) {
                sendgoodsRule = sgSendgoodsRuleReDomain;
                continue;
            }
            Map<String, List<String>> map = this.makeScopeconflist(sgSendgoodsRuleconfDomainList);
            if (null == map || map.isEmpty()) continue;
            boolean flag = true;
            String term = "";
            String key = "";
            for (String keys : map.keySet()) {
                String[] keyStr = keys.split("\\|");
                if (null == keyStr || keyStr.length == 0) continue;
                key = keyStr[0];
                if (keyStr.length > 1) {
                    term = keyStr[1];
                }
                Object objValue = BeanUtils.newForceGetProperty((Object)ocRefundReDomain, (String)key);
                List<String> valueList = map.get(keys);
                if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                    String[] otrs;
                    for (String o : otrs = objValue.toString().split("\\,")) {
                        if (this.cond(valueList, term, o)) break;
                    }
                    continue;
                }
                if (this.cond(valueList, term, objValue)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            sendgoodsRule = sgSendgoodsRuleReDomain;
        }
        return sendgoodsRule;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private Map<String, List<String>> makeScopeconflist(List<SgSendgoodsRuleconfDomain> sgSendgoodsRuleconfDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsRuleconfDomainList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (SgSendgoodsRuleconfDomain sgSendgoodsRuleconfDomain : sgSendgoodsRuleconfDomainList) {
            ArrayList list = (ArrayList)map.get(sgSendgoodsRuleconfDomain.getSendgoodsRuleconfPro() + "|=");
            if (null != list) continue;
            list = new ArrayList();
            map.put(sgSendgoodsRuleconfDomain.getSendgoodsRuleconfPro() + "|=", list);
        }
        return map;
    }

    private ApAdaptationReDomainBean queryAdaptationByCode(String adaptationCode, String tenantCode) {
        if (StringUtils.isBlank((String)adaptationCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.queryAdaptationByCode.param", (Object)(adaptationCode + "-" + tenantCode));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryMapParam("adaptationCode,tenantCode", new Object[]{adaptationCode, tenantCode})));
        String result = "";
        try {
            result = (String)this.getInternalRouter().inInvoke("ap.adaptation.queryAdaptationByCode", map);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.queryAdaptationByCode.inInvoke", (Object)result);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.queryAdaptationByCode.inInvoke.e", (Object)(adaptationCode + tenantCode));
            return null;
        }
        return (ApAdaptationReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(result, ApAdaptationReDomainBean.class);
    }

    private List<OcRefundDomain> createOcRefundByRule(Map<String, Object> map, String adaptationClob) {
        List<OcRefundDomain> ocRefundDomainList;
        if (StringUtils.isBlank((String)adaptationClob)) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.createOcRefundByRule.null");
            return null;
        }
        OcRefundGroovy ocRefundGroovy = (OcRefundGroovy)GroovyUtil.executeCalculate((String)adaptationClob);
        if (null == ocRefundGroovy) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.createOcRefundByRule.ocRefundGroovy");
            return null;
        }
        try {
            ocRefundDomainList = ocRefundGroovy.makeOcRefund(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.createOcRefundByRule.ocRefundDomainList", (Throwable)e);
            return null;
        }
        return ocRefundDomainList;
    }

    @Override
    public void sendRefundGoodsCall(List<OcRefundGoodsCallBean> ocRefundGoodsCallBeanList) {
        if (ListUtil.isEmpty(ocRefundGoodsCallBeanList)) {
            return;
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.updateRefundGoodsCall(ocRefundGoodsCallBeanList);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public void sendUpdateRefundGoodsStateByCode(List<OcRefundGoodsAuBean> ocRefundGoodsAuBeanList) throws ApiException {
        if (ListUtil.isEmpty(ocRefundGoodsAuBeanList)) {
            return;
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.updateRefundGoodsStateByCode(ocRefundGoodsAuBeanList);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public String saveOcRefundByContractNbillcode(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveOcRefundByContractNbillcode is null");
            return "error";
        }
        OcContractReDomain contractByCode = null;
        if (StringUtils.isBlank((String)ocRefundDomain.getContractNbillcode())) {
            HashMap<String, Object> ocmap = new HashMap<String, Object>();
            ocmap.put("tenantCode", ocRefundDomain.getTenantCode());
            ocmap.put("contractNbillcode", ocRefundDomain.getContractBillcode());
            ocmap.put("dataStateStr", "2,3,4");
            QueryResult<OcContractReDomain> ocContractQueryResult = this.ocContractService.queryContractPageReDomain(ocmap);
            if (null == ocContractQueryResult || ListUtil.isEmpty((Collection)ocContractQueryResult.getList())) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveOcRefundByContractNbillcode contractByCode is null1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                return "error";
            }
            contractByCode = (OcContractReDomain)ocContractQueryResult.getList().get(0);
            ocRefundDomain.setContractNbillcode(contractByCode.getContractBillcode());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        map.put("contractBillcode", ocRefundDomain.getContractNbillcode());
        contractByCode = this.ocContractService.getContractByCode(map);
        if (null == contractByCode) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveOcRefundByContractNbillcode contractByCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return "error";
        }
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        if (ListUtil.isEmpty(ocRefundGoodsDomainList)) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveOcRefundByContractNbillcode ocRefundGoodsDomainList is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return "error";
        }
        OcRefundDomain newOcRefundDomain = this.makeNewOcRefundDomain(ocRefundDomain, contractByCode);
        if (null == newOcRefundDomain) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveOcRefundByContractNbillcode ocRefundDomain is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            return "error";
        }
        this.ocRefundService.saveRefund(newOcRefundDomain);
        ArrayList<OcRefundDomain> ocRefundDomainList = new ArrayList<OcRefundDomain>();
        ocRefundDomainList.add(newOcRefundDomain);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        return "success";
    }

    private OcRefundDomain makeNewOcRefundDomain(OcRefundDomain ocRefundDomain, OcContractReDomain contractByCode) {
        OcRefundDomain newOcRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)newOcRefundDomain, (Object)contractByCode);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.makeNewOcRefundDomain is error", (Object)e.getMessage());
            return null;
        }
        HashMap<String, OcContractGoodsDomain> contractGoodsDomainHashMap = new HashMap<String, OcContractGoodsDomain>();
        List<OcContractGoodsDomain> goodsList = contractByCode.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            contractGoodsDomainHashMap.put(ocContractGoodsDomain.getSkuNo() + "-" + ocContractGoodsDomain.getMemberCcode(), ocContractGoodsDomain);
        }
        BigDecimal sumRefundMoney = new BigDecimal(BigInteger.ZERO);
        BigDecimal sunRefundNum = new BigDecimal(BigInteger.ZERO);
        BigDecimal refundGoodsMoney = new BigDecimal(BigInteger.ZERO);
        BigDecimal refundGoodsNum = new BigDecimal(BigInteger.ZERO);
        ArrayList<OcRefundGoodsDomain> newOcRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            OcRefundGoodsDomain newOcRefundGoodsDomain = new OcRefundGoodsDomain();
            refundGoodsNum = BigDecimal.ZERO;
            refundGoodsMoney = BigDecimal.ZERO;
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)contractGoodsDomainHashMap.get(ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundGoodsDomain.getMemberCcode());
            if (null == ocContractGoodsDomain) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.makeNewOcRefundDomain ocContractGoodsDomain is null  ", (Object)(ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundGoodsDomain.getMemberCcode()));
                return null;
            }
            try {
                BeanUtils.copyAllPropertys((Object)newOcRefundGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.makeNewOcRefundDomain ocContractGoodsDomain is error  ", (Object)(ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundGoodsDomain.getMemberCcode()));
                return null;
            }
            refundGoodsNum = ocRefundGoodsDomain.getRefundGoodsNum();
            if (null == refundGoodsNum) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.makeNewOcRefundDomain refundGoodsNum is null  ", (Object)(ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundGoodsDomain.getMemberCcode()));
                return null;
            }
            if (null == ocContractGoodsDomain.getContractGoodsPrice()) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.makeNewOcRefundDomain ContractGoodsPrice is null  ", (Object)(ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundGoodsDomain.getMemberCcode()));
                return null;
            }
            refundGoodsMoney = refundGoodsNum.multiply(ocContractGoodsDomain.getContractGoodsPrice());
            if (refundGoodsMoney.compareTo(ocContractGoodsDomain.getContractGoodsMoney()) > 0) {
                refundGoodsMoney = ocContractGoodsDomain.getContractGoodsMoney();
            }
            newOcRefundGoodsDomain.setRefundGoodsNum(refundGoodsNum);
            newOcRefundGoodsDomain.setRefundGoodsPrice(ocContractGoodsDomain.getContractGoodsPrice());
            newOcRefundGoodsDomain.setRefundGoodsAmt(refundGoodsMoney);
            newOcRefundGoodsDomainList.add(newOcRefundGoodsDomain);
            sumRefundMoney = sumRefundMoney.add(refundGoodsMoney);
            sunRefundNum = sunRefundNum.add(refundGoodsNum);
        }
        newOcRefundDomain.setOcRefundGoodsDomainList(newOcRefundGoodsDomainList);
        newOcRefundDomain.setRefundMoney(sumRefundMoney);
        newOcRefundDomain.setRefundEx(ocRefundDomain.getRefundEx());
        newOcRefundDomain.setPackageName(ocRefundDomain.getPackageName());
        newOcRefundDomain.setPackageBillno(ocRefundDomain.getPackageBillno());
        newOcRefundDomain.setRefundType(ocRefundDomain.getRefundType());
        newOcRefundDomain.setRefundMeo(ocRefundDomain.getRefundMeo());
        newOcRefundDomain.setRefundNcode(ocRefundDomain.getRefundCode());
        newOcRefundDomain.setContractState(contractByCode.getDataState());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", ocRefundDomain.getRefundCode());
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        QueryResult<OcRefundFile> qlist = this.ocRefundFileService.queryRefundFilePage(map);
        if (ListUtil.isNotEmpty((Collection)qlist.getList())) {
            newOcRefundDomain.setOcRefundFileDomainList(this.makeFileDomain(qlist.getList(), ocRefundDomain));
        }
        return newOcRefundDomain;
    }

    private List<OcRefundFileDomain> makeFileDomain(List<OcRefundFile> ocRefundFileList, OcRefundDomain ocRefundDomain) {
        if (ListUtil.isEmpty(ocRefundFileList)) {
            return null;
        }
        ArrayList<OcRefundFileDomain> ocRefundFileDomainList = new ArrayList<OcRefundFileDomain>();
        for (OcRefundFile ocRefundFile : ocRefundFileList) {
            OcRefundFileDomain ocRefundFileDomain = new OcRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundFileDomain, (Object)ocRefundFile);
                ocRefundFileDomain.setRefundCode(null);
                ocRefundFileDomain.setRefundFileCode(null);
                ocRefundFileDomain.setRefundFileId(null);
                ocRefundFileDomainList.add(ocRefundFileDomain);
            }
            catch (Exception exception) {}
        }
        return ocRefundFileDomainList;
    }

    static {
        lock = new Object();
        oc_errDataState = -1;
        oc_newDataState = 0;
    }
}

