/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.util;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service(value="redisUtils")
public class RedisUtils {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public Object get(String key) {
        try {
            return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean del(String key) {
        try {
            return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key));
        }
        catch (Exception e) {
            return false;
        }
    }

    public Long increment(String key, Long delta) {
        try {
            return this.redisTemplate.opsForValue().increment((Object)key, delta.longValue());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void saveByPipeLine(Map<String, Map<String, String>> dataMap) {
        try {
            RedisSerializer keySerializer = this.redisTemplate.getKeySerializer();
            RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
            this.redisTemplate.executePipelined(redisConnection -> {
                dataMap.forEach((key, value) -> redisConnection.set(Objects.requireNonNull(keySerializer.serialize(key)), Objects.requireNonNull(valueSerializer.serialize(value)), Expiration.seconds((long)21600L), RedisStringCommands.SetOption.UPSERT));
                return null;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveByPipeLineMap(Map<String, String> dataMap, String key) {
        try {
            RedisSerializer keySerializer = this.redisTemplate.getKeySerializer();
            RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
            this.redisTemplate.executePipelined(redisConnection -> {
                redisConnection.set(Objects.requireNonNull(keySerializer.serialize((Object)key)), Objects.requireNonNull(valueSerializer.serialize((Object)dataMap)), Expiration.seconds((long)21600L), RedisStringCommands.SetOption.UPSERT);
                return null;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Object> getByPipeLine(List<String> keys) {
        try {
            return this.redisTemplate.executePipelined(redisConnection -> {
                for (String key : keys) {
                    redisConnection.get(key.getBytes(StandardCharsets.UTF_8));
                }
                return null;
            });
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long del(Set<String> key) {
        try {
            if (CollectionUtils.isNotEmpty(key)) {
                return this.redisTemplate.delete(key);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean setNX(String lockKey, String value, long expiryTime) {
        if (this.redisTemplate == null) {
            return false;
        }
        try {
            Boolean flag = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)value, expiryTime, TimeUnit.SECONDS);
            assert (flag != null);
            return flag != false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

