/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contractorder.service.impl;

import com.yqbsoft.laser.service.contractorder.dao.CoCorderGoodsMapper;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderGoodsDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderGoodsReDomain;
import com.yqbsoft.laser.service.contractorder.model.CoCorderGoods;
import com.yqbsoft.laser.service.contractorder.service.CoCorderGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoCorderGoodsServiceImpl
extends BaseServiceImpl
implements CoCorderGoodsService {
    private static final String SYS_CODE = "co.CONTRACTORDER.CoCorderGoodsServiceImpl";
    private CoCorderGoodsMapper coCorderGoodsMapper;

    public void setCoCorderGoodsMapper(CoCorderGoodsMapper coCorderGoodsMapper) {
        this.coCorderGoodsMapper = coCorderGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.coCorderGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCorderGoods(CoCorderGoodsDomain coCorderGoodsDomain) {
        if (null == coCorderGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)coCorderGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCorderGoodsDefault(CoCorderGoods coCorderGoods) {
        if (null == coCorderGoods) {
            return;
        }
        if (null == coCorderGoods.getDataState()) {
            coCorderGoods.setDataState(0);
        }
        if (null == coCorderGoods.getGmtCreate()) {
            coCorderGoods.setGmtCreate(this.getSysDate());
        }
        coCorderGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)coCorderGoods.getCorderGoodsCode())) {
            coCorderGoods.setCorderGoodsCode(this.createUUIDString());
        }
    }

    private int getCorderGoodsMaxCode() {
        int code = 0;
        try {
            return this.coCorderGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.getCorderGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCorderGoodsUpdataDefault(CoCorderGoods coCorderGoods) {
        if (null == coCorderGoods) {
            return;
        }
        coCorderGoods.setGmtModified(this.getSysDate());
    }

    private void saveCorderGoodsModel(CoCorderGoods coCorderGoods) throws ApiException {
        if (null == coCorderGoods) {
            return;
        }
        try {
            this.coCorderGoodsMapper.insert(coCorderGoods);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.saveCorderGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveCorderGoodsBatchModel(List<CoCorderGoods> coCorderGoodsList) throws ApiException {
        if (null == coCorderGoodsList || coCorderGoodsList.isEmpty()) {
            return;
        }
        try {
            this.coCorderGoodsMapper.insertBatch(coCorderGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.saveCorderGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private CoCorderGoods getCorderGoodsModelById(Integer corderGoodsId) {
        if (null == corderGoodsId) {
            return null;
        }
        try {
            return this.coCorderGoodsMapper.selectByPrimaryKey(corderGoodsId);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.getCorderGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private CoCorderGoods getCorderGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.coCorderGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.getCorderGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCorderGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.delCorderGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.delCorderGoodsModelByCode.num");
        }
    }

    private void deleteCorderGoodsModel(Integer corderGoodsId) throws ApiException {
        if (null == corderGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.deleteByPrimaryKey(corderGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.deleteCorderGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.deleteCorderGoodsModel.num");
        }
    }

    private void updateCorderGoodsModel(CoCorderGoods coCorderGoods) throws ApiException {
        if (null == coCorderGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.updateByPrimaryKey(coCorderGoods);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateCorderGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateCorderGoodsModel.num");
        }
    }

    private void updateStateCorderGoodsModel(Integer corderGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == corderGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderGoodsId", corderGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateStateCorderGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateStateCorderGoodsModel.null");
        }
    }

    private void updateStateCorderGoodsModelByCode(String tenantCode, String corderGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)corderGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderGoodsCode", corderGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateStateCorderGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateStateCorderGoodsModelByCode.null");
        }
    }

    private CoCorderGoods makeCorderGoods(CoCorderGoodsDomain coCorderGoodsDomain, CoCorderGoods coCorderGoods) {
        if (null == coCorderGoodsDomain) {
            return null;
        }
        if (null == coCorderGoods) {
            coCorderGoods = new CoCorderGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)coCorderGoods, (Object)coCorderGoodsDomain);
            return coCorderGoods;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.makeCorderGoods", (Throwable)e);
            return null;
        }
    }

    private CoCorderGoodsReDomain makeCoCorderGoodsReDomain(CoCorderGoods coCorderGoods) {
        if (null == coCorderGoods) {
            return null;
        }
        CoCorderGoodsReDomain coCorderGoodsReDomain = new CoCorderGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderGoodsReDomain, (Object)coCorderGoods);
            return coCorderGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.makeCoCorderGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderGoods> queryCorderGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.queryCorderGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countCorderGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.countCorderGoods", (Throwable)e);
        }
        return i;
    }

    private CoCorderGoods createCoCorderGoods(CoCorderGoodsDomain coCorderGoodsDomain) {
        String msg = this.checkCorderGoods(coCorderGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.saveCorderGoods.checkCorderGoods", msg);
        }
        CoCorderGoods coCorderGoods = this.makeCorderGoods(coCorderGoodsDomain, null);
        this.setCorderGoodsDefault(coCorderGoods);
        return coCorderGoods;
    }

    @Override
    public String saveCorderGoods(CoCorderGoodsDomain coCorderGoodsDomain) throws ApiException {
        CoCorderGoods coCorderGoods = this.createCoCorderGoods(coCorderGoodsDomain);
        this.saveCorderGoodsModel(coCorderGoods);
        return coCorderGoods.getCorderGoodsCode();
    }

    @Override
    public String saveCorderGoodsBatch(List<CoCorderGoodsDomain> coCorderGoodsDomainList) throws ApiException {
        if (null == coCorderGoodsDomainList || coCorderGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorderGoods> coCorderGoodsList = new ArrayList<CoCorderGoods>();
        String code = "";
        for (CoCorderGoodsDomain coCorderGoodsDomain : coCorderGoodsDomainList) {
            CoCorderGoods coCorderGoods = this.createCoCorderGoods(coCorderGoodsDomain);
            code = coCorderGoods.getCorderGoodsCode();
            coCorderGoodsList.add(coCorderGoods);
        }
        this.saveCorderGoodsBatchModel(coCorderGoodsList);
        return code;
    }

    @Override
    public void updateCorderGoodsState(Integer corderGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderGoodsModel(corderGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderGoodsStateByCode(String tenantCode, String corderGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderGoodsModelByCode(tenantCode, corderGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderGoods(CoCorderGoodsDomain coCorderGoodsDomain) throws ApiException {
        String msg = this.checkCorderGoods(coCorderGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateCorderGoods.checkCorderGoods", msg);
        }
        CoCorderGoods oldCoCorderGoods = this.getCorderGoodsModelById(coCorderGoodsDomain.getCorderGoodsId());
        if (null == oldCoCorderGoods) {
            throw new ApiException("co.CONTRACTORDER.CoCorderGoodsServiceImpl.updateCorderGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CoCorderGoods coCorderGoods = this.makeCorderGoods(coCorderGoodsDomain, oldCoCorderGoods);
        this.setCorderGoodsUpdataDefault(coCorderGoods);
        this.updateCorderGoodsModel(coCorderGoods);
    }

    @Override
    public CoCorderGoodsDomain getCorderGoods(Integer corderGoodsId) {
        return this.makeCorderGoodsDomain(this.getCorderGoodsModelById(corderGoodsId));
    }

    private CoCorderGoodsDomain makeCorderGoodsDomain(CoCorderGoods corderGoodsModelById) {
        if (null == corderGoodsModelById) {
            return null;
        }
        CoCorderGoodsDomain coCorderGoodsDomain = new CoCorderGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderGoodsDomain, (Object)corderGoodsModelById);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderGoodsServiceImpl.makeCorderGoodsDomain.e", (Throwable)e);
            return null;
        }
        return coCorderGoodsDomain;
    }

    @Override
    public void deleteCorderGoods(Integer corderGoodsId) throws ApiException {
        this.deleteCorderGoodsModel(corderGoodsId);
    }

    @Override
    public QueryResult<CoCorderGoodsReDomain> queryCorderGoodsPage(Map<String, Object> map) {
        List<CoCorderGoodsReDomain> coCorderGoodsList = this.makeCoCorderGoodsReDomainList(this.queryCorderGoodsModelPage(map));
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCorderGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderGoodsList);
        return queryResult;
    }

    private List<CoCorderGoodsReDomain> makeCoCorderGoodsReDomainList(List<CoCorderGoods> queryCorderGoodsModelPage) {
        ArrayList<CoCorderGoodsReDomain> queryCorderGoodsModelPages = new ArrayList<CoCorderGoodsReDomain>();
        for (CoCorderGoods coCorderGoods : queryCorderGoodsModelPage) {
            CoCorderGoodsReDomain coCorderGoodsReDomain = this.makeCoCorderGoodsReDomain(coCorderGoods);
            queryCorderGoodsModelPages.add(coCorderGoodsReDomain);
        }
        return queryCorderGoodsModelPages;
    }

    @Override
    public CoCorderGoods getCorderGoodsByCode(String tenantCode, String corderGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderGoodsCode", corderGoodsCode);
        return this.getCorderGoodsModelByCode(map);
    }

    @Override
    public void deleteCorderGoodsByCode(String tenantCode, String corderGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderGoodsCode", corderGoodsCode);
        this.delCorderGoodsModelByCode(map);
    }
}

