/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contractorder.service.impl;

import com.yqbsoft.laser.service.contractorder.dao.CoCorderMapper;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderGoodsDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderGoodsReDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderReDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCordersendDomain;
import com.yqbsoft.laser.service.contractorder.model.CoCorder;
import com.yqbsoft.laser.service.contractorder.model.CoCorderGoods;
import com.yqbsoft.laser.service.contractorder.service.CoCorderGoodsService;
import com.yqbsoft.laser.service.contractorder.service.CoCorderService;
import com.yqbsoft.laser.service.contractorder.service.CoCordersendService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoCorderServiceImpl
extends BaseServiceImpl
implements CoCorderService {
    private static final String SYS_CODE = "co.CONTRACTORDER.CoCorderServiceImpl";
    private CoCorderMapper coCorderMapper;
    private CoCorderGoodsService coCorderGoodsService;
    private CoCordersendService coCordersendService;

    public void setCoCorderMapper(CoCorderMapper coCorderMapper) {
        this.coCorderMapper = coCorderMapper;
    }

    public void setCoCorderGoodsService(CoCorderGoodsService coCorderGoodsService) {
        this.coCorderGoodsService = coCorderGoodsService;
    }

    public CoCordersendService getCoCordersendService() {
        return this.coCordersendService;
    }

    public void setCoCordersendService(CoCordersendService coCordersendService) {
        this.coCordersendService = coCordersendService;
    }

    private Date getSysDate() {
        try {
            return this.coCorderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCorder(CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCorderDefault(CoCorder coCorder) {
        if (null == coCorder) {
            return;
        }
        if (null == coCorder.getDataState()) {
            coCorder.setDataState(0);
        }
        if (null == coCorder.getGmtCreate()) {
            coCorder.setGmtCreate(this.getSysDate());
        }
        coCorder.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)coCorder.getCorderCode())) {
            coCorder.setCorderCode(this.createUUIDString());
        }
    }

    private int getCorderMaxCode() {
        int code = 0;
        try {
            return this.coCorderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getCorderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCorderUpdataDefault(CoCorder coCorder) {
        if (null == coCorder) {
            return;
        }
        coCorder.setGmtModified(this.getSysDate());
    }

    private void saveCorderModel(CoCorder coCorder) throws ApiException {
        if (null == coCorder) {
            return;
        }
        try {
            this.coCorderMapper.insert(coCorder);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveCorderModel.ex", (Throwable)e);
        }
    }

    private void saveCorderBatchModel(List<CoCorder> coCorderList) throws ApiException {
        if (null == coCorderList || coCorderList.isEmpty()) {
            return;
        }
        try {
            this.coCorderMapper.insertBatch(coCorderList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveCorderBatchModel.ex", (Throwable)e);
        }
    }

    private CoCorder getCorderModelById(Integer corderId) {
        if (null == corderId) {
            return null;
        }
        try {
            return this.coCorderMapper.selectByPrimaryKey(corderId);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getCorderModelById", (Throwable)e);
            return null;
        }
    }

    private CoCorder getCorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.coCorderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.getCorderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.delCorderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.delCorderModelByCode.num");
        }
    }

    private void deleteCorderModel(Integer corderId) throws ApiException {
        if (null == corderId) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderMapper.deleteByPrimaryKey(corderId);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.deleteCorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.deleteCorderModel.num");
        }
    }

    private void updateCorderModel(CoCorder coCorder) throws ApiException {
        if (null == coCorder) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateByPrimaryKey(coCorder);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderModel.num");
        }
    }

    private void updateStateCorderModel(Integer corderId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == corderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderId", corderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModel.null");
        }
    }

    private void updateStateCorderModelByCode(String tenantCode, String corderCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)corderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderCode", corderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateStateCorderModelByCode.null");
        }
    }

    private CoCorder makeCorder(CoCorderDomain coCorderDomain, CoCorder coCorder) {
        if (null == coCorderDomain) {
            return null;
        }
        if (null == coCorder) {
            coCorder = new CoCorder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)coCorder, (Object)coCorderDomain);
            return coCorder;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeCorder", (Throwable)e);
            return null;
        }
    }

    private CoCorderReDomain makeCoCorderReDomain(CoCorder coCorder) {
        if (null == coCorder) {
            return null;
        }
        CoCorderReDomain coCorderReDomain = new CoCorderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderReDomain, (Object)coCorder);
            return coCorderReDomain;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeCoCorderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderReDomain> makeCoCorderReDomainList(Map<String, Object> map) {
        try {
            List<CoCorder> contractList = this.queryCorderModelPage(map);
            return this.childFlag(map, contractList);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeCoCorderReDomainList.e", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderReDomain> childFlag(Map<String, Object> map, List<CoCorder> contractList) {
        if (contractList == null || contractList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorderReDomain> coCorderReDomainList = new ArrayList<CoCorderReDomain>();
        for (CoCorder coCorder : contractList) {
            CoCorderReDomain coCorderReDomain = this.makeCoCorderReDomain(coCorder);
            HashMap<String, Object> query = new HashMap<String, Object>();
            query.put("corderCode", coCorderReDomain.getCorderCode());
            query.put("tenantCode", coCorderReDomain.getTenantCode());
            QueryResult<CoCorderGoodsReDomain> queryResult = this.coCorderGoodsService.queryCorderGoodsPage(query);
            if (!EmptyUtil.isEmpty(queryResult) || ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                coCorderReDomain.setCoCorderGoodsReDomainList(queryResult.getList());
            }
            coCorderReDomainList.add(coCorderReDomain);
        }
        return coCorderReDomainList;
    }

    private List<CoCorder> queryCorderModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.queryCorderModel", (Throwable)e);
            return null;
        }
    }

    private int countCorder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.countCorder", (Throwable)e);
        }
        return i;
    }

    private CoCorder createCoCorder(CoCorderDomain coCorderDomain) {
        String msg = this.checkCorder(coCorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.saveCorder.checkCorder", msg);
        }
        CoCorder coCorder = this.makeCorder(coCorderDomain, null);
        this.setCorderDefault(coCorder);
        return coCorder;
    }

    @Override
    public String saveCorder(CoCorderDomain coCorderDomain) throws ApiException {
        CoCorder coCorder = this.createCoCorder(coCorderDomain);
        this.saveCorderModel(coCorder);
        return coCorder.getCorderCode();
    }

    @Override
    public String saveCorderBatch(List<CoCorderDomain> coCorderDomainList) throws ApiException {
        if (null == coCorderDomainList || coCorderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorder> coCorderList = new ArrayList<CoCorder>();
        String code = "";
        for (CoCorderDomain coCorderDomain : coCorderDomainList) {
            CoCorder coCorder = this.createCoCorder(coCorderDomain);
            code = coCorder.getCorderCode();
            if (ListUtil.isNotEmpty(coCorderDomain.getCoCorderGoodsDomainList())) {
                for (CoCorderGoodsDomain coCorderGoodsDomain : coCorderDomain.getCoCorderGoodsDomainList()) {
                    coCorderGoodsDomain.setCorderCode(code);
                    coCorderGoodsDomain.setTenantCode(coCorder.getTenantCode());
                }
                this.coCorderGoodsService.saveCorderGoodsBatch(coCorderDomain.getCoCorderGoodsDomainList());
            }
            coCorderList.add(coCorder);
        }
        this.saveCorderBatchModel(coCorderList);
        this.sendCoCordersendService(coCorderDomainList);
        return code;
    }

    public void sendCoCordersendService(List<CoCorderDomain> coCorderList) {
        if (ListUtil.isEmpty(coCorderList)) {
            return;
        }
        for (CoCorderDomain coCorder : coCorderList) {
            if (!ListUtil.isNotEmpty(coCorder.getCoCorderGoodsDomainList())) continue;
            for (CoCorderGoodsDomain coCorderGoodsDomain : coCorder.getCoCorderGoodsDomainList()) {
                CoCordersendDomain coCordersendDomain = new CoCordersendDomain();
                coCordersendDomain.setCorderCode(JsonUtil.buildNormalBinder().toJson((Object)coCorderGoodsDomain));
                coCordersendDomain.setMemo("CoCorder-insert");
                coCordersendDomain.setTenantCode(coCorder.getTenantCode());
                this.coCordersendService.sendCoCordersend(coCordersendDomain);
            }
        }
    }

    @Override
    public void updateCorderState(Integer corderId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderModel(corderId, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderStateByCode(String tenantCode, String corderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderModelByCode(tenantCode, corderCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCorder(CoCorderDomain coCorderDomain) throws ApiException {
        String msg = this.checkCorder(coCorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorder.checkCorder", msg);
        }
        CoCorder oldCoCorder = this.getCorderModelById(coCorderDomain.getCorderId());
        if (null == oldCoCorder) {
            throw new ApiException("co.CONTRACTORDER.CoCorderServiceImpl.updateCorder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CoCorder coCorder = this.makeCorder(coCorderDomain, oldCoCorder);
        this.setCorderUpdataDefault(coCorder);
        this.updateCorderModel(coCorder);
    }

    @Override
    public CoCorder getCorder(Integer corderId) {
        return this.getCorderModelById(corderId);
    }

    @Override
    public void deleteCorder(Integer corderId) throws ApiException {
        this.deleteCorderModel(corderId);
    }

    @Override
    public QueryResult<CoCorderReDomain> queryCorderPage(Map<String, Object> map) {
        List<CoCorderReDomain> coCorderList = this.makeCoCorderReDomainList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCorder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderList);
        return queryResult;
    }

    @Override
    public CoCorder getCorderByCode(String tenantCode, String corderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderCode", corderCode);
        return this.getCorderModelByCode(map);
    }

    @Override
    public void deleteCorderByCode(String tenantCode, String corderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderCode", corderCode);
        this.delCorderModelByCode(map);
    }

    @Override
    public QueryResult<CoCorderReDomain> queryCorderReDomainPageByGoods(Map<String, Object> map) {
        int count = this.countCoCorderByGoods(map);
        List<Object> coCorderReDomainList = new ArrayList();
        if (count > 0) {
            coCorderReDomainList = this.queryCorderReDomainAndGoodsPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderReDomainList);
        return queryResult;
    }

    @Override
    public QueryResult<CoCorderGoods> queryCorderGoodsRefundPage(Map<String, Object> map) {
        this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.queryCorderGoodsRefundPage.map", (Object)("map =" + JsonUtil.buildNormalBinder().toJson(map)));
        int count = this.countCorderGoodsRefundRefund(map);
        List<CoCorderGoods> coCorderGoodsDomainList = null;
        if (count > 0) {
            coCorderGoodsDomainList = this.queryCorderGoodsRefundModelPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderGoodsDomainList);
        return queryResult;
    }

    private List<CoCorderGoods> queryCorderGoodsRefundModelPage(Map<String, Object> parammap) {
        try {
            return this.makeCocorderList(this.coCorderMapper.queryCorderGoodsRefund(parammap));
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.queryCorderGoodsRefundModelPage", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderGoods> makeCocorderList(List<CoCorderGoods> queryCorderGoodsRefund) {
        if (ListUtil.isEmpty(queryCorderGoodsRefund)) {
            return queryCorderGoodsRefund;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        for (CoCorderGoods coCorderGoods : queryCorderGoodsRefund) {
            if (StringUtils.isBlank((String)coCorderGoods.getGoodsNo()) || StringUtils.isBlank((String)coCorderGoods.getMemberBcode())) continue;
            queryMap.put("goodsNo", coCorderGoods.getGoodsNo());
            queryMap.put("memberBcode", coCorderGoods.getMemberBcode());
            CoCorder coCorder1 = this.coCorderMapper.getAvgSendGoods(queryMap);
            if (null != coCorder1 && null != coCorder1.getContractGmoney()) {
                coCorderGoods.setContractGoodsPrice(coCorder1.getContractGmoney());
                queryMap.clear();
                continue;
            }
            coCorder1 = this.coCorderMapper.getAvgCorder(queryMap);
            if (null != coCorder1 && null != coCorder1.getContractGmoney()) {
                coCorderGoods.setContractGoodsPrice(coCorder1.getContractGmoney());
            }
            queryMap.clear();
        }
        return queryCorderGoodsRefund;
    }

    private int countCorderGoodsRefundRefund(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderMapper.countCorderGoodsRefundRefund(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.countCorderGoodsRefundRefund", (Throwable)e);
        }
        return i;
    }

    private List<CoCorderReDomain> queryCorderReDomainAndGoodsPage(Map<String, Object> map) {
        List<CoCorder> ocRefundList = this.queryCoCorderModelPageAndGoods(map);
        return this.makeCorderAndGoodsReDomainList(ocRefundList, map);
    }

    private List<CoCorderReDomain> makeCorderAndGoodsReDomainList(List<CoCorder> coCorderList, Map<String, Object> map) {
        if (ListUtil.isEmpty(coCorderList)) {
            return null;
        }
        ArrayList<CoCorderReDomain> coCorderReDomainList = new ArrayList<CoCorderReDomain>();
        for (CoCorder coCorder : coCorderList) {
            CoCorderReDomain coCorderReDomain = this.makeCoCorderGoodsDomain(coCorder, map);
            coCorderReDomainList.add(coCorderReDomain);
        }
        return coCorderReDomainList;
    }

    private CoCorderReDomain makeCoCorderGoodsDomain(CoCorder coCorder, Map<String, Object> map) {
        if (null == coCorder) {
            return null;
        }
        CoCorderReDomain coCorderReDomain = new CoCorderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderReDomain, (Object)coCorder);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.makeCoCorderGoodsDomain.e", (Throwable)e);
            return null;
        }
        coCorderReDomain.setCoCorderGoodsDomainList(Arrays.asList(this.coCorderGoodsService.getCorderGoods(Integer.valueOf(coCorder.getMemo()))));
        return coCorderReDomain;
    }

    private List<CoCorder> queryCoCorderModelPageAndGoods(Map<String, Object> parammap) {
        try {
            return this.coCorderMapper.queryAndGoods(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.queryCoCorderModelPageAndGoods", (Throwable)e);
            return null;
        }
    }

    private int countCoCorderByGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderMapper.countCoCorderByGoods(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.countCoCorderByGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveCorderStr(CoCorderReDomain coCorderReDomain) throws ApiException {
        CoCorder coCorder = this.createCoCorder(coCorderReDomain);
        String corderCode = coCorder.getCorderCode();
        if (ListUtil.isNotEmpty(coCorderReDomain.getCoCorderGoodsReDomainList())) {
            ArrayList<CoCorderGoodsDomain> goodsDomains = new ArrayList<CoCorderGoodsDomain>();
            for (CoCorderGoodsDomain coCorderGoodsDomain : coCorderReDomain.getCoCorderGoodsReDomainList()) {
                coCorderGoodsDomain.setCorderCode(corderCode);
                coCorderGoodsDomain.setMemberBcode(coCorder.getMemberBcode());
                coCorderGoodsDomain.setTenantCode(coCorder.getTenantCode());
                goodsDomains.add(coCorderGoodsDomain);
            }
            this.coCorderGoodsService.saveCorderGoodsBatch(goodsDomains);
        } else if (ListUtil.isNotEmpty(coCorderReDomain.getCoCorderGoodsDomainList())) {
            for (CoCorderGoodsDomain coCorderGoodsDomain : coCorderReDomain.getCoCorderGoodsDomainList()) {
                coCorderGoodsDomain.setCorderCode(corderCode);
                coCorderGoodsDomain.setMemberBcode(coCorder.getMemberBcode());
                coCorderGoodsDomain.setTenantCode(coCorder.getTenantCode());
            }
            this.coCorderGoodsService.saveCorderGoodsBatch(coCorderReDomain.getCoCorderGoodsDomainList());
        }
        this.saveCorderModel(coCorder);
        return corderCode;
    }

    @Override
    public void updateCorderAndGoods(CoCorderReDomain coCorderReDomain) throws ApiException {
        if (ListUtil.isNotEmpty(coCorderReDomain.getCoCorderGoodsReDomainList())) {
            List<CoCorderGoodsReDomain> coCorderGoodsReDomainList = coCorderReDomain.getCoCorderGoodsReDomainList();
            if (coCorderGoodsReDomainList.size() < 100) {
                for (CoCorderGoodsReDomain coCorderGoodsReDomain : coCorderGoodsReDomainList) {
                    this.coCorderGoodsService.updateCorderGoods(coCorderGoodsReDomain);
                }
            } else {
                this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderAndGoods.e", (Object)"\u4fee\u6539\u8d85\u51fa100\u6761\u9650\u5236");
            }
        } else if (ListUtil.isNotEmpty(coCorderReDomain.getCoCorderGoodsDomainList())) {
            List<CoCorderGoodsReDomain> coCorderGoodsReDomainList = coCorderReDomain.getCoCorderGoodsReDomainList();
            if (coCorderGoodsReDomainList.size() < 100) {
                for (CoCorderGoodsReDomain coCorderGoodsReDomain : coCorderGoodsReDomainList) {
                    this.coCorderGoodsService.updateCorderGoods(coCorderGoodsReDomain);
                }
            } else {
                this.logger.error("co.CONTRACTORDER.CoCorderServiceImpl.updateCorderAndGoods.e", (Object)"\u4fee\u6539\u8d85\u51fa100\u6761\u9650\u5236");
            }
        }
        this.updateCorder(coCorderReDomain);
        this.sendUpdateCoCordersendService(coCorderReDomain);
    }

    public void sendUpdateCoCordersendService(CoCorderReDomain coCorderDomain) {
        if (null == coCorderDomain) {
            return;
        }
        if (ListUtil.isNotEmpty(coCorderDomain.getCoCorderGoodsDomainList())) {
            for (CoCorderGoodsDomain coCorderGoodsDomain : coCorderDomain.getCoCorderGoodsDomainList()) {
                CoCordersendDomain coCordersendDomain = new CoCordersendDomain();
                coCordersendDomain.setCorderCode(JsonUtil.buildNormalBinder().toJson((Object)coCorderGoodsDomain));
                coCordersendDomain.setMemo("CoCorder-update");
                coCordersendDomain.setTenantCode(coCorderDomain.getTenantCode());
                this.coCordersendService.sendCoCordersend(coCordersendDomain);
            }
        }
    }
}

