/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpUrechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeReDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.crp.enums.URechargeListTypeEnum;
import com.yqbsoft.laser.service.crp.es.SendPollThread;
import com.yqbsoft.laser.service.crp.es.SendPutThread;
import com.yqbsoft.laser.service.crp.es.SendService;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrechargelist;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuter;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuterSubset;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeBaseService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargelistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpUrechargeServiceImpl
extends BaseServiceImpl
implements CrpUrechargeService {
    private static final String SYS_CODE = "service.adapter.crp.CrpUrechargeServiceImpl";
    private CrpUrechargeMapper crpUrechargeMapper;
    private CrpChannelsendService crpChannelsendService;
    private CrpUrechargelistService crpUrechargelistService;
    private static SendService sendService;
    private static final Object lock;

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public void setCrpUrechargeMapper(CrpUrechargeMapper crpUrechargeMapper) {
        this.crpUrechargeMapper = crpUrechargeMapper;
    }

    public CrpUrechargelistService getCrpUrechargelistService() {
        return this.crpUrechargelistService;
    }

    public void setCrpUrechargelistService(CrpUrechargelistService crpUrechargelistService) {
        this.crpUrechargelistService = crpUrechargelistService;
    }

    private Date getSysDate() {
        try {
            return this.crpUrechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpUrechargeDomain crpUrechargeDomain) {
        if (null == crpUrechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpUrechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        if (null == crpUrecharge.getDataState()) {
            crpUrecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpUrecharge.getGmtCreate()) {
            crpUrecharge.setGmtCreate(date);
        }
        crpUrecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpUrecharge.getUrechargeCode())) {
            crpUrecharge.setUrechargeCode(this.getNo(null, "CrpUrecharge", "crpUrecharge", crpUrecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpUrechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        crpUrecharge.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        try {
            this.crpUrechargeMapper.insert(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpUrecharge> crpUrechargeList) throws ApiException {
        if (null == crpUrechargeList || crpUrechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpUrechargeMapper.insertBatch(crpUrechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpUrecharge getCrpModelById(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByUserInfoCode(String tenantCode, String userInfoCode) {
        if (null == userInfoCode) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByUserInfoCode(tenantCode, userInfoCode);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCModelByUserInfoCode(String tenantCode, String userInfoCode, String fchannelPmodeCode, String rechargeType) {
        if (null == userInfoCode) {
            return null;
        }
        try {
            List<CrpUrecharge> crpUrecharges = this.crpUrechargeMapper.selectCByUserInfoCode(tenantCode, userInfoCode, fchannelPmodeCode, rechargeType);
            if (crpUrecharges.size() > 1) {
                this.logger.error("selectCByUserInfoCode.total not one");
            }
            return crpUrecharges.get(0);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer urechargeId) throws ApiException {
        if (null == urechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.deleteByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateByPrimaryKey(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == urechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateAvailableQuotaModel(Integer urechargeId, BigDecimal quota, BigDecimal allMoney) throws ApiException {
        if (null == urechargeId || null == quota) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("quota", quota);
        map.put("allMoney", allMoney);
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateAvailableQuota(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateAvailableQuotaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateAvailableQuotaModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpUrecharge makeCrp(CrpUrechargeDomain crpUrechargeDomain, CrpUrecharge crpUrecharge) {
        if (null == crpUrechargeDomain) {
            return null;
        }
        if (null == crpUrecharge) {
            crpUrecharge = new CrpUrecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpUrecharge, (Object)crpUrechargeDomain);
            return crpUrecharge;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargeReDomain makeCrpUrechargeReDomain(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return null;
        }
        CrpUrechargeReDomain crpUrechargeReDomain = new CrpUrechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeReDomain, (Object)crpUrecharge);
            return crpUrechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.makeCrpUrechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrechargeReDomain> queryCrpUModelPageList(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.queryCrpURechargePageList(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.queryCrpModelPageList", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private int countCrpURechargeRe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.countCrpURechargeRe(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpUrecharge createCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, null);
        this.setCrpDefault(crpUrecharge);
        return crpUrecharge;
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpUrecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getUrechargeCode());
            pmChannelsendDomain.setChannelsendType("crpUrecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> saveCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.createCrpUrecharge(crpUrechargeDomain);
        this.saveCrpModel(crpUrecharge);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        crpUrecharge.setRechargeUrl2(crpUrechargeDomain.getBankcodeName());
        String contractTypeName = null;
        contractTypeName = crpUrechargeDomain.getBankcardCode().equals("Credit") ? "\u6388\u4fe1\u8fd8\u6b3e" : "\u6388\u4fe1\u5145\u503c";
        this.handlerCrpURecharge(crpUrecharge, URechargeListTypeEnum.ADD.getCode(), contractTypeName);
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargeBatch(List<CrpUrechargeDomain> crpUrechargeDomainList) throws ApiException {
        if (null == crpUrechargeDomainList || crpUrechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> crpUrechargeList = new ArrayList<CrpChannelsend>();
        for (CrpUrechargeDomain crpUrechargeDomain : crpUrechargeDomainList) {
            List<CrpChannelsend> list = this.saveCrpUrecharge(crpUrechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crpUrechargeList.addAll(list);
        }
        return crpUrechargeList;
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpUrecharge> crpUrechargeList, String dri) {
        if (ListUtil.isEmpty(crpUrechargeList)) {
            return null;
        }
        ArrayList<CrpChannelsendDomain> crpChannelsendDomainArrayList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrecharge crpUrecharge : crpUrechargeList) {
            CrpChannelsendDomain crpChannelsendDomain = new CrpChannelsendDomain();
            crpChannelsendDomain.setChannelsendOpcode(crpUrecharge.getUrechargeCode());
            crpChannelsendDomain.setChannelsendType("crpUrecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)crpUrecharge));
            crpChannelsendDomain.setTenantCode(crpUrecharge.getTenantCode());
            crpChannelsendDomainArrayList.add(crpChannelsendDomain);
        }
        List<CrpChannelsend> pmChannelsendList = this.crpChannelsendService.saveCrpBatch(crpChannelsendDomainArrayList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeState(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(urechargeId, dataState, oldDataState, map);
        CrpUrecharge orgDepartemp = this.getCrpUrecharge(urechargeId);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateAvailableQuota(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.getCrpUrecharge(crpUrechargeDomain.getUrechargeId());
        crpUrecharge.setRechargeAllmoney(crpUrecharge.getRechargeAllmoney().add(crpUrechargeDomain.getRechargeAllmoney()));
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(crpUrechargeDomain.getRechargeAllmoney()));
        crpUrecharge.setRechargePeriod(crpUrechargeDomain.getRechargePeriod());
        crpUrecharge.setRechargeName3(crpUrechargeDomain.getRechargeName3());
        crpUrecharge.setRechargeName4(crpUrechargeDomain.getRechargeName4());
        crpUrecharge.setRechargeName8(crpUrechargeDomain.getRechargeName8());
        crpUrecharge.setRechargeName9(crpUrechargeDomain.getRechargeName9());
        crpUrecharge.setRechargeName10(crpUrechargeDomain.getRechargeName10());
        crpUrecharge.setRechargeName5(crpUrechargeDomain.getRechargeName5());
        crpUrecharge.setRechargeState(crpUrechargeDomain.getRechargeState());
        crpUrecharge.setRechargeUrl(crpUrechargeDomain.getRechargeUrl());
        crpUrecharge.setBankcardCode(crpUrechargeDomain.getBankcardCode());
        crpUrecharge.setBankcodeName(crpUrechargeDomain.getBankcodeName());
        crpUrecharge.setRechargeUrl2(crpUrechargeDomain.getBankcodeName());
        crpUrecharge.setRechargeMode(crpUrechargeDomain.getRechargeMode());
        String contractTypeName = null;
        contractTypeName = StringUtils.isBlank((String)crpUrechargeDomain.getBankcodeName()) ? "\u65b0\u589e\u989d\u5ea6" : crpUrechargeDomain.getBankcodeName();
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        crpUrecharge.setRechargeOpcode(crpUrechargeDomain.getRechargeOpcode());
        crpUrecharge.setQuota(crpUrechargeDomain.getRechargeAllmoney());
        crpUrecharge.setAllMoney(crpUrechargeDomain.getRechargeAllmoney());
        crpUrecharge.setRechargeName8(crpUrecharge.getRechargeName8());
        this.handlerCrpURecharge(crpUrecharge, URechargeListTypeEnum.UPDATE.getCode(), contractTypeName);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> changeAvailableQuota(CrpUrecharge crpUrecharge, Map<String, Object> map) throws ApiException {
        BigDecimal quota = new BigDecimal(map.get("quota").toString());
        String quotaType = map.get("quotaType").toString();
        String rechargeOpno = map.get("contractBillcode").toString();
        if (URechargeListTypeEnum.ORDER_WITHHOLDING.getCode().equals(quotaType)) {
            quota = quota.multiply(new BigDecimal(-1));
        }
        this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.changeAvailableQuota.map" + JsonUtil.buildNonDefaultBinder().toJson(map));
        String contractTypeName = "";
        if (null != map.get("contractType") && StringUtils.isNotBlank((String)map.get("contractType").toString())) {
            String contractType = map.get("contractType").toString();
            contractTypeName = StringUtils.isNotBlank((String)contractType) && contractType.equals("00") ? "\u6b63\u5f0f\u8ba2\u5355" : (StringUtils.isNotBlank((String)contractType) && contractType.equals("zy00") ? "\u76f4\u8425\u8ba2\u5355" : (StringUtils.isNotBlank((String)contractType) && contractType.equals("80") ? "\u9884\u552e\u8ba2\u5355" : (StringUtils.isNotBlank((String)contractType) && contractType.equals("85") ? "\u9884\u552e\u8f6c\u6b63\u5f0f" : (StringUtils.isNotBlank((String)contractType) && contractType.equals("50") ? "\u8fd0\u8d39\u8ba2\u5355" : (StringUtils.isNotBlank((String)contractType) && contractType.equals("86") ? "\u6b63\u5f0f\u8ba2\u5355" : "\u672a\u77e5\u7c7b\u578b\u8ba2\u5355")))));
        }
        crpUrecharge.setBankcardCode("contract");
        crpUrecharge.setBankcardCode(contractTypeName);
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(quota));
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        crpUrecharge.setQuota(quota);
        this.handlerCrpURecharge(crpUrecharge, quotaType, rechargeOpno, contractTypeName);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    private void handlerCrpURecharge(CrpUrecharge crpUrecharge, String rechargeType, String contractTypeName) {
        this.handlerCrpURecharge(crpUrecharge, rechargeType, null, contractTypeName);
    }

    private void handlerCrpURecharge(CrpUrecharge crpUrecharge, String rechargeType, String rechargeOpno, String contractTypeName) {
        block9: {
            CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpUrecharge);
                crpUrechargelistDomain.setRechargeAllmoney(crpUrecharge.getQuota() == null ? crpUrecharge.getRechargeSmoney() : crpUrecharge.getQuota());
                crpUrechargelistDomain.setUrechargeCode(crpUrecharge.getUrechargeCode());
                crpUrechargelistDomain.setRechargeSmoney(crpUrecharge.getQuota() == null ? crpUrecharge.getRechargeSmoney() : crpUrecharge.getQuota());
                if (!"568457092274532359".equals(crpUrecharge.getTenantCode())) {
                    crpUrechargelistDomain.setRechargeType(rechargeType);
                }
                if (StringUtils.isBlank((String)rechargeOpno)) {
                    crpUrechargelistDomain.setRechargeOpno(crpUrecharge.getRechargeOpcode());
                } else {
                    crpUrechargelistDomain.setRechargeOpno(rechargeOpno);
                }
                if (!crpUrechargelistDomain.getRechargeAllmoney().equals(BigDecimal.valueOf(0L))) {
                    crpUrechargelistDomain.setRechargeName10(contractTypeName);
                    this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.handlerCrpURecharge" + JsonUtil.buildNonDefaultBinder().toJson((Object)contractTypeName));
                    this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
                    break block9;
                }
                HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                stringObjectMap.put("tenantCode", crpUrecharge.getTenantCode());
                stringObjectMap.put("rechargeName8", crpUrecharge.getRechargeName8().toString());
                stringObjectMap.put("rechargeType", crpUrecharge.getRechargeType());
                QueryResult<CrpUrechargelist> crpUrechargelists = this.crpUrechargelistService.queryCrpUrechargelistPage(stringObjectMap);
                if (null == crpUrechargelists || ListUtil.isEmpty((Collection)crpUrechargelists.getList())) {
                    throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.crpUrechargelists.null", "\u6570\u636e\u4e3a\u7a7a" + stringObjectMap);
                }
                CrpUrechargelist crpUrechargelist = (CrpUrechargelist)crpUrechargelists.getList().get(0);
                CrpUrechargelistDomain crpUrechargelistDomain1 = new CrpUrechargelistDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain1, (Object)crpUrechargelist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                crpUrechargelistDomain1.setRechargeState(crpUrecharge.getRechargeState());
                crpUrechargelistDomain1.setRechargeName3(crpUrecharge.getRechargeName3());
                crpUrechargelistDomain1.setRechargeName4(crpUrecharge.getRechargeName4());
                crpUrechargelistDomain1.setTenantCode(crpUrecharge.getTenantCode());
                crpUrechargelistDomain1.setUrechargelistId(crpUrechargelist.getUrechargelistId());
                this.crpUrechargelistService.updateCrpUrechargelist(crpUrechargelistDomain1);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
            }
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeStateByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModelByCode(tenantCode, urechargeCode, dataState, oldDataState, map);
        CrpUrecharge orgDepartemp = this.getCrpUrechargeByCode(tenantCode, urechargeCode);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpUrecharge oldCrpUrecharge = this.getCrpModelById(crpUrechargeDomain.getUrechargeId());
        if (null == oldCrpUrecharge) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, oldCrpUrecharge);
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpUrecharge getCrpUrecharge(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        return this.getCrpModelById(urechargeId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrecharge(Integer urechargeId) throws ApiException {
        CrpUrecharge orgDepartemp = this.getCrpUrecharge(urechargeId);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        this.deleteCrpModel(urechargeId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpUrecharge> queryCrpUrechargePage(Map<String, Object> map) {
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public QueryResult<CrpUrechargeReDomain> queryCrpURechargePageList(Map<String, Object> map) {
        List<CrpUrechargeReDomain> crpUrechargeList = this.queryCrpUModelPageList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrpURechargeRe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public CrpUrecharge getCrpUrechargeByCode(String tenantCode, String urechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public CrpUrecharge selectByUserInfoCode(String tenantCode, String userInfoCode) throws ApiException {
        if (null == userInfoCode) {
            return null;
        }
        return this.getCrpModelByUserInfoCode(tenantCode, userInfoCode);
    }

    @Override
    public CrpUrecharge selectCByUserInfoCode(String tenantCode, String userInfoCode, String fchannelPmodeCode, String rechargeType) throws ApiException {
        if (null == userInfoCode) {
            return null;
        }
        return this.getCModelByUserInfoCode(tenantCode, userInfoCode, fchannelPmodeCode, rechargeType);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrechargeByCode(String tenantCode, String urechargeCode) throws ApiException {
        CrpUrecharge orgDepartemp = this.getCrpUrechargeByCode(tenantCode, urechargeCode);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public Map<String, Object> deductibleCrp(BigDecimal goodsPmoney, String tenantCode, String userinfoCode) throws ApiException {
        if (null == goodsPmoney || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.deductibleCrp", (Object)("goodsPmoney:" + goodsPmoney + "tenantCode:" + tenantCode + "userinfoCode:" + userinfoCode));
            return null;
        }
        HashMap<String, Object> iamap = new HashMap<String, Object>();
        CrpUrecharge crpUrecharge = this.selectByUserInfoCode(tenantCode, userinfoCode);
        if (null == crpUrecharge) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.deductibleCrp", (Object)("goodsPmoney:" + goodsPmoney + "tenantCode:" + tenantCode + "userinfoCode:" + userinfoCode));
            return null;
        }
        BigDecimal rechargeSmoney = crpUrecharge.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = new BigDecimal(0);
        }
        BigDecimal disamount = new BigDecimal(0);
        disamount = rechargeSmoney.compareTo(goodsPmoney) > -1 ? goodsPmoney : rechargeSmoney;
        iamap.put("dataState", "0");
        iamap.put("disamount", disamount);
        return iamap;
    }

    @Override
    public void sendupdateCreditRepaymentMoneyCrp(Map<String, Object> map) {
        this.updateCreditMoneys(map);
    }

    public void updateCreditMoneys(Map<String, Object> map) {
        int i = 0;
        try {
            this.logger.error("map---->", map);
            i = this.crpUrechargeMapper.updateCreditMoney(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCreditMoney.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCreditMoney.null");
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeDeail(CrpUrecharge urecharge) throws ApiException {
        CrpUrecharge crpUrecha = this.getCrpUrecharge(urecharge.getUrechargeId());
        BigDecimal oldAllMoney = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((String)crpUrecha.getRechargeName10())) {
            oldAllMoney = new BigDecimal(crpUrecha.getRechargeName10());
        }
        oldAllMoney = oldAllMoney.add(new BigDecimal(crpUrecha.getRechargeName10()));
        urecharge.setRechargeName10(oldAllMoney.toString());
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)urecharge);
            crpUrechargelistDomain.setUrechargelistDir("1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateCrpModel(urecharge);
        return this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
    }

    @Override
    public List<CrpChannelsend> updateSmoneyByCode(String tenantCode, BigDecimal rechargeSmoney, String urechargelistCode, String memo) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || null == rechargeSmoney || StringUtils.isBlank((String)urechargelistCode) || StringUtils.isBlank((String)memo)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl\u53c2\u6570\u4e3a\u7a7a");
        }
        this.crpUrechargelistService.updateCrpUrechargelistSmoney(tenantCode, rechargeSmoney, urechargelistCode, memo);
        CrpUrechargelist crpUrechargelist = this.crpUrechargelistService.getCrpUrechargelistByCode(tenantCode, urechargelistCode);
        if (null == crpUrechargelist || StringUtils.isBlank((String)crpUrechargelist.getUrechargeCode())) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.getCrpUrechargeByCode(tenantCode, crpUrechargelist.getUrechargeCode());
        if (null == crpUrecharge) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl\u6570\u636e\u4e3a\u7a7a1");
        }
        crpUrecharge.setRechargeSmoney(rechargeSmoney);
        ArrayList<CrpUrecharge> crpUrechargeList = new ArrayList<CrpUrecharge>();
        this.updateCrpModel(crpUrecharge);
        crpUrechargeList.add(crpUrecharge);
        return this.buidPmChannelsend(crpUrechargeList, "edit");
    }

    @Override
    public void autoSend() {
        this.loadDb(null);
    }

    private void loadDb(Map<String, Object> map) {
        try {
            HashMap<String, Object> objMap = new HashMap<String, Object>();
            if (null != map && null != map.get("userinfoCode") || null != map.get("tenantCode")) {
                objMap.put("userinfoCode", map.get("userinfoCode"));
                objMap.put("tenantCode", map.get("tenantCode"));
            }
            objMap.put("order", true);
            objMap.put("dataState", 0);
            objMap.put("orderStr", "STR_TO_DATE(RECHARGE_NAME4,'%Y-%m-%d') asc");
            objMap.put("rechargeName4Str", "date");
            int startRow = 0;
            boolean flag = true;
            QueryResult<CrpUrecharge> result = null;
            do {
                startRow = CrpUrechargeServiceImpl.getSendService().getStartRow();
                objMap.put("startRow", startRow);
                objMap.put("rows", CrpUrechargeServiceImpl.getSendService().getPage());
                result = this.queryCrpUrechargePage(objMap);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    CrpUrechargeServiceImpl.getSendService().addPutPool(new SendPutThread(CrpUrechargeServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != CrpUrechargeServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(100L);
            } while (flag);
            CrpUrechargeServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((CrpUrechargeBaseService)SpringApplicationContextUtil.getBean((String)"crpUrechargeBaseService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargemonery(CrpUrecharge crpUrecharge) throws ApiException {
        Integer n;
        Integer count;
        if (null == crpUrecharge) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImplupdateCrpUrechargemonery.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (crpUrecharge.getRechargeSmoney().compareTo(crpUrecharge.getAllMoney()) == 0 || StringUtils.isBlank((String)crpUrecharge.getRechargeName10())) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpUrechargemonery", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrecharge));
            return null;
        }
        BigDecimal money = new BigDecimal(crpUrecharge.getRechargeName10());
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("merchantCode", crpUrecharge.getUserinfoCode());
        goodsMap.put("faccountType", "101");
        goodsMap.put("tenantCode", crpUrecharge.getTenantCode());
        map.put("map", JsonUtil.buildNonNullBinder().toJson(goodsMap));
        QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
        if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpUrechargemonery.null", (Object)((Object)map).toString());
            return null;
        }
        VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
        HashMap<String, String> vdMap = new HashMap<String, String>();
        HashMap<String, String> sendVdMap = new HashMap<String, String>();
        vdMap.put("faccountOuterNo", vdFaccountOuter.getFaccountOuterNo());
        vdMap.put("fundType", "01");
        vdMap.put("tenantCode", crpUrecharge.getTenantCode());
        sendVdMap.put("map", JsonUtil.buildNonNullBinder().toJson(vdMap));
        QueryResult subsetQueryResult = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterSubsetPage", map, VdFaccountOuterSubset.class);
        if (EmptyUtil.isEmpty((Object)subsetQueryResult) || ListUtil.isEmpty((Collection)subsetQueryResult.getList())) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpUrechargemonery.null", (Object)((Object)sendVdMap).toString());
            return null;
        }
        VdFaccountOuterSubset vdFaccountOuterSubset = (VdFaccountOuterSubset)subsetQueryResult.getList().get(0);
        if (null == vdFaccountOuterSubset.getFaccountAmount()) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpUrechargemonery.null", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountOuterSubset));
            return null;
        }
        BigDecimal surplusMoney = vdFaccountOuterSubset.getFaccountAmount().subtract(money);
        Integer i = 3;
        map = new HashMap();
        map.put("tenantCode", crpUrecharge.getTenantCode());
        map.put("urechargeCode", crpUrecharge.getUrechargeCode());
        map.put("gmtModified", crpUrecharge.getGmtModified());
        map.put("rechargeName10", crpUrecharge.getRechargeName10());
        if (vdFaccountOuterSubset.getFaccountAmount().compareTo(money) < 0) {
            surplusMoney = money.subtract(vdFaccountOuterSubset.getFaccountAmount());
            crpUrecharge.setRechargeName10(surplusMoney.toString());
            vdFaccountOuterSubset.setFaccountAmount(BigDecimal.ZERO);
            count = this.updateCrpModeByModified(map);
            if (count <= 0 && i > 0) {
                n = i;
                Integer n2 = i = Integer.valueOf(i - 1);
                this.updateCrpUrechargemonery(this.getCrpUrecharge(crpUrecharge.getUrechargeId()));
            }
        } else {
            crpUrecharge.setRechargeName10(String.valueOf(0));
            vdFaccountOuterSubset.setFaccountAmount(surplusMoney);
            map.put("rechargeName10", crpUrecharge.getRechargeName10());
            count = this.updateCrpModeByModified(map);
            if (count <= 0 && i > 0) {
                n = i;
                Integer n3 = i = Integer.valueOf(i - 1);
                this.updateCrpUrechargemonery(this.getCrpUrecharge(crpUrecharge.getUrechargeId()));
            }
            this.updateStateCrpModelByCode(crpUrecharge.getTenantCode(), crpUrecharge.getUrechargeCode(), 6, 0, null);
        }
        CrpUrechargelistDomain crpUrechargelist = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelist, (Object)crpUrecharge);
            crpUrechargelist.setFundType("01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelist);
        HashMap<String, String> outSubMap = new HashMap<String, String>();
        outSubMap.put("vdFaccountOuterSubsetDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuterSubset));
        this.getInternalRouter().inInvoke("vd.faccountOuter.updateFaccountOuterSubset", outSubMap);
        return null;
    }

    @Override
    public CrpUrecharge queryCrpURechargeMoney(Map<String, Object> map) {
        try {
            return this.crpUrechargeMapper.queryCrpURechargeMoney(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.queryCrpURechargeMoney", (Throwable)e);
            return null;
        }
    }

    @Override
    public String updateCrpUrechargemoneryByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || null == map.get("userinfoCode")) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpUrechargemoneryByCode", map);
            return "error";
        }
        this.loadDb(map);
        return "success";
    }

    @Override
    public String updateRefundmoneryByCode(CrpUrechargelistDomain crpUrechargelistDomain) {
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeName9())) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelistDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("rechargeOpno", crpUrechargelistDomain.getRechargeOpno());
        map.put("urechargelistDir", crpUrechargelistDomain.getUrechargelistDir());
        QueryResult<CrpUrechargelist> queryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode", (Object)"queryResult is null");
            return "error";
        }
        CrpUrechargelist crpUrechargelist = (CrpUrechargelist)queryResult.getList().get(0);
        if (StringUtils.isBlank((String)crpUrechargelist.getRechargeName10()) || StringUtils.isBlank((String)crpUrechargelist.getRechargeOpno2())) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode.crpUrechargelist", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelist));
            return "error";
        }
        BigDecimal money = new BigDecimal(crpUrechargelist.getRechargeName10());
        BigDecimal allMoney = new BigDecimal(crpUrechargelist.getRechargeOpno2());
        BigDecimal refundMoney = new BigDecimal(crpUrechargelist.getRechargeName9());
        BigDecimal refundSmoney = refundMoney.divide(allMoney).setScale(2, RoundingMode.HALF_UP).multiply(money);
        crpUrechargelist.setUrechargelistId(null);
        crpUrechargelist.setUrechargelistCode(null);
        CrpUrechargelistDomain crpUrechargelistDomain1 = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain1, (Object)crpUrechargelist);
            crpUrechargelistDomain1.setUrechargelistDir("0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CrpUrecharge crpUrecharge = this.getCrpUrechargeByCode(crpUrechargelist.getTenantCode(), crpUrechargelist.getUrechargeCode());
        if (null == crpUrecharge) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode.crpUrecharge", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelist));
            return "error";
        }
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain1);
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(refundSmoney));
        this.updateCrpModel(crpUrecharge);
        return "success";
    }

    private Integer updateCrpModeByModified(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByCodeAndModified(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrecharges(Map<String, Object> map, BigDecimal money) throws ApiException {
        CrpUrecharge urecharge;
        if (MapUtil.isEmpty(map) || null == money || "".equals(money) || null != map.get("rechargeOpcode") || null != map.get("rechargeRemark")) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImplupdateCrpUrecharges.urechargePage", JsonUtil.buildNonNullBinder().toJson(map) + "," + money);
        }
        String contractBillcode = map.get("rechargeOpcode").toString();
        String rechargeRemark = map.get("rechargeRemark").toString();
        BigDecimal payMoney = new BigDecimal(map.get("money").toString());
        map.remove("rechargeOpcode");
        map.remove("money");
        Boolean flags = true;
        Integer i = 0;
        do {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            QueryResult<CrpUrecharge> urechargePage = this.queryCrpUrechargePage(map);
            if (null == urechargePage || ListUtil.isEmpty((Collection)urechargePage.getList())) {
                throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail.urechargePage", JsonUtil.buildNonNullBinder().toJson(map) + "," + money);
            }
            urecharge = (CrpUrecharge)urechargePage.getList().get(0);
            BigDecimal newMoney = urecharge.getRechargeSmoney().subtract(money);
            if (newMoney.compareTo(BigDecimal.ZERO) <= 0) {
                newMoney = BigDecimal.ZERO;
                money = urecharge.getRechargeSmoney();
            }
            urecharge.setRechargeSmoney(newMoney);
            urecharge.setRechargeName10(money.toString());
            CrpUrecharge crpUrecha = this.getCrpUrecharge(urecharge.getUrechargeId());
            BigDecimal oldAllMoney = BigDecimal.ZERO;
            if (StringUtils.isNotBlank((String)crpUrecha.getRechargeName10())) {
                oldAllMoney = new BigDecimal(crpUrecha.getRechargeName10());
            }
            if (StringUtils.isBlank((String)crpUrecha.getRechargeName10())) {
                crpUrecha.setRechargeName10("0");
            }
            oldAllMoney = oldAllMoney.add(new BigDecimal(crpUrecha.getRechargeName10()));
            urecharge.setRechargeName10(oldAllMoney.toString());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (StringUtils.isBlank((String)urecharge.getRechargeUrl4())) {
                hashMap.put("rechargeUrl4Str", "1");
            } else {
                Integer integer = Integer.valueOf(urecharge.getRechargeUrl4());
                integer = integer + 1;
                hashMap.put("rechargeUrl4Str", integer.toString());
            }
            hashMap.put("tenantCode", urecharge.getTenantCode());
            hashMap.put("rechargeSmoney", urecharge.getRechargeSmoney());
            hashMap.put("rechargeName10", urecharge.getRechargeName10());
            hashMap.put("urechargeCode", urecharge.getUrechargeCode());
            hashMap.put("rechargeUrl4", urecharge.getRechargeUrl4());
            Integer count = this.updateCrpModeByModified(hashMap);
            if (count < 1 && i > 80) {
                throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail", JsonUtil.buildNonNullBinder().toJson(hashMap));
            }
            if (count <= 0) continue;
            flags = false;
        } while (flags.booleanValue());
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("contractBillcode", contractBillcode);
        objectMap.put("tenantCode", map.get("tenantCode"));
        if ("sgSendgoods".equals(rechargeRemark) && null != map.get("sendGoods")) {
            SgSendgoodsReDomain sendgoodsReDomain = (SgSendgoodsReDomain)map.get("sendGoods");
            if (null == sendgoodsReDomain) {
                throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpUrecharges.sendgoodsReDomain", JsonUtil.buildNonNullBinder().toJson(map));
            }
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sendgoodsReDomain));
            this.getInternalRouter().inInvoke("sg.sendgoods.updateSendgoods", objectMap);
        }
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)urecharge);
            crpUrechargelistDomain.setUrechargelistDir("1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
    }

    @Override
    public String updateCrpUrechargesToOrder(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || null == map.get("crpUrechargelist") || "".equals(map.get("crpUrechargelist")) || null == map.get("crpUrechargelistCopy") || "".equals(map.get("crpUrechargelistCopy"))) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImplupdateCrpUrechargesToOrder.map", JsonUtil.buildNonNullBinder().toJson(map));
        }
        String crpUrechargelist = JsonUtil.buildNonDefaultBinder().toJson(map.get("crpUrechargelist"));
        CrpUrechargelist crpUrechargelist1 = (CrpUrechargelist)JsonUtil.buildNonDefaultBinder().getJsonToObject(crpUrechargelist, CrpUrechargelist.class);
        String crpUrechargelistCopy = JsonUtil.buildNonDefaultBinder().toJson(map.get("crpUrechargelistCopy"));
        CrpUrechargelist crpUrechargelistCopy1 = (CrpUrechargelist)JsonUtil.buildNonDefaultBinder().getJsonToObject(crpUrechargelistCopy, CrpUrechargelist.class);
        String uMoney = crpUrechargelistCopy1.getRechargeUrl4();
        if (StringUtils.isBlank((String)uMoney)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail", JsonUtil.buildNonNullBinder().toJson(map));
        }
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        crpMap.put("tenantCode", crpUrechargelist1.getTenantCode());
        crpMap.put("urechargeCode", crpUrechargelist1.getUrechargeCode());
        crpMap.put("rechargeType", crpUrechargelist1.getRechargeType());
        crpMap.put("userinfoCode", crpUrechargelist1.getUserinfoCode());
        Boolean flags = true;
        Integer i = 0;
        do {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            QueryResult<CrpUrecharge> urechargePage = this.queryCrpUrechargePage(crpMap);
            if (null == urechargePage || ListUtil.isEmpty((Collection)urechargePage.getList())) {
                throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail.urechargePage", JsonUtil.buildNonNullBinder().toJson(crpMap));
            }
            CrpUrecharge urecharge = (CrpUrecharge)urechargePage.getList().get(0);
            BigDecimal newMoney = urecharge.getRechargeSmoney().subtract(new BigDecimal(uMoney));
            if (newMoney.compareTo(BigDecimal.ZERO) < 0) {
                throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail.urechargePage1", JsonUtil.buildNonNullBinder().toJson(map) + newMoney);
            }
            urecharge.setRechargeSmoney(newMoney);
            CrpUrecharge crpUrecha = this.getCrpUrecharge(urecharge.getUrechargeId());
            BigDecimal oldAllMoney = BigDecimal.ZERO;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (StringUtils.isBlank((String)urecharge.getRechargeUrl4())) {
                hashMap.put("rechargeUrl4Str", "1");
            } else {
                Integer integer = Integer.valueOf(urecharge.getRechargeUrl4());
                integer = integer + 1;
                hashMap.put("rechargeUrl4Str", integer.toString());
            }
            hashMap.put("tenantCode", urecharge.getTenantCode());
            hashMap.put("rechargeSmoney", urecharge.getRechargeSmoney());
            hashMap.put("urechargeCode", urecharge.getUrechargeCode());
            hashMap.put("rechargeUrl4", urecharge.getRechargeUrl4());
            Integer count = this.updateCrpModeByModified(hashMap);
            if (count < 1 && i > 80) {
                throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail", JsonUtil.buildNonNullBinder().toJson(hashMap));
            }
            if (count <= 0) continue;
            flags = false;
        } while (flags.booleanValue());
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)crpUrechargelistCopy1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        return "success";
    }

    static {
        lock = new Object();
    }
}

