/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.utils;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

@Service
public class RedisUtilService {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private static Long lockExpirseTimeout = 10000L;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String IDEMPOTENT_TOKEN_PREFIX = "idempotent_token:";

    public String get(String key) {
        Object obj = this.redisTemplate.boundValueOps((Object)key).get();
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public void set(String key, String value) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)value);
    }

    public void set(String key, String value, Long time, TimeUnit timeUnit) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)value, time.longValue(), timeUnit);
    }

    public Boolean exist(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean setNx(String key, Object value) {
        return this.redisTemplate.boundValueOps((Object)key).setIfAbsent(value);
    }

    public String getAndSet(String key, Object value) {
        Object obj = this.redisTemplate.boundValueOps((Object)key).getAndSet(value);
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public <T> T exeLuaScript(final String luaScript, final List<String> keys, final List<String> args, Class<T> clz) {
        Object t = this.redisTemplate.execute(new RedisCallback<T>(){

            public T doInRedis(RedisConnection redisConnection) throws DataAccessException {
                Object nativeConnection = redisConnection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    return ((JedisCluster)nativeConnection).eval(luaScript.toString(), keys, args);
                }
                if (nativeConnection instanceof Jedis) {
                    return ((Jedis)nativeConnection).eval(luaScript.toString(), keys, args);
                }
                return null;
            }
        });
        if (t == null) {
            throw new RuntimeException("redis model doesn't support luascript");
        }
        return (T)t;
    }

    public boolean trylock(String lockKey, String lockValue, Long lockWaitTimeout, Long lockExpirseTimeout) {
        int timeout = lockWaitTimeout.intValue();
        while (timeout >= 0) {
            String oldLockTimeStr;
            String expireTimeout = String.valueOf(lockExpirseTimeout / 1000L);
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(lockKey);
            ArrayList<String> args = new ArrayList<String>();
            args.add(lockValue);
            args.add(expireTimeout);
            String lockLuaScript = this.setNxLuaScript();
            Long exeResult = this.exeLuaScript(lockLuaScript, keys, args, Long.class);
            if (exeResult != null && exeResult.intValue() == 1) {
                return true;
            }
            String lockTimeStr = this.get(lockKey);
            if (lockTimeStr != null && Long.parseLong(lockTimeStr) < System.currentTimeMillis() && (oldLockTimeStr = this.getAndSet(lockKey, lockValue)) != null && oldLockTimeStr.equals(lockTimeStr)) {
                this.set(lockKey, lockValue, Long.valueOf(expireTimeout), TimeUnit.SECONDS);
                return true;
            }
            int sleepTime = new Random().nextInt(10) * 100;
            timeout -= sleepTime;
            try {
                this.logger.info("\u83b7\u53d6redis\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0csleep\uff1a{}ms\u540e\u91cd\u65b0\u83b7\u53d6", (Object)sleepTime);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean lock(String lockKey) {
        String oldLockTimeStr;
        Long expires = System.currentTimeMillis() + lockExpirseTimeout + 1L;
        String expiresStr = String.valueOf(expires);
        String expireTimeout = String.valueOf(lockExpirseTimeout / 1000L);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(lockKey);
        ArrayList<String> args = new ArrayList<String>();
        args.add(expiresStr);
        args.add(expireTimeout);
        String lockLuaScript = this.setNxLuaScript();
        if (this.exeLuaScript(lockLuaScript, keys, args, Long.class) == 1L) {
            return true;
        }
        String lockTimeStr = this.get(lockKey);
        if (lockTimeStr != null && Long.parseLong(lockTimeStr) < System.currentTimeMillis() && (oldLockTimeStr = this.getAndSet(lockKey, expiresStr)) != null && oldLockTimeStr.equals(lockTimeStr)) {
            this.set(lockKey, expiresStr, lockExpirseTimeout / 1000L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public void unlock(String lockKey, String oldValue) {
        String luascript = this.delLuaScript();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(lockKey);
        ArrayList<String> args = new ArrayList<String>();
        args.add(oldValue);
        this.exeLuaScript(luascript, keys, args, Long.class);
    }

    private String delLuaScript() {
        StringBuffer luascript = new StringBuffer();
        luascript.append(" if redis.call('exists',KEYS[1]) == 1 and redis.call('get',KEYS[1]) == ARGV[1] then");
        luascript.append(" redis.call('del',KEYS[1])  return 1");
        luascript.append(" else return 0 end");
        return luascript.toString();
    }

    private String setNxLuaScript() {
        StringBuffer luascript = new StringBuffer();
        luascript.append(" if redis.call('setnx',KEYS[1],ARGV[1]) == 1 then ");
        luascript.append(" redis.call('expire',KEYS[1],ARGV[2]) return 1");
        luascript.append(" else return 0 end");
        return luascript.toString();
    }

    public boolean trylock(String lockKey, String lockValue) {
        Long lockWaitTimeout = 5000L;
        Long lockExpirseTimeout = 10000L;
        Boolean lockFlag = false;
        int i = 0;
        do {
            if (this.trylock(lockKey, lockValue, lockWaitTimeout, lockExpirseTimeout)) continue;
            try {
                this.logger.info("lockFlagNum:", (Object)i++);
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            lockFlag = true;
        } while (lockFlag.booleanValue());
        return false;
    }

    public String generateToken(String value) {
        String token = UUID.randomUUID().toString();
        String key = IDEMPOTENT_TOKEN_PREFIX + token;
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        return token;
    }

    public boolean validToken(String token, String value) {
        String script = "if redis.call('get', KEYS[1]) == KEYS[2] then return redis.call('del', KEYS[1]) else return 0 end";
        DefaultRedisScript redisScript = new DefaultRedisScript(script, Long.class);
        String key = IDEMPOTENT_TOKEN_PREFIX + token;
        Long result = (Long)this.redisTemplate.execute((RedisScript)redisScript, Arrays.asList(key, value), new Object[0]);
        if (result != null && result != 0L) {
            this.logger.info("\u9a8c\u8bc1 token={},key={},value={} \u6210\u529f", (Object)("token:" + token + "key:" + key + "value" + value));
            return true;
        }
        this.logger.info("\u9a8c\u8bc1 token={},key={},value={} \u5931\u8d25", (Object)("token:" + token + "key:" + key + "value" + value));
        return false;
    }
}

