/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.common;

import com.google.common.collect.Lists;
import com.yqbsoft.laser.service.data.common.DaSalesSettleDetailsModel;
import com.yqbsoft.laser.service.data.common.DaSalesSettleModel;
import com.yqbsoft.laser.service.data.common.Excel;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelUtil {
    private static final String GET = "get";
    private static final String SET = "set";

    public static <T> Map<String, Object> excelFileToObject(String fileUrl, Class<DaSalesSettleDetailsModel> daSalesSettleDetailsModel, Class<DaSalesSettleModel> daSalesSettleModel) throws IOException, IllegalAccessException, InstantiationException, InvalidFormatException {
        String methodName;
        String endName;
        String startName;
        Excel excel;
        Field[] daFields;
        if (StringUtils.isBlank((String)fileUrl)) {
            throw new NullPointerException("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<Integer, String> methodMap = new HashMap<Integer, String>();
        HashMap<Integer, String> startRowNameMap = new HashMap<Integer, String>();
        HashMap<Integer, Boolean> fieldIsMustMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, String> daDetailsMethodMap = new HashMap<Integer, String>();
        HashMap<Integer, String> daDetailsStartRowNameMap = new HashMap<Integer, String>();
        HashMap<Integer, Boolean> daDetailsFieldIsMustMap = new HashMap<Integer, Boolean>();
        Field[] daDetailsFields = daSalesSettleDetailsModel.getDeclaredFields();
        for (Field field : daFields = daSalesSettleModel.getDeclaredFields()) {
            excel = field.getAnnotation(Excel.class);
            if (excel == null) continue;
            startName = field.getName().substring(0, 1);
            endName = field.getName().substring(1, field.getName().length());
            methodName = new StringBuffer(SET).append(startName.toUpperCase()).append(endName).toString();
            methodMap.put(excel.index(), methodName);
            startRowNameMap.put(excel.index(), excel.name());
            fieldIsMustMap.put(excel.index(), excel.isMust());
        }
        System.out.println(fieldIsMustMap);
        System.out.println(daDetailsFieldIsMustMap);
        for (Field field : daDetailsFields) {
            excel = field.getAnnotation(Excel.class);
            if (excel == null) continue;
            startName = field.getName().substring(0, 1);
            endName = field.getName().substring(1, field.getName().length());
            methodName = new StringBuffer(SET).append(startName.toUpperCase()).append(endName).toString();
            daDetailsMethodMap.put(excel.index(), methodName);
            daDetailsStartRowNameMap.put(excel.index(), excel.name());
            daDetailsFieldIsMustMap.put(excel.index(), excel.isMust());
        }
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(new File(fileUrl)));
        Sheet sheet = workbook.getSheetAt(0);
        Row sheetRow = sheet.getRow(0);
        sheet.removeRow(sheetRow);
        ArrayList<DaSalesSettleDetailsModel> daDetailsList = new ArrayList<DaSalesSettleDetailsModel>();
        ArrayList<DaSalesSettleModel> daList = new ArrayList<DaSalesSettleModel>();
        int lastRowNum = sheet.getLastRowNum();
        System.out.println(lastRowNum);
        System.out.println(lastRowNum - 1);
        System.out.println(lastRowNum - 1);
        int i = 0;
        for (Row row : sheet) {
            Class<?> excelModelClass;
            Object obj;
            if (++i == lastRowNum - 1) continue;
            if (i <= lastRowNum - 2) {
                if (row == null || !ExcelUtil.checkRow(row)) continue;
                obj = daSalesSettleDetailsModel.newInstance();
                excelModelClass = obj.getClass();
                daDetailsStartRowNameMap.entrySet().forEach(x -> {
                    Integer index = (Integer)x.getKey();
                    Cell cell = row.getCell(index.intValue());
                    String methodName = (String)daDetailsMethodMap.get(index);
                    if (StringUtils.isEmpty((String)methodName)) {
                        return;
                    }
                    List methods = Lists.newArrayList((Object[])excelModelClass.getMethods()).stream().filter(m -> m.getName().startsWith(SET)).collect(Collectors.toList());
                    String rowName = (String)daDetailsStartRowNameMap.get(index);
                    for (Method method : methods) {
                        String value;
                        if (!method.getName().startsWith(methodName) || !StringUtils.isNotBlank((String)(value = ExcelUtil.valueCheck(cell, rowName, (Boolean)fieldIsMustMap.get(index))))) continue;
                        ExcelUtil.methodInvokeHandler(obj, method, value);
                    }
                });
                daDetailsList.add((DaSalesSettleDetailsModel)obj);
                continue;
            }
            if (row == null || !ExcelUtil.checkRow(row)) continue;
            obj = daSalesSettleModel.newInstance();
            excelModelClass = obj.getClass();
            startRowNameMap.entrySet().forEach(x -> {
                Integer index = (Integer)x.getKey();
                Cell cell = row.getCell(index.intValue());
                String methodName = (String)methodMap.get(index);
                if (StringUtils.isEmpty((String)methodName)) {
                    return;
                }
                List methods = Lists.newArrayList((Object[])excelModelClass.getMethods()).stream().filter(m -> m.getName().startsWith(SET)).collect(Collectors.toList());
                String rowName = (String)startRowNameMap.get(index);
                for (Method method : methods) {
                    String value;
                    if (!method.getName().startsWith(methodName) || !StringUtils.isNotBlank((String)(value = ExcelUtil.valueCheck(cell, rowName, (Boolean)fieldIsMustMap.get(index))))) continue;
                    ExcelUtil.methodInvokeHandler(obj, method, value);
                }
            });
            daList.add((DaSalesSettleModel)obj);
        }
        result.put("daDetailsList", JsonUtil.buildNormalBinder().toJson(daDetailsList));
        result.put("daList", JsonUtil.buildNormalBinder().toJson(daList));
        return result;
    }

    private static String valueCheck(Cell cell, String rowName, Boolean isMust) {
        if (cell == null && isMust.booleanValue()) {
            throw new RuntimeException("excel\u6821\u9a8c\u5931\u8d25,\u3010" + rowName + "\u3011\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (cell == null) {
            return null;
        }
        cell.setCellType(1);
        String value = cell.getStringCellValue();
        System.out.println(value);
        value = value.replace("`", "");
        System.out.println(value);
        return value;
    }

    private static void methodInvokeHandler(Object obj, Method method, String value) {
        Class<?> parameterType = method.getParameterTypes()[0];
        try {
            if (parameterType == null) {
                method.invoke(obj, new Object[0]);
                return;
            }
            String name = parameterType.getName();
            if (name.equals(String.class.getName())) {
                method.invoke(obj, value);
                return;
            }
            if (name.equals(Long.class.getName())) {
                method.invoke(obj, Long.valueOf(value));
                return;
            }
            if (name.equals(Double.class.getName())) {
                method.invoke(obj, Double.valueOf(value));
            }
            if (name.equals(Integer.class.getName())) {
                method.invoke(obj, Integer.parseInt(value));
            }
            if (name.equals(Date.class.getName())) {
                try {
                    method.invoke(obj, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (name.equals(BigDecimal.class.getName())) {
                method.invoke(obj, new BigDecimal(value));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static boolean checkRow(Row row) {
        try {
            if (row == null) {
                return false;
            }
            short firstCellNum = row.getFirstCellNum();
            short lastCellNum = row.getLastCellNum();
            if (firstCellNum < 0 && lastCellNum < 0) {
                return false;
            }
            if (firstCellNum != 0) {
                for (short i = firstCellNum; i < lastCellNum; i = (short)(i + 1)) {
                    Cell cell = row.getCell((int)i);
                    String cellValue = cell.getStringCellValue();
                    if (StringUtils.isBlank((String)cellValue)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void main(String[] args) {
        System.out.println("17.0".substring(0, "17.0".indexOf(".")));
    }
}

