/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaStoreErpMapper;
import com.yqbsoft.laser.service.data.domain.DaStoreErpDomain;
import com.yqbsoft.laser.service.data.domain.DaStoreErpReDomain;
import com.yqbsoft.laser.service.data.model.DaStoreErp;
import com.yqbsoft.laser.service.data.service.DaStoreErpService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaStoreErpServiceImpl
extends BaseServiceImpl
implements DaStoreErpService {
    private static final String SYS_CODE = SYS_CODE + ".DaStoreErpServiceImpl";
    private DaStoreErpMapper daStoreErpMapper;

    public void setDaStoreErpMapper(DaStoreErpMapper daStoreErpMapper) {
        this.daStoreErpMapper = daStoreErpMapper;
    }

    private Date getSysDate() {
        try {
            return this.daStoreErpMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreErp(DaStoreErpDomain daStoreErpDomain) {
        if (null == daStoreErpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daStoreErpDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreErpDefault(DaStoreErp daStoreErp) {
        if (null == daStoreErp) {
            return;
        }
        if (null == daStoreErp.getDataState()) {
            daStoreErp.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daStoreErp.getGmtCreate()) {
            daStoreErp.setGmtCreate(date);
        }
        daStoreErp.setGmtModified(date);
        if (StringUtils.isBlank((String)daStoreErp.getStoreErpCode())) {
            daStoreErp.setStoreErpCode(this.getNo(null, "DaStoreErp", "daStoreErp", daStoreErp.getTenantCode()));
        }
    }

    private int getStoreErpMaxCode() {
        int code = 0;
        try {
            return this.daStoreErpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreErpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreErpUpdataDefault(DaStoreErp daStoreErp) {
        if (null == daStoreErp) {
            return;
        }
        daStoreErp.setGmtModified(this.getSysDate());
    }

    private void saveStoreErpModel(DaStoreErp daStoreErp) throws ApiException {
        if (null == daStoreErp) {
            return;
        }
        try {
            this.daStoreErpMapper.insert(daStoreErp);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveStoreErpModel.ex", (Throwable)e);
        }
    }

    private void saveStoreErpBatchModel(List<DaStoreErp> daStoreErpList) throws ApiException {
        if (null == daStoreErpList || daStoreErpList.isEmpty()) {
            return;
        }
        try {
            this.daStoreErpMapper.insertBatch(daStoreErpList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveStoreErpBatchModel.ex", (Throwable)e);
        }
    }

    private DaStoreErp getStoreErpModelById(Integer storeErpId) {
        if (null == storeErpId) {
            return null;
        }
        try {
            return this.daStoreErpMapper.selectByPrimaryKey(storeErpId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreErpModelById", (Throwable)e);
            return null;
        }
    }

    private DaStoreErp getStoreErpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daStoreErpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreErpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreErpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreErpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delStoreErpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delStoreErpModelByCode.num");
        }
    }

    private void deleteStoreErpModel(Integer storeErpId) throws ApiException {
        if (null == storeErpId) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreErpMapper.deleteByPrimaryKey(storeErpId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteStoreErpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteStoreErpModel.num");
        }
    }

    private void updateStoreErpModel(DaStoreErp daStoreErp) throws ApiException {
        if (null == daStoreErp) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreErpMapper.updateByPrimaryKey(daStoreErp);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStoreErpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateStoreErpModel.num");
        }
    }

    private void updateStateStoreErpModel(Integer storeErpId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeErpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeErpId", storeErpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreErpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateStoreErpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateStoreErpModel.null");
        }
    }

    private void updateStateStoreErpModelByCode(String tenantCode, String storeErpCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeErpCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeErpCode", storeErpCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreErpMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateStoreErpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateStoreErpModelByCode.null");
        }
    }

    private DaStoreErp makeStoreErp(DaStoreErpDomain daStoreErpDomain, DaStoreErp daStoreErp) {
        if (null == daStoreErpDomain) {
            return null;
        }
        if (null == daStoreErp) {
            daStoreErp = new DaStoreErp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daStoreErp, (Object)daStoreErpDomain);
            return daStoreErp;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeStoreErp", (Throwable)e);
            return null;
        }
    }

    private DaStoreErpReDomain makeDaStoreErpReDomain(DaStoreErp daStoreErp) {
        if (null == daStoreErp) {
            return null;
        }
        DaStoreErpReDomain daStoreErpReDomain = new DaStoreErpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daStoreErpReDomain, (Object)daStoreErp);
            return daStoreErpReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaStoreErpReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaStoreErp> queryStoreErpModelPage(Map<String, Object> parammap) {
        try {
            return this.daStoreErpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryStoreErpModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreErp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daStoreErpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countStoreErp", (Throwable)e);
        }
        return i;
    }

    private DaStoreErp createDaStoreErp(DaStoreErpDomain daStoreErpDomain) {
        String msg = this.checkStoreErp(daStoreErpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveStoreErp.checkStoreErp", msg);
        }
        DaStoreErp daStoreErp = this.makeStoreErp(daStoreErpDomain, null);
        this.setStoreErpDefault(daStoreErp);
        return daStoreErp;
    }

    @Override
    public String saveStoreErp(DaStoreErpDomain daStoreErpDomain) throws ApiException {
        DaStoreErp daStoreErp = this.createDaStoreErp(daStoreErpDomain);
        this.saveStoreErpModel(daStoreErp);
        return daStoreErp.getStoreErpCode();
    }

    @Override
    public String saveStoreErpBatch(List<DaStoreErpDomain> daStoreErpDomainList) throws ApiException {
        if (null == daStoreErpDomainList || daStoreErpDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaStoreErp> daStoreErpList = new ArrayList<DaStoreErp>();
        String code = "";
        for (DaStoreErpDomain daStoreErpDomain : daStoreErpDomainList) {
            DaStoreErp daStoreErp = this.createDaStoreErp(daStoreErpDomain);
            code = daStoreErp.getStoreErpCode();
            daStoreErpList.add(daStoreErp);
        }
        this.saveStoreErpBatchModel(daStoreErpList);
        return code;
    }

    @Override
    public void updateStoreErpState(Integer storeErpId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeErpId) {
            return;
        }
        this.updateStateStoreErpModel(storeErpId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreErpStateByCode(String tenantCode, String storeErpCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeErpCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoreErpModelByCode(tenantCode, storeErpCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreErp(DaStoreErpDomain daStoreErpDomain) throws ApiException {
        String msg = this.checkStoreErp(daStoreErpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateStoreErp.checkStoreErp", msg);
        }
        DaStoreErp oldDaStoreErp = this.getStoreErpModelById(daStoreErpDomain.getStoreErpId());
        if (null == oldDaStoreErp) {
            throw new ApiException(SYS_CODE + ".updateStoreErp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaStoreErp daStoreErp = this.makeStoreErp(daStoreErpDomain, oldDaStoreErp);
        this.setStoreErpUpdataDefault(daStoreErp);
        this.updateStoreErpModel(daStoreErp);
    }

    @Override
    public DaStoreErp getStoreErp(Integer storeErpId) {
        if (null == storeErpId) {
            return null;
        }
        return this.getStoreErpModelById(storeErpId);
    }

    @Override
    public void deleteStoreErp(Integer storeErpId) throws ApiException {
        if (null == storeErpId) {
            return;
        }
        this.deleteStoreErpModel(storeErpId);
    }

    @Override
    public QueryResult<DaStoreErp> queryStoreErpPage(Map<String, Object> map) {
        List<DaStoreErp> daStoreErpList = this.queryStoreErpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreErp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daStoreErpList);
        return queryResult;
    }

    @Override
    public DaStoreErp getStoreErpByCode(String tenantCode, String storeErpCode) throws ApiException {
        if (StringUtils.isBlank((String)storeErpCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeErpCode", storeErpCode);
        return this.getStoreErpModelByCode(map);
    }

    @Override
    public void deleteStoreErpByCode(String tenantCode, String storeErpCode) throws ApiException {
        if (StringUtils.isBlank((String)storeErpCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeErpCode", storeErpCode);
        this.delStoreErpModelByCode(map);
    }
}

