/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaStoreWmsMapper;
import com.yqbsoft.laser.service.data.domain.DaStoreWmsDomain;
import com.yqbsoft.laser.service.data.domain.DaStoreWmsReDomain;
import com.yqbsoft.laser.service.data.model.DaStoreWms;
import com.yqbsoft.laser.service.data.service.DaStoreWmsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaStoreWmsServiceImpl
extends BaseServiceImpl
implements DaStoreWmsService {
    private static final String SYS_CODE = SYS_CODE + ".DaStoreWmsServiceImpl";
    private DaStoreWmsMapper daStoreWmsMapper;

    public void setDaStoreWmsMapper(DaStoreWmsMapper daStoreWmsMapper) {
        this.daStoreWmsMapper = daStoreWmsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daStoreWmsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreWms(DaStoreWmsDomain daStoreWmsDomain) {
        if (null == daStoreWmsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daStoreWmsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreWmsDefault(DaStoreWms daStoreWms) {
        if (null == daStoreWms) {
            return;
        }
        if (null == daStoreWms.getDataState()) {
            daStoreWms.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daStoreWms.getGmtCreate()) {
            daStoreWms.setGmtCreate(date);
        }
        daStoreWms.setGmtModified(date);
        if (StringUtils.isBlank((String)daStoreWms.getStoreWmsCode())) {
            daStoreWms.setStoreWmsCode(this.getNo(null, "DaStoreWms", "daStoreWms", daStoreWms.getTenantCode()));
        }
    }

    private int getStoreWmsMaxCode() {
        int code = 0;
        try {
            return this.daStoreWmsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreWmsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreWmsUpdataDefault(DaStoreWms daStoreWms) {
        if (null == daStoreWms) {
            return;
        }
        daStoreWms.setGmtModified(this.getSysDate());
    }

    private void saveStoreWmsModel(DaStoreWms daStoreWms) throws ApiException {
        if (null == daStoreWms) {
            return;
        }
        try {
            this.daStoreWmsMapper.insert(daStoreWms);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveStoreWmsModel.ex", (Throwable)e);
        }
    }

    private void saveStoreWmsBatchModel(List<DaStoreWms> daStoreWmsList) throws ApiException {
        if (null == daStoreWmsList || daStoreWmsList.isEmpty()) {
            return;
        }
        try {
            this.daStoreWmsMapper.insertBatch(daStoreWmsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveStoreWmsBatchModel.ex", (Throwable)e);
        }
    }

    private DaStoreWms getStoreWmsModelById(Integer storeWmsId) {
        if (null == storeWmsId) {
            return null;
        }
        try {
            return this.daStoreWmsMapper.selectByPrimaryKey(storeWmsId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreWmsModelById", (Throwable)e);
            return null;
        }
    }

    private DaStoreWms getStoreWmsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daStoreWmsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreWmsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreWmsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreWmsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delStoreWmsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delStoreWmsModelByCode.num");
        }
    }

    private void deleteStoreWmsModel(Integer storeWmsId) throws ApiException {
        if (null == storeWmsId) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreWmsMapper.deleteByPrimaryKey(storeWmsId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteStoreWmsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteStoreWmsModel.num");
        }
    }

    private void updateStoreWmsModel(DaStoreWms daStoreWms) throws ApiException {
        if (null == daStoreWms) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreWmsMapper.updateByPrimaryKey(daStoreWms);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStoreWmsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateStoreWmsModel.num");
        }
    }

    private void updateStateStoreWmsModel(Integer storeWmsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeWmsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeWmsId", storeWmsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreWmsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateStoreWmsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateStoreWmsModel.null");
        }
    }

    private void updateStateStoreWmsModelByCode(String tenantCode, String storeWmsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeWmsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeWmsCode", storeWmsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreWmsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateStoreWmsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateStoreWmsModelByCode.null");
        }
    }

    private DaStoreWms makeStoreWms(DaStoreWmsDomain daStoreWmsDomain, DaStoreWms daStoreWms) {
        if (null == daStoreWmsDomain) {
            return null;
        }
        if (null == daStoreWms) {
            daStoreWms = new DaStoreWms();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daStoreWms, (Object)daStoreWmsDomain);
            return daStoreWms;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeStoreWms", (Throwable)e);
            return null;
        }
    }

    private DaStoreWmsReDomain makeDaStoreWmsReDomain(DaStoreWms daStoreWms) {
        if (null == daStoreWms) {
            return null;
        }
        DaStoreWmsReDomain daStoreWmsReDomain = new DaStoreWmsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daStoreWmsReDomain, (Object)daStoreWms);
            return daStoreWmsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaStoreWmsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaStoreWms> queryStoreWmsModelPage(Map<String, Object> parammap) {
        try {
            return this.daStoreWmsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryStoreWmsModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreWms(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daStoreWmsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countStoreWms", (Throwable)e);
        }
        return i;
    }

    private DaStoreWms createDaStoreWms(DaStoreWmsDomain daStoreWmsDomain) {
        String msg = this.checkStoreWms(daStoreWmsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveStoreWms.checkStoreWms", msg);
        }
        DaStoreWms daStoreWms = this.makeStoreWms(daStoreWmsDomain, null);
        this.setStoreWmsDefault(daStoreWms);
        return daStoreWms;
    }

    @Override
    public String saveStoreWms(DaStoreWmsDomain daStoreWmsDomain) throws ApiException {
        DaStoreWms daStoreWms = this.createDaStoreWms(daStoreWmsDomain);
        this.saveStoreWmsModel(daStoreWms);
        return daStoreWms.getStoreWmsCode();
    }

    @Override
    public String saveStoreWmsBatch(List<DaStoreWmsDomain> daStoreWmsDomainList) throws ApiException {
        if (null == daStoreWmsDomainList || daStoreWmsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaStoreWms> daStoreWmsList = new ArrayList<DaStoreWms>();
        String code = "";
        for (DaStoreWmsDomain daStoreWmsDomain : daStoreWmsDomainList) {
            DaStoreWms daStoreWms = this.createDaStoreWms(daStoreWmsDomain);
            code = daStoreWms.getStoreWmsCode();
            daStoreWmsList.add(daStoreWms);
        }
        this.saveStoreWmsBatchModel(daStoreWmsList);
        return code;
    }

    @Override
    public void updateStoreWmsState(Integer storeWmsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeWmsId) {
            return;
        }
        this.updateStateStoreWmsModel(storeWmsId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreWmsStateByCode(String tenantCode, String storeWmsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeWmsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoreWmsModelByCode(tenantCode, storeWmsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreWms(DaStoreWmsDomain daStoreWmsDomain) throws ApiException {
        String msg = this.checkStoreWms(daStoreWmsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateStoreWms.checkStoreWms", msg);
        }
        DaStoreWms oldDaStoreWms = this.getStoreWmsModelById(daStoreWmsDomain.getStoreWmsId());
        if (null == oldDaStoreWms) {
            throw new ApiException(SYS_CODE + ".updateStoreWms.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaStoreWms daStoreWms = this.makeStoreWms(daStoreWmsDomain, oldDaStoreWms);
        this.setStoreWmsUpdataDefault(daStoreWms);
        this.updateStoreWmsModel(daStoreWms);
    }

    @Override
    public DaStoreWms getStoreWms(Integer storeWmsId) {
        if (null == storeWmsId) {
            return null;
        }
        return this.getStoreWmsModelById(storeWmsId);
    }

    @Override
    public void deleteStoreWms(Integer storeWmsId) throws ApiException {
        if (null == storeWmsId) {
            return;
        }
        this.deleteStoreWmsModel(storeWmsId);
    }

    @Override
    public QueryResult<DaStoreWms> queryStoreWmsPage(Map<String, Object> map) {
        List<DaStoreWms> daStoreWmsList = this.queryStoreWmsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreWms(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daStoreWmsList);
        return queryResult;
    }

    @Override
    public DaStoreWms getStoreWmsByCode(String tenantCode, String storeWmsCode) throws ApiException {
        if (StringUtils.isBlank((String)storeWmsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeWmsCode", storeWmsCode);
        return this.getStoreWmsModelByCode(map);
    }

    @Override
    public void deleteStoreWmsByCode(String tenantCode, String storeWmsCode) throws ApiException {
        if (StringUtils.isBlank((String)storeWmsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeWmsCode", storeWmsCode);
        this.delStoreWmsModelByCode(map);
    }
}

