/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaPayableMapper;
import com.yqbsoft.laser.service.data.domain.DaPayableDomain;
import com.yqbsoft.laser.service.data.domain.DaPayableReDomain;
import com.yqbsoft.laser.service.data.model.DaPayable;
import com.yqbsoft.laser.service.data.service.DaPayableService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaPayableServiceImpl
extends BaseServiceImpl
implements DaPayableService {
    private static final String SYS_CODE = "da.DaPayableServiceImpl";
    private DaPayableMapper daPayableMapper;

    public void setDaPayableMapper(DaPayableMapper daPayableMapper) {
        this.daPayableMapper = daPayableMapper;
    }

    private Date getSysDate() {
        try {
            return this.daPayableMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPayable(DaPayableDomain daPayableDomain) {
        if (null == daPayableDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daPayableDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPayableDefault(DaPayable daPayable) {
        if (null == daPayable) {
            return;
        }
        if (null == daPayable.getDataState()) {
            daPayable.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daPayable.getGmtCreate()) {
            daPayable.setGmtCreate(date);
        }
        daPayable.setGmtModified(date);
        if (StringUtils.isBlank((String)daPayable.getPayableCode())) {
            daPayable.setPayableCode(this.getNo(null, "DaPayable", "daPayable", daPayable.getTenantCode()));
        }
    }

    private int getPayableMaxCode() {
        int code = 0;
        try {
            return this.daPayableMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.getPayableMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPayableUpdataDefault(DaPayable daPayable) {
        if (null == daPayable) {
            return;
        }
        daPayable.setGmtModified(this.getSysDate());
    }

    private void savePayableModel(DaPayable daPayable) throws ApiException {
        if (null == daPayable) {
            return;
        }
        try {
            this.daPayableMapper.insert(daPayable);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.savePayableModel.ex", (Throwable)e);
        }
    }

    private void savePayableBatchModel(List<DaPayable> daPayableList) throws ApiException {
        if (null == daPayableList || daPayableList.isEmpty()) {
            return;
        }
        try {
            this.daPayableMapper.insertBatch(daPayableList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.savePayableBatchModel.ex", (Throwable)e);
        }
    }

    private DaPayable getPayableModelById(Integer PayableId) {
        if (null == PayableId) {
            return null;
        }
        try {
            return this.daPayableMapper.selectByPrimaryKey(PayableId);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.getPayableModelById", (Throwable)e);
            return null;
        }
    }

    private DaPayable getPayableModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daPayableMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.getPayableModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPayableModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daPayableMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.delPayableModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaPayableServiceImpl.delPayableModelByCode.num");
        }
    }

    private void deletePayableModel(Integer PayableId) throws ApiException {
        if (null == PayableId) {
            return;
        }
        int i = 0;
        try {
            i = this.daPayableMapper.deleteByPrimaryKey(PayableId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.deletePayableModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaPayableServiceImpl.deletePayableModel.num");
        }
    }

    private void updatePayableModel(DaPayable daPayable) throws ApiException {
        if (null == daPayable) {
            return;
        }
        int i = 0;
        try {
            i = this.daPayableMapper.updateByPrimaryKey(daPayable);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.updatePayableModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaPayableServiceImpl.updatePayableModel.num");
        }
    }

    private void updateStatePayableModel(Integer PayableId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == PayableId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PayableId", PayableId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPayableMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.updateStatePayableModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaPayableServiceImpl.updateStatePayableModel.null");
        }
    }

    private void updateStatePayableModelByCode(String tenantCode, String PayableCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)PayableCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PayableCode", PayableCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPayableMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableServiceImpl.updateStatePayableModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaPayableServiceImpl.updateStatePayableModelByCode.null");
        }
    }

    private DaPayable makePayable(DaPayableDomain daPayableDomain, DaPayable daPayable) {
        if (null == daPayableDomain) {
            return null;
        }
        if (null == daPayable) {
            daPayable = new DaPayable();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daPayable, (Object)daPayableDomain);
            return daPayable;
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.makePayable", (Throwable)e);
            return null;
        }
    }

    private DaPayableReDomain makeDaPayableReDomain(DaPayable daPayable) {
        if (null == daPayable) {
            return null;
        }
        DaPayableReDomain daPayableReDomain = new DaPayableReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daPayableReDomain, (Object)daPayable);
            return daPayableReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.makeDaPayableReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaPayable> queryPayableModelPage(Map<String, Object> parammap) {
        try {
            return this.daPayableMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.queryPayableModel", (Throwable)e);
            return null;
        }
    }

    private int countPayable(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daPayableMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableServiceImpl.countPayable", (Throwable)e);
        }
        return i;
    }

    private DaPayable createDaPayable(DaPayableDomain daPayableDomain) {
        String msg = this.checkPayable(daPayableDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaPayableServiceImpl.savePayable.checkPayable", msg);
        }
        DaPayable daPayable = this.makePayable(daPayableDomain, null);
        this.setPayableDefault(daPayable);
        return daPayable;
    }

    @Override
    public String savePayable(DaPayableDomain daPayableDomain) throws ApiException {
        DaPayable daPayable = this.createDaPayable(daPayableDomain);
        this.savePayableModel(daPayable);
        return daPayable.getPayableCode();
    }

    @Override
    public String savePayableBatch(List<DaPayableDomain> daPayableDomainList) throws ApiException {
        if (null == daPayableDomainList || daPayableDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaPayable> daPayableList = new ArrayList<DaPayable>();
        String code = "";
        for (DaPayableDomain daPayableDomain : daPayableDomainList) {
            DaPayable daPayable = this.createDaPayable(daPayableDomain);
            code = daPayable.getPayableCode();
            daPayableList.add(daPayable);
        }
        this.savePayableBatchModel(daPayableList);
        return code;
    }

    @Override
    public void updatePayableState(Integer PayableId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == PayableId) {
            return;
        }
        this.updateStatePayableModel(PayableId, dataState, oldDataState, map);
    }

    @Override
    public void updatePayableStateByCode(String tenantCode, String PayableCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)PayableCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePayableModelByCode(tenantCode, PayableCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePayable(DaPayableDomain daPayableDomain) throws ApiException {
        String msg = this.checkPayable(daPayableDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaPayableServiceImpl.updatePayable.checkPayable", msg);
        }
        DaPayable oldDaPayable = this.getPayableModelById(daPayableDomain.getPayableId());
        if (null == oldDaPayable) {
            throw new ApiException("da.DaPayableServiceImpl.updatePayable.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaPayable daPayable = this.makePayable(daPayableDomain, oldDaPayable);
        this.setPayableUpdataDefault(daPayable);
        this.updatePayableModel(daPayable);
    }

    @Override
    public DaPayable getPayable(Integer PayableId) {
        if (null == PayableId) {
            return null;
        }
        return this.getPayableModelById(PayableId);
    }

    @Override
    public void deletePayable(Integer PayableId) throws ApiException {
        if (null == PayableId) {
            return;
        }
        this.deletePayableModel(PayableId);
    }

    @Override
    public QueryResult<DaPayable> queryPayablePage(Map<String, Object> map) {
        List<DaPayable> daPayableList = this.queryPayableModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPayable(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daPayableList);
        return queryResult;
    }

    @Override
    public DaPayable getPayableByCode(String tenantCode, String PayableCode) throws ApiException {
        if (StringUtils.isBlank((String)PayableCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PayableCode", PayableCode);
        return this.getPayableModelByCode(map);
    }

    @Override
    public void deletePayableByCode(String tenantCode, String PayableCode) throws ApiException {
        if (StringUtils.isBlank((String)PayableCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PayableCode", PayableCode);
        this.delPayableModelByCode(map);
    }
}

