/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderTotalMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsReDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalReDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.DaOrderTotalGoods;
import com.yqbsoft.laser.service.data.model.PteBalancelist;
import com.yqbsoft.laser.service.data.model.RsSku;
import com.yqbsoft.laser.service.data.service.DaOpsumOrderlistService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalGoodsService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DaOrderTotalServiceImpl
extends BaseServiceImpl
implements DaOrderTotalService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderTotalServiceImpl";
    private DaOrderTotalMapper daOrderTotalMapper;
    @Autowired
    private DaOrderTotalGoodsService daOrderTotalGoodsService;
    private DaOpsumOrderlistService daOpsumOrderlistService;
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    public void setDaOrderTotalMapper(DaOrderTotalMapper daOrderTotalMapper) {
        this.daOrderTotalMapper = daOrderTotalMapper;
    }

    public DaOpsumOrderlistService getDaOpsumOrderlistService() {
        return this.daOpsumOrderlistService;
    }

    public void setDaOpsumOrderlistService(DaOpsumOrderlistService daOpsumOrderlistService) {
        this.daOpsumOrderlistService = daOpsumOrderlistService;
    }

    private Date getSysDate() {
        try {
            return this.daOrderTotalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrderTotal(DaOrderTotalDomain daOrderTotalDomain) {
        if (null == daOrderTotalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderTotalDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrderTotalDefault(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return;
        }
        if (null == daOrderTotal.getDataState()) {
            daOrderTotal.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderTotal.getGmtCreate()) {
            daOrderTotal.setGmtCreate(date);
        }
        daOrderTotal.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderTotal.getOrderTotalCode())) {
            daOrderTotal.setOrderTotalCode(this.getNo(null, "DaOrderTotal", "daOrderTotal", daOrderTotal.getTenantCode()));
        }
    }

    private int getOrderTotalMaxCode() {
        int code = 0;
        try {
            return this.daOrderTotalMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderTotalUpdataDefault(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return;
        }
        daOrderTotal.setGmtModified(this.getSysDate());
    }

    private void saveOrderTotalModel(DaOrderTotal daOrderTotal) throws ApiException {
        if (null == daOrderTotal) {
            return;
        }
        try {
            this.daOrderTotalMapper.insert(daOrderTotal);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalModel.ex", (Throwable)e);
        }
    }

    private int saveOrderTotalModelWhere(DaOrderTotal daOrderTotal) throws ApiException {
        if (null == daOrderTotal) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalModelWhere.null");
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.insertAndWhere(daOrderTotal);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalModelWhere.ex", (Throwable)e);
        }
        return i;
    }

    private void saveOrderTotalBatchModel(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return;
        }
        try {
            this.daOrderTotalMapper.insertBatch(daOrderTotalList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public DaOrderTotal getDaOrderTotalOrderSum(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        int orderSum = this.getOrderSum(map);
        if (orderSum != -1) {
            DaOrderTotal daOrderTotal = new DaOrderTotal();
            daOrderTotal.setOrderTotalId(orderSum);
            return daOrderTotal;
        }
        return null;
    }

    @Override
    public String updateOrderTotalCyy(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOrderTotalCyy(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalDataOcstate.ex", (Throwable)e);
        }
        return "success";
    }

    private int getOrderSum(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return -1;
        }
        try {
            return this.daOrderTotalMapper.getOrderSum(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderSum", (Throwable)e);
            return -1;
        }
    }

    private DaOrderTotal getOrderTotalModelById(Integer orderTotalId) {
        if (null == orderTotalId) {
            return null;
        }
        try {
            return this.daOrderTotalMapper.selectByPrimaryKey(orderTotalId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalModelById", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotal getOrderTotalModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOrderTotalMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrderTotalModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delOrderTotalModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delOrderTotalModelByCode.num");
        }
    }

    private void deleteOrderTotalModel(Integer orderTotalId) throws ApiException {
        if (null == orderTotalId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.deleteByPrimaryKey(orderTotalId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteOrderTotalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteOrderTotalModel.num");
        }
    }

    private void updateOrderTotalModel(DaOrderTotal daOrderTotal) throws ApiException {
        if (null == daOrderTotal) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateByPrimaryKey(daOrderTotal);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalModel.num");
        }
    }

    private void updateStateOrderTotalModel(Integer orderTotalId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == orderTotalId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderTotalId", orderTotalId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModel.null");
        }
    }

    private void updateNoOrderTotalModel(Integer orderTotalId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == orderTotalId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderTotalId", orderTotalId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModel.null");
        }
    }

    private void updateStateOrderTotalModelByCode(String tenantCode, String orderTotalCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalCode", orderTotalCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModelByCode.null");
        }
    }

    private DaOrderTotal makeOrderTotal(DaOrderTotalDomain daOrderTotalDomain, DaOrderTotal daOrderTotal) {
        if (null == daOrderTotalDomain) {
            return null;
        }
        if (null == daOrderTotal) {
            daOrderTotal = new DaOrderTotal();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotal, (Object)daOrderTotalDomain);
            return daOrderTotal;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeOrderTotal", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotalReDomain makeDaOrderTotalReDomain(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return null;
        }
        DaOrderTotalReDomain daOrderTotalReDomain = new DaOrderTotalReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalReDomain, (Object)daOrderTotal);
            return daOrderTotalReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaOrderTotalReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOrderTotal> queryOrderTotalModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderTotalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryOrderTotalModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderTotal(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countOrderTotal", (Throwable)e);
        }
        return i;
    }

    private DaOrderTotal createDaOrderTotal(DaOrderTotalDomain daOrderTotalDomain) {
        String msg = this.checkOrderTotal(daOrderTotalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveOrderTotal.checkOrderTotal", msg);
        }
        DaOrderTotal daOrderTotal = this.makeOrderTotal(daOrderTotalDomain, null);
        this.setOrderTotalDefault(daOrderTotal);
        return daOrderTotal;
    }

    @Override
    public String saveOrderTotal(DaOrderTotalDomain daOrderTotalDomain) throws ApiException {
        DaOrderTotal daOrderTotal = this.createDaOrderTotal(daOrderTotalDomain);
        this.saveOrderTotalModel(daOrderTotal);
        return daOrderTotal.getOrderTotalCode();
    }

    @Override
    public int saveOrderTotalWhere(DaOrderTotalDomain daOrderTotalDomain) throws ApiException {
        DaOrderTotal daOrderTotal = this.createDaOrderTotal(daOrderTotalDomain);
        return this.saveOrderTotalModelWhere(daOrderTotal);
    }

    @Override
    public String saveOrderTotalWithReport(Map<String, Object> map) throws ApiException {
        return null;
    }

    @Override
    public String saveOrderTotalBatch(List<DaOrderTotalDomain> daOrderTotalDomainList) throws ApiException {
        if (null == daOrderTotalDomainList || daOrderTotalDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotal> daOrderTotalList = new ArrayList<DaOrderTotal>();
        String code = "";
        for (DaOrderTotalDomain daOrderTotalDomain : daOrderTotalDomainList) {
            DaOrderTotal daOrderTotal = this.createDaOrderTotal(daOrderTotalDomain);
            code = daOrderTotal.getOrderTotalCode();
            daOrderTotalList.add(daOrderTotal);
        }
        this.saveOrderTotalBatchModel(daOrderTotalList);
        return code;
    }

    @Override
    public void updateOrderTotalState(Integer orderTotalId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == orderTotalId) {
            return;
        }
        this.updateStateOrderTotalModel(orderTotalId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderTotalStateByCode(String tenantCode, String orderTotalCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrderTotalModelByCode(tenantCode, orderTotalCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderTotal(DaOrderTotalDomain daOrderTotalDomain) throws ApiException {
        String msg = this.checkOrderTotal(daOrderTotalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateOrderTotal.checkOrderTotal", msg);
        }
        DaOrderTotal oldDaOrderTotal = this.getOrderTotalModelById(daOrderTotalDomain.getOrderTotalId());
        if (null == oldDaOrderTotal) {
            throw new ApiException(SYS_CODE + ".updateOrderTotal.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOrderTotal daOrderTotal = this.makeOrderTotal(daOrderTotalDomain, oldDaOrderTotal);
        this.setOrderTotalUpdataDefault(daOrderTotal);
        this.updateOrderTotalModel(daOrderTotal);
    }

    @Override
    public DaOrderTotal getOrderTotal(Integer orderTotalId) {
        if (null == orderTotalId) {
            return null;
        }
        return this.getOrderTotalModelById(orderTotalId);
    }

    @Override
    public void deleteOrderTotal(Integer orderTotalId) throws ApiException {
        if (null == orderTotalId) {
            return;
        }
        this.deleteOrderTotalModel(orderTotalId);
    }

    @Override
    public QueryResult<DaOrderTotal> queryOrderTotalPage(Map<String, Object> map) {
        List<DaOrderTotal> daOrderTotalList = this.queryOrderTotalModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderTotalList);
        return queryResult;
    }

    @Override
    public DaOrderTotal getOrderTotalByCode(String tenantCode, String orderTotalCode) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalCode", orderTotalCode);
        return this.getOrderTotalModelByCode(map);
    }

    @Override
    public void deleteOrderTotalByCode(String tenantCode, String orderTotalCode) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalCode", orderTotalCode);
        this.delOrderTotalModelByCode(map);
    }

    @Override
    public String saveOrderTotalReBatch(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotal> daOrderTotalLists = new ArrayList<DaOrderTotal>();
        String code = "";
        for (DaOrderTotal orderTotal : daOrderTotalList) {
            this.setOrderTotalDefault(orderTotal);
            code = orderTotal.getOrderTotalCode();
            daOrderTotalLists.add(orderTotal);
        }
        this.saveOrderTotalBatchModel(daOrderTotalLists);
        return code;
    }

    @Override
    public QueryResult<DaOrderTotalReDomain> queryOrderTotalReDomainPage(Map<String, Object> map) {
        List<DaOrderTotal> daOrderTotalList = this.queryOrderTotalModelPage(map);
        ArrayList<DaOrderTotalReDomain> reDomainList = new ArrayList<DaOrderTotalReDomain>();
        for (DaOrderTotal orderTotal : daOrderTotalList) {
            DaOrderTotalReDomain reDomain = this.makeDaOrderTotalReDomain(orderTotal);
            if (null == reDomain) continue;
            this.logger.info(SYS_CODE + "orderTotal.OrderTotalCode is " + reDomain.getOrderTotalCode());
            this.makeOrderTotalGoods(reDomain);
            reDomainList.add(reDomain);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(reDomainList);
        return queryResult;
    }

    @Override
    public DaOrderTotalReDomain getOrderTotalReDomainByCode(String tenantCode, String orderTotalCode) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalCode", orderTotalCode);
        DaOrderTotal orderTotal = this.getOrderTotalModelByCode(map);
        DaOrderTotalReDomain reDomain = this.makeDaOrderTotalReDomain(orderTotal);
        this.logger.info(SYS_CODE + "orderTotal.OrderTotalCode is " + reDomain.getOrderTotalCode());
        this.makeOrderTotalGoods(reDomain);
        return reDomain;
    }

    @Override
    public String saveOrderTotalWithContract(OcContractDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error(SYS_CODE + "saveOrderTotalWithContract param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insuranceOpcode", ocContractDomain.getContractBillcode());
        map.put("orderTotalType", "1");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        int orderNum = this.countOrderTotal(map);
        if (0 != orderNum) {
            this.logger.info(SYS_CODE, (Object)(ocContractDomain.getContractBillcode() + "-----\u8be5\u8ba2\u5355\u5df2\u5b58\u5728"));
            return "success";
        }
        this.logger.info(SYS_CODE + "ocContractReDomain code is " + ocContractDomain.getContractBillcode());
        DaOrderTotalDomain domain = this.makeDomainWithContract(ocContractDomain);
        this.saveOrderTotalGoodsByBillBCode(domain);
        if (ListUtil.isEmpty(domain.getOrderTotalGoodsDomainList())) {
            this.logger.error(SYS_CODE, (Object)"\u6b63\u5411\u5355\u6ca1\u6709\u53d1\u8d27\u5355,\u65b0\u589e\u5931\u8d25");
            return "success";
        }
        DaOrderTotal daOrderTotal = this.createDaOrderTotal(domain);
        this.saveOrderTotalModel(daOrderTotal);
        for (DaOrderTotalGoodsDomain goodsDomain : domain.getOrderTotalGoodsDomainList()) {
            goodsDomain.setOrderTotalCode(daOrderTotal.getOrderTotalCode());
        }
        this.daOrderTotalGoodsService.saveOrderTotalGoodsBatch(domain.getOrderTotalGoodsDomainList());
        return "success";
    }

    @Override
    public String saveOrderTotalWithRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        if (ocRefundDomain == null) {
            this.logger.error(SYS_CODE + "saveOrderTotalWithContract param is null");
            return null;
        }
        this.logger.info(SYS_CODE + "ocRefundDomain code is " + ocRefundDomain.getRefundCode());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insuranceOpcode2", ocRefundDomain.getRefundCode());
        map.put("orderTotalType", "2");
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        int orderNum = this.countOrderTotal(map);
        if (0 != orderNum) {
            this.logger.info(SYS_CODE, (Object)(ocRefundDomain.getRefundCode() + "-----\u8be5\u9000\u5355\u5df2\u5b58\u5728"));
            return "success";
        }
        DaOrderTotalDomain domain = this.makeDomainWithRefund(ocRefundDomain);
        this.saveOrderTotalGoodsByBillBCode(domain);
        if (ListUtil.isEmpty(domain.getOrderTotalGoodsDomainList())) {
            this.logger.error(SYS_CODE, (Object)"\u9006\u5411\u5355\u6ca1\u6709\u53d1\u8d27\u5355,\u65b0\u589e\u5931\u8d25");
            return "success";
        }
        DaOrderTotal daOrderTotal = this.createDaOrderTotal(domain);
        this.saveOrderTotalModel(daOrderTotal);
        for (DaOrderTotalGoodsDomain goodsDomain : domain.getOrderTotalGoodsDomainList()) {
            goodsDomain.setOrderTotalCode(daOrderTotal.getOrderTotalCode());
        }
        this.daOrderTotalGoodsService.saveOrderTotalGoodsBatch(domain.getOrderTotalGoodsDomainList());
        return "success";
    }

    public void saveOrderTotalGoodsByBillBCode(DaOrderTotalDomain orderTotalDomain) throws ApiException {
        String apiCode = "sg.sendgoods.querySendgoodsGoodsPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", orderTotalDomain.getTenantCode());
        map.put("contractBillcode", orderTotalDomain.getInsuranceOpcode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        List sgSendgoodsDomain = this.getQueryResutl(apiCode, invokeMap, SgSendgoodsGoodsDomain.class).getList();
        if (ListUtil.isEmpty((Collection)sgSendgoodsDomain)) {
            this.logger.error(SYS_CODE, (Object)"saveOrderTotalGoodsByBillBCode sgSendgoodsDomainList is null");
            return;
        }
        BigDecimal srp = new BigDecimal("0.00");
        ArrayList<DaOrderTotalGoodsDomain> totalGoods = new ArrayList<DaOrderTotalGoodsDomain>();
        for (SgSendgoodsGoodsDomain sendgoodsDomain : sgSendgoodsDomain) {
            DaOrderTotalGoodsDomain totalGoodsDomain = this.makeGoodsDomainWithsendtGoods(sendgoodsDomain, orderTotalDomain);
            totalGoodsDomain.setInsuranceOpcode2(orderTotalDomain.getInsuranceOpcode2());
            totalGoodsDomain.setOrderTotalType(orderTotalDomain.getOrderTotalType());
            totalGoodsDomain.setOrderTotalOrdertype(orderTotalDomain.getOrderTotalOrdertype());
            totalGoodsDomain.setInsuranceOpcode(orderTotalDomain.getInsuranceOpcode());
            totalGoodsDomain.setInsuranceOpcode1(orderTotalDomain.getInsuranceOpcode1());
            totalGoods.add(totalGoodsDomain);
            srp = srp.add(totalGoodsDomain.getOrderTotalNum4());
        }
        orderTotalDomain.setOrderTotalNum4(srp);
        orderTotalDomain.setOrderTotalGoodsDomainList(totalGoods);
    }

    private void saveOrderTotalGoodsByRefund(DaOrderTotalDomain orderTotalDomain) throws ApiException {
        String apiCode = "oc.refund.queryRefundGoodsPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", orderTotalDomain.getInsuranceOpcode2());
        map.put("tenantCode", orderTotalDomain.getTenantCode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult ocRefundGoodsQueryResult = this.getQueryResutl(apiCode, invokeMap, OcRefundGoodsDomain.class);
        if (ocRefundGoodsQueryResult.getList() == null) {
            return;
        }
        BigDecimal srp = new BigDecimal("0.00");
        ArrayList<DaOrderTotalGoodsDomain> totalGoods = new ArrayList<DaOrderTotalGoodsDomain>();
        for (OcRefundGoodsDomain ocRefundGoods : ocRefundGoodsQueryResult.getList()) {
            DaOrderTotalGoodsDomain totalGoodsDomain = this.makeGoodsDomainWithRefundGoods(ocRefundGoods);
            totalGoodsDomain.setInsuranceOpcode2(orderTotalDomain.getInsuranceOpcode2());
            totalGoodsDomain.setOrderTotalType(orderTotalDomain.getOrderTotalType());
            totalGoodsDomain.setOrderTotalOrdertype(orderTotalDomain.getOrderTotalOrdertype());
            totalGoodsDomain.setInsuranceOpcode(orderTotalDomain.getInsuranceOpcode());
            totalGoodsDomain.setInsuranceOpcode1(orderTotalDomain.getInsuranceOpcode1());
            totalGoods.add(totalGoodsDomain);
            srp = srp.add(totalGoodsDomain.getOrderTotalNum4());
        }
        orderTotalDomain.setOrderTotalNum4(srp);
        orderTotalDomain.setOrderTotalGoodsDomainList(totalGoods);
    }

    @Override
    public void updateOrderTotalOpCodeByCode(String tenantCode, String orderTotalCode, String insuranceOpcode3) throws ApiException {
        if (null == orderTotalCode) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderTotalCode", orderTotalCode);
        param.put("tenantCode", tenantCode);
        param.put("insuranceOpcode3", insuranceOpcode3);
        param.put("dataState", 1);
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updatePcodeByCode(param);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalOpCodeByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalOpCodeByCode.null");
        }
    }

    @Override
    public String updateOcStateByOpCode(String tenantCode, Date orderTotalDate1, String insuranceOpcode, Integer dataOcstate, Integer oldDataOcstate) throws ApiException {
        this.logger.info(SYS_CODE + ",orderTotalDate1=" + orderTotalDate1 + ",insuranceOpcode=" + insuranceOpcode + ",dataOcstate" + dataOcstate);
        if (null == dataOcstate || null == insuranceOpcode) {
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("insuranceOpcode", insuranceOpcode);
        param.put("orderTotalType", "1");
        param.put("dataOcstate", dataOcstate);
        param.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOcStateByCode(param);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOcStateByOpCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error(SYS_CODE + ".updateOcStateByOpCode", (Object)"\u6b63\u5411\u5355\u4e0d\u5b58\u5728");
        }
        return "success";
    }

    @Override
    public String updateReOcStateByOpCode(String tenantCode, Date orderTotalDate1, String insuranceOpcode, Integer dataOcstate, Integer oldDataOcstate) throws ApiException {
        this.logger.info(SYS_CODE + ",orderTotalDate1=" + orderTotalDate1 + ",insuranceOpcode=" + insuranceOpcode + ",dataOcstate=" + dataOcstate);
        if (null == dataOcstate || insuranceOpcode == null) {
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderTotalDate1", orderTotalDate1);
        param.put("orderTotalType", "2");
        param.put("insuranceOpcode", insuranceOpcode);
        param.put("dataOcstate", dataOcstate);
        param.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOcStateByCode(param);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateReOcStateByOpCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error(SYS_CODE + ".updateReOcStateByOpCode", (Object)"\u9006\u5411\u5355\u4e0d\u5b58\u5728");
        }
        return "success";
    }

    @Override
    public String updateReOcTimeByOpCode(String tenantCode, Date orderTotalDate1, String channelClearSeqno, Integer dataOcstate, Integer oldDataOcstate) throws ApiException {
        this.logger.info(SYS_CODE + ",orderTotalDate1=" + orderTotalDate1 + ",channelClearSeqno=" + channelClearSeqno + ",dataOcstate=" + dataOcstate);
        if (null == orderTotalDate1 || channelClearSeqno == null) {
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderTotalDate1", orderTotalDate1);
        param.put("channelClearSeqno", channelClearSeqno);
        param.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOcTimeByCode(param);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOcTimeByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error(SYS_CODE + ".updateOcTimeByCode", (Object)"\u9006\u5411\u5355\u4e0d\u5b58\u5728");
        }
        return "success";
    }

    @Override
    public String updateReOcTime(OcRefundDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error(SYS_CODE + ".updateReOcTime is null", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderTotalDate1", ocRefundDomain.getGmtModified());
        param.put("channelClearSeqno", ocRefundDomain.getContractBillcode());
        param.put("tenantCode", ocRefundDomain.getTenantCode());
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOcTimeByCode(param);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateReOcTime.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error(SYS_CODE + ".updateReOcTime", (Object)"\u9006\u5411\u5355\u4e0d\u5b58\u5728");
        }
        return "success";
    }

    public DaOrderTotalDomain makeDomainWithContract(OcContractDomain reDomain) {
        DaOrderTotalDomain totalDomain = new DaOrderTotalDomain();
        totalDomain.setMemberMcode(reDomain.getMemberMcode());
        totalDomain.setMemberMname(reDomain.getMemberMname());
        totalDomain.setMemberCode(reDomain.getMemberCode());
        totalDomain.setMemberName(reDomain.getMemberName());
        totalDomain.setMemberBcode(reDomain.getMemberBcode());
        totalDomain.setMemberBname(reDomain.getMemberBname());
        totalDomain.setInsuranceOpcode(reDomain.getContractBillcode());
        totalDomain.setInsuranceOpcode1(reDomain.getContractNbbillcode());
        totalDomain.setOrderTotalDate(reDomain.getGmtCreate());
        totalDomain.setChannelCode(reDomain.getChannelCode());
        totalDomain.setChannelName(reDomain.getChannelName());
        totalDomain.setTenantCode(reDomain.getTenantCode());
        totalDomain.setDataOcstate(reDomain.getDataState());
        totalDomain.setOrderTotalType("1");
        totalDomain.setOrderTotalDate1(reDomain.getGmtModified());
        totalDomain.setOrderTotalNum(reDomain.getDataBnum());
        totalDomain.setOrderTotalNum1(reDomain.getDataBmoney());
        totalDomain.setOrderTotalNum2(reDomain.getDataBmoney().divide(new BigDecimal("1.13"), 2, 4));
        totalDomain.setOrderTotalNum3(totalDomain.getOrderTotalNum1().subtract(totalDomain.getOrderTotalNum2()));
        return totalDomain;
    }

    public DaOrderTotalGoodsDomain makeGoodsDomainWithContractGoods(OcContractGoodsDomain goodsDomain) {
        DaOrderTotalGoodsDomain domain = new DaOrderTotalGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)goodsDomain);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeGoodsDomainWithContractGoods", (Throwable)e);
        }
        domain.setSkuName(goodsDomain.getGoodsName());
        if (null == domain.getSkuName()) {
            domain.setSkuName(goodsDomain.getSkuShowno());
        }
        domain.setOrderTotalNum(goodsDomain.getGoodsNum());
        domain.setOrderTotalNum1(goodsDomain.getContractGoodsMoney());
        domain.setOrderTotalNum2(goodsDomain.getContractGoodsMoney().divide(new BigDecimal("1.13"), 2, 4));
        domain.setOrderTotalNum3(domain.getOrderTotalNum1().subtract(domain.getOrderTotalNum2()));
        domain.setOrderTotalNum4(goodsDomain.getPricesetNprice());
        domain.setOrderTotalNum5(null);
        return domain;
    }

    public DaOrderTotalGoodsDomain makeGoodsDomainWithsendtGoods(SgSendgoodsGoodsDomain goodsDomain, DaOrderTotalDomain orderTotalDomain) {
        DaOrderTotalGoodsDomain domain = new DaOrderTotalGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)goodsDomain);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeGoodsDomainWithsendtGoods", (Throwable)e);
        }
        domain.setSkuCode(goodsDomain.getSkuNo());
        domain.setSkuName(goodsDomain.getSkuName());
        domain.setGoodsClass(goodsDomain.getGoodsName());
        if (null == domain.getSkuName()) {
            domain.setSkuName(goodsDomain.getSkuShowno());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("skuNo", goodsDomain.getSkuNo());
        map1.put("memberCode", orderTotalDomain.getMemberCode());
        map1.put("channelCode", orderTotalDomain.getChannelCode());
        map1.put("tenantCode", goodsDomain.getTenantCode());
        map1.put("memberCcode", goodsDomain.getMemberCcode());
        RsSku rsSku = (RsSku)this.getForObject("rs.sku.getSkuBySkuNo", RsSku.class, map1);
        if (null != rsSku) {
            domain.setGoodsType(rsSku.getGoodsType());
            domain.setGoodsPro(rsSku.getGoodsPro());
        }
        domain.setOrderTotalNum(goodsDomain.getSendgoodsGoodsCamount());
        domain.setOrderTotalNum1(goodsDomain.getContractGoodsMoney());
        domain.setGoodsNum(goodsDomain.getSendgoodsGoodsCamount());
        domain.setOrderTotalNum5(goodsDomain.getContractGoodsPrice());
        domain.setOrderTotalNum2(goodsDomain.getContractGoodsMoney().divide(new BigDecimal("1.13"), 2, 4));
        domain.setOrderTotalNum3(domain.getOrderTotalNum1().subtract(domain.getOrderTotalNum2()));
        domain.setOrderTotalNum4(goodsDomain.getPricesetNprice());
        return domain;
    }

    public DaOrderTotalDomain makeDomainWithRefund(OcRefundDomain reDomain) {
        DaOrderTotalDomain totalDomain = new DaOrderTotalDomain();
        totalDomain.setMemberMcode(reDomain.getMemberMcode());
        totalDomain.setMemberMname(reDomain.getMemberMname());
        totalDomain.setMemberCode(reDomain.getMemberCode());
        totalDomain.setMemberName(reDomain.getMemberName());
        totalDomain.setMemberBcode(reDomain.getMemberBcode());
        totalDomain.setMemberBname(reDomain.getMemberBname());
        totalDomain.setInsuranceOpcode(reDomain.getContractBillcode());
        totalDomain.setInsuranceOpcode1(reDomain.getContractNbbillcode());
        totalDomain.setInsuranceOpcode2(reDomain.getRefundCode());
        if (reDomain.getGmtCreate() == null) {
            totalDomain.setOrderTotalDate(new Date());
        } else {
            totalDomain.setOrderTotalDate(reDomain.getGmtCreate());
        }
        totalDomain.setChannelCode(reDomain.getChannelCode());
        totalDomain.setChannelName(reDomain.getChannelName());
        totalDomain.setTenantCode(reDomain.getTenantCode());
        totalDomain.setDataOcstate(reDomain.getDataState());
        totalDomain.setOrderTotalType("2");
        totalDomain.setOrderTotalOrdertype(reDomain.getRefundType());
        totalDomain.setOrderTotalNum(reDomain.getGoodsNum());
        totalDomain.setOrderTotalNum1(reDomain.getRefundMoney());
        totalDomain.setOrderTotalNum2(reDomain.getRefundMoney().divide(new BigDecimal("1.13"), 2, 4));
        totalDomain.setOrderTotalNum3(reDomain.getRefundMoney().subtract(totalDomain.getOrderTotalNum2()));
        return totalDomain;
    }

    public DaOrderTotalGoodsDomain makeGoodsDomainWithRefundGoods(OcRefundGoodsDomain goods) {
        DaOrderTotalGoodsDomain domain = new DaOrderTotalGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)goods);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeGoodsDomainWithRefundGoods", (Throwable)e);
        }
        if (null == domain.getSkuName()) {
            domain.setSkuName(goods.getSkuShowno());
        }
        domain.setSkuName(goods.getGoodsName());
        domain.setOrderTotalNum(goods.getGoodsNum());
        domain.setOrderTotalNum1(goods.getRefundGoodsPrice());
        domain.setOrderTotalNum2(goods.getRefundGoodsPrice().divide(new BigDecimal("1.13"), 2, 4));
        domain.setOrderTotalNum3(domain.getOrderTotalNum1().subtract(domain.getOrderTotalNum2()));
        domain.setOrderTotalNum4(goods.getPricesetNprice());
        domain.setOrderTotalNum5(null);
        return domain;
    }

    public void makeOrderTotalGoods(DaOrderTotalReDomain reDomain) {
        if (null == reDomain) {
            this.logger.info(SYS_CODE + "makerOrderTotalGoods getOrderTotalGoods param is null");
        }
        ArrayList<DaOrderTotalGoodsDomain> reDomainList = new ArrayList<DaOrderTotalGoodsDomain>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", reDomain.getTenantCode());
        param.put("orderTotalCode", reDomain.getOrderTotalCode());
        param.put("order", true);
        List daOrderTotalGoodsList = this.daOrderTotalGoodsService.queryOrderTotalGoodsPage(param).getList();
        for (DaOrderTotalGoods goods : daOrderTotalGoodsList) {
            reDomainList.add(this.makeDaOrderTotalGoodsReDomain(goods));
        }
        reDomain.setOrderTotalGoodsDomainList(reDomainList);
    }

    private DaOrderTotalGoodsReDomain makeDaOrderTotalGoodsReDomain(DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoods) {
            return null;
        }
        DaOrderTotalGoodsReDomain daOrderTotalGoodsReDomain = new DaOrderTotalGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalGoodsReDomain, (Object)daOrderTotalGoods);
            return daOrderTotalGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaOrderTotalGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public String sendPteBalancelist(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            this.logger.error(SYS_CODE + ".sendPteBalancelist pteBalancelist is null");
            return "error";
        }
        String code = "";
        DaOrderTotal daOrderTotalMode = this.getDaOrderTotalMode(pteBalancelist);
        if (null == daOrderTotalMode) {
            int daOrderTotalLock = this.saveDaOrderTotalLock(pteBalancelist);
            if (1 == daOrderTotalLock) {
                daOrderTotalMode = this.getDaOrderTotalMode(pteBalancelist);
            } else {
                daOrderTotalMode = this.getDaOrderTotalMode(pteBalancelist);
                if (null == daOrderTotalMode) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new ApiException(SYS_CODE + ".sendPteBalancelist.ex", (Throwable)e);
                    }
                    daOrderTotalMode = this.getDaOrderTotalMode(pteBalancelist);
                }
                if (null == daOrderTotalMode) {
                    throw new ApiException(SYS_CODE + ".sendPteBalancelist.ex null");
                }
                this.updateOrderTotalNumById(pteBalancelist, daOrderTotalMode);
            }
        } else {
            this.updateOrderTotalNumById(pteBalancelist, daOrderTotalMode);
        }
        if (null == daOrderTotalMode) {
            throw new ApiException(SYS_CODE + ".sendPteBalancelist.ex111111 null");
        }
        code = daOrderTotalMode.getOrderTotalCode();
        DaOrderTotalGoodsDomain daOrderTotalGoodsDomain = new DaOrderTotalGoodsDomain();
        daOrderTotalGoodsDomain.setOrderTotalCode(code);
        daOrderTotalGoodsDomain.setOrderTotalNum(pteBalancelist.getBalanceopAmount());
        daOrderTotalGoodsDomain.setOrderTotalNum1(pteBalancelist.getOrderOamount());
        daOrderTotalGoodsDomain.setOrderTotalNum2(pteBalancelist.getOrderPrice());
        daOrderTotalGoodsDomain.setInsuranceOpcode(pteBalancelist.getBusinessOrder());
        daOrderTotalGoodsDomain.setInsuranceOpcode1(pteBalancelist.getBusinessOrderno());
        daOrderTotalGoodsDomain.setMemberBcode(pteBalancelist.getMemberBcode());
        daOrderTotalGoodsDomain.setMemberBname(pteBalancelist.getMemberBname());
        daOrderTotalGoodsDomain.setMemberCode(pteBalancelist.getMemberCode());
        daOrderTotalGoodsDomain.setMemberName(pteBalancelist.getMemberName());
        daOrderTotalGoodsDomain.setMemberMcode(pteBalancelist.getOpuserCode());
        daOrderTotalGoodsDomain.setTenantCode(pteBalancelist.getTenantCode());
        this.daOrderTotalGoodsService.saveOrderTotalGoods(daOrderTotalGoodsDomain);
        return "success";
    }

    @Override
    public void updateDataState(String tenantCode) {
        String pteDateBalanceStr = this.getDdFalgSetting("00000000", "PteDateBalance", "PteDateBalance", "");
        int pteDateBalance = 0;
        pteDateBalance = StringUtils.isBlank((String)pteDateBalanceStr) ? this.getLastDayInMoney() : Integer.parseInt(pteDateBalanceStr);
        int today = this.getToday();
        if (today != pteDateBalance) {
            return;
        }
        int page = 1;
        int rows = 100;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page", page);
        param.put("rows", rows);
        param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()));
        param.put("dataState", 0);
        param.put("orderTotalOrdertype", "rebate");
        param.put("tenantCode", tenantCode);
        boolean boo = true;
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (boo) {
            List<DaOrderTotal> daOrderTotals = this.queryOrderTotalModelPage(param);
            if (ListUtil.isEmpty(daOrderTotals)) {
                this.logger.error(SYS_CODE + ".updateDataState daOrderTotals is null", (Object)JsonUtil.buildNormalBinder().toJson(param));
                boo = false;
                continue;
            }
            for (DaOrderTotal daOrderTotal : daOrderTotals) {
                map.put("orderTotalDate", new Date());
                map.put("memo", this.getYearMon());
                this.updateOrderTotalState(daOrderTotal.getOrderTotalId(), 1, 0, map);
            }
        }
    }

    private int saveDaOrderTotalLock(PteBalancelist pteBalancelist) {
        DaOrderTotalDomain daOrderTotalDomain = new DaOrderTotalDomain();
        daOrderTotalDomain.setMemberCode(pteBalancelist.getMemberCode());
        daOrderTotalDomain.setMemberName(pteBalancelist.getMemberName());
        daOrderTotalDomain.setMemberMcode(pteBalancelist.getOpuserCode());
        daOrderTotalDomain.setOrderTotalNum(pteBalancelist.getBalanceopAmount());
        daOrderTotalDomain.setOrderTotalOrdertype(pteBalancelist.getBalanceType());
        daOrderTotalDomain.setDataState(0);
        daOrderTotalDomain.setTenantCode(pteBalancelist.getTenantCode());
        return this.saveOrderTotalWhere(daOrderTotalDomain);
    }

    public static void main(String[] args) {
    }

    private static synchronized void get11() {
        System.out.println(1);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private DaOrderTotal getDaOrderTotalMode(PteBalancelist pteBalancelist) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", pteBalancelist.getMemberCode());
        param.put("tenantCode", pteBalancelist.getTenantCode());
        param.put("dataState", 0);
        param.put("orderTotalOrdertype", pteBalancelist.getBalanceType());
        List<DaOrderTotal> daOrderTotals = this.queryOrderTotalModelPage(param);
        if (ListUtil.isEmpty(daOrderTotals)) {
            return null;
        }
        return daOrderTotals.get(0);
    }

    private void updateOrderTotalNumById(PteBalancelist pteBalancelist, DaOrderTotal daOrderTotal) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderTotalId", daOrderTotal.getOrderTotalId());
        param.put("orderTotalNum", pteBalancelist.getBalanceopAmount());
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOrderTotalNumById(param);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalNumById.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error(SYS_CODE + ".updateOrderTotalNumById", (Object)"\u5bf9\u8d26\u4fe1\u606f\u4fee\u6539\u5931\u8d25!");
            throw new ApiException(SYS_CODE + ".updateOrderTotalNumById.null");
        }
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (!(StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode))) {
            String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
            return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        return null;
    }

    public int getToday() {
        return Integer.parseInt(new SimpleDateFormat("dd").format(new Date()));
    }

    public String getYearMon() {
        String mm = new SimpleDateFormat("MM").format(new Date());
        String year = new SimpleDateFormat("yyyy").format(new Date());
        return year + "\u5e74" + mm + "\u6708";
    }

    public int getLastDayInMoney() {
        String mon = new SimpleDateFormat("MM").format(new Date());
        String year = new SimpleDateFormat("yyyy").format(new Date());
        String lastday = this.getLastday(year, mon);
        String[] split = lastday.split("-");
        return Integer.parseInt(split[2]);
    }

    public String getLastday(String year, String month) {
        System.out.println(year + "---" + month);
        LocalDate firstDayOfCurrentDate = LocalDate.of(Integer.parseInt(year), Integer.parseInt(month), 1);
        LocalDate lastDayOfCurrentDate = firstDayOfCurrentDate.with(TemporalAdjusters.lastDayOfMonth());
        return lastDayOfCurrentDate.toString();
    }

    @Override
    public void dataCompensation(String tenantCode, String dateFlag) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isBlank((String)dateFlag)) {
            parammap.put("gmtModifiedQend", calendar.getTime());
            calendar.add(5, -1);
            calendar.add(11, -1);
            parammap.put("gmtModifiedQstart", calendar.getTime());
        }
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        parammap.put("dataOcstate", "2,30");
        parammap.put("colName6", "ORDER_TOTAL_DATE");
        this.logger.error(SYS_CODE + ".dataCompensation1", (Object)JsonUtil.buildNormalBinder().toJson(parammap));
        List<DaOrderTotal> daOrderTotals = this.queryOrderTotalModelPage(parammap);
        if (ListUtil.isNotEmpty(daOrderTotals)) {
            for (DaOrderTotal daOrderTotal : daOrderTotals) {
                param.put("contractBillcode", daOrderTotal.getChannelClearSeqno());
                map.put("map", JsonUtil.buildNormalBinder().toJson(param));
                String contractStr = (String)BaseAuth.internalRouter.inInvoke("oc.contract.getContractByCode", "1.0", "0", map);
                if (StringUtils.isBlank((String)contractStr)) continue;
                OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, OcContractDomain.class);
                ocContractDomain.setDataState(2);
                ocContractDomain.setDataStatestr("false");
                ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
                this.daOpsumOrderlistService.sendContractGoodInfo(ocContractDomain);
            }
        }
        parammap.put("dataOcstate", 3);
        parammap.put("orderTotalType", "00,24,26,08");
        parammap.put("colName6", "MEMBER_MCODE");
        this.logger.error(SYS_CODE + ".dataCompensation2", (Object)JsonUtil.buildNormalBinder().toJson(parammap));
        List<DaOrderTotal> daOrderTotals1 = this.queryOrderTotalModelPage(parammap);
        if (ListUtil.isNotEmpty(daOrderTotals1)) {
            for (DaOrderTotal daOrderTotal : daOrderTotals1) {
                param.put("contractBillcode", daOrderTotal.getChannelClearSeqno());
                map.put("map", JsonUtil.buildNormalBinder().toJson(param));
                String contractStr = (String)BaseAuth.internalRouter.inInvoke("oc.contract.getContractByCode", "1.0", "0", map);
                if (StringUtils.isBlank((String)contractStr)) continue;
                OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, OcContractDomain.class);
                ocContractDomain.setDataState(3);
                ocContractDomain.setDataStatestr("false");
                this.daOpsumOrderlistService.sendContractGoodInfo(ocContractDomain);
            }
        }
    }
}

