/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDgoodsuplistFileMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDgoodsuplistMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsuplistDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsuplistFileDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsuplistFileReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsuplistReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDgoodsuplist;
import com.yqbsoft.laser.service.distribution.model.DisDgoodsuplistFile;
import com.yqbsoft.laser.service.distribution.service.DisDgoodsuplistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisDgoodsuplistServiceImpl
extends BaseServiceImpl
implements DisDgoodsuplistService {
    private static final String SYS_CODE = "dis.DisDgoodsuplistServiceImpl";
    private DisDgoodsuplistMapper disDgoodsuplistMapper;
    private String cachekey = "DisDgoodsuplist-No-channelCode";
    private String cacheFilekey = "DisDgoodsuplistFile-No-channelCode";
    private DisDgoodsuplistFileMapper disDgoodsuplistFileMapper;

    public void setDisDgoodsuplistMapper(DisDgoodsuplistMapper disDgoodsuplistMapper) {
        this.disDgoodsuplistMapper = disDgoodsuplistMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDgoodsuplistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) {
        if (null == disDgoodsuplistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsuplistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsuplistDefault(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        if (null == disDgoodsuplist.getDataState()) {
            disDgoodsuplist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgoodsuplist.getGmtCreate()) {
            disDgoodsuplist.setGmtCreate(date);
        }
        disDgoodsuplist.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgoodsuplist.getDgoodsuplistCode())) {
            disDgoodsuplist.setDgoodsuplistCode(this.getNo(null, "DisDgoodsuplist", "disDgoodsuplist", disDgoodsuplist.getTenantCode()));
        }
    }

    private int getDgoodsuplistMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsuplistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsuplistUpdataDefault(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        disDgoodsuplist.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsuplistModel(DisDgoodsuplist disDgoodsuplist) throws ApiException {
        if (null == disDgoodsuplist) {
            return;
        }
        try {
            this.disDgoodsuplistMapper.insert(disDgoodsuplist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistModel.ex", (Throwable)e);
        }
    }

    public void saveDgoodsuplistBatchModel(List<DisDgoodsuplist> disDgoodsuplistList) throws ApiException {
        if (null == disDgoodsuplistList || disDgoodsuplistList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsuplistMapper.insertBatch(disDgoodsuplistList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoodsuplist getDgoodsuplistModelById(Integer dgoodsuplistId) {
        if (null == dgoodsuplistId) {
            return null;
        }
        try {
            return this.disDgoodsuplistMapper.selectByPrimaryKey(dgoodsuplistId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsuplist getDgoodsuplistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsuplistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsuplistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelByCode.num");
        }
    }

    private void delDgoodsuplistModelBySkuNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.delBySkuNo(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelBySkuNo.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelBySkuNo.num");
        }
    }

    private void delDgoodsuplistModelByGoodsNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.delByGoodsNo(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelByGoodsNo.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelByGoodsNo.num");
        }
    }

    private void deleteDgoodsuplistModel(Integer dgoodsuplistId) throws ApiException {
        if (null == dgoodsuplistId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.deleteByPrimaryKey(dgoodsuplistId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.deleteDgoodsuplistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.deleteDgoodsuplistModel.num");
        }
    }

    private void updateDgoodsuplistModel(DisDgoodsuplist disDgoodsuplist) throws ApiException {
        if (null == disDgoodsuplist) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.updateByPrimaryKey(disDgoodsuplist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistModel.num");
        }
    }

    private void updateStateDgoodsuplistModel(Integer dgoodsuplistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgoodsuplistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsuplistId", dgoodsuplistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModel.null");
        }
    }

    private void updateStateDgoodsuplistModelByCode(String tenantCode, String dgoodsuplistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistCode", dgoodsuplistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModelByCode.null");
        }
    }

    private DisDgoodsuplist makeDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain, DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplistDomain) {
            return null;
        }
        if (null == disDgoodsuplist) {
            disDgoodsuplist = new DisDgoodsuplist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsuplist, (Object)disDgoodsuplistDomain);
            return disDgoodsuplist;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.makeDgoodsuplist", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsuplistReDomain makeDisDgoodsuplistReDomain(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return null;
        }
        DisDgoodsuplistReDomain disDgoodsuplistReDomain = new DisDgoodsuplistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsuplistReDomain, (Object)disDgoodsuplist);
            return disDgoodsuplistReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.makeDisDgoodsuplistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoodsuplist> queryDgoodsuplistModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsuplistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoodsuplist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.countDgoodsuplist", (Throwable)e);
        }
        return i;
    }

    private DisDgoodsuplist createDisDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) {
        String msg = this.checkDgoodsuplist(disDgoodsuplistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplist.checkDgoodsuplist", msg);
        }
        DisDgoodsuplist disDgoodsuplist = this.makeDgoodsuplist(disDgoodsuplistDomain, null);
        this.setDgoodsuplistDefault(disDgoodsuplist);
        return disDgoodsuplist;
    }

    @Override
    public String saveDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) throws ApiException {
        if (this.checkUpdate(disDgoodsuplistDomain)) {
            this.updateDgoodsuplist(disDgoodsuplistDomain);
            return disDgoodsuplistDomain.getDgoodsuplistCode();
        }
        DisDgoodsuplist disDgoodsuplist = this.createDisDgoodsuplist(disDgoodsuplistDomain);
        this.saveDgoodsuplistModel(disDgoodsuplist);
        if (ListUtil.isNotEmpty(disDgoodsuplistDomain.getDisDgoodsuplistFileDomainList())) {
            this.saveDgoodsuplistFileBatch(disDgoodsuplistDomain.getDisDgoodsuplistFileDomainList());
        }
        this.updateCache(disDgoodsuplist);
        return disDgoodsuplist.getDgoodsuplistCode();
    }

    private boolean checkUpdate(DisDgoodsuplistDomain disDgoodsuplistDomain) {
        List<DisDgoodsuplist> list;
        if (null == disDgoodsuplistDomain) {
            return false;
        }
        if (null != disDgoodsuplistDomain.getDgoodsuplistId()) {
            return true;
        }
        if ((StringUtils.isNotBlank((String)disDgoodsuplistDomain.getSkuNo()) || StringUtils.isNotBlank((String)disDgoodsuplistDomain.getGoodsNo())) && StringUtils.isNotBlank((String)disDgoodsuplistDomain.getTenantCode()) && ListUtil.isNotEmpty(list = this.queryDgoodsuplistModelPage(this.getQueryMapParam("goodsNo,skuNo,channelCode,tenantCode", new Object[]{disDgoodsuplistDomain.getGoodsNo(), disDgoodsuplistDomain.getSkuNo(), disDgoodsuplistDomain.getChannelCode(), disDgoodsuplistDomain.getTenantCode()})))) {
            disDgoodsuplistDomain.setDgoodsuplistId(list.get(0).getDgoodsuplistId());
            disDgoodsuplistDomain.setDgoodsuplistCode(list.get(0).getDgoodsuplistCode());
            return true;
        }
        if (StringUtils.isBlank((String)disDgoodsuplistDomain.getSkuNo()) && StringUtils.isNotBlank((String)disDgoodsuplistDomain.getGoodsNo()) && StringUtils.isNotBlank((String)disDgoodsuplistDomain.getTenantCode()) && ListUtil.isNotEmpty(list = this.queryDgoodsuplistModelPage(this.getQueryMapParam("goodsNo,channelCode,tenantCode", new Object[]{disDgoodsuplistDomain.getGoodsNo(), disDgoodsuplistDomain.getChannelCode(), disDgoodsuplistDomain.getTenantCode()})))) {
            disDgoodsuplistDomain.setDgoodsuplistId(list.get(0).getDgoodsuplistId());
            disDgoodsuplistDomain.setDgoodsuplistCode(list.get(0).getDgoodsuplistCode());
            return true;
        }
        return false;
    }

    @Override
    public String saveDgoodsuplistBatch(List<DisDgoodsuplistDomain> disDgoodsuplistDomainList) throws ApiException {
        if (null == disDgoodsuplistDomainList || disDgoodsuplistDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (DisDgoodsuplistDomain disDgoodsuplistDomain : disDgoodsuplistDomainList) {
            code = this.saveDgoodsuplist(disDgoodsuplistDomain);
        }
        return code;
    }

    @Override
    public void updateDgoodsuplistState(Integer dgoodsuplistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgoodsuplistId) {
            return;
        }
        this.updateStateDgoodsuplistModel(dgoodsuplistId, dataState, oldDataState, map);
        if (-1 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelById(dgoodsuplistId);
            this.deleteCache(disDgoodsuplist);
        } else if (0 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelById(dgoodsuplistId);
            this.updateCache(disDgoodsuplist);
        }
    }

    @Override
    public void updateDgoodsuplistStateByCode(String tenantCode, String dgoodsuplistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgoodsuplistModelByCode(tenantCode, dgoodsuplistCode, dataState, oldDataState, map);
        if (-1 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelByCode(this.getQueryMapParam(tenantCode, new Object[]{dgoodsuplistCode, tenantCode, dgoodsuplistCode}));
            this.deleteCache(disDgoodsuplist);
        } else if (0 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelByCode(this.getQueryMapParam(tenantCode, new Object[]{dgoodsuplistCode, tenantCode, dgoodsuplistCode}));
            this.updateCache(disDgoodsuplist);
        }
    }

    @Override
    public void updateDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) throws ApiException {
        String msg = this.checkDgoodsuplist(disDgoodsuplistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplist.checkDgoodsuplist", msg);
        }
        DisDgoodsuplist oldDisDgoodsuplist = this.getDgoodsuplistModelById(disDgoodsuplistDomain.getDgoodsuplistId());
        if (null == oldDisDgoodsuplist) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String code = oldDisDgoodsuplist.getDgoodsuplistCode();
        DisDgoodsuplist disDgoodsuplist = this.makeDgoodsuplist(disDgoodsuplistDomain, oldDisDgoodsuplist);
        disDgoodsuplist.setDgoodsuplistCode(code);
        disDgoodsuplist = this.getDgoodsuplistModelById(disDgoodsuplistDomain.getDgoodsuplistId());
        this.setDgoodsuplistUpdataDefault(disDgoodsuplist);
        this.updateDgoodsuplistModel(disDgoodsuplist);
        this.updateCache(disDgoodsuplist);
    }

    @Override
    public DisDgoodsuplist getDgoodsuplist(Integer dgoodsuplistId) {
        if (null == dgoodsuplistId) {
            return null;
        }
        return this.getDgoodsuplistModelById(dgoodsuplistId);
    }

    @Override
    public void deleteDgoodsuplist(Integer dgoodsuplistId) throws ApiException {
        if (null == dgoodsuplistId) {
            return;
        }
        DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelById(dgoodsuplistId);
        this.deleteDgoodsuplistModel(dgoodsuplistId);
        this.deleteCache(disDgoodsuplist);
    }

    @Override
    public QueryResult<DisDgoodsuplist> queryDgoodsuplistPage(Map<String, Object> map) {
        List<DisDgoodsuplist> disDgoodsuplistList = this.queryDgoodsuplistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoodsuplist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsuplistList);
        return queryResult;
    }

    @Override
    public DisDgoodsuplist getDgoodsuplistByCode(String tenantCode, String dgoodsuplistCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistCode", dgoodsuplistCode);
        return this.getDgoodsuplistModelByCode(map);
    }

    @Override
    public void deleteDgoodsuplistByCode(String tenantCode, String dgoodsuplistCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistCode", dgoodsuplistCode);
        DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelByCode(map);
        this.delDgoodsuplistModelByCode(map);
        this.deleteCache(disDgoodsuplist);
    }

    private void updateFileCache(DisDgoodsuplistFile disDgoodsuplistFile) {
        ArrayList<DisDgoodsuplistFile> cachedlist;
        List dlist;
        String json;
        String key;
        if (null == disDgoodsuplistFile) {
            return;
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplistFile.getSkuNo())) {
            key = disDgoodsuplistFile.getChannelCode() + "-1-" + disDgoodsuplistFile.getSkuNo() + "-" + disDgoodsuplistFile.getTenantCode();
            json = DisUtil.getRemotMap((String)this.cacheFilekey, (String)key);
            if (StringUtils.isBlank((String)json)) {
                dlist = new ArrayList<DisDgoodsuplistFile>();
                dlist.add(disDgoodsuplistFile);
                DisUtil.setMapVer((String)this.cacheFilekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(dlist));
            } else {
                dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsuplistFile.class);
                cachedlist = new ArrayList<DisDgoodsuplistFile>();
                if (ListUtil.isEmpty(dlist)) {
                    cachedlist.add(disDgoodsuplistFile);
                } else {
                    for (DisDgoodsuplistFile disDgoodsuplistFile2 : dlist) {
                        if (disDgoodsuplistFile2.getDgoodsuplistFileCode().equals(disDgoodsuplistFile.getDgoodsuplistFileCode())) continue;
                        cachedlist.add(disDgoodsuplistFile2);
                    }
                    cachedlist.add(disDgoodsuplistFile);
                }
                DisUtil.setMapVer((String)this.cacheFilekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(cachedlist));
            }
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplistFile.getGoodsNo())) {
            key = disDgoodsuplistFile.getChannelCode() + "-0-" + disDgoodsuplistFile.getGoodsNo() + "-" + disDgoodsuplistFile.getTenantCode();
            json = DisUtil.getRemotMap((String)this.cacheFilekey, (String)key);
            if (StringUtils.isBlank((String)json)) {
                dlist = new ArrayList();
                dlist.add(disDgoodsuplistFile);
                DisUtil.setMapVer((String)this.cacheFilekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(dlist));
            } else {
                dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsuplistFile.class);
                cachedlist = new ArrayList();
                if (ListUtil.isEmpty(dlist)) {
                    cachedlist.add(disDgoodsuplistFile);
                } else {
                    for (DisDgoodsuplistFile disDgoodsuplistFile2 : dlist) {
                        if (disDgoodsuplistFile2.getDgoodsuplistFileCode().equals(disDgoodsuplistFile.getDgoodsuplistFileCode())) continue;
                        cachedlist.add(disDgoodsuplistFile2);
                    }
                    cachedlist.add(disDgoodsuplistFile);
                }
                DisUtil.setMapVer((String)this.cacheFilekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(cachedlist));
            }
        }
    }

    private void deleteFileCache(DisDgoodsuplistFile disDgoodsuplistFile) {
        ArrayList<DisDgoodsuplistFile> cachedlist;
        List dlist;
        String key;
        String json;
        if (null == disDgoodsuplistFile) {
            return;
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplistFile.getSkuNo()) && !StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cacheFilekey, (String)(key = disDgoodsuplistFile.getChannelCode() + "-1-" + disDgoodsuplistFile.getSkuNo() + "-" + disDgoodsuplistFile.getTenantCode()))))) {
            dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsuplistFile.class);
            cachedlist = new ArrayList<DisDgoodsuplistFile>();
            if (!ListUtil.isEmpty((Collection)dlist)) {
                for (DisDgoodsuplistFile disDgoodsuplistFile2 : dlist) {
                    if (disDgoodsuplistFile2.getDgoodsuplistFileCode().equals(disDgoodsuplistFile.getDgoodsuplistFileCode())) continue;
                    cachedlist.add(disDgoodsuplistFile2);
                }
            }
            DisUtil.setMapVer((String)this.cacheFilekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(cachedlist));
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplistFile.getGoodsNo()) && !StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cacheFilekey, (String)(key = disDgoodsuplistFile.getChannelCode() + "-0-" + disDgoodsuplistFile.getGoodsNo() + "-" + disDgoodsuplistFile.getTenantCode()))))) {
            dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsuplistFile.class);
            cachedlist = new ArrayList();
            if (!ListUtil.isEmpty((Collection)dlist)) {
                for (DisDgoodsuplistFile disDgoodsuplistFile2 : dlist) {
                    if (disDgoodsuplistFile2.getDgoodsuplistFileCode().equals(disDgoodsuplistFile.getDgoodsuplistFileCode())) continue;
                    cachedlist.add(disDgoodsuplistFile2);
                }
            }
            DisUtil.setMapVer((String)this.cacheFilekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(cachedlist));
        }
    }

    private void updateCache(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        String value = this.makeCache(disDgoodsuplist);
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getSkuNo())) {
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgoodsuplist.getChannelCode() + "-1-" + disDgoodsuplist.getSkuNo() + "-" + disDgoodsuplist.getTenantCode()), (String)value);
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getGoodsNo())) {
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgoodsuplist.getChannelCode() + "-0-" + disDgoodsuplist.getGoodsNo() + "-" + disDgoodsuplist.getTenantCode()), (String)value);
        }
    }

    private void deleteCache(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        if (null == disDgoodsuplist.getSkuShowno()) {
            disDgoodsuplist.setSkuShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowno()) {
            disDgoodsuplist.setGoodsShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowname()) {
            disDgoodsuplist.setGoodsShowname("");
        }
        if (null == disDgoodsuplist.getClasstreeShopcode()) {
            disDgoodsuplist.setClasstreeShopcode("");
        }
        if (null == disDgoodsuplist.getClasstreeShopname()) {
            disDgoodsuplist.setClasstreeShopname("");
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getSkuNo())) {
            DisUtil.delMapVer((String)this.cachekey, (String[])new String[]{disDgoodsuplist.getChannelCode() + "-1-" + disDgoodsuplist.getSkuNo() + "-" + disDgoodsuplist.getTenantCode()});
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getGoodsNo())) {
            DisUtil.delMapVer((String)this.cachekey, (String[])new String[]{disDgoodsuplist.getChannelCode() + "-0-" + disDgoodsuplist.getGoodsNo() + "-" + disDgoodsuplist.getTenantCode()});
        }
    }

    @Override
    public void queryDgoodsuplistLoadCache() {
        this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        this.loadlist(parammap);
        this.loadlistFile(parammap);
        this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========add-end==========");
    }

    private void loadlistFile(Map<String, Object> parammap) {
        List<DisDgoodsuplistFile> disDgoodsuplistlistFile = this.queryDgoodsuplistFileModelPage(parammap);
        if (null == disDgoodsuplistlistFile || disDgoodsuplistlistFile.isEmpty()) {
            DisUtil.delVer((String)this.cacheFilekey);
            this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========del-end==========");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<DisDgoodsuplistFile>> filemap = new HashMap<String, ArrayList<DisDgoodsuplistFile>>();
        for (DisDgoodsuplistFile disDgoodsuplistFile : disDgoodsuplistlistFile) {
            if (StringUtils.isNotBlank((String)disDgoodsuplistFile.getSkuNo())) {
                String key = disDgoodsuplistFile.getChannelCode() + "-1-" + disDgoodsuplistFile.getSkuNo() + "-" + disDgoodsuplistFile.getTenantCode();
                ArrayList<DisDgoodsuplistFile> mapList = (ArrayList<DisDgoodsuplistFile>)filemap.get(key);
                if (null == mapList) {
                    mapList = new ArrayList<DisDgoodsuplistFile>();
                    filemap.put(key, mapList);
                }
                mapList.add(disDgoodsuplistFile);
            }
            if (!StringUtils.isNotBlank((String)disDgoodsuplistFile.getGoodsNo())) continue;
            String key1 = disDgoodsuplistFile.getChannelCode() + "-0-" + disDgoodsuplistFile.getGoodsNo() + "-" + disDgoodsuplistFile.getTenantCode();
            ArrayList<DisDgoodsuplistFile> mapList1 = (ArrayList<DisDgoodsuplistFile>)filemap.get(key1);
            if (null == mapList1) {
                mapList1 = new ArrayList<DisDgoodsuplistFile>();
                filemap.put(key1, mapList1);
            }
            mapList1.add(disDgoodsuplistFile);
        }
        for (String makeKey : filemap.keySet()) {
            map.put(makeKey, JsonUtil.buildNormalBinder().toJson(filemap.get(makeKey)));
        }
        DisUtil.setMapVer((String)this.cacheFilekey, map);
    }

    private String makeCache(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return "";
        }
        if (null == disDgoodsuplist.getSkuShowno()) {
            disDgoodsuplist.setSkuShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowno()) {
            disDgoodsuplist.setGoodsShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowname()) {
            disDgoodsuplist.setGoodsShowname("");
        }
        if (null == disDgoodsuplist.getClasstreeShopcode()) {
            disDgoodsuplist.setClasstreeShopcode("");
        }
        if (null == disDgoodsuplist.getClasstreeShopname()) {
            disDgoodsuplist.setClasstreeShopname("");
        }
        if (null == disDgoodsuplist.getClasstreeShopcode1()) {
            disDgoodsuplist.setClasstreeShopcode1("");
        }
        if (null == disDgoodsuplist.getClasstreeShopname1()) {
            disDgoodsuplist.setClasstreeShopname1("");
        }
        if (null == disDgoodsuplist.getClasstreeShopcode2()) {
            disDgoodsuplist.setClasstreeShopcode2("");
        }
        if (null == disDgoodsuplist.getClasstreeShopname2()) {
            disDgoodsuplist.setClasstreeShopname2("");
        }
        if (null == disDgoodsuplist.getClasstreeShopcode3()) {
            disDgoodsuplist.setClasstreeShopcode3("");
        }
        if (null == disDgoodsuplist.getClasstreeShopname3()) {
            disDgoodsuplist.setClasstreeShopname3("");
        }
        String value = disDgoodsuplist.getSkuShowno() + "|" + disDgoodsuplist.getGoodsShowno() + "|" + disDgoodsuplist.getGoodsShowname() + "|" + disDgoodsuplist.getClasstreeShopcode() + "|" + disDgoodsuplist.getClasstreeShopname() + "|" + disDgoodsuplist.getClasstreeShopcode1() + "|" + disDgoodsuplist.getClasstreeShopname1() + "|" + disDgoodsuplist.getClasstreeShopcode2() + "|" + disDgoodsuplist.getClasstreeShopname2() + "|" + disDgoodsuplist.getClasstreeShopcode3() + "|" + disDgoodsuplist.getClasstreeShopname3();
        return value;
    }

    private void loadlist(Map<String, Object> parammap) {
        List<DisDgoodsuplist> disDgoodsuplistlist = this.queryDgoodsuplistModelPage(parammap);
        if (null == disDgoodsuplistlist || disDgoodsuplistlist.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========del-end==========");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DisDgoodsuplist disDgoodsuplist : disDgoodsuplistlist) {
            String value = this.makeCache(disDgoodsuplist);
            if (StringUtils.isNotBlank((String)disDgoodsuplist.getSkuNo())) {
                map.put(disDgoodsuplist.getChannelCode() + "-1-" + disDgoodsuplist.getSkuNo() + "-" + disDgoodsuplist.getTenantCode(), value);
            }
            if (!StringUtils.isNotBlank((String)disDgoodsuplist.getGoodsNo())) continue;
            map.put(disDgoodsuplist.getChannelCode() + "-0-" + disDgoodsuplist.getGoodsNo() + "-" + disDgoodsuplist.getTenantCode(), value);
        }
        DisUtil.setMapVer((String)this.cachekey, map);
    }

    public void setDisDgoodsuplistFileMapper(DisDgoodsuplistFileMapper disDgoodsuplistFileMapper) {
        this.disDgoodsuplistFileMapper = disDgoodsuplistFileMapper;
    }

    private String checkDgoodsuplistFile(DisDgoodsuplistFileDomain disDgoodsuplistFileDomain) {
        if (null == disDgoodsuplistFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsuplistFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsuplistFileDefault(DisDgoodsuplistFile disDgoodsuplistFile) {
        if (null == disDgoodsuplistFile) {
            return;
        }
        if (null == disDgoodsuplistFile.getDataState()) {
            disDgoodsuplistFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgoodsuplistFile.getGmtCreate()) {
            disDgoodsuplistFile.setGmtCreate(date);
        }
        disDgoodsuplistFile.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgoodsuplistFile.getDgoodsuplistFileCode())) {
            disDgoodsuplistFile.setDgoodsuplistFileCode(this.getNo(null, "DisDgoodsuplistFile", "disDgoodsuplistFile", disDgoodsuplistFile.getTenantCode()));
        }
    }

    private int getDgoodsuplistFileMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsuplistFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsuplistFileUpdataDefault(DisDgoodsuplistFile disDgoodsuplistFile) {
        if (null == disDgoodsuplistFile) {
            return;
        }
        disDgoodsuplistFile.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsuplistFileModel(DisDgoodsuplistFile disDgoodsuplistFile) throws ApiException {
        if (null == disDgoodsuplistFile) {
            return;
        }
        try {
            this.disDgoodsuplistFileMapper.insert(disDgoodsuplistFile);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistFileModel.ex", (Throwable)e);
        }
    }

    private void saveDgoodsuplistFileBatchModel(List<DisDgoodsuplistFile> disDgoodsuplistFileList) throws ApiException {
        if (null == disDgoodsuplistFileList || disDgoodsuplistFileList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsuplistFileMapper.insertBatch(disDgoodsuplistFileList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistFileBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoodsuplistFile getDgoodsuplistFileModelById(Integer dgoodsuplistFileId) {
        if (null == dgoodsuplistFileId) {
            return null;
        }
        try {
            return this.disDgoodsuplistFileMapper.selectByPrimaryKey(dgoodsuplistFileId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistFileModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsuplistFile getDgoodsuplistFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsuplistFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsuplistFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistFileModelByCode.num");
        }
    }

    private void delDgoodsuplistFileModelBySkuNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsuplistFileMapper.delBySkuNo(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistFileModelBySkuNo.ex", (Throwable)e);
        }
    }

    private void delDgoodsuplistFileModelByGoodsNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.delByGoodsNo(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistFileModelByGoodsNo.ex", (Throwable)e);
        }
    }

    private void deleteDgoodsuplistFileModel(Integer dgoodsuplistFileId) throws ApiException {
        if (null == dgoodsuplistFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.deleteByPrimaryKey(dgoodsuplistFileId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.deleteDgoodsuplistFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.deleteDgoodsuplistFileModel.num");
        }
    }

    private void updateDgoodsuplistFileModel(DisDgoodsuplistFile disDgoodsuplistFile) throws ApiException {
        if (null == disDgoodsuplistFile) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.updateByPrimaryKey(disDgoodsuplistFile);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistFileModel.num");
        }
    }

    private void updateStateDgoodsuplistFileModel(Integer dgoodsuplistFileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgoodsuplistFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsuplistFileId", dgoodsuplistFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistFileModel.null");
        }
    }

    private void updateStateDgoodsuplistFileModelByCode(String tenantCode, String dgoodsuplistFileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistFileCode", dgoodsuplistFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistFileModelByCode.null");
        }
    }

    private DisDgoodsuplistFile makeDgoodsuplistFile(DisDgoodsuplistFileDomain disDgoodsuplistFileDomain, DisDgoodsuplistFile disDgoodsuplistFile) {
        if (null == disDgoodsuplistFileDomain) {
            return null;
        }
        if (null == disDgoodsuplistFile) {
            disDgoodsuplistFile = new DisDgoodsuplistFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsuplistFile, (Object)disDgoodsuplistFileDomain);
            return disDgoodsuplistFile;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.makeDgoodsuplistFile", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsuplistFileReDomain makeDisDgoodsuplistFileReDomain(DisDgoodsuplistFile disDgoodsuplistFile) {
        if (null == disDgoodsuplistFile) {
            return null;
        }
        DisDgoodsuplistFileReDomain disDgoodsuplistFileReDomain = new DisDgoodsuplistFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsuplistFileReDomain, (Object)disDgoodsuplistFile);
            return disDgoodsuplistFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.makeDisDgoodsuplistFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoodsuplistFile> queryDgoodsuplistFileModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsuplistFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistFileModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoodsuplistFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsuplistFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.countDgoodsuplistFile", (Throwable)e);
        }
        return i;
    }

    private DisDgoodsuplistFile createDisDgoodsuplistFile(DisDgoodsuplistFileDomain disDgoodsuplistFileDomain) {
        String msg = this.checkDgoodsuplistFile(disDgoodsuplistFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistFile.checkDgoodsuplistFile", msg);
        }
        DisDgoodsuplistFile disDgoodsuplistFile = this.makeDgoodsuplistFile(disDgoodsuplistFileDomain, null);
        this.setDgoodsuplistFileDefault(disDgoodsuplistFile);
        return disDgoodsuplistFile;
    }

    @Override
    public String saveDgoodsuplistFile(DisDgoodsuplistFileDomain disDgoodsuplistFileDomain) throws ApiException {
        if (null != disDgoodsuplistFileDomain && null != disDgoodsuplistFileDomain.getDgoodsuplistFileId()) {
            this.updateDgoodsuplistFile(disDgoodsuplistFileDomain);
            return disDgoodsuplistFileDomain.getDgoodsuplistFileCode();
        }
        DisDgoodsuplistFile disDgoodsuplistFile = this.createDisDgoodsuplistFile(disDgoodsuplistFileDomain);
        this.saveDgoodsuplistFileModel(disDgoodsuplistFile);
        this.updateFileCache(disDgoodsuplistFile);
        return disDgoodsuplistFile.getDgoodsuplistFileCode();
    }

    @Override
    public String saveDgoodsuplistFileBatch(List<DisDgoodsuplistFileDomain> disDgoodsuplistFileDomainList) throws ApiException {
        if (null == disDgoodsuplistFileDomainList || disDgoodsuplistFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDgoodsuplistFile> disDgoodsuplistFileList = new ArrayList<DisDgoodsuplistFile>();
        String code = "";
        HashMap<String, String> map = new HashMap<String, String>();
        String key = "";
        for (DisDgoodsuplistFileDomain disDgoodsuplistFileDomain : disDgoodsuplistFileDomainList) {
            key = disDgoodsuplistFileDomain.getTenantCode() + "-" + disDgoodsuplistFileDomain.getSkuNo() + "-" + disDgoodsuplistFileDomain.getChannelCode();
            if (StringUtils.isBlank((String)((String)map.get(key)))) {
                this.deleteDgoodsuplistFileBySkuNo(disDgoodsuplistFileDomain.getTenantCode(), disDgoodsuplistFileDomain.getSkuNo(), disDgoodsuplistFileDomain.getChannelCode());
                map.put(key, key);
            }
            DisDgoodsuplistFile disDgoodsuplistFile = this.createDisDgoodsuplistFile(disDgoodsuplistFileDomain);
            code = disDgoodsuplistFile.getDgoodsuplistFileCode();
            disDgoodsuplistFileList.add(disDgoodsuplistFile);
        }
        if (ListUtil.isNotEmpty(disDgoodsuplistFileList)) {
            this.saveDgoodsuplistFileBatchModel(disDgoodsuplistFileList);
            for (DisDgoodsuplistFile disDgoodsuplistFile2 : disDgoodsuplistFileList) {
                this.updateFileCache(disDgoodsuplistFile2);
            }
        }
        return code;
    }

    @Override
    public void updateDgoodsuplistFileState(Integer dgoodsuplistFileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgoodsuplistFileId) {
            return;
        }
        this.updateStateDgoodsuplistFileModel(dgoodsuplistFileId, dataState, oldDataState, map);
        if (dataState == -1) {
            DisDgoodsuplistFile disDgoodsuplistFile = this.getDgoodsuplistFileModelById(dgoodsuplistFileId);
            this.deleteFileCache(disDgoodsuplistFile);
        } else if (oldDataState == -1) {
            DisDgoodsuplistFile disDgoodsuplistFile = this.getDgoodsuplistFileModelById(dgoodsuplistFileId);
            this.updateFileCache(disDgoodsuplistFile);
        }
    }

    @Override
    public void updateDgoodsuplistFileStateByCode(String tenantCode, String dgoodsuplistFileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgoodsuplistFileModelByCode(tenantCode, dgoodsuplistFileCode, dataState, oldDataState, map);
        if (dataState == -1) {
            DisDgoodsuplistFile disDgoodsuplistFile = this.getDgoodsuplistFileByCode(tenantCode, dgoodsuplistFileCode);
            this.deleteFileCache(disDgoodsuplistFile);
        } else if (oldDataState == -1) {
            DisDgoodsuplistFile disDgoodsuplistFile = this.getDgoodsuplistFileByCode(tenantCode, dgoodsuplistFileCode);
            this.updateFileCache(disDgoodsuplistFile);
        }
    }

    @Override
    public void updateDgoodsuplistFile(DisDgoodsuplistFileDomain disDgoodsuplistFileDomain) throws ApiException {
        String msg = this.checkDgoodsuplistFile(disDgoodsuplistFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistFile.checkDgoodsuplistFile", msg);
        }
        DisDgoodsuplistFile oldDisDgoodsuplistFile = this.getDgoodsuplistFileModelById(disDgoodsuplistFileDomain.getDgoodsuplistFileId());
        if (null == oldDisDgoodsuplistFile) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String code = oldDisDgoodsuplistFile.getDgoodsuplistFileCode();
        DisDgoodsuplistFile disDgoodsuplistFile = this.makeDgoodsuplistFile(disDgoodsuplistFileDomain, oldDisDgoodsuplistFile);
        disDgoodsuplistFile.setDgoodsuplistFileCode(code);
        this.setDgoodsuplistFileUpdataDefault(disDgoodsuplistFile);
        this.updateDgoodsuplistFileModel(disDgoodsuplistFile);
        this.updateFileCache(disDgoodsuplistFile);
    }

    @Override
    public DisDgoodsuplistFile getDgoodsuplistFile(Integer dgoodsuplistFileId) {
        if (null == dgoodsuplistFileId) {
            return null;
        }
        return this.getDgoodsuplistFileModelById(dgoodsuplistFileId);
    }

    @Override
    public void deleteDgoodsuplistFile(Integer dgoodsuplistFileId) throws ApiException {
        if (null == dgoodsuplistFileId) {
            return;
        }
        DisDgoodsuplistFile disDgoodsuplistFile = this.getDgoodsuplistFileModelById(dgoodsuplistFileId);
        this.deleteDgoodsuplistFileModel(dgoodsuplistFileId);
        this.deleteFileCache(disDgoodsuplistFile);
    }

    @Override
    public QueryResult<DisDgoodsuplistFile> queryDgoodsuplistFilePage(Map<String, Object> map) {
        List<DisDgoodsuplistFile> disDgoodsuplistFileList = this.queryDgoodsuplistFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoodsuplistFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsuplistFileList);
        return queryResult;
    }

    @Override
    public DisDgoodsuplistFile getDgoodsuplistFileByCode(String tenantCode, String dgoodsuplistFileCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistFileCode", dgoodsuplistFileCode);
        return this.getDgoodsuplistFileModelByCode(map);
    }

    @Override
    public void deleteDgoodsuplistFileByCode(String tenantCode, String dgoodsuplistFileCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistFileCode", dgoodsuplistFileCode);
        DisDgoodsuplistFile disDgoodsuplistFile = this.getDgoodsuplistFileModelByCode(map);
        this.delDgoodsuplistFileModelByCode(map);
        this.deleteFileCache(disDgoodsuplistFile);
    }

    @Override
    public void deleteDgoodsuplistByGoodsNo(String tenantCode, String goodsNo, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsNo) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        Map map = this.getQueryMapParam("goodsNo,channelCode,tenantCode", new Object[]{goodsNo, channelCode, tenantCode});
        List<DisDgoodsuplist> list = this.queryDgoodsuplistModelPage(map);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        this.delDgoodsuplistModelByGoodsNo(map);
        for (DisDgoodsuplist disDgoodsuplist : list) {
            this.deleteCache(disDgoodsuplist);
        }
    }

    @Override
    public void deleteDgoodsuplistBySkuNo(String tenantCode, String skuNo, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        Map map = this.getQueryMapParam("skuNo,channelCode,tenantCode", new Object[]{skuNo, channelCode, tenantCode});
        List<DisDgoodsuplist> list = this.queryDgoodsuplistModelPage(map);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        this.delDgoodsuplistModelBySkuNo(map);
        for (DisDgoodsuplist disDgoodsuplist : list) {
            this.deleteCache(disDgoodsuplist);
        }
    }

    @Override
    public void deleteDgoodsuplistFileByGoodsNo(String tenantCode, String goodsNo, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsNo) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        Map map = this.getQueryMapParam("goodsNo,channelCode,tenantCode", new Object[]{goodsNo, channelCode, tenantCode});
        List<DisDgoodsuplistFile> list = this.queryDgoodsuplistFileModelPage(map);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        this.delDgoodsuplistFileModelByGoodsNo(map);
        for (DisDgoodsuplistFile disDgoodsuplistFile : list) {
            this.deleteFileCache(disDgoodsuplistFile);
        }
    }

    @Override
    public void deleteDgoodsuplistFileBySkuNo(String tenantCode, String skuNo, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        Map map = this.getQueryMapParam("skuNo,channelCode,tenantCode", new Object[]{skuNo, channelCode, tenantCode});
        List<DisDgoodsuplistFile> list = this.queryDgoodsuplistFileModelPage(map);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        this.delDgoodsuplistFileModelBySkuNo(map);
        for (DisDgoodsuplistFile disDgoodsuplistFile : list) {
            this.deleteFileCache(disDgoodsuplistFile);
        }
    }
}

