/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eq.service.impl;

import com.yqbsoft.laser.service.eq.dao.EqAuctionGoodsMapper;
import com.yqbsoft.laser.service.eq.domain.EqAuctionGoodsDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionGoodsReDomain;
import com.yqbsoft.laser.service.eq.model.EqAuctionGoods;
import com.yqbsoft.laser.service.eq.service.EqAuctionGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EqAuctionGoodsServiceImpl
extends BaseServiceImpl
implements EqAuctionGoodsService {
    private static final String SYS_CODE = "eq.EqAuctionGoodsServiceImpl";
    private EqAuctionGoodsMapper eqAuctionGoodsMapper;

    public void setEqAuctionGoodsMapper(EqAuctionGoodsMapper eqAuctionGoodsMapper) {
        this.eqAuctionGoodsMapper = eqAuctionGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.eqAuctionGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctionGoods(EqAuctionGoodsDomain eqAuctionGoodsDomain) {
        if (null == eqAuctionGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)eqAuctionGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionGoodsDefault(EqAuctionGoods eqAuctionGoods) {
        if (null == eqAuctionGoods) {
            return;
        }
        if (null == eqAuctionGoods.getDataState()) {
            eqAuctionGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == eqAuctionGoods.getGmtCreate()) {
            eqAuctionGoods.setGmtCreate(date);
        }
        eqAuctionGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)eqAuctionGoods.getAuctionGoodsCode())) {
            eqAuctionGoods.setAuctionGoodsCode(this.getNo(null, "EqAuctionGoods", "eqAuctionGoods", eqAuctionGoods.getTenantCode()));
        }
    }

    private int getAuctionGoodsMaxCode() {
        int code = 0;
        try {
            return this.eqAuctionGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.getAuctionGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionGoodsUpdataDefault(EqAuctionGoods eqAuctionGoods) {
        if (null == eqAuctionGoods) {
            return;
        }
        eqAuctionGoods.setGmtModified(this.getSysDate());
    }

    private void saveAuctionGoodsModel(EqAuctionGoods eqAuctionGoods) throws ApiException {
        if (null == eqAuctionGoods) {
            return;
        }
        try {
            this.eqAuctionGoodsMapper.insert(eqAuctionGoods);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.saveAuctionGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionGoodsBatchModel(List<EqAuctionGoods> eqAuctionGoodsList) throws ApiException {
        if (null == eqAuctionGoodsList) {
            return;
        }
        try {
            this.eqAuctionGoodsMapper.insertBatch(eqAuctionGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.saveAuctionGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private EqAuctionGoods getAuctionGoodsModelById(Integer auctionGoodsId) {
        if (null == auctionGoodsId) {
            return null;
        }
        try {
            return this.eqAuctionGoodsMapper.selectByPrimaryKey(auctionGoodsId);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.getAuctionGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private EqAuctionGoods getAuctionGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.eqAuctionGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.getAuctionGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.delAuctionGoodsModelByCode.ex", (Throwable)e);
        }
    }

    private void deleteAuctionGoodsModel(Integer auctionGoodsId) throws ApiException {
        if (null == auctionGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionGoodsMapper.deleteByPrimaryKey(auctionGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.deleteAuctionGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.deleteAuctionGoodsModel.num");
        }
    }

    private void updateAuctionGoodsModel(EqAuctionGoods eqAuctionGoods) throws ApiException {
        if (null == eqAuctionGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionGoodsMapper.updateByPrimaryKeySelective(eqAuctionGoods);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateAuctionGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateAuctionGoodsModel.num");
        }
    }

    private void updateStateAuctionGoodsModel(Integer auctionGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionGoodsId", auctionGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateStateAuctionGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateStateAuctionGoodsModel.null");
        }
    }

    private void updateStateAuctionGoodsModelByCode(String tenantCode, String auctionGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionGoodsCode", auctionGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateStateAuctionGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateStateAuctionGoodsModelByCode.null");
        }
    }

    private EqAuctionGoods makeAuctionGoods(EqAuctionGoodsDomain eqAuctionGoodsDomain, EqAuctionGoods eqAuctionGoods) {
        if (null == eqAuctionGoodsDomain) {
            return null;
        }
        if (null == eqAuctionGoods) {
            eqAuctionGoods = new EqAuctionGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionGoods, (Object)eqAuctionGoodsDomain);
            return eqAuctionGoods;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.makeAuctionGoods", (Throwable)e);
            return null;
        }
    }

    private EqAuctionGoodsReDomain makeEqAuctionGoodsReDomain(EqAuctionGoods eqAuctionGoods) {
        if (null == eqAuctionGoods) {
            return null;
        }
        EqAuctionGoodsReDomain eqAuctionGoodsReDomain = new EqAuctionGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionGoodsReDomain, (Object)eqAuctionGoods);
            return eqAuctionGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.makeEqAuctionGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<EqAuctionGoods> queryAuctionGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.eqAuctionGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.queryAuctionGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countAuctionGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.eqAuctionGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionGoodsServiceImpl.countAuctionGoods", (Throwable)e);
        }
        return i;
    }

    private EqAuctionGoods createEqAuctionGoods(EqAuctionGoodsDomain eqAuctionGoodsDomain) {
        String msg = this.checkAuctionGoods(eqAuctionGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.saveAuctionGoods.checkAuctionGoods", msg);
        }
        EqAuctionGoods eqAuctionGoods = this.makeAuctionGoods(eqAuctionGoodsDomain, null);
        this.setAuctionGoodsDefault(eqAuctionGoods);
        return eqAuctionGoods;
    }

    @Override
    public String saveAuctionGoods(EqAuctionGoodsDomain eqAuctionGoodsDomain) throws ApiException {
        EqAuctionGoods eqAuctionGoods = this.createEqAuctionGoods(eqAuctionGoodsDomain);
        this.saveAuctionGoodsModel(eqAuctionGoods);
        return eqAuctionGoods.getAuctionGoodsCode();
    }

    @Override
    public String saveAuctionGoodsBatch(List<EqAuctionGoodsDomain> goodsList) throws ApiException {
        ArrayList<EqAuctionGoods> eqAuctionGoodsList = new ArrayList<EqAuctionGoods>();
        for (EqAuctionGoodsDomain goodsDomain : goodsList) {
            EqAuctionGoods eqAuctionGoods = this.createEqAuctionGoods(goodsDomain);
            eqAuctionGoodsList.add(eqAuctionGoods);
        }
        this.saveAuctionGoodsBatchModel(eqAuctionGoodsList);
        return ((EqAuctionGoods)eqAuctionGoodsList.get(0)).getAuctionGoodsCode();
    }

    private EqAuctionGoodsDomain setDefaultValueOfEqAuctionGood(EqAuctionGoodsDomain source) {
        EqAuctionGoodsReDomain result = new EqAuctionGoodsReDomain();
        result.setAuctionGoodsCode(this.createUUIDString());
        result.setAuctionGinfoCode("\u8be2\u62a5\u4ef7\u65e0 AUCTION_GINFO_CODE");
        result.setAuctionEnrollCode("");
        result.setPricesetPrefprice(BigDecimal.ZERO);
        result.setGoodsNum(BigDecimal.ZERO);
        result.setPricesetInsideprice(BigDecimal.ZERO);
        result.setSkuCode("");
        result.setGoodsName("");
        result.setDataPic("");
        result.setGoodsCode("");
        result.setGoodsName("");
        result.setPartsnameNumunit("");
        result.setPricesetNprice(BigDecimal.ZERO);
        result.setGoodsSupplynum(BigDecimal.ZERO);
        result.setBrandCode("");
        result.setBrandName("");
        result.setClasstreeCode("");
        result.setClasstreeName("");
        result.setTenantCode("");
        result.setChannelCode("");
        if (source != null) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)result, (Object)source);
            }
            catch (Exception e) {
                throw new RuntimeException("copy property error");
            }
        }
        return result;
    }

    @Override
    public void updateAuctionGoodsState(Integer auctionGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionGoodsId) {
            return;
        }
        this.updateStateAuctionGoodsModel(auctionGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionGoodsStateByCode(String tenantCode, String auctionGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionGoodsModelByCode(tenantCode, auctionGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionGoods(EqAuctionGoodsDomain eqAuctionGoodsDomain) throws ApiException {
        String msg = this.checkAuctionGoods(eqAuctionGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateAuctionGoods.checkAuctionGoods", msg);
        }
        EqAuctionGoods oldEqAuctionGoods = this.getAuctionGoodsModelById(eqAuctionGoodsDomain.getAuctionGoodsId());
        if (null == oldEqAuctionGoods) {
            throw new ApiException("eq.EqAuctionGoodsServiceImpl.updateAuctionGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EqAuctionGoods eqAuctionGoods = this.makeAuctionGoods(eqAuctionGoodsDomain, oldEqAuctionGoods);
        this.setAuctionGoodsUpdataDefault(eqAuctionGoods);
        this.updateAuctionGoodsModel(eqAuctionGoods);
    }

    @Override
    public EqAuctionGoods getAuctionGoods(Integer auctionGoodsId) {
        if (null == auctionGoodsId) {
            return null;
        }
        return this.getAuctionGoodsModelById(auctionGoodsId);
    }

    @Override
    public void deleteAuctionGoods(Integer auctionGoodsId) throws ApiException {
        if (null == auctionGoodsId) {
            return;
        }
        this.deleteAuctionGoodsModel(auctionGoodsId);
    }

    @Override
    public QueryResult<EqAuctionGoods> queryAuctionGoodsPage(Map<String, Object> map) {
        List<EqAuctionGoods> eqAuctionGoodsList = this.queryAuctionGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctionGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(eqAuctionGoodsList);
        return queryResult;
    }

    @Override
    public EqAuctionGoods getAuctionGoodsByCode(String tenantCode, String auctionGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionGoodsCode", auctionGoodsCode);
        return this.getAuctionGoodsModelByCode(map);
    }

    @Override
    public void deleteAuctionGoodsByCode(String tenantCode, String auctionGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionGoodsCode", auctionGoodsCode);
        this.delAuctionGoodsModelByCode(map);
    }

    @Override
    public void deleteAuctionGoodsByEnrollCode(String tenantCode, String auctionEnrollCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionEnrollCode", auctionEnrollCode);
        this.delAuctionGoodsModelByCode(map);
    }
}

