/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmRouteRuleMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmRouteRuleDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmRouteRule;
import com.yqbsoft.laser.service.esb.appmanage.service.RouteRuleService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.RouteRule;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteRuleServiceImpl
extends BaseServiceImpl
implements RouteRuleService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.RouteRuleServiceImpl";
    private AmRouteRuleMapper amRouteRuleMapper;

    public void setAmRouteRuleMapper(AmRouteRuleMapper amRouteRuleMapper) {
        this.amRouteRuleMapper = amRouteRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.amRouteRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouteRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRouteOption(AmRouteRuleDomain amRouteRuleDomain) {
        if (null == amRouteRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        return "";
    }

    private void setRouteOptionDefault(AmRouteRule amRouteRule) {
        if (null == amRouteRule) {
            return;
        }
        if (null == amRouteRule.getDataState()) {
            amRouteRule.setDataState(0);
        }
        if (null == amRouteRule.getGmtCreate()) {
            amRouteRule.setGmtCreate(this.getSysDate());
        }
        amRouteRule.setGmtModified(this.getSysDate());
    }

    private void setRouteOptionUpdataDefault(AmRouteRule amRouteRule) {
        if (null == amRouteRule) {
            return;
        }
        amRouteRule.setGmtModified(this.getSysDate());
    }

    private void saveRouteOptionModel(AmRouteRule amRouteRule) throws ApiException {
        if (null == amRouteRule) {
            return;
        }
        try {
            this.amRouteRuleMapper.insert(amRouteRule);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.saveFtpserverModel.ex");
        }
    }

    private AmRouteRule getRouteOptionModelById(Integer routeOptionId) {
        if (null == routeOptionId) {
            return null;
        }
        try {
            return this.amRouteRuleMapper.selectByPrimaryKey(routeOptionId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouteRuleServiceImpl.getRouteOptionModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteRouteOptionModel(Integer routeOptionId) throws ApiException {
        if (null == routeOptionId) {
            return;
        }
        int i = 0;
        try {
            i = this.amRouteRuleMapper.deleteByPrimaryKey(routeOptionId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.deleteRouteOptionModel.ex");
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.deleteRouteOptionModel.num");
        }
    }

    private void updateRouteOptionModel(AmRouteRule amRouteRule) throws ApiException {
        if (null == amRouteRule) {
            return;
        }
        try {
            this.amRouteRuleMapper.updateByPrimaryKeySelective(amRouteRule);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.updateRouteOptionModel.ex");
        }
    }

    private void updateStateRouteOptionModel(Integer routeOptionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == routeOptionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routeRuleId", routeOptionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amRouteRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.updateStateRouteOptionModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.updateStateRouteOptionModel.null");
        }
    }

    private AmRouteRule makeRouteOption(AmRouteRuleDomain amRouteRuleDomain, AmRouteRule amRouteRule) {
        if (null == amRouteRuleDomain) {
            return null;
        }
        if (null == amRouteRule) {
            amRouteRule = new AmRouteRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amRouteRule, (Object)amRouteRuleDomain);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouteRuleServiceImpl.makeRouteOption", (Throwable)e);
        }
        return amRouteRule;
    }

    private List<AmRouteRule> queryRouteOptionModelPage(Map<String, Object> parammap) {
        try {
            return this.amRouteRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouteRuleServiceImpl.queryRouteOptionModel", (Throwable)e);
            return null;
        }
    }

    private int countRouteOption(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amRouteRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouteRuleServiceImpl.countRouteOption", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRouteRule(AmRouteRuleDomain amRouteRuleDomain) throws ApiException {
        String msg = this.checkRouteOption(amRouteRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.saveRouteOption.checkRouteOption", msg);
        }
        AmRouteRule AmRouteRule2 = this.makeRouteOption(amRouteRuleDomain, null);
        this.setRouteOptionDefault(AmRouteRule2);
        this.saveRouteOptionModel(AmRouteRule2);
        this.refreshCache(AmRouteRule2, 1);
    }

    @Override
    public void updateRouteRuleState(Integer routeOptionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRouteOptionModel(routeOptionId, dataState, oldDataState);
        this.refreshCache(this.getRouteRule(routeOptionId), dataState);
    }

    @Override
    public void updateRouteRule(AmRouteRuleDomain amRouteRuleDomain) throws ApiException {
        String msg = this.checkRouteOption(amRouteRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.updateRouteOption.checkRouteOption", msg);
        }
        AmRouteRule oldAmRouteRule = this.getRouteOptionModelById(amRouteRuleDomain.getRouteRuleId());
        if (null == oldAmRouteRule) {
            throw new ApiException("am.ESB.APPMANAGE.RouteRuleServiceImpl.updateRouteOption.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmRouteRule AmRouteRule2 = this.makeRouteOption(amRouteRuleDomain, oldAmRouteRule);
        this.setRouteOptionUpdataDefault(AmRouteRule2);
        this.updateRouteOptionModel(AmRouteRule2);
    }

    @Override
    public AmRouteRule getRouteRule(Integer routeOptionId) {
        return this.getRouteOptionModelById(routeOptionId);
    }

    @Override
    public void deleteRouteRule(Integer routeOptionId) throws ApiException {
        this.deleteRouteOptionModel(routeOptionId);
    }

    @Override
    public QueryResult<AmRouteRule> queryRouteRulePage(Map<String, Object> map) {
        List<AmRouteRule> amRouteRuleList = this.queryRouteOptionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRouteOption(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amRouteRuleList);
        return queryResult;
    }

    @Override
    public void queryRouteRuleCache() {
        this.info("am.ESB.APPMANAGE.RouteRuleServiceImpl.queryRouteRuleCache", "=======queryRouteRuleCache\u8c03\u5ea6start=======");
        DisUtil.delVer((String)"AmRouteRule-phase");
        this.info("am.ESB.APPMANAGE.RouteRuleServiceImpl.clear Cache\uff1a", "AmRouteRule-phase=" + DisUtil.get((String)"AmRouteRule-phase"));
        List<AmRouteRule> amRouteRuleList = this.queryRouteOptionModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (amRouteRuleList == null || amRouteRuleList.isEmpty()) {
            this.info("am.ESB.APPMANAGE.RouteRuleServiceImpl.queryRouteRuleCache", "=======queryRouteRuleCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<RouteRule>> phaseMap = new HashMap<String, List<RouteRule>>();
        for (AmRouteRule amRouteRule : amRouteRuleList) {
            this.savePhase(amRouteRule, phaseMap);
        }
        DisUtil.setVer((String)"AmRouteRule-phase", (String)JsonUtil.buildNormalBinder().toJson(phaseMap));
        this.info("am.ESB.APPMANAGE.RouteRuleServiceImpl.load Cache\uff1a", "AmRouteRule-phase=" + DisUtil.get((String)"AmRouteRule-phase"));
        this.info("am.ESB.APPMANAGE.RouteRuleServiceImpl.queryRouteRuleCache", "=======queryRouteRuleCache\u8c03\u5ea6end=======");
    }

    private void refreshCache(AmRouteRule amRouteRule, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<RouteRule>> map = DisUtil.getMapByListJson((String)"AmRouteRule-pro", String.class, RouteRule.class);
        if (map == null) {
            map = new HashMap<String, List<RouteRule>>();
        }
        if (addflag) {
            this.saveCache(amRouteRule, map);
        } else {
            this.deleteCache(amRouteRule, map);
        }
        DisUtil.setVer((String)"AmRouteRule-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
        HashMap<String, List<RouteRule>> phase0Map = DisUtil.getMapByListJson((String)"AmRouteRule-phase", String.class, RouteRule.class);
        if (phase0Map == null) {
            phase0Map = new HashMap<String, List<RouteRule>>();
        }
        if (addflag) {
            this.savePhase(amRouteRule, phase0Map);
        } else {
            this.deletePhase0(amRouteRule, phase0Map);
        }
        DisUtil.setVer((String)"AmRouteRule-phase", (String)JsonUtil.buildNormalBinder().toJson(phase0Map));
    }

    private void deleteCache(AmRouteRule amRouteRule, Map<String, List<RouteRule>> map) {
        if (map == null) {
            return;
        }
        List<RouteRule> list = map.get(amRouteRule.getGroupId());
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getRouteRuleId().equals(amRouteRule.getRouteRuleId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void deletePhase0(AmRouteRule amRouteRule, Map<String, List<RouteRule>> map) {
        if (map == null) {
            return;
        }
        List<RouteRule> list = map.get(amRouteRule.getPhase());
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getRouteRuleId().equals(amRouteRule.getRouteRuleId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(AmRouteRule amRouteRule, Map<String, List<RouteRule>> map) {
        if (amRouteRule.getGroupId() == null) {
            return;
        }
        RouteRule RouteRule2 = this.makeRouteOption(amRouteRule);
        List<RouteRule> list = map.get(amRouteRule.getGroupId());
        if (list == null) {
            list = new ArrayList<RouteRule>();
            map.put(amRouteRule.getGroupId(), list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getRouteRuleId().equals(amRouteRule.getRouteRuleId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, RouteRule2);
        } else {
            list.add(RouteRule2);
        }
    }

    private void savePhase(AmRouteRule amRouteRule, Map<String, List<RouteRule>> map) {
        if (amRouteRule.getPhase() == null) {
            return;
        }
        String routeDire = amRouteRule.getRouteDire();
        routeDire = StringUtils.isBlank((String)routeDire) ? "" : routeDire;
        String appIcode = amRouteRule.getAppIcode();
        appIcode = StringUtils.isBlank((String)appIcode) ? "" : appIcode;
        String phase = amRouteRule.getPhase();
        String groupId = amRouteRule.getGroupId();
        groupId = StringUtils.isBlank((String)groupId) ? "" : groupId;
        String key = appIcode + routeDire + "-" + phase + "-" + groupId;
        RouteRule RouteRule2 = this.makeRouteOption(amRouteRule);
        List<RouteRule> list = map.get(key);
        if (list == null) {
            list = new ArrayList<RouteRule>();
        }
        list.add(RouteRule2);
        map.put(key, list);
    }

    private RouteRule makeRouteOption(AmRouteRule amRouteRule) {
        if (null == amRouteRule) {
            return null;
        }
        RouteRule routeRule = new RouteRule();
        try {
            BeanUtils.copyAllPropertys((Object)routeRule, (Object)amRouteRule);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouteRuleServiceImpl.makeSecCheck", (Throwable)e);
        }
        return routeRule;
    }
}

