/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppwarJarMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppwarMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarJarDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AppwarUpdateDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwar;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwarJar;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppwarService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class AmAppwarServiceImpl
extends BaseServiceImpl
implements AmAppwarService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmAppwarServiceImpl";
    private AmAppwarMapper amAppwarMapper;
    private AmAppwarJarMapper amAppwarJarMapper;
    private static String cache = "AmAppwar-jar";
    private static String cachewar = "AmAppwar-icode";
    private static String cachejar = "AmAppwar-jar-war";

    public void setAmAppwarMapper(AmAppwarMapper amAppwarMapper) {
        this.amAppwarMapper = amAppwarMapper;
    }

    public void setAmAppwarJarMapper(AmAppwarJarMapper amAppwarJarMapper) {
        this.amAppwarJarMapper = amAppwarJarMapper;
    }

    private Date getSysDate() {
        try {
            return this.amAppwarMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAppwar(AmAppwarDomain amAppwarDomain) {
        if (null == amAppwarDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppwarDomain.getAppwarAppkey())) {
            msg = msg + "AppwarAppkey\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppwarDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkAppwarupdate(AppwarUpdateDomain appwarUpdateDomain) {
        if (null == appwarUpdateDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)appwarUpdateDomain.getAppwarAppkey())) {
            msg = msg + "AppwarAppkey\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)appwarUpdateDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAppwarDefault(AmAppwar amAppwar) {
        if (null == amAppwar) {
            return;
        }
        if (null == amAppwar.getDataState()) {
            amAppwar.setDataState(0);
        }
        if (null == amAppwar.getGmtCreate()) {
            amAppwar.setGmtCreate(this.getSysDate());
        }
        amAppwar.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)amAppwar.getAppwarIcode())) {
            amAppwar.setAppwarIcode(this.createUUIDString());
        }
    }

    private int getAppwarMaxCode() {
        int code = 0;
        try {
            return this.amAppwarMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getAppwarMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppwarUpdataDefault(AmAppwar amAppwar) {
        if (null == amAppwar) {
            return;
        }
        amAppwar.setGmtModified(this.getSysDate());
    }

    private void saveAppwarModel(AmAppwar amAppwar) throws ApiException {
        if (null == amAppwar) {
            return;
        }
        try {
            this.amAppwarMapper.insert(amAppwar);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.saveAppwarModel.ex", (Throwable)e);
        }
    }

    private AmAppwar getAppwarModelById(Integer appwarId) {
        if (null == appwarId) {
            return null;
        }
        try {
            return this.amAppwarMapper.selectByPrimaryKey(appwarId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getAppwarModelById", (Throwable)e);
            return null;
        }
    }

    public AmAppwar getAppwarModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amAppwarMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getAppwarModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAppwarModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.delAppwarModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.delAppwarModelByCode.num");
        }
    }

    private void deleteAppwarModel(Integer appwarId) throws ApiException {
        if (null == appwarId) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarMapper.deleteByPrimaryKey(appwarId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.deleteAppwarModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.deleteAppwarModel.num");
        }
    }

    private void updateAppwarModel(AmAppwar amAppwar) throws ApiException {
        if (null == amAppwar) {
            return;
        }
        try {
            this.amAppwarMapper.updateByPrimaryKeySelective(amAppwar);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwarModel.ex", (Throwable)e);
        }
    }

    private void updateAppwarUpdateModel(AppwarUpdateDomain appwarUpdateDomain) throws ApiException {
        if (null == appwarUpdateDomain) {
            return;
        }
        try {
            this.amAppwarMapper.updateByAppwarKey(appwarUpdateDomain);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwarUpdateModel.ex", (Throwable)e);
        }
    }

    private void updateStateAppwarModel(Integer appwarId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appwarId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appwarId", appwarId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppwarMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateStateAppwarModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateStateAppwarModel.null");
        }
    }

    private AmAppwar makeAppwar(AmAppwarDomain amAppwarDomain, AmAppwar amAppwar) {
        if (null == amAppwarDomain) {
            return null;
        }
        if (null == amAppwar) {
            amAppwar = new AmAppwar();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppwar, (Object)amAppwarDomain);
            return amAppwar;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.makeAppwar", (Throwable)e);
            return null;
        }
    }

    private List<AmAppwar> queryAppwarModelPage(Map<String, Object> parammap) {
        try {
            return this.amAppwarMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.queryAppwarModel", (Throwable)e);
            return null;
        }
    }

    private int countAppwar(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppwarMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.countAppwar", (Throwable)e);
        }
        return i;
    }

    private String checkAppwarJar(AmAppwarJarDomain amAppwarJarDomain) {
        if (null == amAppwarJarDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppwarJarDomain.getAppmanageIcode())) {
            msg = msg + "AppmanageIcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppwarJarDomain.getAppwarIcode())) {
            msg = msg + "AppwarIcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppwarJarDomain.getAppwarJarType())) {
            msg = msg + "AppwarJarType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppwarJarDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAppwarJarDefault(AmAppwarJar amAppwarJar) {
        if (null == amAppwarJar) {
            return;
        }
        if (null == amAppwarJar.getDataState()) {
            amAppwarJar.setDataState(0);
        }
        if (null == amAppwarJar.getGmtCreate()) {
            amAppwarJar.setGmtCreate(this.getSysDate());
        }
        amAppwarJar.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)amAppwarJar.getAppwarJarCoe())) {
            amAppwarJar.setAppwarJarCoe(this.createUUIDString());
        }
    }

    private int getAppwarJarMaxCode() {
        int code = 0;
        try {
            return this.amAppwarJarMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getAppwarJarMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppwarJarUpdataDefault(AmAppwarJar amAppwarJar) {
        if (null == amAppwarJar) {
            return;
        }
        amAppwarJar.setGmtModified(this.getSysDate());
    }

    private void saveAppwarJarModel(AmAppwarJar amAppwarJar) throws ApiException {
        if (null == amAppwarJar) {
            return;
        }
        try {
            this.amAppwarJarMapper.insert(amAppwarJar);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.saveAppwarJarModel.ex", (Throwable)e);
        }
    }

    private AmAppwarJar getAppwarJarModelById(Integer appwarJarId) {
        if (null == appwarJarId) {
            return null;
        }
        try {
            return this.amAppwarJarMapper.selectByPrimaryKey(appwarJarId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getAppwarJarModelById", (Throwable)e);
            return null;
        }
    }

    public AmAppwarJar getAppwarJarModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amAppwarJarMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.getAppwarJarModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAppwarJarModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarJarMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.delAppwarJarModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.delAppwarJarModelByCode.num");
        }
    }

    private void deleteAppwarJarModel(Integer appwarJarId) throws ApiException {
        if (null == appwarJarId) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarJarMapper.deleteByPrimaryKey(appwarJarId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.deleteAppwarJarModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.deleteAppwarJarModel.num");
        }
    }

    private void updateAppwarJarModel(AmAppwarJar amAppwarJar) throws ApiException {
        if (null == amAppwarJar) {
            return;
        }
        try {
            this.amAppwarJarMapper.updateByPrimaryKeySelective(amAppwarJar);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwarJarModel.ex", (Throwable)e);
        }
    }

    private void updateStateAppwarJarModel(Integer appwarJarId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appwarJarId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appwarJarId", appwarJarId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppwarJarMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateStateAppwarJarModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateStateAppwarJarModel.null");
        }
    }

    private AmAppwarJar makeAppwarJar(AmAppwarJarDomain amAppwarJarDomain, AmAppwarJar amAppwarJar) {
        if (null == amAppwarJarDomain) {
            return null;
        }
        if (null == amAppwarJar) {
            amAppwarJar = new AmAppwarJar();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppwarJar, (Object)amAppwarJarDomain);
            return amAppwarJar;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.makeAppwarJar", (Throwable)e);
            return null;
        }
    }

    private List<AmAppwarJar> queryAppwarJarModelPage(Map<String, Object> parammap) {
        try {
            return this.amAppwarJarMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.queryAppwarJarModel", (Throwable)e);
            return null;
        }
    }

    private int countAppwarJar(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppwarJarMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarServiceImpl.countAppwarJar", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveAppwar(AmAppwarDomain amAppwarDomain) throws ApiException {
        String msg = this.checkAppwar(amAppwarDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.saveAppwar.checkAppwar", msg);
        }
        AmAppwar amAppwar = this.makeAppwar(amAppwarDomain, null);
        this.setAppwarDefault(amAppwar);
        this.saveAppwarModel(amAppwar);
        DisUtil.setMap((String)"EcoreAppwar-pro", (String)amAppwar.getAppwarAppkey(), (String)JsonUtil.buildNonDefaultBinder().toJson((Object)amAppwar));
        this.queryAppwarJarLoadCache();
        return amAppwar.getAppwarIcode();
    }

    @Override
    public void updateAppwarState(Integer appwarId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppwarModel(appwarId, dataState, oldDataState);
    }

    @Override
    public void updateAppwar(AmAppwarDomain amAppwarDomain) throws ApiException {
        String msg = this.checkAppwar(amAppwarDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwar.checkAppwar", msg);
        }
        AmAppwar oldAmAppwar = this.getAppwarModelById(amAppwarDomain.getAppwarId());
        if (null == oldAmAppwar) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwar.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmAppwar amAppwar = this.makeAppwar(amAppwarDomain, oldAmAppwar);
        this.setAppwarUpdataDefault(amAppwar);
        this.updateAppwarModel(amAppwar);
    }

    @Override
    public void updateAppwaruuid(AppwarUpdateDomain appwarUpdateDomain) {
        String msg = this.checkAppwarupdate(appwarUpdateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwaruuid.checkAppwarupdate", msg);
        }
        if (null == appwarUpdateDomain.getDataStateOld()) {
            appwarUpdateDomain.setDataStateOld(0);
        }
        this.updateAppwarUpdateModel(appwarUpdateDomain);
        DisUtil.setMap((String)"EcoreAppwar-healthyline", (String)appwarUpdateDomain.getAppwarAppkey(), (String)appwarUpdateDomain.getDataStateOld().toString());
        DisUtil.setMap((String)"EcoreAppwar-pro", (String)appwarUpdateDomain.getAppwarAppkey(), (String)JsonUtil.buildNonDefaultBinder().toJson((Object)appwarUpdateDomain));
        String keyStr = DisUtil.getRemotMap((String)"EcoreAppwar-healthylinePro", (String)appwarUpdateDomain.getAppwarIcode());
        if (StringUtils.isNotBlank((String)keyStr)) {
            if ("1".equals(appwarUpdateDomain.getDataStateOld().toString())) {
                if (keyStr.indexOf(appwarUpdateDomain.getAppwarAppkey()) < 0) {
                    if (StringUtils.isNotBlank((String)keyStr)) {
                        keyStr = keyStr + ",";
                    }
                    keyStr = keyStr + appwarUpdateDomain.getAppwarAppkey();
                }
            } else if (keyStr.indexOf(appwarUpdateDomain.getAppwarAppkey()) >= 0) {
                keyStr = keyStr.replace(appwarUpdateDomain.getAppwarAppkey() + ",", "");
                keyStr = keyStr.replace(appwarUpdateDomain.getAppwarAppkey(), "");
            }
        } else if ("1".equals(appwarUpdateDomain.getDataStateOld().toString())) {
            keyStr = appwarUpdateDomain.getAppwarAppkey();
        }
        if (StringUtils.isBlank((String)keyStr)) {
            DisUtil.delMap((String)"EcoreAppwar-healthylinePro", (String[])new String[]{appwarUpdateDomain.getAppwarIcode()});
        } else {
            DisUtil.setMap((String)"EcoreAppwar-healthylinePro", (String)appwarUpdateDomain.getAppwarIcode(), (String)keyStr);
        }
    }

    @Override
    public AmAppwar getAppwar(Integer appwarId) {
        return this.getAppwarModelById(appwarId);
    }

    @Override
    public void deleteAppwar(Integer appwarId) throws ApiException {
        AmAppwar amAppwar = this.getAppwarModelById(appwarId);
        if (null == amAppwar) {
            return;
        }
        this.deleteAppwarModel(appwarId);
        DisUtil.delMap((String)"EcoreAppwar-healthyline", (String[])new String[]{amAppwar.getAppwarAppkey()});
        DisUtil.delMap((String)"EcoreAppwar-pro", (String[])new String[]{amAppwar.getAppwarAppkey()});
        String keyStr = DisUtil.getRemotMap((String)"EcoreAppwar-healthylinePro", (String)amAppwar.getAppwarIcode());
        if (StringUtils.isNotBlank((String)keyStr) && keyStr.indexOf(amAppwar.getAppwarAppkey()) >= 0) {
            keyStr = keyStr.replace(amAppwar.getAppwarAppkey() + ",", "");
            keyStr = keyStr.replace(amAppwar.getAppwarAppkey(), "");
        }
        if (StringUtils.isBlank((String)keyStr)) {
            DisUtil.delMap((String)"EcoreAppwar-healthylinePro", (String[])new String[]{amAppwar.getAppwarIcode()});
        } else {
            DisUtil.setMap((String)"EcoreAppwar-healthylinePro", (String)amAppwar.getAppwarIcode(), (String)keyStr);
        }
    }

    @Override
    public QueryResult<AmAppwar> queryAppwarPage(Map<String, Object> map) {
        List<AmAppwar> amAppwarList = this.queryAppwarModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppwar(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppwarList);
        return queryResult;
    }

    @Override
    public Map<String, List<AmAppwar>> queryAppwarToMap() {
        List<AmAppwar> amAppwarList = this.queryAppwarModelPage(null);
        if (null == amAppwarList || amAppwarList.isEmpty()) {
            return null;
        }
        HashMap<String, List<AmAppwar>> map = new HashMap<String, List<AmAppwar>>();
        ArrayList<AmAppwar> amAppwarMapList = null;
        String key = null;
        for (AmAppwar amAppwar : amAppwarList) {
            key = amAppwar.getAppwarIcode();
            amAppwarMapList = (ArrayList<AmAppwar>)map.get(key);
            if (null == amAppwarMapList) {
                amAppwarMapList = new ArrayList<AmAppwar>();
                map.put(key, amAppwarMapList);
            }
            amAppwarMapList.add(amAppwar);
        }
        return map;
    }

    @Override
    public Map<String, AmAppwarJar> queryAppwarJarToMap() {
        List<AmAppwarJar> amAppwarJarList = this.queryAppwarJarModelPage(null);
        if (amAppwarJarList.isEmpty() || amAppwarJarList.isEmpty()) {
            return null;
        }
        HashMap<String, AmAppwarJar> map = new HashMap<String, AmAppwarJar>();
        for (AmAppwarJar amAppwarJar : amAppwarJarList) {
            map.put(amAppwarJar.getTenantCode() + "-" + amAppwarJar.getAppmanageIcode() + "-" + amAppwarJar.getAppwarJarType(), amAppwarJar);
        }
        return map;
    }

    @Override
    public AmAppwar getAppwarByCode(Map<String, Object> map) {
        return this.getAppwarModelByCode(map);
    }

    @Override
    public void delAppwarByCode(Map<String, Object> map) throws ApiException {
        this.delAppwarModelByCode(map);
    }

    @Override
    public String saveAppwarJar(AmAppwarJarDomain amAppwarJarDomain) throws ApiException {
        String msg = this.checkAppwarJar(amAppwarJarDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.saveAppwarJar.checkAppwarJar", msg);
        }
        AmAppwarJar amAppwarJar = this.makeAppwarJar(amAppwarJarDomain, null);
        this.setAppwarJarDefault(amAppwarJar);
        this.saveAppwarJarModel(amAppwarJar);
        return amAppwarJar.getAppwarJarCoe();
    }

    @Override
    public void updateAppwarJarState(Integer appwarJarId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppwarJarModel(appwarJarId, dataState, oldDataState);
    }

    @Override
    public void updateAppwarJar(AmAppwarJarDomain amAppwarJarDomain) throws ApiException {
        String msg = this.checkAppwarJar(amAppwarJarDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwarJar.checkAppwarJar", msg);
        }
        AmAppwarJar oldAmAppwarJar = this.getAppwarJarModelById(amAppwarJarDomain.getAppwarJarId());
        if (null == oldAmAppwarJar) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarServiceImpl.updateAppwarJar.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmAppwarJar amAppwarJar = this.makeAppwarJar(amAppwarJarDomain, oldAmAppwarJar);
        this.setAppwarJarUpdataDefault(amAppwarJar);
        this.updateAppwarJarModel(amAppwarJar);
    }

    @Override
    public AmAppwarJar getAppwarJar(Integer appwarJarId) {
        return this.getAppwarJarModelById(appwarJarId);
    }

    @Override
    public void deleteAppwarJar(Integer appwarJarId) throws ApiException {
        this.deleteAppwarJarModel(appwarJarId);
    }

    @Override
    public QueryResult<AmAppwarJar> queryAppwarJarPage(Map<String, Object> map) {
        List<AmAppwarJar> amAppwarJarList = this.queryAppwarJarModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppwarJar(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppwarJarList);
        return queryResult;
    }

    @Override
    public AmAppwarJar getAppwarJarByCode(Map<String, Object> map) {
        return this.getAppwarJarModelByCode(map);
    }

    @Override
    public void delAppwarJarByCode(Map<String, Object> map) throws ApiException {
        this.delAppwarJarModelByCode(map);
    }

    @Override
    public void queryAppwarJarLoadCache() {
        List<AmAppwarJar> jarList;
        List warplist;
        this.info("am.ESB.APPMANAGE.AmAppwarServiceImpl.queryAppwarJarLoadCache", "=======AppwarJar\u8c03\u5ea6start=======");
        List<AmAppwar> amAppwarList = this.queryAppwarModelPage(null);
        if (CollectionUtils.isEmpty(amAppwarList)) {
            DisUtil.delVer((String)cache);
            DisUtil.delVer((String)cachewar);
            DisUtil.delVer((String)cachejar);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> warmap = new HashMap<String, String>();
        HashMap<String, ArrayList<AmAppwar>> warListmap = new HashMap<String, ArrayList<AmAppwar>>();
        HashMap<String, ArrayList<AmAppwar>> warMap = new HashMap<String, ArrayList<AmAppwar>>();
        for (AmAppwar amAppwar : amAppwarList) {
            if (!StringUtils.isBlank((String)amAppwar.getAppwarPicode())) continue;
            warplist = (ArrayList<AmAppwar>)warMap.get(amAppwar.getAppwarIcode() + "-" + amAppwar.getTenantCode());
            if (null == warplist) {
                warplist = new ArrayList<AmAppwar>();
                warMap.put(amAppwar.getAppwarIcode() + "-" + amAppwar.getTenantCode(), (ArrayList<AmAppwar>)warplist);
            }
            warplist.add(amAppwar);
        }
        for (AmAppwar amAppwar : amAppwarList) {
            if (StringUtils.isNotBlank((String)amAppwar.getAppwarPicode())) {
                ArrayList<AmAppwar> warlist = (ArrayList<AmAppwar>)warListmap.get(amAppwar.getAppwarPicode() + "-" + amAppwar.getTenantCode());
                if (null == warlist) {
                    warlist = new ArrayList<AmAppwar>();
                    warListmap.put(amAppwar.getAppwarPicode() + "-" + amAppwar.getTenantCode(), warlist);
                }
                warlist.add(amAppwar);
            }
            if ("0".equals(amAppwar.getAppwarType()) || "1".equals(amAppwar.getAppwarType())) {
                map.put("appwarIcode", amAppwar.getAppwarIcode());
                map.put("tenantCode", amAppwar.getTenantCode());
                jarList = this.queryAppwarJarModelPage(map);
                warmap.put(amAppwar.getAppwarIcode() + "-" + amAppwar.getAppwarType() + "-" + amAppwar.getTenantCode(), JsonUtil.buildNormalBinder().toJson(jarList));
            }
            if (!"2".equals(amAppwar.getAppwarType()) && !"3".equals(amAppwar.getAppwarType())) continue;
            String url = amAppwar.getAppwarIp() + ":" + amAppwar.getAppwarPort() + (StringUtils.isNotBlank((String)amAppwar.getAppwarContext()) ? "/" + amAppwar.getAppwarContext() : "");
            if (StringUtils.isNotBlank((String)amAppwar.getAppwarPicode()) && ListUtil.isNotEmpty(warplist = (List)warMap.get(amAppwar.getAppwarPicode() + "-" + amAppwar.getTenantCode()))) {
                String purl = "";
                for (AmAppwar pAmAppwar1 : warplist) {
                    if (!StringUtils.isNotBlank((String)pAmAppwar1.getAppwarIp())) continue;
                    if (StringUtils.isNotBlank((String)purl)) {
                        purl = purl + ",";
                    }
                    purl = purl + pAmAppwar1.getAppwarIp() + ":" + pAmAppwar1.getAppwarPort() + (StringUtils.isNotBlank((String)pAmAppwar1.getAppwarContext()) ? "/" + pAmAppwar1.getAppwarContext() : "");
                }
                if (StringUtils.isNotBlank((String)purl)) {
                    url = purl;
                }
            }
            String key = amAppwar.getAppwarIcode();
            key = "/" + key;
            DisUtil.set((String)key, (String)url);
        }
        DisUtil.setMap((String)cache, warmap);
        HashMap<String, String> warlistStrmap = new HashMap<String, String>();
        for (String key1 : warListmap.keySet()) {
            warlistStrmap.put(key1, JsonUtil.buildNormalBinder().toJson(warListmap.get(key1)));
        }
        DisUtil.setMap((String)cachewar, warlistStrmap);
        jarList = this.queryAppwarJarModelPage(null);
        if (ListUtil.isEmpty(jarList)) {
            DisUtil.delVer((String)cachejar);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AmAppwarJar amAppwarJar : jarList) {
            hashMap.put(amAppwarJar.getAppmanageIcode() + "-" + amAppwarJar.getTenantCode(), amAppwarJar.getAppwarIcode());
        }
        DisUtil.setMap((String)cachejar, hashMap);
        this.info("am.ESB.APPMANAGE.AmAppwarServiceImpl.queryAppwarJarLoadCache", "=======AppwarJar\u8c03\u5ea6end=======");
    }
}

