/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppUpdateMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppmanageMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppUpdateDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapibakDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapibakParamDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppUpdate;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapimng;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapimngParam;
import com.yqbsoft.laser.service.esb.appmanage.service.AppUpdateService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppapiService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppapibakParamService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppapibakService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppapimngService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppmanageService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class AppUpdateServiceImpl
extends BaseServiceImpl
implements AppUpdateService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.AppUpdateServiceImpl";
    private AmAppUpdateMapper amAppUpdateMapper;
    private AppmanageService appmanageService;
    private AppapibakService appapibakService;
    private AppapibakParamService appapibakParamService;
    private AppapimngService appapimngService;
    private AppapiService appapiService;
    private AmAppmanageMapper amAppmanageMapper;

    public void setAppapiService(AppapiService appapiService) {
        this.appapiService = appapiService;
    }

    public void setAppmanageService(AppmanageService appmanageService) {
        this.appmanageService = appmanageService;
    }

    public void setAppapibakService(AppapibakService appapibakService) {
        this.appapibakService = appapibakService;
    }

    public void setAppapibakParamService(AppapibakParamService appapibakParamService) {
        this.appapibakParamService = appapibakParamService;
    }

    public void setAppapimngService(AppapimngService appapimngService) {
        this.appapimngService = appapimngService;
    }

    public void setAmAppUpdateMapper(AmAppUpdateMapper amAppUpdateMapper) {
        this.amAppUpdateMapper = amAppUpdateMapper;
    }

    public AmAppmanageMapper getAmAppmanageMapper() {
        return this.amAppmanageMapper;
    }

    public void setAmAppmanageMapper(AmAppmanageMapper amAppmanageMapper) {
        this.amAppmanageMapper = amAppmanageMapper;
    }

    private Date getSysDate() {
        try {
            return this.amAppUpdateMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAppUpdate(AmAppUpdateDomain amAppUpdateDomain) {
        if (null == amAppUpdateDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        String appupdateType = amAppUpdateDomain.getAppupdateType();
        if ("0".equals(appupdateType) || "1".equals(appupdateType)) {
            if (StringUtils.isBlank((String)amAppUpdateDomain.getAppmanageAppkey())) {
                msg = msg + "AppmanageAppkey\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)amAppUpdateDomain.getUserCode())) {
                msg = msg + "UserCode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)amAppUpdateDomain.getUserName())) {
                msg = msg + "UserName\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)String.valueOf(amAppUpdateDomain.getAppupdateInf()))) {
                msg = msg + "AppupdateInf\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)String.valueOf(amAppUpdateDomain.getAppupdateStopCall()))) {
                msg = msg + "AppupdateStopCall\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)String.valueOf(amAppUpdateDomain.getAppupdateStop()))) {
                msg = msg + "AppupdateStop\u4e3a\u7a7a;";
            }
        }
        return msg;
    }

    private void setAppUpdateDefault(AmAppUpdate amAppUpdate) {
        if (null == amAppUpdate) {
            return;
        }
        if (null == amAppUpdate.getAppupdateAdate()) {
            amAppUpdate.setAppupdateAdate(this.getSysDate());
        }
        if (null == amAppUpdate.getDataState()) {
            amAppUpdate.setDataState(0);
        }
        if (null == amAppUpdate.getGmtCreate()) {
            amAppUpdate.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)amAppUpdate.getAppupdateCode())) {
            int code = this.getMaxCode();
            amAppUpdate.setAppupdateCode(this.makeMaxCode8(++code));
        }
    }

    private void setAppUpdateSubmitDefault(AmAppUpdate amAppUpdate) {
        if (null == amAppUpdate) {
            return;
        }
        if (null == amAppUpdate.getAppupdateAdate()) {
            amAppUpdate.setAppupdateAdate(this.getSysDate());
        }
        if (null == amAppUpdate.getDataState()) {
            amAppUpdate.setDataState(1);
        }
        if (null == amAppUpdate.getGmtCreate()) {
            amAppUpdate.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)amAppUpdate.getAppupdateCode())) {
            int code = this.getMaxCode();
            amAppUpdate.setAppupdateCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.amAppUpdateMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppUpdateUpdataDefault(AmAppUpdate amAppUpdate) {
        if (null == amAppUpdate) {
            return;
        }
        amAppUpdate.setGmtModified(this.getSysDate());
    }

    private void saveAppUpdateModel(AmAppUpdate amAppUpdate) throws ApiException {
        if (null == amAppUpdate) {
            return;
        }
        try {
            if (!this.existAppUpdate(amAppUpdate)) {
                throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.saveAppUpdateModel.ex");
            }
            this.amAppUpdateMapper.insert(amAppUpdate);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.saveAppUpdateModel.ex");
        }
    }

    private boolean existAppUpdate(AmAppUpdate amAppUpdate) throws ApiException {
        if (null == amAppUpdate) {
            return false;
        }
        try {
            HashMap<String, Object> parameMap = new HashMap<String, Object>();
            parameMap.put("appmanageAppkey", amAppUpdate.getAppmanageAppkey());
            List<AmAppUpdate> amAppUpdateList = this.amAppUpdateMapper.queryList(parameMap);
            if (null != amAppUpdateList && amAppUpdateList.size() > 0) {
                for (AmAppUpdate appUpdate : amAppUpdateList) {
                    int dataState = appUpdate.getDataState();
                    if (dataState == 8 || dataState == 10) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.existAppUpdate.ex");
        }
        return true;
    }

    private AmAppUpdate getAppUpdateModelById(Integer appupdateId) {
        if (null == appupdateId) {
            return null;
        }
        try {
            return this.amAppUpdateMapper.selectByPrimaryKey(appupdateId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.getAppUpdateModelById", (Throwable)e);
            return null;
        }
    }

    private AmAppUpdate getByAppupdateCode(String appupdateCode) {
        if (null == appupdateCode) {
            return null;
        }
        try {
            return this.amAppUpdateMapper.selectByAppupdateCode(appupdateCode);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.getAppUpdateModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteAppUpdateModel(Integer appupdateId) throws ApiException {
        if (null == appupdateId) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppUpdateMapper.deleteByPrimaryKey(appupdateId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.deleteAppUpdateModel.ex");
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.deleteAppUpdateModel.num");
        }
    }

    private void updateAppUpdateModel(AmAppUpdate amAppUpdate) throws ApiException {
        if (null == amAppUpdate) {
            return;
        }
        try {
            this.amAppUpdateMapper.updateByPrimaryKeySelective(amAppUpdate);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateAppUpdateModel.ex");
        }
    }

    private void updateStateAppUpdateModel(Integer appupdateId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appupdateId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appupdateId", appupdateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppUpdateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateStateAppUpdateModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateStateAppUpdateModel.null");
        }
    }

    private void updateAppUpdateInstanceCodeModel(Integer appupdateId, String instanceCode) throws ApiException {
        if (null == appupdateId || null == instanceCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appupdateId", appupdateId);
        map.put("instanceCode", instanceCode);
        int i = 0;
        try {
            i = this.amAppUpdateMapper.updateInstanceCodeByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateStateAppUpdateModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateStateAppUpdateModel.null");
        }
    }

    private AmAppUpdate makeAppUpdate(AmAppUpdateDomain amAppUpdateDomain, AmAppUpdate amAppUpdate) {
        if (null == amAppUpdateDomain) {
            return null;
        }
        if (null == amAppUpdate) {
            amAppUpdate = new AmAppUpdate();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppUpdate, (Object)amAppUpdateDomain);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.makeAppUpdate", (Throwable)e);
        }
        return amAppUpdate;
    }

    private List<AmAppUpdate> queryAppUpdateModelPage(Map<String, Object> parammap) {
        try {
            return this.amAppUpdateMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.queryAppUpdateModel", (Throwable)e);
            return null;
        }
    }

    private List<AmAppUpdate> queryAppUpdateModelList(Map<String, Object> parammap) {
        try {
            return this.amAppUpdateMapper.queryList(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.queryAppUpdateModel", (Throwable)e);
            return null;
        }
    }

    private int countAppUpdate(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppUpdateMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppUpdateServiceImpl.countAppUpdate", (Throwable)e);
        }
        return i;
    }

    private void updateStateModeCheck(Integer appupdateId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == appupdateId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appupdateId", appupdateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.amAppUpdateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateStateModeCheck.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateStateModeCheck.null");
        }
    }

    @Override
    public void saveAppUpdate(AmAppUpdateDomain amAppUpdateDomain) throws ApiException {
        String msg = this.checkAppUpdate(amAppUpdateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.saveAppUpdate.checkAppUpdate", msg);
        }
        AmAppUpdate amAppUpdate = this.makeAppUpdate(amAppUpdateDomain, null);
        this.setAppUpdateDefault(amAppUpdate);
        this.saveAppUpdateModel(amAppUpdate);
    }

    @Override
    public AmAppUpdate saveAppUpdateSubmit(AmAppUpdateDomain amAppUpdateDomain) throws ApiException {
        String msg = this.checkAppUpdate(amAppUpdateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.saveAppUpdate.checkAppUpdate", msg);
        }
        AmAppUpdate amAppUpdate = this.makeAppUpdate(amAppUpdateDomain, null);
        this.setAppUpdateSubmitDefault(amAppUpdate);
        this.saveAppUpdateModel(amAppUpdate);
        return amAppUpdate;
    }

    @Override
    public void updateAppUpdateState(Integer appupdateId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppUpdateModel(appupdateId, dataState, oldDataState);
    }

    @Override
    public void updateAppUpdateInstanceCode(Integer appupdateId, String instanceCode) throws ApiException {
        this.updateAppUpdateInstanceCodeModel(appupdateId, instanceCode);
    }

    @Override
    public void updateAppUpdate(AmAppUpdateDomain amAppUpdateDomain) throws ApiException {
        String msg = this.checkAppUpdate(amAppUpdateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateAppUpdate.checkAppUpdate", msg);
        }
        AmAppUpdate oldAmAppUpdate = this.getAppUpdateModelById(amAppUpdateDomain.getAppupdateId());
        if (null == oldAmAppUpdate) {
            throw new ApiException("am.ESB.APPMANAGE.AppUpdateServiceImpl.updateAppUpdate.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmAppUpdate amAppUpdate = this.makeAppUpdate(amAppUpdateDomain, oldAmAppUpdate);
        this.setAppUpdateUpdataDefault(amAppUpdate);
        this.updateAppUpdateModel(amAppUpdate);
    }

    @Override
    public AmAppUpdate getAppUpdate(Integer appupdateId) {
        return this.getAppUpdateModelById(appupdateId);
    }

    @Override
    public AmAppUpdate getAppUpdateByAppupdateCode(String appupdateCode) {
        return this.getByAppupdateCode(appupdateCode);
    }

    @Override
    public void deleteAppUpdate(Integer appupdateId) throws ApiException {
        this.deleteAppUpdateModel(appupdateId);
    }

    @Override
    public QueryResult<AmAppUpdate> queryAppUpdatePage(Map<String, Object> map) {
        List<AmAppUpdate> amAppUpdateList = this.queryAppUpdateModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppUpdate(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppUpdateList);
        return queryResult;
    }

    @Override
    public List<AmAppUpdate> queryAppUpdateList(Map<String, Object> map) {
        List<AmAppUpdate> amAppUpdateList = this.queryAppUpdateModelList(map);
        return amAppUpdateList;
    }

    @Override
    public void updateAppUpdateStateCheck(Integer appupdateId, String appupdateType, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        AmAppUpdate amAppUpdate = this.getAppUpdateModelById(appupdateId);
        String appupdateOtype = amAppUpdate.getAppupdateOtype();
        appupdateType = amAppUpdate.getAppupdateType();
        if (null != appupdateOtype && "0000".equals(appupdateOtype) && "1".equals(appupdateType)) {
            if (null != oldDataState && oldDataState == 6) {
                this.updateStateModeCheck(appupdateId, dataState, oldDataState, memo);
            } else {
                this.updateStateModeCheck(appupdateId, 5, oldDataState, memo);
            }
        } else {
            this.updateStateModeCheck(appupdateId, dataState, oldDataState, memo);
        }
    }

    @Override
    public void updateReleaseApi(Integer appupdateId) throws ApiException {
        AmAppUpdate amAppUpdate = this.getAppUpdateModelById(appupdateId);
        String appupdateType = amAppUpdate.getAppupdateType();
        if ("0".equals(appupdateType) || "1".equals(appupdateType)) {
            List<AmAppapimng> appapiList = this.getAppapimngList(amAppUpdate);
            List<AmAppapimngParam> apiparamList = this.getApiparamList(appapiList);
            this.appapiService.updateReleaseSyncApi(appapiList, apiparamList);
            this.appapimngService.updateApiAndParamFlag();
            this.saveApiAndParamBak(amAppUpdate, appapiList, apiparamList);
            this.recordStopId(amAppUpdate, appapiList, apiparamList);
            this.appmanageService.updateAppmanageStateBykey(amAppUpdate.getAppmanageAppkey(), 1, Integer.parseInt(appupdateType) == 0 ? Integer.valueOf(7) : null);
            this.appapiService.queryApiCache();
        } else if ("2".equals(appupdateType)) {
            this.appmanageService.updateAppmanageStateBykey(amAppUpdate.getAppmanageAppkey(), 6, 1);
        } else if ("3".equals(appupdateType)) {
            this.appmanageService.updateAppmanageStateBykey(amAppUpdate.getAppmanageAppkey(), 1, 6);
        }
        amAppUpdate.setDataState(8);
        this.updateAppUpdateModel(amAppUpdate);
    }

    private List<AmAppapimng> getAppapimngList(AmAppUpdate amAppUpdate) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if ("1".equals(amAppUpdate.getAppupdateType())) {
            parammap.put("updateFlag", 1);
        }
        parammap.put("appmanageAppkey", amAppUpdate.getAppmanageAppkey());
        QueryResult<AmAppapimng> qrAppapi = this.appapimngService.queryAppapimngPage(parammap);
        List appapiList = qrAppapi.getList();
        return appapiList;
    }

    private List<AmAppapimngParam> getApiparamList(List<AmAppapimng> appapiList) {
        ArrayList<AmAppapimngParam> apiparamList = new ArrayList<AmAppapimngParam>();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (null != appapiList && appapiList.size() > 0) {
            for (AmAppapimng amAppapimng : appapiList) {
                parammap.put("appapiCode", amAppapimng.getAppapiCode());
                parammap.put("updateFlag", 1);
                QueryResult<AmAppapimngParam> qrApiparam = this.appapimngService.queryAppapimngParamPage(parammap);
                List apiparamListTem = qrApiparam.getList();
                if (null == apiparamListTem || apiparamListTem.size() <= 0) continue;
                apiparamList.addAll(apiparamListTem);
            }
        }
        return apiparamList;
    }

    private void recordStopId(AmAppUpdate amAppUpdate, List<AmAppapimng> appapiList, List<AmAppapimngParam> apiparamList) {
        HashMap stopIdMap = new HashMap();
        ArrayList<Map<String, String>> stopApiList = null;
        ArrayList<Map<String, String>> stopParamList = null;
        for (AmAppapimng amAppapimng : appapiList) {
            if (amAppapimng.getUpdateType() != 3) continue;
            if (stopApiList == null) {
                stopApiList = new ArrayList<Map<String, String>>();
            }
            stopApiList.add(this.getApiMap(amAppapimng));
        }
        for (AmAppapimngParam amAppapimngParam : apiparamList) {
            if (amAppapimngParam.getUpdateType() != 3) continue;
            if (stopParamList == null) {
                stopParamList = new ArrayList<Map<String, String>>();
            }
            stopParamList.add(this.getParamMap(amAppapimngParam));
        }
        if (stopApiList != null) {
            stopIdMap.put("stop_api", stopApiList);
        }
        if (stopParamList != null) {
            stopIdMap.put("stop_param", stopParamList);
        }
        if (!stopIdMap.isEmpty()) {
            amAppUpdate.setAppupdateStopCall(1);
            amAppUpdate.setAppupdateStoptext(JsonUtil.buildNormalBinder().toJson(stopIdMap));
        }
    }

    private Map<String, String> getApiMap(AmAppapimng amAppapimng) {
        String appapiCode = amAppapimng.getAppapiCode();
        String appapiVersion = amAppapimng.getAppapiVersion();
        HashMap<String, String> apiMap = new HashMap<String, String>();
        apiMap.put("appapiCode", appapiCode);
        apiMap.put("appapiVersion", appapiVersion);
        return apiMap;
    }

    private Map<String, String> getParamMap(AmAppapimngParam amAppapimngParam) {
        String appapiCode = amAppapimngParam.getAppapiCode();
        String appapiVersion = amAppapimngParam.getAppapiVersion();
        String paramName = amAppapimngParam.getParamName();
        String paramDire = amAppapimngParam.getParamDire().toString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appapiCode", appapiCode);
        paramMap.put("appapiVersion", appapiVersion);
        paramMap.put("paramName", paramName);
        paramMap.put("paramDire", paramDire);
        return paramMap;
    }

    private void saveApiAndParamBak(AmAppUpdate amAppUpdate, List<AmAppapimng> appapiList, List<AmAppapimngParam> apiparamList) {
        ArrayList<AmAppapibakDomain> vabdomainList = new ArrayList<AmAppapibakDomain>();
        ArrayList<AmAppapibakParamDomain> vabpdomainList = new ArrayList<AmAppapibakParamDomain>();
        if (appapiList != null && !appapiList.isEmpty()) {
            for (AmAppapimng amAppapimng : appapiList) {
                AmAppapibakDomain vab = this.makeAmAppapibakDomain(amAppapimng);
                if (vab == null) continue;
                vab.setAppupdateCode(amAppUpdate.getAppupdateCode());
                vabdomainList.add(vab);
            }
        }
        if (apiparamList != null && !apiparamList.isEmpty()) {
            for (AmAppapimngParam amAppapimngParam : apiparamList) {
                AmAppapibakParamDomain vabp = this.makeAmAppapibakParamDomain(amAppapimngParam);
                if (vabp == null) continue;
                vabp.setAppupdateCode(amAppUpdate.getAppupdateCode());
                vabpdomainList.add(vabp);
            }
        }
        if (vabdomainList != null && !vabdomainList.isEmpty()) {
            for (AmAppapibakDomain amAppapibakDomain : vabdomainList) {
                amAppapibakDomain.setAppapiId(null);
                this.appapibakService.saveAppapibak(amAppapibakDomain);
            }
        }
        if (vabpdomainList != null && !vabpdomainList.isEmpty()) {
            for (AmAppapibakParamDomain amAppapibakParamDomain : vabpdomainList) {
                amAppapibakParamDomain.setAppapiParamId(null);
                this.appapibakParamService.saveAppapibakParam(amAppapibakParamDomain);
            }
        }
    }

    private AmAppapibakDomain makeAmAppapibakDomain(AmAppapimng amAppapimng) {
        if (amAppapimng == null) {
            return null;
        }
        AmAppapibakDomain amAppapibakDomain = new AmAppapibakDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amAppapibakDomain, (Object)amAppapimng);
        }
        catch (Exception e) {
            return null;
        }
        return amAppapibakDomain;
    }

    private AmAppapibakParamDomain makeAmAppapibakParamDomain(AmAppapimngParam amAppapimngParam) {
        if (amAppapimngParam == null) {
            return null;
        }
        AmAppapibakParamDomain amAppapibakParamDomain = new AmAppapibakParamDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amAppapibakParamDomain, (Object)amAppapimngParam);
        }
        catch (Exception e) {
            return null;
        }
        return amAppapibakParamDomain;
    }

    @Override
    public void updateStopApi(Integer appupdateId) throws ApiException {
        String appapiVersion;
        String appapiCode;
        AmAppUpdate amAppUpdate = this.getAppUpdateModelById(appupdateId);
        String json = amAppUpdate.getAppupdateStoptext();
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, List.class);
        if (map == null) {
            return;
        }
        List stopApiList = (List)map.get("stop_api");
        List stopParamList = (List)map.get("stop_param");
        if (CollectionUtils.isNotEmpty((Collection)stopApiList)) {
            for (Map apiMap : stopApiList) {
                appapiCode = (String)apiMap.get("appapiCode");
                appapiVersion = (String)apiMap.get("appapiVersion");
                this.appapiService.updateAppapiStateByCodeVersion(appapiCode, appapiVersion, 0, 1);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)stopParamList)) {
            for (Map paramMap : stopParamList) {
                appapiCode = (String)paramMap.get("appapiCode");
                appapiVersion = (String)paramMap.get("appapiVersion");
                String paramName = (String)paramMap.get("paramName");
                String paramDire = (String)paramMap.get("paramDire");
                this.appapiService.updateAppapiParamStateByUnique(appapiCode, appapiVersion, paramName, paramDire, 0, 0, 1);
            }
        }
        amAppUpdate.setAppupdateStopCall(0);
        this.updateAppUpdateModel(amAppUpdate);
    }
}

