/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.service.impl;

import com.yqbsoft.laser.service.cdl.dao.QstPriceTrackingListMapper;
import com.yqbsoft.laser.service.cdl.domain.QstPriceTrackingListDomain;
import com.yqbsoft.laser.service.cdl.model.PgLabel;
import com.yqbsoft.laser.service.cdl.model.PgProductMasterCdl;
import com.yqbsoft.laser.service.cdl.model.QstPriceTrackingList;
import com.yqbsoft.laser.service.cdl.service.QstPriceTrackingListService;
import com.yqbsoft.laser.service.cdl.tool.cdl.PgProductCDLUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QstPriceTrackingListServiceImpl
extends BaseServiceImpl
implements QstPriceTrackingListService {
    private static final String SYS_CODE = "cdl.QstPriceTrackingListServiceImpl";
    private static Logger log = LoggerFactory.getLogger(QstPriceTrackingListServiceImpl.class);
    private QstPriceTrackingListMapper qstPriceTrackingListMapper;

    public void setQstPriceTrackingListMapper(QstPriceTrackingListMapper qstPriceTrackingListMapper) {
        this.qstPriceTrackingListMapper = qstPriceTrackingListMapper;
    }

    private String checktPriceTrackingList(QstPriceTrackingListDomain qstPriceTrackingListDomain) {
        if (null == qstPriceTrackingListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void settPriceTrackingListDefault(QstPriceTrackingList qstPriceTrackingList) {
        if (null == qstPriceTrackingList) {
            return;
        }
    }

    private void savetPriceTrackingListBatchModel(List<QstPriceTrackingList> qstPriceTrackingListList) throws ApiException {
        if (null == qstPriceTrackingListList || qstPriceTrackingListList.isEmpty()) {
            return;
        }
        try {
            this.qstPriceTrackingListMapper.insertBatch(qstPriceTrackingListList);
        }
        catch (Exception e) {
            throw new ApiException("cdl.QstPriceTrackingListServiceImpl.savetPriceTrackingListBatchModel.ex", (Throwable)e);
        }
    }

    private QstPriceTrackingList maketPriceTrackingList(QstPriceTrackingListDomain qstPriceTrackingListDomain, QstPriceTrackingList qstPriceTrackingList) {
        if (null == qstPriceTrackingListDomain) {
            return null;
        }
        if (null == qstPriceTrackingList) {
            qstPriceTrackingList = new QstPriceTrackingList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)qstPriceTrackingList, (Object)qstPriceTrackingListDomain);
            return qstPriceTrackingList;
        }
        catch (Exception e) {
            this.logger.error("cdl.QstPriceTrackingListServiceImpl.maketPriceTrackingList", (Throwable)e);
            return null;
        }
    }

    private List<QstPriceTrackingList> querytPriceTrackingListModelPage(Map<String, Object> parammap) {
        try {
            return this.qstPriceTrackingListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cdl.QstPriceTrackingListServiceImpl.querytPriceTrackingListModel", (Throwable)e);
            return null;
        }
    }

    private int counttPriceTrackingList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.qstPriceTrackingListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cdl.QstPriceTrackingListServiceImpl.counttPriceTrackingList", (Throwable)e);
        }
        return i;
    }

    private QstPriceTrackingList createQstPriceTrackingList(QstPriceTrackingListDomain qstPriceTrackingListDomain) {
        String msg = this.checktPriceTrackingList(qstPriceTrackingListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cdl.QstPriceTrackingListServiceImpl.savetPriceTrackingList.checktPriceTrackingList", msg);
        }
        QstPriceTrackingList qstPriceTrackingList = this.maketPriceTrackingList(qstPriceTrackingListDomain, null);
        this.settPriceTrackingListDefault(qstPriceTrackingList);
        return qstPriceTrackingList;
    }

    @Override
    public String savetPriceTrackingListBatch(List<QstPriceTrackingListDomain> qstPriceTrackingListDomainList) throws ApiException {
        if (null == qstPriceTrackingListDomainList || qstPriceTrackingListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<QstPriceTrackingList> qstPriceTrackingListList = new ArrayList<QstPriceTrackingList>();
        String code = "";
        for (QstPriceTrackingListDomain qstPriceTrackingListDomain : qstPriceTrackingListDomainList) {
            QstPriceTrackingList qstPriceTrackingList = this.createQstPriceTrackingList(qstPriceTrackingListDomain);
            code = qstPriceTrackingList.getFpcCode();
            qstPriceTrackingListList.add(qstPriceTrackingList);
        }
        this.savetPriceTrackingListBatchModel(qstPriceTrackingListList);
        return code;
    }

    public QueryResult<QstPriceTrackingList> querytPriceTrackingListPage(Map<String, Object> map) {
        List<QstPriceTrackingList> qstPriceTrackingListList = this.querytPriceTrackingListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.counttPriceTrackingList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(qstPriceTrackingListList);
        return queryResult;
    }

    @Override
    public void deleteBatch() throws ApiException {
        this.qstPriceTrackingListMapper.deleteBatch();
    }

    @Override
    public String saveRPCBatch() throws ApiException {
        HashMap params = new HashMap();
        String result = this.internalInvoke("pg.pgProductMasterCdl.queryProductMasterCdlPage", params);
        QueryResult masterResult = (QueryResult)JsonUtil.buildNonNullBinder().getJsonToObject(result, QueryResult.class);
        List masterList = masterResult.getList();
        this.logger.info(".saveRPCBatch.queryProductMasterCdlPage", (Object)("masterList.size=" + masterList.size()));
        params = new HashMap();
        String result1 = this.internalInvoke("pg.pgLabel.queryLabelPage", params);
        QueryResult labelResult = (QueryResult)JsonUtil.buildNonNullBinder().getJsonToObject(result1, QueryResult.class);
        List labelList = labelResult.getList();
        this.logger.info(".saveRPCBatch.queryLabelPage", (Object)("labelList.size=" + labelList.size()));
        List labelListGroup = labelList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PgLabel>(Comparator.comparing(b -> b.getSellBarcode()))), ArrayList::new));
        List collect1 = masterList.stream().filter(p -> this.existStr((PgProductMasterCdl)p, labelListGroup)).collect(Collectors.toList());
        List collect = collect1.stream().map(p -> {
            QstPriceTrackingList qstList = new QstPriceTrackingList();
            qstList.setBarcode(p.getFpcItemBarcode());
            qstList.setBrand(p.getBrandCn());
            qstList.setCategory(p.getCategoryCn());
            qstList.setPlatform("JD");
            qstList.setRpcCode(p.getRpcCode());
            qstList.setRpcName(p.getRpcProductName());
            qstList.setFpcCode(p.getFpcCode());
            qstList.setUpdateTime(new Date());
            return qstList;
        }).collect(Collectors.toList());
        if (collect != null && collect.size() > 0) {
            this.deleteBatch();
        }
        List lists = PgProductCDLUtil.splitList(collect, 400);
        for (int i = 0; i < lists.size(); ++i) {
            this.savetPriceTrackingListBatchModel(lists.get(i));
            log.info("\u66f4\u65b0\u4eac\u4e1cRPC\u5230\u4e00\u9762-DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{}", (Object)i, (Object)lists.get(i).size());
        }
        return "success";
    }

    private boolean existStr(PgProductMasterCdl p, List<PgLabel> labelListGroup) {
        for (PgLabel pgLabel : labelListGroup) {
            if (p.getGtinCode().indexOf(pgLabel.getSellBarcode()) < 0) continue;
            return true;
        }
        return false;
    }
}

