/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.service.impl;

import com.yqbsoft.laser.service.cdl.dao.QstPriceTrackingResultMapper;
import com.yqbsoft.laser.service.cdl.domain.PgLabelDomain;
import com.yqbsoft.laser.service.cdl.model.QstPriceTrackingResult;
import com.yqbsoft.laser.service.cdl.service.QstPriceTrackingResultService;
import com.yqbsoft.laser.service.cdl.tool.cdl.PgProductCDLUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QstPriceTrackingResultServiceImpl
extends BaseServiceImpl
implements QstPriceTrackingResultService {
    private static final String SYS_CODE = "cdl.QstPriceTrackingResultServiceImpl";
    private static Logger log = LoggerFactory.getLogger(QstPriceTrackingResultServiceImpl.class);
    private static String tenantCode = "2022011000000021";
    private QstPriceTrackingResultMapper qstPriceTrackingResultMapper;

    public void setQstPriceTrackingResultMapper(QstPriceTrackingResultMapper qstPriceTrackingResultMapper) {
        this.qstPriceTrackingResultMapper = qstPriceTrackingResultMapper;
    }

    @Override
    public int countResult() {
        int i = 0;
        try {
            i = this.qstPriceTrackingResultMapper.countResult();
        }
        catch (Exception e) {
            this.logger.error("cdl.QstPriceTrackingResultServiceImpl.countResult", (Throwable)e);
        }
        this.logger.info("cdl.QstPriceTrackingResultServiceImpl.countResult", (Object)i);
        return i;
    }

    @Override
    public void updatePgGoodsJDPrice() {
        List<QstPriceTrackingResult> resultList = this.qstPriceTrackingResultMapper.selectByExample();
        this.logger.info(".updatePgGoodsJDPrice.selectByExample", (Object)("resultList.size=" + resultList.size()));
        List collect = resultList.stream().map(p -> {
            PgLabelDomain labelDomain = new PgLabelDomain();
            labelDomain.setLabelJdprice(new BigDecimal(p.getRsp().floatValue()).setScale(2, 4));
            labelDomain.setLabelJdlink(p.getUrl());
            labelDomain.setSkuCode(p.getFpcCode());
            labelDomain.setTenantCode(tenantCode);
            return labelDomain;
        }).collect(Collectors.toList());
        List lists = PgProductCDLUtil.splitList(collect, 400);
        for (int i = 0; i < lists.size(); ++i) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("pgLabelDomainList", JsonUtil.buildNormalBinder().toJson(lists.get(i)));
            String code = this.internalInvoke("pg.pgLabel.updateJdPriceBatch", params);
            log.info("\u66f4\u65b0\u4eac\u4e1c\u4ef7-DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{},{}", new Object[]{i, lists.get(i).size(), code});
        }
    }
}

