/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.tool.salesHub;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.yqbsoft.laser.service.cdl.domain.FileIdMode;
import com.yqbsoft.laser.service.cdl.tool.salesHub.AliyunOSS;
import com.yqbsoft.laser.service.cdl.tool.salesHub.ImageCMYKUtil;
import com.yqbsoft.laser.service.cdl.tool.salesHub.ImageTypeUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpload {
    private static final Logger log = LoggerFactory.getLogger(FileUpload.class);

    public static void main(String[] args) throws Exception {
        FileIdMode mode = new FileIdMode();
        mode.setFpcCode("80696560");
        mode.setFileId("76abfc10c8da469e80639a0e74a5f824");
        mode.setFilePath("https://b2bfileserviceprd01.blob.core.chinacloudapi.cn/one-sales-portal-private/202112/76abfc10c8da469e80639a0e74a5f824.jpg?sig=p%2FMewP2S%2Fs50fbUZDpnPx8ltAczd%2BLJB6H7TO9moUnQ%3D&se=2022-02-21T06%3A42%3A39Z&sv=2019-02-02&rscd=attachment%3B%20filename*%3DUTF-8%27%27806965606903148324349PB4pPantsBayMaxCN.jpg&sp=r&sr=b");
        FileUpload.OSSUploadFile(mode);
    }

    public static String OSSUploadFile(FileIdMode fileIdMode) throws Exception {
        float sfTemp;
        HttpRequest get = HttpUtil.createGet((String)fileIdMode.getFilePath());
        HttpResponse execute = get.execute();
        if (!execute.isOk()) {
            new Exception("fileId\u672a\u627e\u5230\u8fdc\u7a0b\u56fe\u7247,fpcCode=" + fileIdMode.getFpcCode());
        }
        String fileSuffix = ImageTypeUtil.mimeMapingSuffix(execute.header("Content-Type"));
        byte[] bytes = execute.bodyBytes();
        log.info(" -- \u4e0b\u8f7dSalesHub\u56fe\u7247{}\u6210\u529f\uff0csize={}KB\uff0c\u51c6\u5907\u7f29\u653e", (Object)fileIdMode.getFpcCode(), (Object)(bytes.length / 1000));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = ImageCMYKUtil.readImage(inputStream);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int wh = 1280;
        float sf = 1.0f;
        if (width > wh) {
            sf = Float.valueOf(wh).floatValue() / Float.valueOf(width).floatValue();
        }
        if (height > wh && sf > (sfTemp = Float.valueOf(wh).floatValue() / Float.valueOf(height).floatValue())) {
            sf = sfTemp;
        }
        sf = new BigDecimal(sf).setScale(2, 1).floatValue();
        ImgUtil.scale((Image)bufferedImage, (OutputStream)outputStream, (float)sf);
        String filePath = "pick/" + fileIdMode.getFpcCode() + fileSuffix;
        AliyunOSS.upload(filePath, FileUpload.parse(outputStream));
        fileIdMode.setFilePath("https://gusoss.oss-cn-shanghai.aliyuncs.com/" + filePath);
        log.info("  |- oss\u4e0a\u4f20\u6210\u529f\uff0c\u5546\u54c1filePath={}", (Object)filePath);
        return filePath;
    }

    public static ByteArrayInputStream parse(OutputStream out) {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }
}

