/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.tool.salesHub;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCMYKUtil {
    static Logger log = LoggerFactory.getLogger(ImageCMYKUtil.class);

    public static BufferedImage readImage(File file) throws IOException {
        return ImageCMYKUtil.readImage(ImageIO.createImageInputStream(file));
    }

    public static BufferedImage readImage(InputStream stream) throws IOException {
        return ImageCMYKUtil.readImage(ImageIO.createImageInputStream(stream));
    }

    public static BufferedImage readImage(ImageInputStream input) throws IOException {
        BufferedImage image;
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        if (readers == null || !readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        reader.setInput(input);
        try {
            image = reader.read(0);
        }
        catch (IIOException e) {
            Raster raster = reader.readRaster(0, null);
            image = ImageCMYKUtil.createJPEG4(raster);
        }
        return image;
    }

    private static BufferedImage createJPEG4(Raster raster) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
        float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
        float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
        float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
        int i = 0;
        int imax = Y.length;
        int base = 0;
        while (i < imax) {
            float k = 220.0f - K[i];
            float y = 255.0f - Y[i];
            float cb = 255.0f - Cb[i];
            float cr = 255.0f - Cr[i];
            double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
            rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            ++i;
            base += 3;
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }
}

