/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.flow.Task;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.convert.BpmTaskConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmTaskExtMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmTaskExtDO;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceDeleteReasonEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceResultEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmMessageService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessInstanceService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.date.DateUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.object.PageUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskApproveReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskDonePageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskDonePageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskRejectReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskTodoPageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskTodoPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskUpdateAssigneeReqVO;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.flowable.engine.HistoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BpmTaskServiceImpl
extends BaseServiceImpl
implements BpmTaskService {
    private static final Logger log = LoggerFactory.getLogger(BpmTaskServiceImpl.class);
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private BpmProcessInstanceService processInstanceService;
    @Resource
    private AdminUserApi adminUserApi;
    @Resource
    private DeptApi deptApi;
    @Resource
    private BpmTaskExtMapper taskExtMapper;
    @Resource
    private BpmMessageService messageService;

    @Override
    public PageResult<BpmTaskTodoPageItemRespVO> getTodoTaskPage(String userId, BpmTaskTodoPageReqVO pageVO) {
        List tasks;
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(String.valueOf(userId))).orderByTaskCreateTime()).desc();
        if (StrUtil.isNotBlank((CharSequence)pageVO.getName())) {
            taskQuery.taskNameLike("%" + pageVO.getName() + "%");
        }
        if (ArrayUtil.get((Object)pageVO.getCreateTime(), (int)0) != null) {
            taskQuery.taskCreatedAfter(DateUtils.of(pageVO.getCreateTime()[0]));
        }
        if (ArrayUtil.get((Object)pageVO.getCreateTime(), (int)1) != null) {
            taskQuery.taskCreatedBefore(DateUtils.of(pageVO.getCreateTime()[1]));
        }
        if (CollUtil.isEmpty((Collection)(tasks = taskQuery.listPage(PageUtils.getStart(pageVO), pageVO.getPageSize().intValue())))) {
            return PageResult.empty(taskQuery.count());
        }
        Map<String, ProcessInstance> processInstanceMap = this.processInstanceService.getProcessInstanceMap1(CollectionUtils.convertSet(tasks, TaskInfo::getProcessInstanceId));
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(CollectionUtils.convertSet(processInstanceMap.values(), instance -> instance.getStartUserId()));
        return new PageResult<BpmTaskTodoPageItemRespVO>(BpmTaskConvert.INSTANCE.convertList1(tasks, processInstanceMap, userMap), taskQuery.count());
    }

    @Override
    public PageResult<BpmTaskDonePageItemRespVO> getDoneTaskPage(String userId, BpmTaskDonePageReqVO pageVO) {
        List tasks;
        HistoricTaskInstanceQuery taskQuery = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().finished().taskAssignee(String.valueOf(userId))).orderByHistoricTaskInstanceEndTime().desc();
        if (StrUtil.isNotBlank((CharSequence)pageVO.getName())) {
            taskQuery.taskNameLike("%" + pageVO.getName() + "%");
        }
        if (pageVO.getBeginCreateTime() != null) {
            taskQuery.taskCreatedAfter(DateUtils.of(pageVO.getBeginCreateTime()));
        }
        if (pageVO.getEndCreateTime() != null) {
            taskQuery.taskCreatedBefore(DateUtils.of(pageVO.getEndCreateTime()));
        }
        if (CollUtil.isEmpty((Collection)(tasks = taskQuery.listPage(PageUtils.getStart(pageVO), pageVO.getPageSize().intValue())))) {
            return PageResult.empty(taskQuery.count());
        }
        List<BpmTaskExtDO> bpmTaskExtDOs = this.taskExtMapper.selectListByTaskIds(tasks.stream().map(u -> u.getId()).collect(Collectors.toList()));
        Map<String, BpmTaskExtDO> bpmTaskExtDOMap = CollectionUtils.convertMap(bpmTaskExtDOs, BpmTaskExtDO::getTaskId);
        Map<String, HistoricProcessInstance> historicProcessInstanceMap = this.processInstanceService.getHistoricProcessInstanceMap1(CollectionUtils.convertSet(tasks, TaskInfo::getProcessInstanceId));
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(CollectionUtils.convertSet(historicProcessInstanceMap.values(), instance -> instance.getStartUserId()));
        return new PageResult<BpmTaskDonePageItemRespVO>(BpmTaskConvert.INSTANCE.convertList2(tasks, bpmTaskExtDOMap, historicProcessInstanceMap, userMap), taskQuery.count());
    }

    @Override
    public List<org.flowable.task.api.Task> getTasksByProcessInstanceIds1(List<String> processInstanceIds) {
        if (CollUtil.isEmpty(processInstanceIds)) {
            return Collections.emptyList();
        }
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(processInstanceIds)).list();
    }

    @Override
    public List<BpmTaskRespVO> getTaskListByProcessInstanceId(String processInstanceId) {
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceStartTime().desc()).list();
        if (CollUtil.isEmpty((Collection)tasks)) {
            return Collections.emptyList();
        }
        List<BpmTaskExtDO> bpmTaskExtDOs = this.taskExtMapper.selectListByTaskIds(tasks.stream().map(u -> u.getId()).collect(Collectors.toList()));
        Map<String, BpmTaskExtDO> bpmTaskExtDOMap = CollectionUtils.convertMap(bpmTaskExtDOs, BpmTaskExtDO::getTaskId);
        HistoricProcessInstance processInstance = this.processInstanceService.getHistoricProcessInstance1(processInstanceId);
        Set<String> userIds = CollectionUtils.convertSet(tasks, task -> task.getAssignee());
        userIds.add(processInstance.getStartUserId());
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(userIds);
        Map<String, DeptRespDTO> deptMap = this.deptApi.getDeptMap(CollectionUtils.convertSet(userMap.values(), AdminUserRespDTO::getDeptId));
        return BpmTaskConvert.INSTANCE.convertList3(tasks, bpmTaskExtDOMap, processInstance, userMap, deptMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approveTask(String userId, @Valid BpmTaskApproveReqVO reqVO) {
        org.flowable.task.api.Task task = this.checkTask(userId, reqVO.getId());
        ProcessInstance instance = this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
        if (instance == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_NOT_EXISTS);
        }
        this.taskService.complete(task.getId(), instance.getProcessVariables());
        BpmTaskExtDO bpmTaskExtDO = new BpmTaskExtDO();
        bpmTaskExtDO.setTaskId(task.getId());
        bpmTaskExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        bpmTaskExtDO.setReason(reqVO.getReason());
        this.taskExtMapper.updateByTaskId(bpmTaskExtDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectTask(String userId, @Valid BpmTaskRejectReqVO reqVO) {
        org.flowable.task.api.Task task = this.checkTask(userId, reqVO.getId());
        ProcessInstance instance = this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
        if (instance == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_NOT_EXISTS);
        }
        this.processInstanceService.updateProcessInstanceExtReject(instance.getProcessInstanceId(), reqVO.getReason());
        BpmTaskExtDO bpmTaskExtDO = new BpmTaskExtDO();
        bpmTaskExtDO.setTaskId(task.getId());
        bpmTaskExtDO.setResult(BpmProcessInstanceResultEnum.REJECT.getResult());
        bpmTaskExtDO.setEndTime(new Date());
        bpmTaskExtDO.setReason(reqVO.getReason());
        this.taskExtMapper.updateByTaskId(bpmTaskExtDO);
    }

    @Override
    public void updateTaskAssignee(String userId, BpmTaskUpdateAssigneeReqVO reqVO) {
        org.flowable.task.api.Task task = this.checkTask(userId, reqVO.getId());
        this.updateTaskAssignee2(task.getId(), reqVO.getAssigneeUserId());
    }

    @Override
    public void updateTaskAssignee2(String id, String userId) {
        this.taskService.setAssignee(id, userId);
    }

    private org.flowable.task.api.Task checkTask(String userId, String taskId) {
        org.flowable.task.api.Task task = this.getTask(taskId);
        if (task == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_COMPLETE_FAIL_NOT_EXISTS);
        }
        if (!Objects.equals(userId, task.getAssignee())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_COMPLETE_FAIL_ASSIGN_NOT_SELF);
        }
        return task;
    }

    @Override
    public void createTaskExt(Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        this.taskExtMapper.insert(taskExtDO);
    }

    @Override
    public void updateTaskExtComplete(Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        taskExtDO.setEndTime(new Date());
        this.taskExtMapper.updateByTaskId(taskExtDO);
    }

    @Override
    public void updateTaskExtCancel(final String taskId) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                HistoricTaskInstance task = BpmTaskServiceImpl.this.getHistoricTask(taskId);
                if (task == null) {
                    return;
                }
                BpmTaskExtDO taskExt = BpmTaskServiceImpl.this.taskExtMapper.getByTaskId(taskId);
                if (taskExt == null) {
                    log.error("[updateTaskExtCancel][taskId({}) \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55\uff0c\u53ef\u80fd\u5b58\u5728\u95ee\u9898]", (Object)taskId);
                    return;
                }
                if (BpmProcessInstanceResultEnum.isEndResult(taskExt.getResult())) {
                    log.error("[updateTaskExtCancel][taskId({}) \u5904\u4e8e\u7ed3\u679c({})\uff0c\u65e0\u9700\u8fdb\u884c\u66f4\u65b0]", (Object)taskId, (Object)taskExt.getResult());
                    return;
                }
                BpmTaskExtDO bpmTaskExtDO = new BpmTaskExtDO();
                bpmTaskExtDO.setId(taskExt.getId());
                bpmTaskExtDO.setResult(BpmProcessInstanceResultEnum.CANCEL.getResult());
                bpmTaskExtDO.setEndTime(new Date());
                bpmTaskExtDO.setReason(BpmProcessInstanceDeleteReasonEnum.translateReason(task.getDeleteReason()));
                BpmTaskServiceImpl.this.taskExtMapper.updateByPrimaryKeySelective(bpmTaskExtDO);
            }
        });
    }

    @Override
    public void updateTaskExtAssign(final Task task) {
        BpmTaskExtDO taskExtDO = new BpmTaskExtDO();
        taskExtDO.setAssigneeUserId(task.getAssignee());
        taskExtDO.setTaskId(task.getId());
        this.taskExtMapper.updateByTaskId(taskExtDO);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ProcessInstance processInstance = BpmTaskServiceImpl.this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
                AdminUserRespDTO startUser = BpmTaskServiceImpl.this.adminUserApi.getUser(processInstance.getStartUserId());
                BpmTaskServiceImpl.this.messageService.sendMessageWhenTaskAssigned(BpmTaskConvert.INSTANCE.convert(processInstance, startUser, task));
            }
        });
    }

    private org.flowable.task.api.Task getTask(String id) {
        return (org.flowable.task.api.Task)((TaskQuery)this.taskService.createTaskQuery().taskId(id)).singleResult();
    }

    private HistoricTaskInstance getHistoricTask(String id) {
        return (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(id)).singleResult();
    }

    @Override
    public void createTaskExt1(org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt1(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        this.taskExtMapper.insert(taskExtDO);
    }

    @Override
    public void updateTaskExtComplete1(org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt1(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        taskExtDO.setEndTime(new Date());
        this.taskExtMapper.updateByTaskId(taskExtDO);
    }

    @Override
    public void updateTaskExtAssign1(final org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = new BpmTaskExtDO();
        taskExtDO.setAssigneeUserId(task.getAssignee());
        taskExtDO.setTaskId(task.getId());
        this.taskExtMapper.updateByTaskId(taskExtDO);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ProcessInstance processInstance = BpmTaskServiceImpl.this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
                AdminUserRespDTO startUser = BpmTaskServiceImpl.this.adminUserApi.getUser(processInstance.getStartUserId());
                BpmTaskServiceImpl.this.messageService.sendMessageWhenTaskAssigned(BpmTaskConvert.INSTANCE.convert1(processInstance, startUser, task));
            }
        });
    }
}

