/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.impl.identity.Authentication;

public class FlowableUtils {
    public static void setAuthenticatedUserId(String userId) {
        Authentication.setAuthenticatedUserId((String)String.valueOf(userId));
    }

    public static void clearAuthenticatedUserId() {
        Authentication.setAuthenticatedUserId(null);
    }

    public static <T extends FlowElement> List<T> getBpmnModelElements(BpmnModel model, Class<T> clazz) {
        ArrayList result = new ArrayList();
        model.getProcesses().forEach(process -> process.getFlowElements().forEach(flowElement -> {
            if (flowElement.getClass().isAssignableFrom(clazz)) {
                result.add(flowElement);
            }
        }));
        return result;
    }

    public static boolean equals(BpmnModel oldModel, BpmnModel newModel) {
        return Arrays.equals(FlowableUtils.getBpmnBytes(oldModel), FlowableUtils.getBpmnBytes(newModel));
    }

    public static byte[] getBpmnBytes(BpmnModel model) {
        if (model == null) {
            return new byte[0];
        }
        BpmnXMLConverter converter = new BpmnXMLConverter();
        return converter.convertToXML(model);
    }

    public static String formatCollectionVariable(String activityId) {
        return activityId + "_assignees";
    }

    public static String formatCollectionElementVariable(String activityId) {
        return activityId + "_assignee";
    }
}

