/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util.collection;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.ArrayUtil;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public class ArrayUtils {
    @SafeVarargs
    public static <T> Consumer<T>[] append(Consumer<T> object, Consumer<T> ... newElements) {
        if (object == null) {
            return newElements;
        }
        Consumer[] result = (Consumer[])ArrayUtil.newArray(Consumer.class, (int)(1 + newElements.length));
        result[0] = object;
        System.arraycopy(newElements, 0, result, 1, newElements.length);
        return result;
    }

    public static <T, V> V[] toArray(Collection<T> from, Function<T, V> mapper) {
        return ArrayUtils.toArray(CollectionUtils.convertList(from, mapper));
    }

    public static <T> T[] toArray(Collection<T> from) {
        if (CollectionUtil.isEmpty(from)) {
            return new Object[0];
        }
        return ArrayUtil.toArray(from, (Class)IterUtil.getElementType(from.iterator()));
    }

    public static <T> T get(T[] array, int index) {
        if (null == array || index >= array.length) {
            return null;
        }
        return array[index];
    }
}

