/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util.mybatis;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.Collection;
import java.util.Optional;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class Db {
    private static final Log log = LogFactory.getLog(Db.class);

    private Db() {
    }

    public static <T> boolean saveBatch(Collection<T> entityList) {
        return Db.saveBatch(entityList, 1000);
    }

    public static <T> boolean saveBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            return false;
        }
        Class<T> entityClass = Db.getEntityClass(entityList);
        Class mapperClass = ClassUtils.toClassConfident((String)Db.getTableInfo(entityClass).getCurrentNamespace());
        String sqlStatement = SqlHelper.getSqlStatement((Class)mapperClass, (SqlMethod)SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(entityClass, (Log)LogFactory.getLog(Db.class), entityList, (int)batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    public static <T> boolean updateBatchById(Collection<T> entityList) {
        return Db.updateBatchById(entityList, 1000);
    }

    public static <T> boolean updateBatchById(Collection<T> entityList, int batchSize) {
        Class<T> entityClass = Db.getEntityClass(entityList);
        TableInfo tableInfo = Db.getTableInfo(entityClass);
        String sqlStatement = SqlHelper.getSqlStatement((Class)ClassUtils.toClassConfident((String)tableInfo.getCurrentNamespace()), (SqlMethod)SqlMethod.UPDATE_BY_ID);
        return SqlHelper.executeBatch(entityClass, (Log)LogFactory.getLog(Db.class), entityList, (int)batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    protected static <T> Class<T> getEntityClass(Collection<T> entityList) {
        Class<?> entityClass = null;
        for (T entity : entityList) {
            if (entity == null || entity.getClass() == null) continue;
            entityClass = entity.getClass();
            break;
        }
        Assert.notNull(entityClass, (String)"error: can not get entityClass from entityList", (Object[])new Object[0]);
        return entityClass;
    }

    protected static <T> Class<T> getEntityClass(AbstractWrapper<T, ?, ?> queryWrapper) {
        Object entity;
        Class<?> entityClass = queryWrapper.getEntityClass();
        if (entityClass == null && (entity = queryWrapper.getEntity()) != null) {
            entityClass = entity.getClass();
        }
        Assert.notNull((Object)entityClass, (String)"error: can not get entityClass from wrapper", (Object[])new Object[0]);
        return entityClass;
    }

    protected static <T> TableInfo getTableInfo(Class<T> entityClass) {
        return Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"error: can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
    }
}

