/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.flow.Task;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.convert.BpmTaskConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmTaskExtMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmTaskExtDO;
import com.yqbsoft.laser.service.flowable.enums.BpmCommentTypeEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceDeleteReasonEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceResultEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmTaskAddSignTypeEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmMessageService;
import com.yqbsoft.laser.service.flowable.service.BpmModelService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessInstanceService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskService;
import com.yqbsoft.laser.service.flowable.util.BpmnModelUtils;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.date.DateUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.number.NumberUtils;
import com.yqbsoft.laser.service.flowable.util.object.PageUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskAddSignReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskApproveReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskDelegateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskDonePageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskDonePageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskRejectReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskReturnReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskSimpleRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskSubSignReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskSubSignRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskTodoPageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskTodoPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskUpdateAssigneeReqVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.NativeTaskQuery;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class BpmTaskServiceImpl
extends BaseServiceImpl
implements BpmTaskService {
    private static final Logger log = LoggerFactory.getLogger(BpmTaskServiceImpl.class);
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private BpmProcessInstanceService processInstanceService;
    @Resource
    private BpmModelService bpmModelService;
    @Resource
    private BpmMessageService messageService;
    @Resource
    private AdminUserApi adminUserApi;
    @Resource
    private DeptApi deptApi;
    @Resource
    private BpmTaskExtMapper taskExtMapper;
    @Resource
    private ManagementService managementService;

    @Override
    public PageResult<BpmTaskTodoPageItemRespVO> getTodoTaskPage(String userId, BpmTaskTodoPageReqVO pageVO) {
        List tasks;
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(String.valueOf(userId))).orderByTaskCreateTime()).desc();
        if (StrUtil.isNotBlank((CharSequence)pageVO.getName())) {
            taskQuery.taskNameLike("%" + pageVO.getName() + "%");
        }
        if (ArrayUtil.get((Object)pageVO.getCreateTime(), (int)0) != null) {
            taskQuery.taskCreatedAfter(DateUtils.of(pageVO.getCreateTime()[0]));
        }
        if (ArrayUtil.get((Object)pageVO.getCreateTime(), (int)1) != null) {
            taskQuery.taskCreatedBefore(DateUtils.of(pageVO.getCreateTime()[1]));
        }
        if (CollUtil.isEmpty((Collection)(tasks = taskQuery.listPage(PageUtils.getStart(pageVO), pageVO.getPageSize().intValue())))) {
            return PageResult.empty(taskQuery.count());
        }
        Map<String, ProcessInstance> processInstanceMap = this.processInstanceService.getProcessInstanceMap1(CollectionUtils.convertSet(tasks, TaskInfo::getProcessInstanceId));
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(CollectionUtils.convertSet(processInstanceMap.values(), instance -> instance.getStartUserId()));
        return new PageResult<BpmTaskTodoPageItemRespVO>(BpmTaskConvert.INSTANCE.convertList1(tasks, processInstanceMap, userMap), taskQuery.count());
    }

    @Override
    public PageResult<BpmTaskDonePageItemRespVO> getDoneTaskPage(String userId, BpmTaskDonePageReqVO pageVO) {
        List tasks;
        HistoricTaskInstanceQuery taskQuery = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().finished().taskAssignee(String.valueOf(userId))).orderByHistoricTaskInstanceEndTime().desc();
        if (StrUtil.isNotBlank((CharSequence)pageVO.getName())) {
            taskQuery.taskNameLike("%" + pageVO.getName() + "%");
        }
        if (pageVO.getBeginCreateTime() != null) {
            taskQuery.taskCreatedAfter(DateUtils.of(pageVO.getBeginCreateTime()));
        }
        if (pageVO.getEndCreateTime() != null) {
            taskQuery.taskCreatedBefore(DateUtils.of(pageVO.getEndCreateTime()));
        }
        if (CollUtil.isEmpty((Collection)(tasks = taskQuery.listPage(PageUtils.getStart(pageVO), pageVO.getPageSize().intValue())))) {
            return PageResult.empty(taskQuery.count());
        }
        List<BpmTaskExtDO> bpmTaskExtDOs = this.taskExtMapper.selectListByTaskIds(tasks.stream().map(u -> u.getId()).collect(Collectors.toList()));
        Map<String, BpmTaskExtDO> bpmTaskExtDOMap = CollectionUtils.convertMap(bpmTaskExtDOs, BpmTaskExtDO::getTaskId);
        Map<String, HistoricProcessInstance> historicProcessInstanceMap = this.processInstanceService.getHistoricProcessInstanceMap1(CollectionUtils.convertSet(tasks, TaskInfo::getProcessInstanceId));
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(CollectionUtils.convertSet(historicProcessInstanceMap.values(), instance -> instance.getStartUserId()));
        return new PageResult<BpmTaskDonePageItemRespVO>(BpmTaskConvert.INSTANCE.convertList2(tasks, bpmTaskExtDOMap, historicProcessInstanceMap, userMap), taskQuery.count());
    }

    @Override
    public List<org.flowable.task.api.Task> getTasksByProcessInstanceIds1(List<String> processInstanceIds) {
        if (CollUtil.isEmpty(processInstanceIds)) {
            return Collections.emptyList();
        }
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(processInstanceIds)).list();
    }

    @Override
    public List<BpmTaskRespVO> getTaskListByProcessInstanceId(String processInstanceId) {
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceStartTime().desc()).list();
        if (CollUtil.isEmpty((Collection)tasks)) {
            return Collections.emptyList();
        }
        List<BpmTaskExtDO> bpmTaskExtDOs = this.taskExtMapper.selectListByTaskIds(tasks.stream().map(u -> u.getId()).collect(Collectors.toList()));
        Map<String, BpmTaskExtDO> bpmTaskExtDOMap = CollectionUtils.convertMap(bpmTaskExtDOs, BpmTaskExtDO::getTaskId);
        HistoricProcessInstance processInstance = this.processInstanceService.getHistoricProcessInstance1(processInstanceId);
        Set<String> userIds = CollectionUtils.convertSet(tasks, task -> task.getAssignee());
        userIds.add(processInstance.getStartUserId());
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(userIds);
        Map<String, DeptRespDTO> deptMap = this.deptApi.getDeptMap(CollectionUtils.convertSet(userMap.values(), AdminUserRespDTO::getDeptId));
        List<BpmTaskRespVO> result = BpmTaskConvert.INSTANCE.convertList3(tasks, bpmTaskExtDOMap, processInstance, userMap, deptMap);
        return BpmTaskConvert.INSTANCE.convertChildrenList(result);
    }

    @Override
    public List<BpmTaskExtDO> getTaskListByTaskIdList(List<String> taskIdList) {
        return this.taskExtMapper.selectListByTaskIds(taskIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approveTask(String userId, @Valid BpmTaskApproveReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateTask(userId, reqVO.getId());
        ProcessInstance instance = this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
        if (instance == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_NOT_EXISTS);
        }
        if (DelegationState.PENDING.equals((Object)task.getDelegationState())) {
            this.approveDelegateTask(reqVO, task, userId);
            return;
        }
        if (BpmTaskAddSignTypeEnum.AFTER.getType().equals(task.getScopeType())) {
            this.approveAfterSignTask(task, reqVO);
            return;
        }
        this.taskService.complete(task.getId(), instance.getProcessVariables());
        BpmTaskExtDO bpmTaskExtDO = new BpmTaskExtDO();
        bpmTaskExtDO.setTaskId(task.getId());
        bpmTaskExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        bpmTaskExtDO.setReason(reqVO.getReason());
        this.taskExtMapper.updateByTaskId(bpmTaskExtDO);
        this.handleParentTask(task);
    }

    private void approveAfterSignTask(org.flowable.task.api.Task task, BpmTaskApproveReqVO reqVO) {
        this.taskExtMapper.updateByTaskId(new BpmTaskExtDO().setTaskId(task.getId()).setResult(BpmProcessInstanceResultEnum.SIGN_AFTER.getResult()).setReason(reqVO.getReason()).setEndTime(new Date()));
        List<String> childrenTaskIdList = this.getChildrenTaskIdList(task.getId());
        for (String childrenTaskId : childrenTaskIdList) {
            this.taskService.resolveTask(childrenTaskId);
        }
        this.taskExtMapper.updateBatchByTaskIdList(childrenTaskIdList, new BpmTaskExtDO().setResult(BpmProcessInstanceResultEnum.PROCESS.getResult()));
    }

    private void handleParentTask(org.flowable.task.api.Task task) {
        String parentTaskId = task.getParentTaskId();
        if (StrUtil.isBlank((CharSequence)parentTaskId)) {
            return;
        }
        Long childrenTaskCount = this.getChildrenTaskCount(parentTaskId);
        if (childrenTaskCount > 0L) {
            return;
        }
        org.flowable.task.api.Task parentTask = this.validateTaskExist(parentTaskId);
        String scopeType = parentTask.getScopeType();
        if (!this.validateSignType(scopeType)) {
            return;
        }
        if (BpmTaskAddSignTypeEnum.BEFORE.getType().equals(scopeType)) {
            this.taskService.resolveTask(parentTaskId);
            this.taskExtMapper.updateByTaskId(new BpmTaskExtDO().setTaskId(parentTask.getId()).setResult(BpmProcessInstanceResultEnum.PROCESS.getResult()));
        } else if (BpmTaskAddSignTypeEnum.AFTER.getType().equals(scopeType)) {
            this.handleParentTaskForAfterSign(parentTask);
        }
        parentTask = this.getTask(parentTaskId);
        if (parentTask == null) {
            return;
        }
        this.clearTaskScopeTypeAndSave(parentTask);
    }

    private void handleParentTaskForAfterSign(org.flowable.task.api.Task parentTask) {
        BpmTaskExtDO parentTaskExt;
        String parentTaskId = parentTask.getId();
        BpmTaskExtDO currentTaskExt = this.taskExtMapper.getByTaskId(parentTask.getId());
        BpmTaskExtDO currentTaskExtUpdateObj = new BpmTaskExtDO().setTaskId(parentTask.getId()).setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        if (currentTaskExt.getEndTime() == null) {
            currentTaskExtUpdateObj.setEndTime(new Date());
        }
        this.taskExtMapper.updateByTaskId(currentTaskExtUpdateObj);
        this.taskService.complete(parentTaskId);
        if (StrUtil.isEmpty((CharSequence)parentTask.getParentTaskId())) {
            return;
        }
        boolean allChildrenTaskFinish = true;
        while (StrUtil.isNotBlank((CharSequence)parentTask.getParentTaskId()) && (parentTaskExt = this.taskExtMapper.getByTaskId((parentTask = this.validateTaskExist(parentTask.getParentTaskId())).getId())) != null) {
            Long childrenTaskCount;
            boolean currentTaskFinish = BpmProcessInstanceResultEnum.isEndResult(parentTaskExt.getResult());
            if (allChildrenTaskFinish) {
                allChildrenTaskFinish = currentTaskFinish;
            }
            if (currentTaskFinish || (childrenTaskCount = this.getChildrenTaskCount(parentTaskExt.getTaskId())) > 0L) continue;
            if (BpmProcessInstanceResultEnum.SIGN_BEFORE.getResult().equals(parentTaskExt.getResult())) {
                this.taskService.resolveTask(parentTaskExt.getTaskId());
                parentTaskExt.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
                this.taskExtMapper.updateByTaskId(parentTaskExt);
            }
            parentTask = this.validateTaskExist(parentTaskExt.getTaskId());
            this.clearTaskScopeTypeAndSave(parentTask);
        }
        if (allChildrenTaskFinish) {
            this.taskService.complete(parentTask.getId());
        }
    }

    private void clearTaskScopeTypeAndSave(org.flowable.task.api.Task task) {
        TaskEntityImpl taskImpl = (TaskEntityImpl)task;
        taskImpl.setScopeType(null);
        this.taskService.saveTask(task);
    }

    private Long getChildrenTaskCount(String parentTaskId) {
        String tableName = this.managementService.getTableName(TaskEntity.class);
        String sql = "SELECT COUNT(1) from " + tableName + " WHERE PARENT_TASK_ID_=#{parentTaskId}";
        return ((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql(sql)).parameter("parentTaskId", (Object)parentTaskId)).count();
    }

    private void approveDelegateTask(BpmTaskApproveReqVO reqVO, org.flowable.task.api.Task task, String userId) {
        AdminUserRespDTO currentUser = this.adminUserApi.getUser(userId);
        AdminUserRespDTO sourceApproveUser = this.adminUserApi.getUser(task.getOwner());
        Assert.notNull((Object)sourceApproveUser, (String)"\u59d4\u6d3e\u4efb\u52a1\u627e\u4e0d\u5230\u539f\u5ba1\u6279\u4eba\uff0c\u9700\u8981\u68c0\u67e5\u6570\u636e");
        String comment = StrUtil.format((CharSequence)"[{}]\u5b8c\u6210\u59d4\u6d3e\u4efb\u52a1\uff0c\u4efb\u52a1\u91cd\u65b0\u56de\u5230[{}]\u624b\u4e2d\uff0c\u5ba1\u6279\u610f\u89c1\u4e3a:{}", (Object[])new Object[]{currentUser.getNickname(), sourceApproveUser.getNickname(), reqVO.getReason()});
        this.taskService.addComment(reqVO.getId(), task.getProcessInstanceId(), BpmCommentTypeEnum.DELEGATE.getType().toString(), comment);
        this.taskService.resolveTask(task.getId());
        this.taskExtMapper.updateByTaskId(new BpmTaskExtDO().setTaskId(task.getId()).setResult(BpmProcessInstanceResultEnum.PROCESS.getResult()).setReason(reqVO.getReason()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectTask(String userId, @Valid BpmTaskRejectReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateTask(userId, reqVO.getId());
        ProcessInstance instance = this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
        if (instance == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_NOT_EXISTS);
        }
        this.processInstanceService.updateProcessInstanceExtReject(instance.getProcessInstanceId(), reqVO.getReason());
        BpmTaskExtDO bpmTaskExtDO = new BpmTaskExtDO();
        bpmTaskExtDO.setTaskId(task.getId());
        bpmTaskExtDO.setResult(BpmProcessInstanceResultEnum.REJECT.getResult());
        bpmTaskExtDO.setEndTime(new Date());
        bpmTaskExtDO.setReason(reqVO.getReason());
        this.taskExtMapper.updateByTaskId(bpmTaskExtDO);
    }

    @Override
    public void updateTaskAssignee(String userId, BpmTaskUpdateAssigneeReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateTask(userId, reqVO.getId());
        this.updateTaskAssignee2(task.getId(), reqVO.getAssigneeUserId());
    }

    @Override
    public void updateTaskAssignee2(String id, String userId) {
        this.taskService.setAssignee(id, userId);
    }

    private org.flowable.task.api.Task validateTask(String userId, String taskId) {
        org.flowable.task.api.Task task = this.validateTaskExist(taskId);
        if (!Objects.equals(userId, NumberUtils.parseLong(task.getAssignee()))) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_OPERATE_FAIL_ASSIGN_NOT_SELF);
        }
        return task;
    }

    @Override
    public void createTaskExt(Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        if (BpmTaskAddSignTypeEnum.AFTER_CHILDREN_TASK.getType().equals(task.getScopeType())) {
            taskExtDO.setResult(BpmProcessInstanceResultEnum.WAIT_BEFORE_TASK.getResult());
        }
        this.taskExtMapper.insert(taskExtDO);
    }

    @Override
    public void updateTaskExtComplete(Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        taskExtDO.setEndTime(new Date());
        this.taskExtMapper.updateByTaskId(taskExtDO);
    }

    @Override
    public void updateTaskExtCancel(final String taskId) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                HistoricTaskInstance task = BpmTaskServiceImpl.this.getHistoricTask(taskId);
                if (task == null) {
                    return;
                }
                BpmTaskExtDO taskExt = BpmTaskServiceImpl.this.taskExtMapper.getByTaskId(taskId);
                if (taskExt == null) {
                    log.error("[updateTaskExtCancel][taskId({}) \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55\uff0c\u53ef\u80fd\u5b58\u5728\u95ee\u9898]", (Object)taskId);
                    return;
                }
                if (BpmProcessInstanceResultEnum.isEndResult(taskExt.getResult())) {
                    log.error("[updateTaskExtCancel][taskId({}) \u5904\u4e8e\u7ed3\u679c({})\uff0c\u65e0\u9700\u8fdb\u884c\u66f4\u65b0]", (Object)taskId, (Object)taskExt.getResult());
                    return;
                }
                BpmTaskExtDO bpmTaskExtDO = new BpmTaskExtDO();
                bpmTaskExtDO.setId(taskExt.getId());
                bpmTaskExtDO.setResult(BpmProcessInstanceResultEnum.CANCEL.getResult());
                bpmTaskExtDO.setEndTime(new Date());
                bpmTaskExtDO.setReason(BpmProcessInstanceDeleteReasonEnum.translateReason(task.getDeleteReason()));
                BpmTaskServiceImpl.this.taskExtMapper.updateByPrimaryKeySelective(bpmTaskExtDO);
            }
        });
    }

    @Override
    public void updateTaskExtAssign(final Task task) {
        BpmTaskExtDO taskExtDO = new BpmTaskExtDO();
        taskExtDO.setAssigneeUserId(task.getAssignee());
        taskExtDO.setTaskId(task.getId());
        this.taskExtMapper.updateByTaskId(taskExtDO);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                if (StrUtil.isNotEmpty((CharSequence)task.getAssignee())) {
                    ProcessInstance processInstance = BpmTaskServiceImpl.this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
                    AdminUserRespDTO startUser = BpmTaskServiceImpl.this.adminUserApi.getUser(processInstance.getStartUserId());
                    BpmTaskServiceImpl.this.messageService.sendMessageWhenTaskAssigned(BpmTaskConvert.INSTANCE.convert(processInstance, startUser, task));
                }
            }
        });
    }

    private org.flowable.task.api.Task validateTaskExist(String id) {
        org.flowable.task.api.Task task = this.getTask(id);
        if (task == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_NOT_EXISTS);
        }
        return task;
    }

    private org.flowable.task.api.Task getTask(String id) {
        return (org.flowable.task.api.Task)((TaskQuery)this.taskService.createTaskQuery().taskId(id)).singleResult();
    }

    private HistoricTaskInstance getHistoricTask(String id) {
        return (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(id)).singleResult();
    }

    @Override
    public void createTaskExt1(org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt1(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        this.taskExtMapper.insert(taskExtDO);
    }

    @Override
    public void updateTaskExtComplete1(org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = BpmTaskConvert.INSTANCE.convert2TaskExt1(task);
        taskExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        taskExtDO.setEndTime(new Date());
        this.taskExtMapper.updateByTaskId(taskExtDO);
    }

    @Override
    public void updateTaskExtAssign1(final org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = new BpmTaskExtDO();
        taskExtDO.setAssigneeUserId(task.getAssignee());
        taskExtDO.setTaskId(task.getId());
        this.taskExtMapper.updateByTaskId(taskExtDO);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ProcessInstance processInstance = BpmTaskServiceImpl.this.processInstanceService.getProcessInstance1(task.getProcessInstanceId());
                AdminUserRespDTO startUser = BpmTaskServiceImpl.this.adminUserApi.getUser(processInstance.getStartUserId());
                BpmTaskServiceImpl.this.messageService.sendMessageWhenTaskAssigned(BpmTaskConvert.INSTANCE.convert1(processInstance, startUser, task));
            }
        });
    }

    @Override
    public List<BpmTaskSimpleRespVO> getReturnTaskList(String taskId) {
        org.flowable.task.api.Task task = this.validateTaskExist(taskId);
        BpmnModel bpmnModel = this.bpmModelService.getBpmnModelByDefinitionId(task.getProcessDefinitionId());
        FlowElement source = BpmnModelUtils.getFlowElementById(bpmnModel, task.getTaskDefinitionKey());
        if (source == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_NOT_EXISTS);
        }
        List<UserTask> previousUserList = BpmnModelUtils.getPreviousUserTaskList(source, null, null);
        if (CollUtil.isEmpty(previousUserList)) {
            return Collections.emptyList();
        }
        previousUserList.removeIf(userTask -> !BpmnModelUtils.isSequentialReachable(source, (FlowElement)userTask, null));
        return BpmTaskConvert.INSTANCE.convertList(previousUserList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnTask(String userId, BpmTaskReturnReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateTask(userId, reqVO.getId());
        if (task.isSuspended()) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_IS_PENDING);
        }
        FlowElement targetElement = this.validateTargetTaskCanReturn(task.getTaskDefinitionKey(), reqVO.getTargetDefinitionKey(), task.getProcessDefinitionId());
        this.returnTask0(task, targetElement, reqVO);
        this.taskExtMapper.updateByTaskId(new BpmTaskExtDO().setTaskId(task.getId()).setResult(BpmProcessInstanceResultEnum.BACK.getResult()).setEndTime(new Date()).setReason(reqVO.getReason()));
    }

    private FlowElement validateTargetTaskCanReturn(String sourceKey, String targetKey, String processDefinitionId) {
        BpmnModel bpmnModel = this.bpmModelService.getBpmnModelByDefinitionId(processDefinitionId);
        FlowElement source = BpmnModelUtils.getFlowElementById(bpmnModel, sourceKey);
        FlowElement target = BpmnModelUtils.getFlowElementById(bpmnModel, targetKey);
        if (target == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_TARGET_NODE_NOT_EXISTS);
        }
        if (!BpmnModelUtils.isSequentialReachable(source, target, null)) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_RETURN_FAIL_SOURCE_TARGET_ERROR);
        }
        return target;
    }

    public void returnTask0(org.flowable.task.api.Task currentTask, FlowElement targetElement, BpmTaskReturnReqVO reqVO) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currentTask.getProcessInstanceId())).list();
        List<String> runTaskKeyList = CollectionUtils.convertList(taskList, TaskInfo::getTaskDefinitionKey);
        List<UserTask> returnUserTaskList = BpmnModelUtils.iteratorFindChildUserTasks(targetElement, runTaskKeyList, null, null);
        List<String> returnTaskKeyList = CollectionUtils.convertList(returnUserTaskList, BaseElement::getId);
        taskList.forEach(task -> {
            if (!returnTaskKeyList.contains(task.getTaskDefinitionKey())) {
                return;
            }
            this.taskService.addComment(task.getId(), currentTask.getProcessInstanceId(), BpmCommentTypeEnum.BACK.getType().toString(), reqVO.getReason());
        });
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(currentTask.getProcessInstanceId()).moveActivityIdsToSingleActivityId(returnTaskKeyList, reqVO.getTargetDefinitionKey()).changeState();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDelegateTask(String userId, BpmTaskDelegateReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateTaskCanDelegate(userId, reqVO);
        AdminUserRespDTO delegateUser = this.adminUserApi.getUser(reqVO.getDelegateUserId());
        if (delegateUser == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_DELEGATE_FAIL_USER_NOT_EXISTS);
        }
        AdminUserRespDTO currentUser = this.adminUserApi.getUser(userId);
        String comment = StrUtil.format((CharSequence)"[{}]\u5c06\u4efb\u52a1\u59d4\u6d3e\u7ed9[{}]\uff0c\u59d4\u6d3e\u7406\u7531\u4e3a:{}", (Object[])new Object[]{currentUser.getNickname(), delegateUser.getNickname(), reqVO.getReason()});
        String taskId = reqVO.getId();
        this.taskService.addComment(taskId, task.getProcessInstanceId(), BpmCommentTypeEnum.DELEGATE.getType().toString(), comment);
        this.taskService.setOwner(taskId, task.getAssignee());
        this.taskService.delegateTask(taskId, reqVO.getDelegateUserId().toString());
        this.taskExtMapper.updateByTaskId(new BpmTaskExtDO().setTaskId(task.getId()).setResult(BpmProcessInstanceResultEnum.DELEGATE.getResult()).setReason(reqVO.getReason()));
    }

    private org.flowable.task.api.Task validateTaskCanDelegate(String userId, BpmTaskDelegateReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateTask(userId, reqVO.getId());
        if (task.getAssignee().equals(reqVO.getDelegateUserId().toString())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_DELEGATE_FAIL_USER_REPEAT);
        }
        return task;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createSignTask(String userId, BpmTaskAddSignReqVO reqVO) {
        TaskEntityImpl taskEntity = this.validateAddSign(userId, reqVO);
        List<AdminUserRespDTO> userList = this.adminUserApi.getUserList(reqVO.getUserIdList());
        if (CollUtil.isEmpty(userList)) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_ADD_SIGN_USER_NOT_EXIST);
        }
        taskEntity.setCountEnabled(true);
        if (reqVO.getType().equals(BpmTaskAddSignTypeEnum.BEFORE.getType())) {
            taskEntity.setOwner(taskEntity.getAssignee());
            taskEntity.setAssignee(null);
            this.taskExtMapper.updateByTaskId(new BpmTaskExtDO().setTaskId(taskEntity.getId()).setResult(BpmProcessInstanceResultEnum.SIGN_BEFORE.getResult()).setReason(reqVO.getReason()));
        }
        taskEntity.setScopeType(reqVO.getType());
        this.taskService.saveTask((org.flowable.task.api.Task)taskEntity);
        this.createSignTask(CollectionUtils.convertList(reqVO.getUserIdList(), String::valueOf), taskEntity);
        AdminUserRespDTO currentUser = this.adminUserApi.getUser(userId);
        String comment = StrUtil.format((CharSequence)BpmCommentTypeEnum.ADD_SIGN.getComment(), (Object[])new Object[]{currentUser.getNickname(), BpmTaskAddSignTypeEnum.formatDesc(reqVO.getType()), String.join((CharSequence)",", CollectionUtils.convertList(userList, AdminUserRespDTO::getNickname)), reqVO.getReason()});
        this.taskService.addComment(reqVO.getId(), taskEntity.getProcessInstanceId(), BpmCommentTypeEnum.ADD_SIGN.getType().toString(), comment);
    }

    private TaskEntityImpl validateAddSign(String userId, BpmTaskAddSignReqVO reqVO) {
        TaskEntityImpl taskEntity = (TaskEntityImpl)this.validateTask(userId, reqVO.getId());
        if (StrUtil.isNotBlank((CharSequence)taskEntity.getScopeType()) && ObjectUtil.notEqual((Object)BpmTaskAddSignTypeEnum.AFTER_CHILDREN_TASK.getType(), (Object)taskEntity.getScopeType()) && ObjectUtil.notEqual((Object)taskEntity.getScopeType(), (Object)reqVO.getType())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_ADD_SIGN_TYPE_ERROR, BpmTaskAddSignTypeEnum.formatDesc(taskEntity.getScopeType()), BpmTaskAddSignTypeEnum.formatDesc(reqVO.getType()));
        }
        List taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(taskEntity.getProcessInstanceId())).taskDefinitionKey(taskEntity.getTaskDefinitionKey())).list();
        List<String> currentAssigneeList = CollectionUtils.convertList(taskList, task -> task.getAssignee());
        currentAssigneeList.retainAll(reqVO.getUserIdList());
        if (CollUtil.isNotEmpty(currentAssigneeList)) {
            List<AdminUserRespDTO> userList = this.adminUserApi.getUserList(currentAssigneeList);
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_ADD_SIGN_USER_REPEAT, String.join((CharSequence)",", CollectionUtils.convertList(userList, AdminUserRespDTO::getNickname)));
        }
        return taskEntity;
    }

    private void createSignTask(List<String> addSingUserIdList, TaskEntityImpl taskEntity) {
        if (CollUtil.isEmpty(addSingUserIdList)) {
            return;
        }
        for (String addSignId : addSingUserIdList) {
            if (StrUtil.isBlank((CharSequence)addSignId)) continue;
            this.createSignTask(taskEntity, addSignId);
        }
    }

    private void createSignTask(TaskEntityImpl parentTask, String assignee) {
        TaskEntityImpl task = (TaskEntityImpl)this.taskService.newTask(IdUtil.fastSimpleUUID());
        task = BpmTaskConvert.INSTANCE.convert(task, parentTask);
        if (BpmTaskAddSignTypeEnum.BEFORE.getType().equals(parentTask.getScopeType())) {
            task.setAssignee(assignee);
        } else {
            task.setOwner(assignee);
            task.setScopeType(BpmTaskAddSignTypeEnum.AFTER_CHILDREN_TASK.getType());
        }
        this.taskService.saveTask((org.flowable.task.api.Task)task);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSignTask(String userId, BpmTaskSubSignReqVO reqVO) {
        org.flowable.task.api.Task task = this.validateSubSign(reqVO.getId());
        AdminUserRespDTO cancelUser = null;
        if (StrUtil.isNotBlank((CharSequence)task.getAssignee())) {
            cancelUser = this.adminUserApi.getUser(task.getAssignee());
        }
        if (cancelUser == null && StrUtil.isNotBlank((CharSequence)task.getOwner())) {
            cancelUser = this.adminUserApi.getUser(task.getOwner());
        }
        Assert.notNull(cancelUser, (String)"\u4efb\u52a1\u4e2d\u6ca1\u6709\u6240\u6709\u8005\u548c\u5ba1\u6279\u4eba\uff0c\u6570\u636e\u9519\u8bef");
        List<String> allTaskIdList = this.getAllChildTaskIds(task.getId());
        this.taskService.deleteTasks(allTaskIdList);
        AdminUserRespDTO user = this.adminUserApi.getUser(userId);
        this.taskExtMapper.updateBatchByTaskIdList(allTaskIdList, new BpmTaskExtDO().setResult(BpmProcessInstanceResultEnum.CANCEL.getResult()).setReason(StrUtil.format((CharSequence)"\u7531\u4e8e{}\u64cd\u4f5c[\u51cf\u7b7e]\uff0c\u4efb\u52a1\u88ab\u53d6\u6d88", (Object[])new Object[]{user.getNickname()})));
        String comment = StrUtil.format((CharSequence)BpmCommentTypeEnum.SUB_SIGN.getComment(), (Object[])new Object[]{user.getNickname(), cancelUser.getNickname()});
        this.taskService.addComment(task.getParentTaskId(), task.getProcessInstanceId(), BpmCommentTypeEnum.SUB_SIGN.getType().toString(), comment);
        this.handleParentTask(task);
    }

    private org.flowable.task.api.Task validateSubSign(String id) {
        org.flowable.task.api.Task task = this.validateTaskExist(id);
        String scopeType = task.getScopeType();
        if (StrUtil.isEmpty((CharSequence)scopeType)) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_SUB_SIGN_NO_PARENT);
        }
        if (!this.validateSignType(scopeType)) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_SUB_SIGN_NO_PARENT);
        }
        return task;
    }

    private boolean validateSignType(String scopeType) {
        return StrUtil.equalsAny((CharSequence)scopeType, (CharSequence[])new CharSequence[]{BpmTaskAddSignTypeEnum.BEFORE.getType(), scopeType, BpmTaskAddSignTypeEnum.AFTER.getType()});
    }

    public List<String> getAllChildTaskIds(String parentTaskId) {
        ArrayList<String> allChildTaskIds = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        stack.push(parentTaskId);
        for (int count = 0; !stack.isEmpty() && count < 127; ++count) {
            String taskId = (String)stack.pop();
            allChildTaskIds.add(taskId);
            List<String> childrenTaskIdList = this.getChildrenTaskIdList(taskId);
            if (!CollUtil.isNotEmpty(childrenTaskIdList)) continue;
            for (String childTaskId : childrenTaskIdList) {
                stack.push(childTaskId);
            }
        }
        return allChildTaskIds;
    }

    private List<String> getChildrenTaskIdList(String parentTaskId) {
        return CollectionUtils.convertList(this.getChildrenTaskList0(parentTaskId), TaskInfo::getId);
    }

    private List<org.flowable.task.api.Task> getChildrenTaskList0(String parentTaskId) {
        String tableName = this.managementService.getTableName(TaskEntity.class);
        String sql = "select ID_,OWNER_,ASSIGNEE_ from " + tableName + " where PARENT_TASK_ID_=#{parentTaskId}";
        return ((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql(sql)).parameter("parentTaskId", (Object)parentTaskId)).list();
    }

    @Override
    public List<BpmTaskSubSignRespVO> getChildrenTaskList(String parentId) {
        List<org.flowable.task.api.Task> taskList = this.getChildrenTaskList0(parentId);
        if (CollUtil.isEmpty(taskList)) {
            return Collections.emptyList();
        }
        List<String> childrenTaskIdList = CollectionUtils.convertList(taskList, TaskInfo::getId);
        List<String> userIds = CollectionUtils.convertListByFlatMap(taskList, control -> Stream.of(control.getAssignee(), control.getOwner()).filter(Objects::nonNull));
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(userIds);
        List<BpmTaskExtDO> taskExtList = this.taskExtMapper.selectListByTaskIdsAndResults(childrenTaskIdList, BpmProcessInstanceResultEnum.CAN_SUB_SIGN_STATUS_LIST);
        Map<String, org.flowable.task.api.Task> idTaskMap = CollectionUtils.convertMap(taskList, TaskInfo::getId);
        return BpmTaskConvert.INSTANCE.convertList(taskExtList, userMap, idTaskMap);
    }
}

