/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.convert.BpmUserGroupConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmUserGroupMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmUserGroupDO;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmUserGroupService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupUpdateReqVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmUserGroupServiceImpl
extends BaseServiceImpl
implements BpmUserGroupService {
    @Resource
    private BpmUserGroupMapper userGroupMapper;

    @Override
    public Long createUserGroup(BpmUserGroupCreateReqVO createReqVO) {
        BpmUserGroupDO userGroup = BpmUserGroupConvert.INSTANCE.convert(createReqVO);
        this.userGroupMapper.insert(userGroup);
        return userGroup.getId();
    }

    @Override
    public void updateUserGroup(BpmUserGroupUpdateReqVO updateReqVO) {
        this.validateUserGroupExists(updateReqVO.getId());
        BpmUserGroupDO updateObj = BpmUserGroupConvert.INSTANCE.convert(updateReqVO);
        this.userGroupMapper.updateByPrimaryKeySelective(updateObj);
    }

    @Override
    public void deleteUserGroup(Long id) {
        this.validateUserGroupExists(id);
        this.userGroupMapper.deleteByPrimaryKey(id);
    }

    private void validateUserGroupExists(Long id) {
        if (this.userGroupMapper.selectByPrimaryKey(id) == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_NOT_EXISTS);
        }
    }

    @Override
    public BpmUserGroupDO getUserGroup(Long id) {
        return this.userGroupMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<BpmUserGroupDO> getUserGroupList(Collection<String> ids) {
        List<String> List2 = ids.stream().collect(Collectors.toList());
        return this.userGroupMapper.selectBatchIds(List2);
    }

    @Override
    public List<BpmUserGroupDO> getUserGroupListByStatus(Integer status) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("status", status);
        return this.userGroupMapper.query(parameters);
    }

    @Override
    public PageResult<BpmUserGroupDO> getUserGroupPage(BpmUserGroupPageReqVO pageReqVO) {
        PageResult<BpmUserGroupDO> pageResult = new PageResult<BpmUserGroupDO>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (pageReqVO.getPageNo() != null && pageReqVO.getPageSize() != null) {
            parameters.put("startRow", (pageReqVO.getPageNo() - 1) * pageReqVO.getPageSize());
            parameters.put("rows", pageReqVO.getPageSize());
        }
        if (pageReqVO.getName() != null) {
            parameters.put("name", pageReqVO.getName());
        }
        if (pageReqVO.getMemberCode() != null) {
            parameters.put("memberCode", pageReqVO.getMemberCode());
        }
        if (pageReqVO.getChannelCode() != null) {
            parameters.put("channelCode", pageReqVO.getChannelCode());
        }
        if (pageReqVO.getStatus() != null) {
            parameters.put("status", pageReqVO.getStatus());
        }
        if (pageReqVO.getCreateTime() != null) {
            parameters.put("createTime", pageReqVO.getCreateTime());
        }
        List<BpmUserGroupDO> query = this.userGroupMapper.query(parameters);
        int count = this.userGroupMapper.count(parameters);
        pageResult.setList(query);
        pageResult.setTotal(Long.valueOf(count));
        return pageResult;
    }

    @Override
    public void validUserGroups(Set<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        List<String> List2 = ids.stream().collect(Collectors.toList());
        List<BpmUserGroupDO> userGroups = this.userGroupMapper.selectBatchIds(List2);
        Map<Long, BpmUserGroupDO> userGroupMap = CollectionUtils.convertMap(userGroups, BpmUserGroupDO::getId);
        ids.forEach(id -> {
            BpmUserGroupDO userGroup = (BpmUserGroupDO)userGroupMap.get(id);
            if (userGroup == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_NOT_EXISTS);
            }
            if (!CommonStatusEnum.ENABLE.getStatus().equals(userGroup.getStatus())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_IS_DISABLE, userGroup.getName());
            }
        });
    }
}

