/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.flow.Task;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.domain.BpmTaskExtDO;
import com.yqbsoft.laser.service.flowable.dto.BpmMessageSendWhenTaskCreatedReqDTO;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.collection.MapUtils;
import com.yqbsoft.laser.service.flowable.util.date.DateUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskDonePageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskSimpleRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskSubSignRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskTodoPageItemRespVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;

@Mapper(uses={DateUtils.class})
public interface BpmTaskConvert {
    public static final BpmTaskConvert INSTANCE = (BpmTaskConvert)Mappers.getMapper(BpmTaskConvert.class);

    public static <T> T copy(Object source, Class<T> target) {
        if (source == null || target == null) {
            return null;
        }
        try {
            T newInstance = target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)source, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public List<BpmTaskTodoPageItemRespVO> convertList1(List<org.flowable.task.api.Task> tasks, Map<String, ProcessInstance> processInstanceMap, Map<String, AdminUserRespDTO> userMap) {
        return CollectionUtils.convertList(tasks, task -> {
            BpmTaskTodoPageItemRespVO respVO = this.convert1((org.flowable.task.api.Task)task);
            ProcessInstance processInstance = (ProcessInstance)processInstanceMap.get(task.getProcessInstanceId());
            if (processInstance != null) {
                AdminUserRespDTO startUser = (AdminUserRespDTO)userMap.get(processInstance.getStartUserId());
                respVO.setProcessInstance(this.convert(processInstance, startUser));
            }
            return respVO;
        });
    }

    @Mapping(source="suspended", target="suspensionState", qualifiedByName={"convertSuspendedToSuspensionState"})
    public BpmTaskTodoPageItemRespVO convert1(org.flowable.task.api.Task var1);

    @Named(value="convertSuspendedToSuspensionState")
    default public Integer convertSuspendedToSuspensionState(boolean suspended) {
        return suspended ? SuspensionState.SUSPENDED.getStateCode() : SuspensionState.ACTIVE.getStateCode();
    }

    default public List<BpmTaskDonePageItemRespVO> convertList2(List<HistoricTaskInstance> tasks, Map<String, BpmTaskExtDO> bpmTaskExtDOMap, Map<String, HistoricProcessInstance> historicProcessInstanceMap, Map<String, AdminUserRespDTO> userMap) {
        return CollectionUtils.convertList(tasks, task -> {
            BpmTaskDonePageItemRespVO respVO = this.convert2((HistoricTaskInstance)task);
            BpmTaskExtDO taskExtDO = (BpmTaskExtDO)bpmTaskExtDOMap.get(task.getId());
            this.copyTo(taskExtDO, respVO);
            HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceMap.get(task.getProcessInstanceId());
            if (processInstance != null) {
                AdminUserRespDTO startUser = (AdminUserRespDTO)userMap.get(processInstance.getStartUserId());
                respVO.setProcessInstance(this.convert(processInstance, startUser));
            }
            return respVO;
        });
    }

    public BpmTaskDonePageItemRespVO convert2(HistoricTaskInstance var1);

    @Mappings(value={@Mapping(source="processInstance.id", target="id"), @Mapping(source="processInstance.name", target="name"), @Mapping(source="processInstance.startUserId", target="startUserId"), @Mapping(source="processInstance.processDefinitionId", target="processDefinitionId"), @Mapping(source="startUser.nickname", target="startUserNickname")})
    public BpmTaskTodoPageItemRespVO.ProcessInstance convert(ProcessInstance var1, AdminUserRespDTO var2);

    default public List<BpmTaskRespVO> convertList3(List<HistoricTaskInstance> tasks, Map<String, BpmTaskExtDO> bpmTaskExtDOMap, HistoricProcessInstance processInstance, Map<String, AdminUserRespDTO> userMap, Map<String, DeptRespDTO> deptMap) {
        return CollectionUtils.convertList(tasks, task -> {
            AdminUserRespDTO assignUser;
            BpmTaskRespVO respVO = this.convert3((HistoricTaskInstance)task);
            BpmTaskExtDO taskExtDO = (BpmTaskExtDO)bpmTaskExtDOMap.get(task.getId());
            this.copyTo(taskExtDO, respVO);
            if (processInstance != null) {
                AdminUserRespDTO startUser = (AdminUserRespDTO)userMap.get(processInstance.getStartUserId());
                respVO.setProcessInstance(this.convert(processInstance, startUser));
            }
            if ((assignUser = (AdminUserRespDTO)userMap.get(task.getAssignee())) != null) {
                respVO.setAssigneeUser(this.convert3(assignUser));
                DeptRespDTO dept = (DeptRespDTO)deptMap.get(assignUser.getDeptId());
                if (dept != null) {
                    respVO.getAssigneeUser().setDeptName(dept.getName());
                }
            }
            return respVO;
        });
    }

    @Mapping(source="taskDefinitionKey", target="definitionKey")
    public BpmTaskRespVO convert3(HistoricTaskInstance var1);

    public BpmTaskRespVO.User convert3(AdminUserRespDTO var1);

    @Mapping(target="id", ignore=true)
    public void copyTo(BpmTaskExtDO var1, @MappingTarget BpmTaskDonePageItemRespVO var2);

    @Mappings(value={@Mapping(source="processInstance.id", target="id"), @Mapping(source="processInstance.name", target="name"), @Mapping(source="processInstance.startUserId", target="startUserId"), @Mapping(source="processInstance.processDefinitionId", target="processDefinitionId"), @Mapping(source="startUser.nickname", target="startUserNickname")})
    public BpmTaskTodoPageItemRespVO.ProcessInstance convert(HistoricProcessInstance var1, AdminUserRespDTO var2);

    default public BpmTaskExtDO convert2TaskExt(Task task) {
        BpmTaskExtDO taskExtDO = new BpmTaskExtDO();
        taskExtDO.setTaskId(task.getId());
        taskExtDO.setAssigneeUserId(task.getAssignee());
        taskExtDO.setName(task.getName());
        taskExtDO.setProcessDefinitionId(task.getProcessDefinitionId());
        taskExtDO.setProcessInstanceId(task.getProcessInstanceId());
        taskExtDO.setCreateTime(task.getCreateTime());
        return taskExtDO;
    }

    default public BpmMessageSendWhenTaskCreatedReqDTO convert(ProcessInstance processInstance, AdminUserRespDTO startUser, Task task) {
        BpmMessageSendWhenTaskCreatedReqDTO reqDTO = new BpmMessageSendWhenTaskCreatedReqDTO();
        reqDTO.setProcessInstanceId(processInstance.getProcessInstanceId()).setProcessInstanceName(processInstance.getName()).setStartUserId(startUser.getId()).setStartUserNickname(startUser.getNickname()).setTaskId(task.getId()).setTaskName(task.getName()).setAssigneeUserId(task.getAssignee());
        return reqDTO;
    }

    default public BpmTaskExtDO convert2TaskExt1(org.flowable.task.api.Task task) {
        BpmTaskExtDO taskExtDO = new BpmTaskExtDO();
        taskExtDO.setTaskId(task.getId());
        taskExtDO.setAssigneeUserId(task.getAssignee());
        taskExtDO.setName(task.getName());
        taskExtDO.setProcessDefinitionId(task.getProcessDefinitionId());
        taskExtDO.setProcessInstanceId(task.getProcessInstanceId());
        taskExtDO.setCreateTime(task.getCreateTime());
        return taskExtDO;
    }

    default public BpmMessageSendWhenTaskCreatedReqDTO convert1(ProcessInstance processInstance, AdminUserRespDTO startUser, org.flowable.task.api.Task task) {
        BpmMessageSendWhenTaskCreatedReqDTO reqDTO = new BpmMessageSendWhenTaskCreatedReqDTO();
        reqDTO.setProcessInstanceId(processInstance.getProcessInstanceId());
        reqDTO.setProcessInstanceName(processInstance.getName());
        reqDTO.setStartUserId(startUser.getId());
        reqDTO.setStartUserNickname(startUser.getNickname());
        reqDTO.setTaskId(task.getId());
        reqDTO.setTaskName(task.getName());
        reqDTO.setAssigneeUserId(task.getAssignee());
        return reqDTO;
    }

    default public List<BpmTaskSimpleRespVO> convertList(List<? extends FlowElement> elementList) {
        return CollectionUtils.convertList(elementList, element -> new BpmTaskSimpleRespVO().setName(element.getName()).setDefinitionKey(element.getId()));
    }

    default public TaskEntityImpl convert(TaskEntityImpl task, TaskEntityImpl parentTask) {
        task.setCategory(parentTask.getCategory());
        task.setDescription(parentTask.getDescription());
        task.setTenantId(parentTask.getTenantId());
        task.setName(parentTask.getName());
        task.setParentTaskId(parentTask.getId());
        task.setProcessDefinitionId(parentTask.getProcessDefinitionId());
        task.setProcessInstanceId(parentTask.getProcessInstanceId());
        task.setTaskDefinitionKey(parentTask.getTaskDefinitionKey());
        task.setTaskDefinitionId(parentTask.getTaskDefinitionId());
        task.setPriority(parentTask.getPriority());
        task.setCreateTime(new Date());
        return task;
    }

    default public List<BpmTaskSubSignRespVO> convertList(List<BpmTaskExtDO> bpmTaskExtDOList, Map<String, AdminUserRespDTO> userMap, Map<String, org.flowable.task.api.Task> idTaskMap) {
        return CollectionUtils.convertList(bpmTaskExtDOList, task -> {
            BpmTaskSubSignRespVO bpmTaskSubSignRespVO = new BpmTaskSubSignRespVO().setId(task.getTaskId()).setName(task.getName());
            org.flowable.task.api.Task sourceTask = (org.flowable.task.api.Task)idTaskMap.get(task.getTaskId());
            String assignee = (String)ObjectUtil.defaultIfBlank((CharSequence)sourceTask.getOwner(), (CharSequence)sourceTask.getAssignee());
            MapUtils.findAndThen(userMap, assignee, assignUser -> bpmTaskSubSignRespVO.setAssigneeUser(this.convert3((AdminUserRespDTO)assignUser)));
            return bpmTaskSubSignRespVO;
        });
    }

    default public List<BpmTaskRespVO> convertChildrenList(List<BpmTaskRespVO> sourceList) {
        List<BpmTaskRespVO> childrenTaskList = CollectionUtils.filterList(sourceList, r -> StrUtil.isNotEmpty((CharSequence)r.getParentTaskId()));
        Map<String, List<BpmTaskRespVO>> parentChildrenTaskListMap = CollectionUtils.convertMultiMap(childrenTaskList, BpmTaskRespVO::getParentTaskId);
        for (BpmTaskRespVO bpmTaskRespVO : sourceList) {
            bpmTaskRespVO.setChildren(parentChildrenTaskListMap.get(bpmTaskRespVO.getId()));
        }
        return CollectionUtils.filterList(sourceList, r -> StrUtil.isEmpty((CharSequence)r.getParentTaskId()));
    }
}

