/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.flow.HistoricProcessInstance;
import com.yqbsoft.laser.service.flowable.api.flow.ProcessInstance;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.convert.BpmProcessInstanceConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmProcessInstanceExtMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessDefinitionExtDO;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessInstanceExtDO;
import com.yqbsoft.laser.service.flowable.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.flowable.dto.BpmProcessInstanceCreateReqDTO;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceDeleteReasonEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceResultEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceStatusEnum;
import com.yqbsoft.laser.service.flowable.framework.bpm.core.event.BpmProcessInstanceResultEventPublisher;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmMessageService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessDefinitionService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessInstanceService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceCancelReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceMyPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstancePageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceRespVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmProcessInstanceServiceImpl
extends BaseServiceImpl
implements BpmProcessInstanceService {
    private static final Logger log = LoggerFactory.getLogger(BpmProcessInstanceServiceImpl.class);
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private IdentityService identityService;
    @Resource
    private BpmProcessInstanceExtMapper processInstanceExtMapper;
    @Resource
    @Lazy
    private BpmTaskService taskService;
    @Resource
    private BpmProcessDefinitionService processDefinitionService;
    @Resource
    private HistoryService historyService;
    @Resource
    private AdminUserApi adminUserApi;
    @Resource
    private DeptApi deptApi;
    @Resource
    private BpmProcessInstanceResultEventPublisher processInstanceResultEventPublisher;
    @Resource
    private BpmMessageService messageService;

    @Override
    public ProcessInstance getProcessInstance(String id) {
        return (ProcessInstance)((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId(id).singleResult());
    }

    @Override
    public org.flowable.engine.runtime.ProcessInstance getProcessInstance1(String id) {
        return (org.flowable.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    @Override
    public List<ProcessInstance> getProcessInstances(Set<String> ids) {
        return BpmProcessInstanceConvert.INSTANCE.convertList5(this.runtimeService.createProcessInstanceQuery().processInstanceIds(ids).list());
    }

    @Override
    public List<org.flowable.engine.runtime.ProcessInstance> getProcessInstances1(Set<String> ids) {
        return this.runtimeService.createProcessInstanceQuery().processInstanceIds(ids).list();
    }

    @Override
    public PageResult<BpmProcessInstancePageItemRespVO> getMyProcessInstancePage(String userId, BpmProcessInstanceMyPageReqVO pageReqVO) {
        PageResult<BpmProcessInstanceExtDO> pageResult = new PageResult<BpmProcessInstanceExtDO>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("startUserId", userId);
        parameters.put("name", pageReqVO.getName());
        parameters.put("processDefinitionId", pageReqVO.getProcessDefinitionId());
        parameters.put("getCategory", pageReqVO.getCategory());
        parameters.put("status", pageReqVO.getStatus());
        parameters.put("result", pageReqVO.getResult());
        parameters.put("createTimeQstart", pageReqVO.getCreateTime());
        parameters.put("createTimeQend", pageReqVO.getCreateTime());
        parameters.put("order", true);
        parameters.put("orderStr", "id desc");
        parameters.put("startRow", pageReqVO.getPageNo() - 1);
        parameters.put("rows", pageReqVO.getPageSize());
        List<BpmProcessInstanceExtDO> query = this.processInstanceExtMapper.query(parameters);
        if (CollUtil.isEmpty(query)) {
            return new PageResult<BpmProcessInstancePageItemRespVO>(pageResult.getTotal());
        }
        pageResult.setList(query);
        int count = this.processInstanceExtMapper.count(parameters);
        pageResult.setTotal(Long.valueOf(count));
        List<String> processInstanceIds = CollectionUtils.convertList(pageResult.getList(), BpmProcessInstanceExtDO::getProcessInstanceId);
        Map<String, List<Task>> taskMap = this.taskService.getTaskMapByProcessInstanceIds2(processInstanceIds);
        return BpmProcessInstanceConvert.INSTANCE.convertPage(pageResult, taskMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createProcessInstance(String userId, @Valid BpmProcessInstanceCreateReqVO createReqVO) {
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinition2(createReqVO.getProcessDefinitionId());
        return this.createProcessInstance0(userId, definition, createReqVO.getVariables(), null);
    }

    @Override
    public String createProcessInstance2(String userId, @Valid BpmProcessInstanceCreateReqDTO createReqDTO) throws ApiException {
        ProcessDefinition definition = this.processDefinitionService.getActiveProcessDefinition1(createReqDTO.getProcessDefinitionKey());
        return this.createProcessInstance0(userId, definition, createReqDTO.getVariables(), createReqDTO.getBusinessKey());
    }

    @Override
    public String createProcessInstanceForPm(PmPromotionDomain pmPromotionDomain) throws ApiException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        BpmProcessInstanceCreateReqDTO bpmProcessInstanceCreateReqDTO = new BpmProcessInstanceCreateReqDTO();
        bpmProcessInstanceCreateReqDTO.setProcessDefinitionKey("procesPM");
        bpmProcessInstanceCreateReqDTO.setVariables(paramsMap);
        bpmProcessInstanceCreateReqDTO.setBusinessKey(pmPromotionDomain.getPromotionCode());
        bpmProcessInstanceCreateReqDTO.setChannelCode(pmPromotionDomain.getChannelCode());
        bpmProcessInstanceCreateReqDTO.setMemberCode(pmPromotionDomain.getMemberCode());
        return this.createProcessInstance2(pmPromotionDomain.getUserCode(), bpmProcessInstanceCreateReqDTO);
    }

    @Override
    public BpmProcessInstanceRespVO getProcessInstanceVO(String id) {
        org.flowable.engine.history.HistoricProcessInstance processInstance = this.getHistoricProcessInstance1(id);
        if (processInstance == null) {
            return null;
        }
        BpmProcessInstanceExtDO processInstanceExt = this.processInstanceExtMapper.selectByProcessInstanceId(id);
        Assert.notNull((Object)processInstanceExt, (String)"\u6d41\u7a0b\u5b9e\u4f8b\u62d3\u5c55({}) \u4e0d\u5b58\u5728", (Object[])new Object[]{id});
        ProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition2(processInstance.getProcessDefinitionId());
        Assert.notNull((Object)processDefinition, (String)"\u6d41\u7a0b\u5b9a\u4e49({}) \u4e0d\u5b58\u5728", (Object[])new Object[]{processInstance.getProcessDefinitionId()});
        BpmProcessDefinitionExtDO processDefinitionExt = this.processDefinitionService.getProcessDefinitionExt(processInstance.getProcessDefinitionId());
        Assert.notNull((Object)processDefinitionExt, (String)"\u6d41\u7a0b\u5b9a\u4e49\u62d3\u5c55({}) \u4e0d\u5b58\u5728", (Object[])new Object[]{id});
        String bpmnXml = this.processDefinitionService.getProcessDefinitionBpmnXML(processInstance.getProcessDefinitionId());
        AdminUserRespDTO startUser = this.adminUserApi.getUser(processInstance.getStartUserId());
        DeptRespDTO dept = null;
        if (startUser != null) {
            dept = this.deptApi.getDept(startUser.getDeptId());
        }
        return BpmProcessInstanceConvert.INSTANCE.convert2(processInstance, processInstanceExt, processDefinition, processDefinitionExt, bpmnXml, startUser, dept);
    }

    @Override
    public void cancelProcessInstance(String userId, @Valid BpmProcessInstanceCancelReqVO cancelReqVO) {
        org.flowable.engine.runtime.ProcessInstance instance = this.getProcessInstance1(cancelReqVO.getId());
        if (instance == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_CANCEL_FAIL_NOT_EXISTS);
        }
        if (!Objects.equals(instance.getStartUserId(), String.valueOf(userId))) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_CANCEL_FAIL_NOT_SELF);
        }
        this.deleteProcessInstance(cancelReqVO.getId(), BpmProcessInstanceDeleteReasonEnum.CANCEL_TASK.format(cancelReqVO.getReason()));
    }

    @Override
    public HistoricProcessInstance getHistoricProcessInstance(String id) {
        return (HistoricProcessInstance)((Object)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(id).singleResult());
    }

    @Override
    public org.flowable.engine.history.HistoricProcessInstance getHistoricProcessInstance1(String id) {
        return (org.flowable.engine.history.HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    @Override
    public List<HistoricProcessInstance> getHistoricProcessInstances(Set<String> ids) {
        return BpmProcessInstanceConvert.INSTANCE.convertList6(this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(ids).list());
    }

    @Override
    public List<org.flowable.engine.history.HistoricProcessInstance> getHistoricProcessInstances1(Set<String> ids) {
        return this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(ids).list();
    }

    @Override
    public void createProcessInstanceExt(ProcessInstance instance) {
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinition2(instance.getProcessDefinitionId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(instance.getId());
        instanceExtDO.setProcessDefinitionId(definition.getId());
        instanceExtDO.setName(instance.getProcessDefinitionName());
        instanceExtDO.setStartUserId(instance.getStartUserId());
        instanceExtDO.setCategory(definition.getCategory());
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.RUNNING.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        this.processInstanceExtMapper.insert(instanceExtDO);
    }

    @Override
    public void updateProcessInstanceExtCancel(com.yqbsoft.laser.service.flowable.api.flow.FlowableCancelledEvent event) {
        if (BpmProcessInstanceDeleteReasonEnum.isRejectReason((String)event.getCause())) {
            return;
        }
        org.flowable.engine.history.HistoricProcessInstance processInstance = this.getHistoricProcessInstance1(event.getProcessInstanceId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(event.getProcessInstanceId());
        instanceExtDO.setEndTime(new Date());
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.CANCEL.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceIdSelective(instanceExtDO);
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    @Override
    public void updateProcessInstanceExtComplete(ProcessInstance instance) {
        org.flowable.engine.history.HistoricProcessInstance processInstance = this.getHistoricProcessInstance1(instance.getId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(instance.getProcessInstanceId());
        instanceExtDO.setEndTime(new Date());
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceIdSelective(instanceExtDO);
        this.messageService.sendMessageWhenProcessInstanceApprove(BpmProcessInstanceConvert.INSTANCE.convert2ApprovedReq1(instance));
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateProcessInstanceExtReject(String id, String reason) {
        org.flowable.engine.runtime.ProcessInstance processInstance = this.getProcessInstance1(id);
        this.deleteProcessInstance(id, StrUtil.format((CharSequence)BpmProcessInstanceDeleteReasonEnum.REJECT_TASK.format(reason), (Object[])new Object[0]));
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(id);
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.REJECT.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceIdSelective(instanceExtDO);
        this.messageService.sendMessageWhenProcessInstanceReject(BpmProcessInstanceConvert.INSTANCE.convert2RejectReq(processInstance, reason));
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    private void deleteProcessInstance(String id, String reason) {
        this.runtimeService.deleteProcessInstance(id, reason);
    }

    private String createProcessInstance0(String userId, ProcessDefinition definition, Map<String, Object> variables, String businessKey) throws ApiException {
        if (definition == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_NOT_EXISTS);
        }
        if (definition.isSuspended()) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_IS_SUSPENDED);
        }
        org.flowable.engine.runtime.ProcessInstance instance = null;
        BpmProcessInstanceExtDO bpmProcessInstanceExtDO = null;
        this.identityService.setAuthenticatedUserId(userId);
        instance = this.runtimeService.createProcessInstanceBuilder().processDefinitionId(definition.getId()).businessKey(businessKey).name(definition.getName().trim()).variables(variables).start();
        this.runtimeService.setProcessInstanceName(instance.getId(), definition.getName());
        bpmProcessInstanceExtDO = new BpmProcessInstanceExtDO();
        bpmProcessInstanceExtDO.setProcessInstanceId(instance.getId());
        bpmProcessInstanceExtDO.setFormVariables(JsonUtils.toJsonString(variables));
        this.processInstanceExtMapper.updateByProcessInstanceIdSelective(bpmProcessInstanceExtDO);
        return instance.getId();
    }

    @Override
    public void createProcessInstanceExt1(org.flowable.engine.runtime.ProcessInstance instance) {
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinition2(instance.getProcessDefinitionId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(instance.getId());
        instanceExtDO.setProcessDefinitionId(definition.getId());
        instanceExtDO.setName(instance.getProcessDefinitionName());
        instanceExtDO.setStartUserId(instance.getStartUserId());
        instanceExtDO.setCategory(definition.getCategory());
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.RUNNING.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        this.setDefaultValues(instanceExtDO);
        this.processInstanceExtMapper.insertSelective(instanceExtDO);
    }

    private void setDefaultValues(BpmProcessInstanceExtDO instanceExtDO) {
        if (instanceExtDO.getCreateTime() == null) {
            instanceExtDO.setCreateTime(new Date());
        }
        if (instanceExtDO.getUpdateTime() == null) {
            instanceExtDO.setUpdateTime(new Date());
        }
        if (instanceExtDO.getDeleted() == null) {
            instanceExtDO.setDeleted(false);
        }
        if (StringUtils.isBlank((CharSequence)instanceExtDO.getTenantId())) {
            instanceExtDO.setTenantId("733997198045540435");
        }
        if (StringUtils.isBlank((CharSequence)instanceExtDO.getStartUserId())) {
            instanceExtDO.setStartUserId("734084254956449814");
        }
    }

    @Override
    public void updateProcessInstanceExtComplete1(org.flowable.engine.runtime.ProcessInstance instance) {
        org.flowable.engine.history.HistoricProcessInstance processInstance = this.getHistoricProcessInstance1(instance.getId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(instance.getProcessInstanceId());
        instanceExtDO.setEndTime(new Date());
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceIdSelective(instanceExtDO);
        this.messageService.sendMessageWhenProcessInstanceApprove(BpmProcessInstanceConvert.INSTANCE.convert2ApprovedReq(instance));
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    @Override
    public void updateProcessInstanceExtCancel1(FlowableCancelledEvent event) {
        if (BpmProcessInstanceDeleteReasonEnum.isRejectReason((String)event.getCause())) {
            return;
        }
        org.flowable.engine.history.HistoricProcessInstance processInstance = this.getHistoricProcessInstance1(event.getProcessInstanceId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO();
        instanceExtDO.setProcessInstanceId(event.getProcessInstanceId());
        instanceExtDO.setEndTime(new Date());
        instanceExtDO.setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus());
        instanceExtDO.setResult(BpmProcessInstanceResultEnum.CANCEL.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceIdSelective(instanceExtDO);
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }
}

