/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.api.user;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.organize.domain.OrgDepartempReDomain;
import com.yqbsoft.laser.service.organize.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminUserApiImpl
implements AdminUserApi {
    public static final String TENANTCODE = "733997198045540435";
    @Autowired
    InternalRouter internalRouter;

    @Override
    public AdminUserRespDTO getUser(String id) {
        AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
        adminUserRespDTO.setId(id);
        adminUserRespDTO.setNickname(id);
        return adminUserRespDTO;
    }

    @Override
    public List<AdminUserRespDTO> getUserList(Collection<String> ids) throws ApiException {
        ArrayList<AdminUserRespDTO> userList = new ArrayList<AdminUserRespDTO>();
        for (String id : ids) {
            AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
            adminUserRespDTO.setId(id);
            userList.add(adminUserRespDTO);
        }
        String extracted = AdminUserApiImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", extracted);
        map.put("tenantCode", TENANTCODE);
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", parma);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(emp, QueryResult.class);
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", parma);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List users = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        for (UmUserReDomainBean umUserReDomainBean : users) {
            userList.stream().filter(u -> u.getId().equals(umUserReDomainBean.getUserCode())).forEach(u -> {
                u.setMobile(umUserReDomainBean.getUserPhone());
                u.setStatus(umUserReDomainBean.getDataState());
            });
        }
        String employeeCodes = null;
        if (null != emps && emps.size() > 0) {
            List<String> collect = emps.stream().map(e -> e.getEmployeeCode()).collect(Collectors.toList());
            employeeCodes = AdminUserApiImpl.extracted(collect);
            HashMap<String, String> departMap = new HashMap<String, String>();
            departMap.put("employeeCode", employeeCodes);
            String departstr = (String)this.internalRouter.inInvoke("org.depart.queryDepartempPage", departMap);
            SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(departstr, QueryResult.class);
            List departs = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepartempReDomain.class);
            if (departs.size() > 0) {
                for (OrgDepartempReDomain orgDepartempReDomain : departs) {
                    emps.stream().filter(e -> e.getEmployeeCode().equals(orgDepartempReDomain.getEmployeeCode())).forEach(e -> e.setMemo(orgDepartempReDomain.getDepartCode()));
                }
            }
            for (OrgEmployee orgEmployee : emps) {
                userList.stream().filter(u -> u.getId().equals(orgEmployee.getUserCode())).forEach(u -> {
                    u.setDeptId(orgEmployee.getMemo());
                    u.setNickname(orgEmployee.getEmployeeName());
                });
            }
        }
        return userList;
    }

    private static String extracted(Collection<String> ids) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String id : ids) {
            stringBuilder.append(id).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<AdminUserRespDTO> getUserListByDeptIds(Collection<String> deptIds) {
        return null;
    }

    @Override
    public List<AdminUserRespDTO> getUsersByPostIds(Collection<String> postIds) {
        return null;
    }

    @Override
    public void validateUserList(Collection<String> ids) {
    }

    @Override
    public List<AdminUserRespDTO> getUserListByPostIds(Collection<String> postIds) {
        return null;
    }

    @Override
    public Map<String, AdminUserRespDTO> getUserMap(Collection<String> ids) {
        return AdminUserApi.super.getUserMap(ids);
    }
}

