/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.flow.BpmnModel;
import com.yqbsoft.laser.service.flowable.convert.BpmModelConvert;
import com.yqbsoft.laser.service.flowable.domain.BpmFormDO;
import com.yqbsoft.laser.service.flowable.dto.BpmModelMetaInfoRespDTO;
import com.yqbsoft.laser.service.flowable.dto.BpmProcessDefinitionCreateReqDTO;
import com.yqbsoft.laser.service.flowable.enums.BpmModelFormTypeEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmFormService;
import com.yqbsoft.laser.service.flowable.service.BpmModelService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessDefinitionService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskAssignRuleService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.flowable.util.object.PageUtils;
import com.yqbsoft.laser.service.flowable.util.validation.ValidationUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmModelCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelPageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelUpdateReqVO;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ModelQuery;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmModelServiceImpl
extends BaseServiceImpl
implements BpmModelService {
    private static final Logger log = LoggerFactory.getLogger(BpmModelServiceImpl.class);
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private BpmProcessDefinitionService processDefinitionService;
    @Resource
    private BpmFormService bpmFormService;
    @Resource
    private BpmTaskAssignRuleService taskAssignRuleService;

    @Override
    public PageResult<BpmModelPageItemRespVO> getModelPage(BpmModelPageReqVO pageVO) {
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        if (StrUtil.isNotBlank((CharSequence)pageVO.getKey())) {
            modelQuery.modelKey(pageVO.getKey());
        }
        if (StrUtil.isNotBlank((CharSequence)pageVO.getName())) {
            modelQuery.modelNameLike("%" + pageVO.getName() + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)pageVO.getCategory())) {
            modelQuery.modelCategory(pageVO.getCategory());
        }
        List models = ((ModelQuery)modelQuery.orderByCreateTime().desc()).listPage(PageUtils.getStart(pageVO), pageVO.getPageSize().intValue());
        Set<Long> formIds = CollectionUtils.convertSet(models, model -> {
            BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(model.getMetaInfo(), BpmModelMetaInfoRespDTO.class);
            return metaInfo != null ? metaInfo.getFormId() : null;
        });
        Map<Long, BpmFormDO> formMap = this.bpmFormService.getFormMap(formIds);
        HashSet<String> deploymentIds = new HashSet<String>();
        models.forEach(model -> CollectionUtils.addIfNotNull(deploymentIds, model.getDeploymentId()));
        Map<String, Deployment> deploymentMap = this.processDefinitionService.getDeploymentMap1(deploymentIds);
        List<ProcessDefinition> processDefinitions = this.processDefinitionService.getProcessDefinitionListByDeploymentIds1(deploymentIds);
        Map<String, ProcessDefinition> processDefinitionMap = CollectionUtils.convertMap(processDefinitions, ProcessDefinition::getDeploymentId);
        long modelCount = modelQuery.count();
        return new PageResult<BpmModelPageItemRespVO>(BpmModelConvert.INSTANCE.convertList(models, formMap, deploymentMap, processDefinitionMap), modelCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createModel(@Valid BpmModelCreateReqVO createReqVO, String bpmnXml) {
        this.checkKeyNCName(createReqVO.getKey());
        Model keyModel = this.getModelByKey(createReqVO.getKey());
        if (keyModel != null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_KEY_EXISTS, createReqVO.getKey());
        }
        Model model = this.repositoryService.newModel();
        BpmModelConvert.INSTANCE.copy(model, createReqVO);
        this.repositoryService.saveModel(model);
        this.saveModelBpmnXml(model, bpmnXml);
        return model.getId();
    }

    private Model getModelByKey(String key) {
        return (Model)this.repositoryService.createModelQuery().modelKey(key).singleResult();
    }

    @Override
    public BpmModelRespVO getModel(String id) {
        Model model = this.repositoryService.getModel(id);
        if (model == null) {
            return null;
        }
        BpmModelRespVO modelRespVO = BpmModelConvert.INSTANCE.convert(model);
        byte[] bpmnBytes = this.repositoryService.getModelEditorSource(id);
        modelRespVO.setBpmnXml(StrUtil.utf8Str((Object)bpmnBytes));
        return modelRespVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateModel(@Valid BpmModelUpdateReqVO updateReqVO) {
        Model model = this.repositoryService.getModel(updateReqVO.getId());
        if (model == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_NOT_EXISTS);
        }
        BpmModelConvert.INSTANCE.copy(model, updateReqVO);
        this.repositoryService.saveModel(model);
        this.saveModelBpmnXml(model, updateReqVO.getBpmnXml());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deployModel(String id) {
        ProcessDefinition oldProcessDefinition;
        Model model = this.repositoryService.getModel(id);
        if (ObjectUtils.isEmpty((Object)model)) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_NOT_EXISTS);
        }
        byte[] bpmnBytes = this.repositoryService.getModelEditorSource(model.getId());
        if (bpmnBytes == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_NOT_EXISTS);
        }
        BpmFormDO form = this.checkFormConfig(model.getMetaInfo());
        this.taskAssignRuleService.checkTaskAssignRuleAllConfig(id);
        BpmProcessDefinitionCreateReqDTO definitionCreateReqDTO = BpmModelConvert.INSTANCE.convert2(model, form).setBpmnBytes(bpmnBytes);
        if (this.processDefinitionService.isProcessDefinitionEquals(definitionCreateReqDTO) && (oldProcessDefinition = this.processDefinitionService.getProcessDefinitionByDeploymentId1(model.getDeploymentId())) != null && this.taskAssignRuleService.isTaskAssignRulesEquals(model.getId(), oldProcessDefinition.getId())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_DEPLOY_FAIL_TASK_INFO_EQUALS);
        }
        String definitionId = this.processDefinitionService.createProcessDefinition(definitionCreateReqDTO);
        this.updateProcessDefinitionSuspended(model.getDeploymentId());
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinition2(definitionId);
        model.setDeploymentId(definition.getDeploymentId());
        this.repositoryService.saveModel(model);
        this.taskAssignRuleService.copyTaskAssignRules(id, definition.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteModel(String id) {
        Model model = this.repositoryService.getModel(id);
        if (model == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_NOT_EXISTS);
        }
        this.repositoryService.deleteModel(id);
        this.updateProcessDefinitionSuspended(model.getDeploymentId());
    }

    @Override
    public void updateModelState(String id, Integer state) {
        Model model = this.repositoryService.getModel(id);
        if (model == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_NOT_EXISTS);
        }
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinitionByDeploymentId1(model.getDeploymentId());
        if (definition == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_NOT_EXISTS);
        }
        this.processDefinitionService.updateProcessDefinitionState(definition.getId(), state);
    }

    @Override
    public org.flowable.bpmn.model.BpmnModel getBpmnModel(String id) {
        byte[] bpmnBytes = this.repositoryService.getModelEditorSource(id);
        if (ArrayUtil.isEmpty((byte[])bpmnBytes)) {
            return null;
        }
        BpmnXMLConverter converter = new BpmnXMLConverter();
        return converter.convertToBpmnModel((InputStreamProvider)new BytesStreamSource(bpmnBytes), true, true);
    }

    @Override
    public BpmnModel getBpmnModel1(String id) {
        byte[] bpmnBytes = this.repositoryService.getModelEditorSource(id);
        if (ArrayUtil.isEmpty((byte[])bpmnBytes)) {
            return null;
        }
        BpmnXMLConverter converter = new BpmnXMLConverter();
        BpmnModel bpmnModel = new BpmnModel();
        try {
            BeanUtils.copyAllPropertys((Object)converter.convertToBpmnModel((InputStreamProvider)new BytesStreamSource(bpmnBytes), true, true), (Object)bpmnModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bpmnModel;
    }

    @Override
    public org.flowable.bpmn.model.BpmnModel getBpmnModelByDefinitionId(String processDefinitionId) {
        return this.repositoryService.getBpmnModel(processDefinitionId);
    }

    private void checkKeyNCName(String key) {
        if (!ValidationUtils.isXmlNCName(key)) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_KEY_VALID);
        }
    }

    private BpmFormDO checkFormConfig(String metaInfoStr) {
        BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(metaInfoStr, BpmModelMetaInfoRespDTO.class);
        if (metaInfo == null || metaInfo.getFormType() == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_DEPLOY_FAIL_FORM_NOT_CONFIG);
        }
        if (Objects.equals(metaInfo.getFormType(), BpmModelFormTypeEnum.NORMAL.getType())) {
            BpmFormDO form = this.bpmFormService.getForm(metaInfo.getFormId());
            if (form == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.FORM_NOT_EXISTS);
            }
            return form;
        }
        return null;
    }

    private void saveModelBpmnXml(Model model, String bpmnXml) {
        if (StrUtil.isEmpty((CharSequence)bpmnXml)) {
            return;
        }
        this.repositoryService.addModelEditorSource(model.getId(), StrUtil.utf8Bytes((CharSequence)bpmnXml));
    }

    private void updateProcessDefinitionSuspended(String deploymentId) {
        if (StrUtil.isEmpty((CharSequence)deploymentId)) {
            return;
        }
        ProcessDefinition oldDefinition = this.processDefinitionService.getProcessDefinitionByDeploymentId1(deploymentId);
        if (oldDefinition == null) {
            return;
        }
        this.processDefinitionService.updateProcessDefinitionState(oldDefinition.getId(), SuspensionState.SUSPENDED.getStateCode());
    }
}

