/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.convert;

import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.flowable.domain.BpmFormDO;
import com.yqbsoft.laser.service.flowable.dto.BpmModelMetaInfoRespDTO;
import com.yqbsoft.laser.service.flowable.dto.BpmProcessDefinitionCreateReqDTO;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.date.DateUtils;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmModeImportReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelBaseVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelPageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmModelUpdateReqVO;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

@Mapper
public interface BpmModelConvert {
    public static final BpmModelConvert INSTANCE = (BpmModelConvert)Mappers.getMapper(BpmModelConvert.class);

    default public List<BpmModelPageItemRespVO> convertList(List<Model> list, Map<Long, BpmFormDO> formMap, Map<String, Deployment> deploymentMap, Map<String, ProcessDefinition> processDefinitionMap) {
        return CollectionUtils.convertList(list, model -> {
            BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(model.getMetaInfo(), BpmModelMetaInfoRespDTO.class);
            BpmFormDO form = metaInfo != null ? (BpmFormDO)formMap.get(metaInfo.getFormId()) : null;
            Deployment deployment = model.getDeploymentId() != null ? (Deployment)deploymentMap.get(model.getDeploymentId()) : null;
            ProcessDefinition processDefinition = model.getDeploymentId() != null ? (ProcessDefinition)processDefinitionMap.get(model.getDeploymentId()) : null;
            return this.convert((Model)model, form, deployment, processDefinition);
        });
    }

    default public BpmModelPageItemRespVO convert(Model model, BpmFormDO form, Deployment deployment, ProcessDefinition processDefinition) {
        BpmModelPageItemRespVO modelRespVO = new BpmModelPageItemRespVO();
        modelRespVO.setId(model.getId());
        modelRespVO.setCreateTime(DateUtils.of(model.getCreateTime()));
        Map map = JsonUtil.buildNonDefaultBinder().getJsonToMap(model.getMetaInfo(), String.class, String.class);
        modelRespVO.setNotifyType((String)map.get("notifyType"));
        this.copyTo(model, (BpmModelBaseVO)modelRespVO);
        if (form != null) {
            modelRespVO.setFormId(form.getId());
            modelRespVO.setFormName(form.getName());
        }
        modelRespVO.setProcessDefinition(this.convert(processDefinition));
        if (modelRespVO.getProcessDefinition() != null) {
            modelRespVO.getProcessDefinition().setSuspensionState(processDefinition.isSuspended() ? SuspensionState.SUSPENDED.getStateCode() : SuspensionState.ACTIVE.getStateCode());
            modelRespVO.getProcessDefinition().setDeploymentTime(DateUtils.of(deployment.getDeploymentTime()));
        }
        return modelRespVO;
    }

    default public BpmModelRespVO convert(Model model) {
        BpmModelRespVO modelRespVO = new BpmModelRespVO();
        modelRespVO.setId(model.getId());
        modelRespVO.setCreateTime(DateUtils.of(model.getCreateTime()));
        this.copyTo(model, (BpmModelBaseVO)modelRespVO);
        return modelRespVO;
    }

    default public void copyTo(Model model, BpmModelBaseVO to) {
        to.setName(model.getName());
        to.setKey(model.getKey());
        to.setCategory(model.getCategory());
        BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(model.getMetaInfo(), BpmModelMetaInfoRespDTO.class);
        this.copyTo(metaInfo, to);
    }

    public BpmModelCreateReqVO convert(BpmModeImportReqVO var1);

    default public BpmProcessDefinitionCreateReqDTO convert2(Model model, BpmFormDO form) {
        BpmProcessDefinitionCreateReqDTO createReqDTO = new BpmProcessDefinitionCreateReqDTO();
        createReqDTO.setModelId(model.getId());
        createReqDTO.setName(model.getName());
        createReqDTO.setKey(model.getKey());
        createReqDTO.setCategory(model.getCategory());
        BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(model.getMetaInfo(), BpmModelMetaInfoRespDTO.class);
        this.copyTo(metaInfo, createReqDTO);
        if (form != null) {
            createReqDTO.setFormConf(form.getConf());
            createReqDTO.setFormFields(form.getFields());
        }
        return createReqDTO;
    }

    public void copyTo(BpmModelMetaInfoRespDTO var1, @MappingTarget BpmProcessDefinitionCreateReqDTO var2);

    public void copyTo(BpmModelMetaInfoRespDTO var1, @MappingTarget BpmModelBaseVO var2);

    public BpmModelPageItemRespVO.ProcessDefinition convert(ProcessDefinition var1);

    default public void copy(Model model, BpmModelCreateReqVO bean) {
        model.setName(bean.getName());
        model.setKey(bean.getKey());
        model.setCategory(bean.getCategory());
        model.setTenantId(bean.getChannelCode());
        model.setMetaInfo(this.buildMetaInfoStr(null, bean.getDescription(), 1, 1L, null, null, bean.getNotifyType(), bean.getCategory()));
    }

    default public void copy(Model model, BpmModelUpdateReqVO bean) {
        model.setName(bean.getName());
        model.setCategory(bean.getCategory());
        model.setTenantId(bean.getChannelCode());
        model.setMetaInfo(this.buildMetaInfoStr(JsonUtils.parseObject(model.getMetaInfo(), BpmModelMetaInfoRespDTO.class), bean.getDescription(), 1, 1L, bean.getFormCustomCreatePath(), bean.getFormCustomViewPath(), bean.getNotifyType(), bean.getCategory()));
    }

    default public String buildMetaInfoStr(BpmModelMetaInfoRespDTO metaInfo, String description, Integer formType, Long formId, String formCustomCreatePath, String formCustomViewPath, String notifyType, String category) {
        if (metaInfo == null) {
            metaInfo = new BpmModelMetaInfoRespDTO();
        }
        if (StrUtil.isNotEmpty((CharSequence)description)) {
            metaInfo.setDescription(description);
        }
        if (Objects.nonNull(formType)) {
            metaInfo.setFormType(formType);
            metaInfo.setFormId(formId);
            metaInfo.setFormCustomCreatePath(formCustomCreatePath);
            metaInfo.setFormCustomViewPath(formCustomViewPath);
            metaInfo.setNotifyType(notifyType);
        }
        if (Objects.nonNull(notifyType)) {
            metaInfo.setFormType(formType);
            metaInfo.setFormId(formId);
            metaInfo.setFormCustomCreatePath(formCustomCreatePath);
            metaInfo.setFormCustomViewPath(formCustomViewPath);
            metaInfo.setNotifyType(notifyType);
            metaInfo.setCategory(category);
        }
        return JsonUtils.toJsonString(metaInfo);
    }
}

