/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.convert;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.yqbsoft.laser.service.flowable.domain.BpmFormDO;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessDefinitionExtDO;
import com.yqbsoft.laser.service.flowable.dto.BpmProcessDefinitionCreateReqDTO;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessDefinitionPageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessDefinitionRespVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper
public interface BpmProcessDefinitionConvert {
    public static final BpmProcessDefinitionConvert INSTANCE = (BpmProcessDefinitionConvert)Mappers.getMapper(BpmProcessDefinitionConvert.class);

    public BpmProcessDefinitionPageItemRespVO convert(ProcessDefinition var1);

    public BpmProcessDefinitionExtDO convert2(BpmProcessDefinitionCreateReqDTO var1);

    default public List<BpmProcessDefinitionPageItemRespVO> convertList(List<ProcessDefinition> list, Map<String, Deployment> deploymentMap, Map<String, BpmProcessDefinitionExtDO> processDefinitionDOMap, Map<Long, BpmFormDO> formMap) {
        return CollectionUtils.convertList(list, definition -> {
            Deployment deployment = definition.getDeploymentId() != null ? (Deployment)deploymentMap.get(definition.getDeploymentId()) : null;
            BpmProcessDefinitionExtDO definitionDO = (BpmProcessDefinitionExtDO)processDefinitionDOMap.get(definition.getId());
            BpmFormDO form = definitionDO != null ? (BpmFormDO)formMap.get(definitionDO.getFormId()) : null;
            return this.convert((ProcessDefinition)definition, deployment, definitionDO, form);
        });
    }

    default public List<BpmProcessDefinitionRespVO> convertList3(List<ProcessDefinition> list, Map<String, BpmProcessDefinitionExtDO> processDefinitionDOMap) {
        return CollectionUtils.convertList(list, processDefinition -> {
            BpmProcessDefinitionRespVO respVO = this.convert3((ProcessDefinition)processDefinition);
            BpmProcessDefinitionExtDO processDefinitionExtDO = (BpmProcessDefinitionExtDO)processDefinitionDOMap.get(processDefinition.getId());
            this.copyTo(processDefinitionExtDO, respVO);
            return respVO;
        });
    }

    @Mapping(source="suspended", target="suspensionState", qualifiedByName={"convertSuspendedToSuspensionState"})
    public BpmProcessDefinitionRespVO convert3(ProcessDefinition var1);

    @Named(value="convertSuspendedToSuspensionState")
    default public Integer convertSuspendedToSuspensionState(boolean suspended) {
        return suspended ? SuspensionState.SUSPENDED.getStateCode() : SuspensionState.ACTIVE.getStateCode();
    }

    default public BpmProcessDefinitionPageItemRespVO convert(ProcessDefinition bean, Deployment deployment, BpmProcessDefinitionExtDO processDefinitionExtDO, BpmFormDO form) {
        BpmProcessDefinitionPageItemRespVO respVO = this.convert(bean);
        respVO.setSuspensionState(bean.isSuspended() ? SuspensionState.SUSPENDED.getStateCode() : SuspensionState.ACTIVE.getStateCode());
        if (deployment != null) {
            respVO.setDeploymentTime(LocalDateTimeUtil.of((Date)deployment.getDeploymentTime()));
        }
        if (form != null) {
            respVO.setFormName(form.getName());
        }
        this.copyTo(processDefinitionExtDO, respVO);
        return respVO;
    }

    @Mapping(source="from.id", target="to.id", ignore=true)
    public void copyTo(BpmProcessDefinitionExtDO var1, @MappingTarget BpmProcessDefinitionRespVO var2);

    public List<com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition> convertList5(List<ProcessDefinition> var1);
}

